/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.notification;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationRecord;
import com.ibm.ws.jmx.connector.converter.NotificationTargetInformation;
import com.ibm.ws.jmx.connector.datatypes.NotificationRegistration;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRoutedNotificationHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRouterHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationFilter;
import com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationListener;
import com.ibm.ws.jmx.connector.server.rest.notification.ServerNotification;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerJsonException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientNotificationArea {
    public final int clientID;
    public final long inboxExpiry;
    public final long deliveryInterval;
    private volatile long lastAccessTimeStamp;
    private final List<NotificationRecord> notifications;
    private final Object waitFlag = new WaitFlag();
    private final ConcurrentHashMap<NotificationTargetInformation, ClientNotificationListener> listeners;
    private final ConcurrentHashMap<Integer, Object> objectLibrary;
    private int paramId = -2147483647;
    private final ConcurrentHashMap<NotificationTargetInformation, List<ServerNotification>> serverNotifications;
    private static final TraceComponent tc = Tr.register(ClientNotificationArea.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.RESTServerMessages");
    static final long serialVersionUID = 3192900576594608779L;

    public ClientNotificationArea(long deliveryInterval, long inboxExpiry, int clientID) {
        this.clientID = clientID;
        this.deliveryInterval = deliveryInterval * 1000000L;
        this.inboxExpiry = inboxExpiry * 1000000L;
        this.lastAccessTimeStamp = System.nanoTime();
        this.notifications = Collections.synchronizedList(new ArrayList());
        this.serverNotifications = new ConcurrentHashMap();
        this.listeners = new ConcurrentHashMap();
        this.objectLibrary = new ConcurrentHashMap();
    }

    public boolean timedOut() {
        return System.nanoTime() - this.lastAccessTimeStamp > this.inboxExpiry;
    }

    public void addNotfication(Notification notification) {
        Object source = notification.getSource();
        NotificationRecord nr = source instanceof ObjectName ? new NotificationRecord(notification, (ObjectName)source) : new NotificationRecord(notification, source != null ? source.toString() : null);
        this.addNotficationRecord(nr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotficationRecord(NotificationRecord record) {
        boolean wasEmpty = this.notifications.isEmpty();
        this.notifications.add(record);
        if (wasEmpty) {
            Object object = this.waitFlag;
            synchronized (object) {
                this.waitFlag.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationRecord[] fetchNotifications() {
        if (this.notifications.isEmpty()) {
            long timedOut = System.nanoTime() + this.deliveryInterval;
            Object object = this.waitFlag;
            synchronized (object) {
                while (this.notifications.isEmpty() && System.nanoTime() < timedOut) {
                    try {
                        this.waitFlag.wait(this.deliveryInterval / 1000000L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationArea", (String)"188", (Object)this, (Object[])new Object[0]);
                    }
                }
            }
        }
        NotificationRecord[] fetchedNotifications = null;
        if (!this.notifications.isEmpty()) {
            List<NotificationRecord> list = this.notifications;
            synchronized (list) {
                fetchedNotifications = this.notifications.toArray(new NotificationRecord[this.notifications.size()]);
                this.notifications.clear();
            }
        }
        this.lastAccessTimeStamp = System.nanoTime();
        return fetchedNotifications;
    }

    public void addClientNotificationListener(RESTRequest request, NotificationRegistration notificationRegistration, JSONConverter converter) {
        ClientNotificationListener mapListener;
        String objectNameStr = notificationRegistration.objectName.getCanonicalName();
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, objectNameStr);
        ClientNotificationListener listener = this.listeners.get(nti);
        if (listener == null && (mapListener = this.listeners.putIfAbsent(nti, listener = new ClientNotificationListener(this))) != null) {
            listener = mapListener;
        }
        ClientNotificationFilter filter = listener.getClientWrapperFilter();
        if (nti.getRoutingInformation() == null) {
            MBeanServerHelper.addClientNotification(notificationRegistration.objectName, listener, filter, null, converter);
        } else {
            MBeanRoutedNotificationHelper helper = MBeanRoutedNotificationHelper.getMBeanRoutedNotificationHelper();
            helper.addRoutedNotificationListener(nti, listener, converter);
        }
        listener.addClientNotification(notificationRegistration.filters);
    }

    public void updateClientNotificationListener(RESTRequest request, String objectNameStr, NotificationFilter[] filters, JSONConverter converter) {
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, objectNameStr);
        ClientNotificationListener listener = this.listeners.get(nti);
        if (listener == null) {
            throw ErrorHelper.createRESTHandlerJsonException(new RuntimeException("There are no listeners registered for " + nti), converter, 400);
        }
        listener.addClientNotification(filters);
    }

    public int getParamId(Object obj) {
        if (obj == null) {
            return Integer.MIN_VALUE;
        }
        if (this.paramId == Integer.MAX_VALUE) {
            for (int i = -2147483647; i < Integer.MAX_VALUE; ++i) {
                if (this.objectLibrary.get(i) != null) continue;
                return i;
            }
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.RESTServerMessages", (String)"JMX_HTTP_MBEAN_LISTENER_LIMIT_ERROR", (Object[])new Object[]{this.clientID}, (String)"CWWKX0104W: The notification client with id {0} has reached its limit of concurrent MBean listener registrations."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return this.paramId++;
    }

    private Object removeObject(Integer key) {
        if (key == null) {
            return null;
        }
        return this.objectLibrary.remove(key);
    }

    private void clearObjectLibrary() {
        this.objectLibrary.clear();
    }

    public Object getObject(Integer key, Object newValue, JSONConverter converter) {
        if (newValue == null && key == Integer.MIN_VALUE) {
            return null;
        }
        Object previousValue = this.objectLibrary.get(key);
        if (previousValue == null) {
            if (newValue == null) {
                throw ErrorHelper.createRESTHandlerJsonException(new ListenerNotFoundException("Could not match Filter and Handback objects"), converter, 400);
            }
            previousValue = this.objectLibrary.putIfAbsent(key, newValue);
            if (previousValue == null) {
                previousValue = newValue;
            }
        }
        return previousValue;
    }

    public void removeClientNotificationListener(RESTRequest request, ObjectName name) {
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, name.getCanonicalName());
        ClientNotificationListener listener = this.listeners.remove(nti);
        if (nti.getRoutingInformation() == null) {
            MBeanServerHelper.removeClientNotification(name, listener);
        } else {
            MBeanRoutedNotificationHelper helper = MBeanRoutedNotificationHelper.getMBeanRoutedNotificationHelper();
            helper.removeRoutedNotificationListener(nti, listener);
        }
    }

    public void removeAllListeners(RESTRequest request, ObjectName source_objName, JSONConverter converter) {
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, source_objName.getCanonicalName());
        List<ServerNotification> notifications = this.serverNotifications.get(nti);
        if (notifications == null) {
            throw ErrorHelper.createRESTHandlerJsonException(new ListenerNotFoundException("There are no listeners registered for ObjectName: " + source_objName.getCanonicalName()), converter, 400);
        }
        Iterator<ServerNotification> notificationsIter = notifications.iterator();
        while (notificationsIter.hasNext()) {
            ServerNotification currentRegistration = notificationsIter.next();
            if (nti.getRoutingInformation() == null) {
                MBeanServerHelper.removeServerNotification(source_objName, currentRegistration.listener, (NotificationFilter)this.getObject(currentRegistration.filter, null, converter), this.getObject(currentRegistration.handback, null, converter), converter);
            } else {
                MBeanRoutedNotificationHelper helper = MBeanRoutedNotificationHelper.getMBeanRoutedNotificationHelper();
                helper.removeRoutedServerNotificationListener(nti, currentRegistration.listener, (NotificationFilter)this.getObject(currentRegistration.filter, null, converter), this.getObject(currentRegistration.handback, null, converter), converter);
            }
            notificationsIter.remove();
            this.removeObject(currentRegistration.filter);
            this.removeObject(currentRegistration.handback);
        }
    }

    public void removeServerNotificationListener(RESTRequest request, ServerNotificationRegistration removedRegistration, boolean removeAll, JSONConverter converter, boolean cleanupHttpIDs) {
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, removedRegistration.objectName.getCanonicalName());
        List<ServerNotification> notifications = this.serverNotifications.get(nti);
        if (notifications == null) {
            throw ErrorHelper.createRESTHandlerJsonException(new ListenerNotFoundException("There are no listeners registered for ObjectName: " + removedRegistration.objectName.getCanonicalName()), converter, 400);
        }
        Iterator<ServerNotification> notificationsIter = notifications.iterator();
        boolean foundMatch = false;
        while (notificationsIter.hasNext()) {
            ServerNotification currentRegistration = notificationsIter.next();
            if (!currentRegistration.listener.equals(removedRegistration.listener) || !removeAll && (currentRegistration.filter != removedRegistration.filterID || currentRegistration.handback != removedRegistration.handbackID)) continue;
            if (nti.getRoutingInformation() == null) {
                MBeanServerHelper.removeServerNotification(removedRegistration.objectName, currentRegistration.listener, (NotificationFilter)this.getObject(currentRegistration.filter, null, converter), this.getObject(currentRegistration.handback, null, converter), converter);
            } else {
                MBeanRoutedNotificationHelper helper = MBeanRoutedNotificationHelper.getMBeanRoutedNotificationHelper();
                helper.removeRoutedServerNotificationListener(nti, currentRegistration.listener, (NotificationFilter)this.getObject(currentRegistration.filter, null, converter), this.getObject(currentRegistration.handback, null, converter), converter);
            }
            notificationsIter.remove();
            if (cleanupHttpIDs) {
                this.removeObject(currentRegistration.filter);
                this.removeObject(currentRegistration.handback);
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            if (removeAll) {
                throw ErrorHelper.createRESTHandlerJsonException(new ListenerNotFoundException("Could not match given Listener to ObjectName: " + removedRegistration.objectName.getCanonicalName()), converter, 400);
            }
            throw ErrorHelper.createRESTHandlerJsonException(new ListenerNotFoundException("Could not match given Listener, Filter and Handback to ObjectName: " + removedRegistration.objectName.getCanonicalName()), converter, 400);
        }
    }

    public List<ServerNotification> getServerRegistrations(RESTRequest request, String objectName) {
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, objectName);
        return this.serverNotifications.get(nti);
    }

    public void addServerNotificationListener(RESTRequest request, ServerNotificationRegistration serverNotificationRegistration, JSONConverter converter) {
        List<ServerNotification> mapList;
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, serverNotificationRegistration.objectName.getCanonicalName());
        NotificationFilter filter = (NotificationFilter)this.getObject(serverNotificationRegistration.filterID, serverNotificationRegistration.filter, converter);
        Object handback = this.getObject(serverNotificationRegistration.handbackID, serverNotificationRegistration.handback, converter);
        if (nti.getRoutingInformation() == null) {
            MBeanServerHelper.addServerNotification(serverNotificationRegistration.objectName, serverNotificationRegistration.listener, filter, handback, converter);
        } else {
            MBeanRoutedNotificationHelper helper = MBeanRoutedNotificationHelper.getMBeanRoutedNotificationHelper();
            helper.addRoutedServerNotificationListener(nti, serverNotificationRegistration.listener, filter, handback, converter);
        }
        ServerNotification serverNotification = new ServerNotification();
        serverNotification.listener = serverNotificationRegistration.listener;
        serverNotification.filter = serverNotificationRegistration.filterID;
        serverNotification.handback = serverNotificationRegistration.handbackID;
        List<ServerNotification> list = this.serverNotifications.get(nti);
        if (list == null && (mapList = this.serverNotifications.putIfAbsent(nti, list = Collections.synchronizedList(new ArrayList()))) != null) {
            list = mapList;
        }
        list.add(serverNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void remoteClientRegistrations(RESTRequest request) {
        Iterator<Map.Entry<NotificationTargetInformation, ClientNotificationListener>> clientListeners = this.listeners.entrySet().iterator();
        try {
            while (clientListeners.hasNext()) {
                Map.Entry<NotificationTargetInformation, ClientNotificationListener> clientListener = clientListeners.next();
                NotificationTargetInformation nti = clientListener.getKey();
                ClientNotificationListener listener = clientListener.getValue();
                if (nti.getRoutingInformation() == null) {
                    ObjectName objName = RESTHelper.objectNameConverter(nti.getNameAsString(), false, null);
                    if (MBeanServerHelper.isRegistered(objName)) {
                        try {
                            MBeanServerHelper.removeClientNotification(objName, listener);
                            continue;
                        }
                        catch (RESTHandlerJsonException rESTHandlerJsonException) {
                            void exception;
                            FFDCFilter.processException((Throwable)rESTHandlerJsonException, (String)"com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationArea", (String)"552", (Object)this, (Object[])new Object[]{request});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Received exception while cleaning up: " + exception), (Object[])new Object[0]);
                            continue;
                        }
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("The MBean " + objName + " is not registered with the MBean server."), (Object[])new Object[0]);
                    continue;
                }
                MBeanRoutedNotificationHelper helper = MBeanRoutedNotificationHelper.getMBeanRoutedNotificationHelper();
                helper.removeRoutedNotificationListener(nti, listener);
            }
            return;
        }
        finally {
            this.listeners.clear();
        }
    }

    public synchronized void remoteServerRegistrations(RESTRequest request) {
        for (Map.Entry<NotificationTargetInformation, List<ServerNotification>> entry : this.serverNotifications.entrySet()) {
            NotificationTargetInformation nti = entry.getKey();
            if (nti.getRoutingInformation() == null) {
                ObjectName objName = RESTHelper.objectNameConverter(nti.getNameAsString(), false, null);
                if (MBeanServerHelper.isRegistered(objName)) {
                    for (ServerNotification notification : entry.getValue()) {
                        MBeanServerHelper.removeServerNotification(objName, notification.listener, (NotificationFilter)this.getObject(notification.filter, null, null), this.getObject(notification.handback, null, null), null);
                    }
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"The MBean is not registered with the MBean server.", (Object[])new Object[0]);
                continue;
            }
            MBeanRoutedNotificationHelper helper = MBeanRoutedNotificationHelper.getMBeanRoutedNotificationHelper();
            for (ServerNotification notification : entry.getValue()) {
                helper.removeRoutedServerNotificationListener(nti, notification.listener, (NotificationFilter)this.getObject(notification.filter, null, null), this.getObject(notification.handback, null, null), null);
            }
        }
        this.serverNotifications.clear();
        this.clearObjectLibrary();
    }

    public void cleanUp(RESTRequest request) {
        this.remoteClientRegistrations(request);
        this.remoteServerRegistrations(request);
    }

    public NotificationFilter[] getRegisteredFilters(RESTRequest request, String objectNameStr, JSONConverter converter) {
        NotificationTargetInformation nti = MBeanRouterHelper.toNotificationTargetInformation(request, objectNameStr);
        ClientNotificationListener listener = this.listeners.get(nti);
        if (listener == null) {
            return null;
        }
        return listener.getClientWrapperFilter().getFilters();
    }

    public String[] getRegisteredListeners(RESTRequest request, JSONConverter converter) {
        Set keys = this.listeners.keySet();
        if (!keys.isEmpty()) {
            String[] routingContext = RESTHelper.getRoutingContext(request, false);
            HashSet<String> objectNames = new HashSet<String>();
            for (NotificationTargetInformation key : keys) {
                Map registeredRoutingInfo = key.getRoutingInformation();
                if (routingContext == null && registeredRoutingInfo == null) {
                    objectNames.add(key.getNameAsString());
                    continue;
                }
                if (routingContext == null || registeredRoutingInfo == null || !routingContext[0].equals(registeredRoutingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.hostName")) || !routingContext[1].equals(registeredRoutingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir")) || !routingContext[2].equals(registeredRoutingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.serverName"))) continue;
                objectNames.add(key.getNameAsString());
            }
            return objectNames.toArray(new String[objectNames.size()]);
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class WaitFlag {
        static final long serialVersionUID = 1451740291761378254L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private WaitFlag() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WaitFlag.class);
        }
    }
}

