/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.helpers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.helper.DefaultRoutingHelper;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMissingRequiredParam;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerUnsupportedMediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RESTHelper {
    private static final TraceComponent tc = Tr.register(RESTHelper.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    static final long serialVersionUID = -8815902903715538504L;

    @FFDCIgnore(value={MalformedObjectNameException.class, NullPointerException.class})
    public static ObjectName objectNameConverter(String name, boolean needDecoding, JSONConverter converter) {
        try {
            if (needDecoding) {
                name = URLDecoder.decode(name, "UTF-8");
            }
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (NullPointerException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (UnsupportedEncodingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper", (String)"59", null, (Object[])new Object[]{name, needDecoding, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String URLDecoder(String name, JSONConverter converter) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper", (String)"67", null, (Object[])new Object[]{name, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String URLEncoder(String name, JSONConverter converter) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper", (String)"75", null, (Object[])new Object[]{name, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
    }

    public static String filterHttpHeader(String original) {
        return original.replaceAll("(\\n|\\r|\\u0085|\\u2028)", "");
    }

    public static void handlePreFlight(HttpServletRequest request, HttpServletResponse response) {
    }

    public static void handleCrossOrigin(HttpServletRequest request, HttpServletResponse response) {
    }

    public static boolean containsMultipleRoutingContext(RESTRequest request) {
        return request.getHeader("com.ibm.websphere.collective.hostNames") != null;
    }

    public static boolean containsSingleRoutingContext(RESTRequest request) {
        return request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.hostName") != null;
    }

    public static String[] getRoutingContext(RESTRequest request, boolean errorIfNull) {
        String targetHost = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.hostName");
        if (targetHost != null) {
            targetHost = RESTHelper.URLDecoder(targetHost, null);
            String targetUserDir = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir");
            String targetServer = request.getHeader("com.ibm.websphere.jmx.connector.rest.routing.serverName");
            targetUserDir = targetUserDir == null ? null : RESTHelper.URLDecoder(targetUserDir, null);
            String string = targetServer = targetServer == null ? null : RESTHelper.URLDecoder(targetServer, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)"RESTHelper", (TraceComponent)tc, (String)("Found routing context in headers.  Host:" + targetHost + " | UserDir:" + targetUserDir + " | Server:" + targetServer), (Object[])new Object[0]);
            }
            return new String[]{targetHost, targetUserDir, targetServer};
        }
        String queryStr = request.getQueryString();
        if (queryStr == null || !queryStr.contains("com.ibm.websphere.jmx.connector.rest.routing.hostName")) {
            if (errorIfNull) {
                throw ErrorHelper.createRESTHandlerJsonException(new IOException("routing context was not present in the request!"), null, 400);
            }
            return null;
        }
        String[] queryParts = queryStr.split("[&=]");
        String[] routingParams = new String[3];
        int size = queryParts.length;
        for (int i = 0; i < size; ++i) {
            if ("com.ibm.websphere.jmx.connector.rest.routing.hostName".equals(queryParts[i])) {
                routingParams[0] = RESTHelper.URLDecoder(queryParts[i + 1], null);
                ++i;
                continue;
            }
            if ("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir".equals(queryParts[i])) {
                routingParams[1] = RESTHelper.URLDecoder(queryParts[i + 1], null);
                ++i;
                continue;
            }
            if (!"com.ibm.websphere.jmx.connector.rest.routing.serverName".equals(queryParts[i])) continue;
            routingParams[2] = RESTHelper.URLDecoder(queryParts[i + 1], null);
            ++i;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)"RESTHelper", (TraceComponent)tc, (String)("Found routing context in queryStr.  Host:" + routingParams[0] + " | UserDir:" + routingParams[1] + " | Server:" + routingParams[2]), (Object[])new Object[0]);
        }
        return routingParams;
    }

    public static boolean isGetMethod(String method) {
        return "GET".equals(method);
    }

    public static boolean isPutMethod(String method) {
        return "PUT".equals(method);
    }

    public static boolean isPostMethod(String method) {
        return "POST".equals(method);
    }

    public static boolean isDeleteMethod(String method) {
        return "DELETE".equals(method);
    }

    public static String getRequiredParam(RESTRequest request, String paramName) {
        return RESTHelper.getRequiredParam(request, paramName, true);
    }

    private static String getRequiredParam(RESTRequest request, String paramName, boolean decode) {
        String param = request.getPathVariable(paramName);
        if (param == null) {
            throw new RESTHandlerMissingRequiredParam(paramName);
        }
        if (decode) {
            param = RESTHelper.URLDecoder(param, null);
        }
        return param;
    }

    public static String getQueryParam(RESTRequest request, String paramName) {
        return RESTHelper.getQueryParam(request, paramName, true);
    }

    public static String getQueryParam(RESTRequest request, String paramName, boolean decode) {
        String param = DefaultRoutingHelper.getQueryParameterValue((RESTRequest)request, (String)paramName);
        if (decode && param != null && !param.isEmpty()) {
            param = RESTHelper.URLDecoder(param, null);
        }
        return param;
    }

    public static List<String> getQueryParams(RESTRequest request, String paramName) {
        return RESTHelper.getQueryParams(request, paramName, true);
    }

    private static List<String> getQueryParams(RESTRequest request, String paramName, boolean decode) {
        List<String> params = RESTHelper.asList(DefaultRoutingHelper.getQueryParameterValues((RESTRequest)request, (String)paramName));
        if (decode) {
            ArrayList<String> decodedParams = new ArrayList<String>();
            for (String param : params) {
                if (param == null || param.isEmpty()) continue;
                decodedParams.add(RESTHelper.URLDecoder(param, null));
            }
            return decodedParams;
        }
        return params;
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getInputStream(RESTRequest request) {
        try {
            return request.getInputStream();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper", (String)"309", null, (Object[])new Object[]{request});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
    }

    public static <T> List<T> asList(T[] a) {
        if (a == null || a.length == 0) {
            return new ArrayList();
        }
        return Arrays.asList(a);
    }

    public static void ensureConsumesJson(RESTRequest request) {
        String contentType = RESTHelper.getType(request.getContentType());
        if (!"application/json".equalsIgnoreCase(contentType)) {
            throw new RESTHandlerUnsupportedMediaType(request.getContentType());
        }
    }

    private static String getType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int firstIndex = contentType.indexOf(";");
        String type = firstIndex == -1 ? contentType : contentType.substring(0, firstIndex);
        return type.trim().toLowerCase(Locale.ENGLISH);
    }
}

