/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.helpers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.plugins.CollectiveExecutor;
import com.ibm.wsspi.collective.plugins.CollectivePlugin;
import com.ibm.wsspi.collective.plugins.TaskStorage;
import com.ibm.wsspi.collective.plugins.helpers.CommandResult;
import com.ibm.wsspi.collective.plugins.helpers.PasswordUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.rest.handler.RESTRequest;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={MultipleRoutingHelper.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class MultipleRoutingHelper {
    private static final TraceComponent tc = Tr.register(MultipleRoutingHelper.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    private final String KEY_FILE_TRANSFER_HELPER = "fileTransferHelper";
    private final AtomicServiceReference<FileTransferHelper> fileTransferHelperRef = new AtomicServiceReference("fileTransferHelper");
    private final String KEY_TASK_STORAGE = "taskStorage";
    private final AtomicServiceReference<TaskStorage> taskStorageRef = new AtomicServiceReference("taskStorage");
    private final String KEY_COLLECTIVE_PLUGIN = "collectivePlugin";
    private final AtomicServiceReference<CollectivePlugin> collectivePluginRef = new AtomicServiceReference("collectivePlugin");
    private final String KEY_COLLECTIVE_EXECUTOR = "collectiveExecutor";
    private final AtomicServiceReference<CollectiveExecutor> collectiveExecutorRef = new AtomicServiceReference("collectiveExecutor");
    static final long serialVersionUID = -8671877675860332064L;

    @Activate
    protected void activate(ComponentContext cc) {
        this.fileTransferHelperRef.activate(cc);
        this.taskStorageRef.activate(cc);
        this.collectivePluginRef.activate(cc);
        this.collectiveExecutorRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.fileTransferHelperRef.deactivate(cc);
        this.taskStorageRef.deactivate(cc);
        this.collectivePluginRef.deactivate(cc);
        this.collectiveExecutorRef.deactivate(cc);
    }

    @Reference(name="fileTransferHelper", service=FileTransferHelper.class)
    protected void setFileTransferHelper(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.setReference(ref);
    }

    protected void unsetFileTransferHelper(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.unsetReference(ref);
    }

    protected FileTransferHelper getFileTransferHelper() {
        FileTransferHelper fileTransferHelper = (FileTransferHelper)this.fileTransferHelperRef.getService();
        if (fileTransferHelper == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"FileTransferHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return fileTransferHelper;
    }

    @Reference(name="taskStorage", service=TaskStorage.class)
    protected void setTaskStorageRef(ServiceReference<TaskStorage> ref) {
        this.taskStorageRef.setReference(ref);
    }

    protected void unsetTaskStorageRef(ServiceReference<TaskStorage> ref) {
        this.taskStorageRef.unsetReference(ref);
    }

    protected TaskStorage getTaskStorage() {
        TaskStorage taskStorage = (TaskStorage)this.taskStorageRef.getService();
        if (taskStorage == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"TaskStorage"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return taskStorage;
    }

    @Reference(name="collectivePlugin", service=CollectivePlugin.class)
    protected void setCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        this.collectivePluginRef.setReference(ref);
    }

    protected void unsetCollectivePlugin(ServiceReference<CollectivePlugin> ref) {
        this.collectivePluginRef.unsetReference(ref);
    }

    protected CollectivePlugin getCollectivePlugin() {
        CollectivePlugin collectivePlugin = (CollectivePlugin)this.collectivePluginRef.getService();
        if (collectivePlugin == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"CollectivePlugin"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return collectivePlugin;
    }

    @Reference(name="collectiveExecutor", service=CollectiveExecutor.class)
    protected void setCollectiveExecutor(ServiceReference<CollectiveExecutor> ref) {
        this.collectiveExecutorRef.setReference(ref);
    }

    protected void unsetCollectiveExecutor(ServiceReference<CollectiveExecutor> ref) {
        this.collectiveExecutorRef.unsetReference(ref);
    }

    protected CollectiveExecutor getCollectiveExecutor() {
        CollectiveExecutor collectiveExecutor = (CollectiveExecutor)this.collectiveExecutorRef.getService();
        if (collectiveExecutor == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"CollectiveExecutor"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return collectiveExecutor;
    }

    /*
     * WARNING - void declaration
     */
    Map<String, String> processEnvVars(String headerEnvVars) throws IOException {
        if (headerEnvVars != null && !headerEnvVars.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            JSONObject obj = JSONObject.parse((String)headerEnvVars);
            for (Object key : obj.keySet()) {
                try {
                    String k = (String)key;
                    map.put(k, String.valueOf(obj.get((Object)k)));
                }
                catch (Exception k) {
                    void e;
                    FFDCFilter.processException((Throwable)k, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MultipleRoutingHelper", (String)"212", (Object)this, (Object[])new Object[]{headerEnvVars});
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Exception while processing env vars map: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
            return map;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    Map<String, String> processTransferCredentials(@Sensitive String headerTransferCredentials) throws IOException {
        if (headerTransferCredentials != null && !headerTransferCredentials.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            JSONObject obj = JSONObject.parse((String)headerTransferCredentials);
            for (Object key : obj.keySet()) {
                try {
                    String k = (String)key;
                    if (!k.equals("rpcUser") && !k.equals("rpcUserPassword") && !k.equals("sshPrivateKey") && !k.equals("sshPrivateKeyPassword") && !k.equals("useSudo") && !k.equals("sudoUser") && !k.equals("sudoUserPassword")) continue;
                    map.put(k, String.valueOf(obj.get((Object)k)));
                }
                catch (Exception k) {
                    void e;
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "<sensitive java.lang.String>";
                    FFDCFilter.processException((Throwable)k, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MultipleRoutingHelper", (String)"248", (Object)this, (Object[])objectArray);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Exception while processing credentials map: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
            return map;
        }
        return null;
    }

    public String multipleDeleteInternal(RESTRequest request, String targetPath, boolean recursive) throws IOException {
        String headerHosts = request.getHeader("com.ibm.websphere.collective.hostNames");
        String headerAsync = request.getHeader("com.ibm.websphere.jmx.connector.rest.asyncExecution");
        String headerTransferCredentials = request.getHeader("com.ibm.websphere.jmx.connector.rest.transferCredentials");
        String headerEnvVars = request.getHeader("com.ibm.websphere.jmx.connector.rest.transferEnvVars");
        String headerAction = request.getHeader("com.ibm.websphere.jmx.connector.rest.preTransferAction");
        String headerActionOptions = request.getHeader("com.ibm.websphere.jmx.connector.rest.preTransferAction.options");
        assert (headerHosts != null);
        Map<String, String> transferCredentials = this.processTransferCredentials(headerTransferCredentials);
        Map<String, String> envVars = this.processEnvVars(headerEnvVars);
        String[] actions = new String[]{};
        String[] actionOptions = null;
        if (headerAction != null && !headerAction.isEmpty()) {
            actions = headerAction.split(",");
            String[] stringArray = actionOptions = headerActionOptions == null || headerActionOptions.isEmpty() ? null : headerActionOptions.split(",");
            if (actionOptions != null && actions.length != actionOptions.length) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (Enumeration)request.getLocales(), (String)"INVALID_ACTION_OPTIONS", (Object[])new Object[]{actionOptions}));
            }
        }
        String[] hosts = headerHosts.split(",");
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Processing a list of " + hosts.length + " hosts."), (Object[])new Object[0]);
        }
        boolean async = Boolean.valueOf(headerAsync);
        targetPath = FileTransferHelper.processRoutingPathLight(targetPath);
        TaskStorage taskStorage = this.getTaskStorage();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transferCredentials", transferCredentials);
        map.put("transferEnvVars", envVars);
        map.put("preTransferActionArray", actions);
        map.put("preTransferActionOptionsArray", actionOptions);
        map.put("controllerHost", this.getCollectivePlugin().getControllerHost());
        map.put("controllerPort", this.getCollectivePlugin().getControllerPort());
        map.put("recursiveDelete", recursive);
        map.put("fileToDelete", targetPath);
        Principal principal = request.getUserPrincipal();
        map.put("user", principal == null ? null : principal.getName());
        String taskID = taskStorage.createTask(hosts, map);
        this.getCollectiveExecutor().deleteFile(taskID, async);
        OrderedJSONObject obj = new OrderedJSONObject();
        if (!async) {
            obj.put((Object)"taskStatus", (Object)taskStorage.getTaskStatus(taskID));
        }
        obj.put((Object)"taskID", (Object)taskID);
        obj.put((Object)"taskURL", (Object)("/IBMJMXConnectorREST/file/status/" + taskID));
        return this.serializeJSON((JSONArtifact)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String multipleUploadInternal(RESTRequest request, String targetPath, boolean expand, boolean local) throws IOException {
        boolean createdNewFile;
        String uploadToDir;
        String uploadFrom;
        String fileName;
        boolean async;
        String[] hosts;
        String[] actionOptions;
        String[] actions;
        Map<String, String> envVars;
        Map<String, String> transferCredentials;
        String headerActionOptions;
        String headerAction;
        block17: {
            block15: {
                String absLocalFile;
                block16: {
                    String headerHosts = request.getHeader("com.ibm.websphere.collective.hostNames");
                    String headerAsync = request.getHeader("com.ibm.websphere.jmx.connector.rest.asyncExecution");
                    String headerTransferCredentials = request.getHeader("com.ibm.websphere.jmx.connector.rest.transferCredentials");
                    headerAction = request.getHeader("com.ibm.websphere.jmx.connector.rest.postTransferAction");
                    headerActionOptions = request.getHeader("com.ibm.websphere.jmx.connector.rest.postTransferAction.options");
                    String headerEnvVars = request.getHeader("com.ibm.websphere.jmx.connector.rest.transferEnvVars");
                    assert (headerHosts != null);
                    transferCredentials = this.processTransferCredentials(headerTransferCredentials);
                    envVars = this.processEnvVars(headerEnvVars);
                    actions = new String[]{};
                    actionOptions = null;
                    if (headerAction != null && !headerAction.isEmpty()) {
                        actions = headerAction.split(",");
                        String[] stringArray = actionOptions = headerActionOptions == null || headerActionOptions.isEmpty() ? null : headerActionOptions.split(",");
                        if (actionOptions != null && actions.length != actionOptions.length) {
                            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (Enumeration)request.getLocales(), (String)"INVALID_ACTION_OPTIONS", (Object[])new Object[]{actionOptions}));
                        }
                    }
                    hosts = headerHosts.split(",");
                    for (int i = 0; i < hosts.length; ++i) {
                        hosts[i] = hosts[i].trim();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Processing a list of " + hosts.length + " hosts."), (Object[])new Object[0]);
                    }
                    async = Boolean.valueOf(headerAsync);
                    targetPath = FileTransferHelper.processRoutingPathLight(targetPath);
                    fileName = FileTransferHelper.getFilename(targetPath);
                    uploadFrom = null;
                    uploadToDir = FileTransferHelper.getParentDir(targetPath);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed targetPath: " + targetPath + " | FileName: " + fileName + " | uploadToDir: " + uploadToDir), (Object[])new Object[0]);
                    }
                    createdNewFile = false;
                    if (!local) break block15;
                    InputStreamReader reader = null;
                    StringBuilder sb = new StringBuilder();
                    try {
                        reader = new InputStreamReader(request.getInputStream(), "UTF-8");
                        char[] buffer = new char[1024];
                        int count = 0;
                        while ((count = reader.read(buffer)) != -1) {
                            sb.append(buffer, 0, count);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.tryToClose(reader);
                        throw throwable;
                    }
                    FileUtils.tryToClose((Closeable)reader);
                    absLocalFile = sb.toString();
                    absLocalFile = this.getFileTransferHelper().getWsLocationAdmin().resolveString(absLocalFile);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Local file: " + absLocalFile), (Object[])new Object[0]);
                    }
                    if (!expand || !fileName.equals(FileTransferHelper.getFilename(absLocalFile))) break block16;
                    createdNewFile = true;
                    String localTarget = this.getFileTransferHelper().getWritableLocation() + FileTransferHelper.getTempArchiveName(request, fileName);
                    FileUtils.ensureDirExists((File)new File(FileTransferHelper.getParentDir(localTarget)));
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    FileChannel fromChannel = null;
                    FileChannel toChannel = null;
                    try {
                        fis = new FileInputStream(absLocalFile);
                        fos = new FileOutputStream(localTarget);
                        fromChannel = fis.getChannel();
                        toChannel = fos.getChannel();
                        fromChannel.transferTo(0L, fromChannel.size(), toChannel);
                    }
                    catch (Throwable throwable) {
                        FileUtils.tryToClose(fis);
                        FileUtils.tryToClose(fos);
                        FileUtils.tryToClose(fromChannel);
                        FileUtils.tryToClose(toChannel);
                        throw throwable;
                    }
                    FileUtils.tryToClose((Closeable)fis);
                    FileUtils.tryToClose((Closeable)fos);
                    FileUtils.tryToClose((Closeable)fromChannel);
                    FileUtils.tryToClose((Closeable)toChannel);
                    uploadFrom = localTarget;
                    break block17;
                }
                uploadFrom = absLocalFile;
                break block17;
            }
            createdNewFile = true;
            uploadFrom = this.getFileTransferHelper().getWritableLocation() + (expand ? FileTransferHelper.getTempArchiveName(request, fileName) : fileName);
            this.getFileTransferHelper().readRequestIntoFile(uploadFrom, request, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("uploadFrom: " + uploadFrom), (Object[])new Object[0]);
        }
        TaskStorage taskStorage = this.getTaskStorage();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uploadFromFile", uploadFrom);
        map.put("needToDeleteUploadSource", createdNewFile);
        map.put("uploadToDir", uploadToDir);
        if (expand) {
            map.put("uploadExpansionFilename", fileName);
        }
        map.put("transferCredentials", transferCredentials);
        map.put("transferEnvVars", envVars);
        map.put("postTransferAction", headerAction);
        map.put("postTransferActionArray", actions);
        map.put("postTransferActionOptions", headerActionOptions);
        map.put("postTransferActionOptionsArray", actionOptions);
        map.put("controllerHost", this.getCollectivePlugin().getControllerHost());
        map.put("controllerPort", this.getCollectivePlugin().getControllerPort());
        Principal principal = request.getUserPrincipal();
        map.put("user", principal == null ? null : principal.getName());
        String taskID = taskStorage.createTask(hosts, map);
        this.getCollectiveExecutor().deployArchive(taskID, async);
        OrderedJSONObject obj = new OrderedJSONObject();
        if (!async) {
            obj.put((Object)"taskStatus", (Object)taskStorage.getTaskStatus(taskID));
        }
        obj.put((Object)"taskID", (Object)taskID);
        obj.put((Object)"taskURL", (Object)("/IBMJMXConnectorREST/file/status/" + taskID));
        return this.serializeJSON((JSONArtifact)obj);
    }

    private void ensureTaskIDExists(TaskStorage storage, String taskID) {
        if (storage.getTaskStatus(taskID) == null) {
            throw ErrorHelper.createRESTHandlerJsonException(new IllegalArgumentException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"UNKNOWN_TASK_ID_ERROR", (Object[])new Object[]{taskID}, (String)"CWWKX0131E: A task with id ''{0}'' was not found.")), null, 404);
        }
    }

    public String getTaskProperty(String taskID, String property) {
        TaskStorage storage = this.getTaskStorage();
        this.ensureTaskIDExists(storage, taskID);
        Object value = storage.getTaskPropertyValue(taskID, property);
        String valueString = null;
        if (value != null) {
            valueString = PasswordUtils.maskPasswords((String)property, (Object)value).toString();
            valueString = PasswordUtils.maskPasswords((String)valueString);
        }
        return valueString;
    }

    public String getTaskProperties(String taskID) {
        TaskStorage storage = this.getTaskStorage();
        this.ensureTaskIDExists(storage, taskID);
        Set keys = storage.getTaskPropertyKeys(taskID);
        JSONArray array = new JSONArray();
        if (keys != null) {
            String basePropertyURL = "/IBMJMXConnectorREST/file/status/" + taskID + "/properties/";
            for (String key : keys) {
                OrderedJSONObject obj = new OrderedJSONObject();
                obj.put((Object)"key", (Object)key);
                obj.put((Object)"keyURL", (Object)(basePropertyURL + key));
                array.add((Object)obj);
            }
        }
        return this.serializeJSON((JSONArtifact)array);
    }

    public String getAllStatus(Set<Map.Entry<String, List<String>>> filter) {
        TaskStorage storage = this.getTaskStorage();
        JSONArray array = new JSONArray();
        Set ids = storage.getTaskTokens(filter);
        if (ids != null) {
            for (String taskID : ids) {
                OrderedJSONObject obj = new OrderedJSONObject();
                obj.put((Object)"taskID", (Object)taskID);
                obj.put((Object)"taskStatus", (Object)storage.getTaskStatus(taskID));
                obj.put((Object)"taskURL", (Object)("/IBMJMXConnectorREST/file/status/" + taskID));
                array.add((Object)obj);
            }
        }
        return this.serializeJSON((JSONArtifact)array);
    }

    public String getStatus(String taskID) {
        TaskStorage storage = this.getTaskStorage();
        this.ensureTaskIDExists(storage, taskID);
        OrderedJSONObject obj = new OrderedJSONObject();
        obj.put((Object)"taskStatus", (Object)storage.getTaskStatus(taskID));
        obj.put((Object)"propertiesURL", (Object)("/IBMJMXConnectorREST/file/status/" + taskID + "/properties"));
        obj.put((Object)"hostsURL", (Object)("/IBMJMXConnectorREST/file/status/" + taskID + "/hosts"));
        return this.serializeJSON((JSONArtifact)obj);
    }

    public String getHosts(String taskID) {
        TaskStorage storage = this.getTaskStorage();
        this.ensureTaskIDExists(storage, taskID);
        JSONArray array = new JSONArray();
        String[] hosts = storage.getTaskHostNames(taskID);
        if (hosts != null) {
            for (String host : hosts) {
                OrderedJSONObject obj = new OrderedJSONObject();
                obj.put((Object)"hostName", (Object)host);
                obj.put((Object)"hostStatus", (Object)storage.getHostStatus(taskID, host));
                obj.put((Object)"hostURL", (Object)("/IBMJMXConnectorREST/file/status/" + taskID + "/hosts/" + host));
                array.add((Object)obj);
            }
        }
        return this.serializeJSON((JSONArtifact)array);
    }

    public String getHostDetails(String taskID, String host) {
        TaskStorage storage = this.getTaskStorage();
        this.ensureTaskIDExists(storage, taskID);
        JSONArray array = new JSONArray();
        List results = storage.getHostResult(taskID, host);
        if (results != null) {
            for (CommandResult result : results) {
                OrderedJSONObject obj = new OrderedJSONObject();
                obj.put((Object)"timestamp", (Object)result.getTimestamp());
                obj.put((Object)"status", (Object)result.getStatus());
                obj.put((Object)"description", (Object)result.getDescription());
                obj.put((Object)"returnCode", (Object)result.getReturnCode());
                obj.put((Object)"stdOut", (Object)result.getStdout());
                obj.put((Object)"stdErr", (Object)result.getStderr());
                array.add((Object)obj);
            }
        }
        return this.serializeJSON((JSONArtifact)array);
    }

    /*
     * WARNING - void declaration
     */
    private String serializeJSON(JSONArtifact artifact) {
        try {
            return artifact.serialize().replace("\\/", "/");
        }
        catch (IOException iOException) {
            void ioe;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MultipleRoutingHelper", (String)"665", (Object)this, (Object[])new Object[]{artifact});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)ioe, null, 500);
        }
    }
}

