/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MultipleRoutingHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerOSGiError;
import java.io.IOException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/file/{filePath}"})
public class FileHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(FileHandler.class);
    private final String KEY_FILE_TRANSFER_HELPER = "fileTransferHelper";
    private transient FileTransferHelper fileTransferHelper;
    private final AtomicServiceReference<FileTransferHelper> fileTransferHelperRef = new AtomicServiceReference("fileTransferHelper");
    private transient MultipleRoutingHelper multipleRoutingHelper;
    private transient ComponentContext componentContext;
    static final long serialVersionUID = 2853794455008266509L;

    @Activate
    protected void activate(ComponentContext context) {
        this.fileTransferHelperRef.activate(context);
        this.componentContext = context;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.fileTransferHelperRef.deactivate(context);
        this.componentContext = null;
    }

    @Reference(name="fileTransferHelper", service=FileTransferHelper.class)
    protected void setFileTransferHelperRef(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.setReference(ref);
    }

    protected void unsetFileTransferHelperRef(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.unsetReference(ref);
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (RESTHelper.isGetMethod(method)) {
            this.download(request, response);
        } else if (RESTHelper.isPostMethod(method)) {
            this.upload(request, response);
        } else if (RESTHelper.isDeleteMethod(method)) {
            this.delete(request, response);
        } else {
            throw new RESTHandlerMethodNotAllowedError("GET,POST,DELETE");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void download(RESTRequest request, RESTResponse response) {
        long endOffset;
        long startOffset;
        String filePath = RESTHelper.getRequiredParam(request, "filePath");
        String startOffsetValue = RESTHelper.getQueryParam(request, "startOffset");
        String endOffsetValue = RESTHelper.getQueryParam(request, "endOffset");
        try {
            startOffset = startOffsetValue != null && !startOffsetValue.isEmpty() ? Long.valueOf(startOffsetValue) : 0L;
            endOffset = endOffsetValue != null && !endOffsetValue.isEmpty() ? Long.valueOf(endOffsetValue) : -1L;
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.FileHandler", (String)"103", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        FileTransferHelper helper = this.getFileTransferHelper();
        if (RESTHelper.containsSingleRoutingContext(request)) {
            helper.routedDownloadInternal(request, response, filePath, false);
        } else {
            helper.downloadInternal(request, response, filePath, startOffset, endOffset, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void upload(RESTRequest request, RESTResponse response) {
        String uploadResults;
        boolean localFile;
        String filePath = RESTHelper.getRequiredParam(request, "filePath");
        String expand = RESTHelper.getQueryParam(request, "expandOnCompletion");
        String local = RESTHelper.getQueryParam(request, "local");
        boolean expansion = expand != null && "true".compareToIgnoreCase(expand) == 0;
        boolean bl = localFile = local != null && "true".compareToIgnoreCase(local) == 0;
        if (filePath.endsWith("/")) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        if (RESTHelper.containsMultipleRoutingContext(request)) {
            try {
                uploadResults = this.getMultipleRoutingHelper().multipleUploadInternal(request, filePath, expansion, localFile);
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.FileHandler", (String)"135", (Object)this, (Object[])new Object[]{request, response});
                throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
            }
        } else {
            FileTransferHelper helper = this.getFileTransferHelper();
            if (RESTHelper.containsSingleRoutingContext(request)) {
                helper.routedUploadInternal(request, filePath, expansion, false);
            } else {
                helper.uploadInternal(request, filePath, expansion, false);
            }
            uploadResults = null;
        }
        OutputHelper.writeJsonOutput(response, uploadResults);
    }

    /*
     * WARNING - void declaration
     */
    private void delete(RESTRequest request, RESTResponse response) {
        String deleteOutput;
        boolean recursive;
        String filePath = RESTHelper.getRequiredParam(request, "filePath");
        String recursiveDelete = RESTHelper.getQueryParam(request, "recursiveDelete");
        boolean bl = recursive = recursiveDelete != null && "true".compareToIgnoreCase(recursiveDelete) == 0;
        if (filePath.endsWith("/")) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        if (RESTHelper.containsMultipleRoutingContext(request)) {
            try {
                deleteOutput = this.getMultipleRoutingHelper().multipleDeleteInternal(request, filePath, recursive);
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.FileHandler", (String)"170", (Object)this, (Object[])new Object[]{request, response});
                throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
            }
        } else {
            FileTransferHelper helper = this.getFileTransferHelper();
            if (RESTHelper.containsSingleRoutingContext(request)) {
                helper.routedDeleteInternal(request, filePath, recursive);
            } else {
                helper.deleteInternal(filePath, recursive);
            }
            deleteOutput = null;
        }
        OutputHelper.writeJsonOutput(response, deleteOutput);
    }

    private synchronized FileTransferHelper getFileTransferHelper() {
        if (this.fileTransferHelper == null) {
            FileTransferHelper fileTransferHelper = this.fileTransferHelper = this.fileTransferHelperRef != null ? (FileTransferHelper)this.fileTransferHelperRef.getService() : null;
            if (this.fileTransferHelper == null) {
                throw new RESTHandlerOSGiError("FileTransferHelper");
            }
        }
        return this.fileTransferHelper;
    }

    private synchronized MultipleRoutingHelper getMultipleRoutingHelper() {
        if (this.multipleRoutingHelper == null) {
            BundleContext bc = this.componentContext.getBundleContext();
            ServiceReference multipleRoutingHelperRef = bc.getServiceReference(MultipleRoutingHelper.class);
            MultipleRoutingHelper multipleRoutingHelper = this.multipleRoutingHelper = multipleRoutingHelperRef != null ? (MultipleRoutingHelper)bc.getService(multipleRoutingHelperRef) : null;
            if (this.multipleRoutingHelper == null) {
                IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"MultipleRoutingHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
                throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
            }
        }
        return this.multipleRoutingHelper;
    }
}

