/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.tai.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.tai.internal.TAIServiceImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InterceptorConfigImpl
implements TrustAssociationInterceptor,
ConfigurationListener {
    private static final TraceComponent tc = Tr.register(InterceptorConfigImpl.class);
    static final String KEY_ID = "id";
    static final String KEY_CLASS_NAME = "className";
    static final String KEY_ENABLED = "enabled";
    static final String CFG_KEY_PROPERTIES_PID = "propertiesRef";
    static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    private String id = null;
    private String className = null;
    private boolean invokeBeforeSSO = false;
    private boolean invokeAfterSSO = false;
    private TrustAssociationInterceptor interceptorInstance = null;
    private final Properties properties = new Properties();
    private volatile Library sharedLibrary = null;
    private volatile String pid;
    private volatile TAIServiceImpl taiService = null;
    static final long serialVersionUID = -3527215466269005642L;

    public InterceptorConfigImpl() {
    }

    public InterceptorConfigImpl(Map<String, Object> props) {
        this.processConfig(props);
    }

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.configAdminRef.activate(cc);
        this.processConfig(props);
    }

    protected void modified(Map<String, Object> props) {
        this.processConfig(props);
    }

    protected void deactivate(ComponentContext cc) {
        this.configAdminRef.deactivate(cc);
    }

    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.unsetReference(ref);
    }

    protected void setSharedLib(Library svc) {
        this.sharedLibrary = svc;
    }

    protected void unsetSharedLib(Library ref) {
    }

    private void processConfig(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        if (((Boolean)props.get(KEY_ENABLED)).booleanValue()) {
            this.id = (String)props.get(KEY_ID);
            this.className = (String)props.get(KEY_CLASS_NAME);
            this.invokeBeforeSSO = (Boolean)props.get("invokeBeforeSSO");
            this.invokeAfterSSO = (Boolean)props.get("invokeAfterSSO");
            this.pid = (String)props.get(CFG_KEY_PROPERTIES_PID);
            this.processProperties();
            this.initializeInterceptor();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Skipping TAI that is not enable: " + props), (Object[])new Object[0]);
        }
    }

    private void processProperties() {
        this.properties.clear();
        if (this.pid == null) {
            return;
        }
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getServiceWithException();
        Configuration config = null;
        try {
            Configuration[] configList = configAdmin.listConfigurations(FilterUtils.createPropertyFilter((String)"service.pid", (String)this.pid));
            if (configList != null && configList.length > 0) {
                config = configAdmin.getConfiguration(this.pid);
            }
        }
        catch (InvalidSyntaxException configList) {
            FFDCFilter.processException((Throwable)configList, (String)"com.ibm.ws.security.authentication.tai.internal.InterceptorConfigImpl", (String)"147", (Object)this, (Object[])new Object[0]);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authentication.tai.internal.InterceptorConfigImpl", (String)"148", (Object)this, (Object[])new Object[0]);
        }
        if (config != null) {
            Dictionary cProps = config.getProperties();
            Enumeration keys = cProps.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.startsWith(".") || key.startsWith("config.") || key.startsWith("service.") || key.equals(KEY_ID)) continue;
                this.properties.put(key, cProps.get(key));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("effective interceptor properties: " + this.properties.toString()), (Object[])new Object[0]);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isInvokeBeforeSSO() {
        return this.invokeBeforeSSO;
    }

    public boolean isInvokeAfterSSO() {
        return this.invokeAfterSSO;
    }

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - void declaration
     */
    private TrustAssociationInterceptor loadInterceptor() throws Exception {
        Tr.info((TraceComponent)tc, (String)"SEC_TAI_LOAD_INIT", (Object[])new Object[]{this.id});
        ClassLoader sharedLibClassLoader = this.sharedLibrary.getClassLoader();
        TrustAssociationInterceptor tai = null;
        try {
            Class<?> myClass = sharedLibClassLoader.loadClass(this.className);
            tai = (TrustAssociationInterceptor)myClass.newInstance();
        }
        catch (Exception myClass) {
            void e;
            FFDCFilter.processException((Throwable)myClass, (String)"com.ibm.ws.security.authentication.tai.internal.InterceptorConfigImpl", (String)"206", (Object)this, (Object[])new Object[0]);
            throw e;
        }
        return tai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void initializeInterceptor() {
        try {
            this.interceptorInstance = this.loadInterceptor();
            int initResult = this.interceptorInstance.initialize(this.properties);
            if (initResult == 0) {
                Tr.info((TraceComponent)tc, (String)"SEC_TAI_INIT_SIGNATURE", (Object[])new Object[]{this.className});
            } else {
                Tr.error((TraceComponent)tc, (String)"SEC_TAI_INIT_CLASS_LOAD_ERROR", (Object[])new Object[]{initResult});
            }
        }
        catch (Exception initResult) {
            void e;
            FFDCFilter.processException((Throwable)initResult, (String)"com.ibm.ws.security.authentication.tai.internal.InterceptorConfigImpl", (String)"221", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"SEC_TAI_INIT_CLASS_LOAD_ERROR", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            if (this.taiService != null) {
                this.taiService.initialize();
            }
        }
    }

    public TrustAssociationInterceptor getInterceptorInstance(TAIServiceImpl taiServiceImpl) {
        this.taiService = taiServiceImpl;
        return this.interceptorInstance;
    }

    @Override
    public boolean isTargetInterceptor(HttpServletRequest req) throws WebTrustAssociationException {
        return false;
    }

    @Override
    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest req, HttpServletResponse res) throws WebTrustAssociationFailedException {
        return null;
    }

    @Override
    public int initialize(Properties props) throws WebTrustAssociationFailedException {
        return 0;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1 && event.getPid().equals(this.pid)) {
            this.processProperties();
            this.initializeInterceptor();
        }
    }
}

