/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.JTAResource;
import com.ibm.ws.Transaction.JTA.ResourceSupportsOnePhaseCommit;
import com.ibm.ws.Transaction.JTA.ResourceWrapper;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class JTAResourceBase
extends ResourceWrapper
implements JTAResource,
ResourceSupportsOnePhaseCommit {
    protected int _state = 0;
    protected Xid _xid;
    protected XAResource _resource;
    protected boolean _supportSuspend = true;
    protected boolean _supportResume = true;
    protected JTAResource.JTAResourceVote _vote = JTAResource.JTAResourceVote.none;
    protected int _prepareXARC = 0;
    protected int _completionXARC = 0;
    protected boolean _completedCommit;
    protected int _startFlag = 0;
    public static final int OUTCOME_DIAGNOSTICS = 0;
    public static final int PREPARE_DIAGNOSTICS = 1;
    private static final TraceComponent tc = Tr.register(JTAResourceBase.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TraceComponent tcSummary = Tr.register((String)"TRANSUMMARY", (String)"TransactionSummary", null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object)new Object[]{this._resource, JTAResourceBase.printState(this._state)});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"xa_start", (Object)this);
        }
        int rc = -1;
        try {
            int flags;
            switch (this._state) {
                case 0: {
                    flags = this._startFlag;
                    break;
                }
                case 6: {
                    flags = 0x200000;
                    break;
                }
                case 2: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"startAssociation");
                    }
                    return;
                }
                case 1: {
                    if (!this._supportResume) {
                        Tr.warning((TraceComponent)tc, (String)"WTRN0021_TMRESUME_NOT_SUPPORTED");
                        throw new XAException(-5);
                    }
                    flags = 0x8000000;
                    break;
                }
                case 4: {
                    throw new XAException(100);
                }
                default: {
                    Tr.warning((TraceComponent)tc, (String)"WTRN0022_UNKNOWN_XARESOURCE_STATE");
                }
                case 3: 
                case 5: {
                    throw new XAException(-6);
                }
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("xa_start with flag: " + Util.printFlag(flags)));
            }
            this._resource.start(this._xid, flags);
            rc = 0;
            this._state = 2;
        }
        catch (XAException xae) {
            this.processXAException("start", xae);
            rc = xae.errorCode;
            if (xae.errorCode >= 100 && xae.errorCode <= 107) {
                this._state = 4;
            } else if (xae.errorCode != -9) {
                this._state = 3;
            }
            throw xae;
        }
        catch (Throwable t) {
            this._state = 3;
            this.processThrowable("start", t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start");
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)"xa_start result:", (Object)XAReturnCodeHelper.convertXACode(rc));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void end(int flag) throws XAException {
        int newstate;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"end", (Object)new Object[]{this._resource, Util.printFlag(flag), JTAResourceBase.printState(this._state)});
        }
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"xa_end", (Object)new Object[]{this, "flags = " + Util.printFlag(flag)});
        }
        int rc = -1;
        switch (flag) {
            case 0x4000000: {
                if (this._state == 2 || this._state == 1) {
                    newstate = 5;
                    break;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"end");
                }
                return;
            }
            case 0x20000000: {
                if (this._state == 4 || this._state == 5 || this._state == 3) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"end");
                    }
                    return;
                }
                newstate = 4;
                break;
            }
            case 0x2000000: {
                if (!this._supportSuspend) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"TMSUSPEND is not supported.");
                    }
                    throw new XAException(-5);
                }
                if (this._state == 3 || this._state == 5) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"TMSUSPEND in invalid state.");
                    }
                    throw new XAException(-6);
                }
                if (this._state != 2) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"end");
                    }
                    return;
                }
                newstate = 1;
                break;
            }
            default: {
                Tr.warning((TraceComponent)tc, (String)"WTRN0023_INVALID_XAEND_FLAG", (Object)Util.printFlag(flag));
                throw new XAException(-5);
            }
        }
        try {
            this._resource.end(this._xid, flag);
            rc = 0;
            this._state = newstate;
        }
        catch (XAException xae) {
            this.processXAException("end", xae);
            rc = xae.errorCode;
            this._state = xae.errorCode >= 100 && xae.errorCode <= 107 ? 4 : 3;
            throw xae;
        }
        catch (Throwable t) {
            this._state = 3;
            this.processThrowable("end", t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"end");
            }
            if (tcSummary.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcSummary, (String)"xa_end result:", (Object)XAReturnCodeHelper.convertXACode(rc));
            }
        }
    }

    @Override
    public void log(RecoverableUnitSection rus) throws SystemException {
        throw new SystemException("Resource does not support logging");
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public final Xid getXID() {
        return this._xid;
    }

    @Override
    public final int getState() {
        return this._state;
    }

    @Override
    public void setState(int state) {
        this._state = state;
    }

    @Override
    public final XAResource XAResource() {
        return this._resource;
    }

    public void setBranchCoupling(int startFlag) {
        this._startFlag = startFlag;
    }

    public int getBranchCoupling() {
        return this._startFlag;
    }

    protected void processXAException(String operation, XAException xae) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"XAResource {0} threw an XAException during {1}.  The error code provided was {2}.", (Object)new Object[]{this._resource, operation, XAReturnCodeHelper.convertXACode(xae.errorCode)});
        }
        FFDCFilter.processException((Throwable)xae, (String)(this.getClass().getName() + "." + operation), (String)"307", (Object)this);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Exception", (Object)xae);
            Tr.debug((TraceComponent)tc, (String)"XID", (Object)this._xid);
        }
    }

    protected void processThrowable(String operation, Throwable t) throws XAException {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"XAResource {0} threw an unchecked exception during {1}.  The original exception was {2}.", (Object)new Object[]{this._resource, operation, t});
        }
        FFDCFilter.processException((Throwable)t, (String)(this.getClass().getName() + "." + operation), (String)"341", (Object)this);
        String msg = "XAResource threw an unchecked exception";
        XAException xae = new XAException("XAResource threw an unchecked exception");
        xae.errorCode = -3;
        throw xae;
    }

    protected static String printState(int state) {
        switch (state) {
            case 2: {
                return "XARESOURCE_ACTIVE";
            }
            case 0: {
                return "XARESOURCE_NOTASSOCIATED";
            }
            case 6: {
                return "XARESOURCE_NOTASSOCIATED_TMJOIN";
            }
            case 3: {
                return "XARESOURCE_FAILED";
            }
            case 4: {
                return "XARESOURCE_ROLLBACK_ONLY";
            }
            case 1: {
                return "XARESOURCE_SUSPENDED";
            }
            case 5: {
                return "XARESOURCE_IDLE";
            }
        }
        return "XAResource State Error";
    }

    public void diagnose(int diagType) {
        int rc = -1;
        switch (diagType) {
            case 1: {
                rc = this._prepareXARC;
                break;
            }
            case 0: {
                rc = this._completionXARC;
                break;
            }
            default: {
                return;
            }
        }
        if (rc == 0) {
            switch (diagType) {
                case 1: {
                    Tr.info((TraceComponent)tc, (String)"WTRN0089_PREPARED", (Object)new Object[]{this._resource, this._vote.name()});
                    break;
                }
                case 0: {
                    JTAResource.JTAResourceVote result = JTAResource.JTAResourceVote.none;
                    if (this._completedCommit) {
                        result = JTAResource.JTAResourceVote.commit;
                    } else {
                        switch (this.getResourceStatus()) {
                            case 6: {
                                result = JTAResource.JTAResourceVote.rollback;
                                break;
                            }
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                result = JTAResource.JTAResourceVote.heuristic;
                                break;
                            }
                        }
                    }
                    Tr.info((TraceComponent)tc, (String)"WTRN0090_COMPLETED", (Object)new Object[]{this._resource, this._vote.name(), result.name()});
                }
            }
        } else {
            Tr.info((TraceComponent)tc, (String)"WTRN0088_EXCEPTION_DIAG", (Object)new Object[]{this._resource, XAReturnCodeHelper.convertXACode(rc)});
        }
    }

    public void copyDiagnostics(JTAResourceBase res) {
        this._vote = res._vote;
        this._completedCommit = res._completedCommit;
        this._prepareXARC = res._prepareXARC;
        this._completionXARC = res._completionXARC;
        this.setResourceStatus(res.getResourceStatus());
    }

    protected void traceCreate() {
        if (tcSummary.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcSummary, (String)"JTA Resource created:", (Object)new Object[]{this, this.describe()});
        }
    }
}

