/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.util.alarm;

import com.ibm.tx.jta.util.alarm.AlarmImpl;
import com.ibm.tx.jta.util.alarm.JTMThreadFactory;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.alarm.AlarmManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AlarmManagerImpl
implements AlarmManager {
    private static final int POOL_SIZE = 10;
    private final ScheduledExecutorService _scheduler = Executors.newScheduledThreadPool(10, new JTMThreadFactory());

    public Alarm scheduleAlarm(long millisecondDelay, AlarmListener listener, Object context) {
        AlarmListenerWrapper command = new AlarmListenerWrapper(listener, context);
        ScheduledFuture<?> future = this._scheduler.schedule(command, millisecondDelay, TimeUnit.MILLISECONDS);
        AlarmImpl alarmImpl = new AlarmImpl(future, (ThreadPoolExecutor)((Object)this._scheduler));
        return alarmImpl;
    }

    public Alarm scheduleDeferrableAlarm(long millisecondDelay, AlarmListener listener, Object context) {
        return this.scheduleAlarm(millisecondDelay, listener, context);
    }

    public Alarm scheduleAlarm(long millisecondDelay, AlarmListener listener) {
        return this.scheduleAlarm(millisecondDelay, listener, null);
    }

    public Alarm scheduleDeferrableAlarm(long millisecondDelay, AlarmListener listener) {
        return this.scheduleAlarm(millisecondDelay, listener, null);
    }

    public void shutdown() {
        this._scheduler.shutdown();
    }

    public void shutdownNow() {
        this._scheduler.shutdownNow();
    }

    private static class AlarmListenerWrapper
    implements Runnable {
        private final ClassLoader _contextClassLoader;
        private final Object _context;
        private final AlarmListener _alarmListener;

        public AlarmListenerWrapper(AlarmListener alarmListener, Object context) {
            this._alarmListener = alarmListener;
            this._context = context;
            this._contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader originalLoader = this.setTCCL(this._contextClassLoader);
            try {
                this._alarmListener.alarm(this._context);
            }
            finally {
                this.setTCCL(originalLoader);
            }
        }

        private ClassLoader setTCCL(final ClassLoader classLoader) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader originalLoader = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(classLoader);
                    return originalLoader;
                }
            });
        }
    }
}

