/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.XAResourceFactory;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.tx.jta.impl.DirectEnlistXAResourceInfo;
import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.PartnerLogData;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.XARecoveryDataHelper;
import com.ibm.tx.jta.impl.XARecoveryWrapper;
import com.ibm.tx.jta.impl.XidImpl;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.JTA.XARminst;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XARecoveryData
extends PartnerLogData {
    private static final TraceComponent tc = Tr.register(XARecoveryData.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected boolean _supportsIsSameRM;
    protected ClassLoader _recoveryClassLoader;
    protected byte[] _wrapperData;
    protected final String[] _extDirs;
    protected final int _priority;
    protected boolean auditRecovery = ConfigurationProviderManager.getConfigurationProvider().getAuditRecovery();
    private static boolean _continuePropagatingXAResourceTimeout = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.ibm.tx.continuePropagatingXAResourceTimeout");
        }
    });
    protected boolean _propagateXAResourceTransactionTimeout = ConfigurationProviderManager.getConfigurationProvider().getPropagateXAResourceTransactionTimeout();

    protected XARecoveryData(FailureScopeController failureScopeController, XARecoveryWrapper logData) {
        super(logData, failureScopeController);
        this._sectionId = 34;
        this._priority = logData.getPriority();
        this._extDirs = logData.getXAResourceFactoryClasspath();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"XARecoveryData", (Object)new Object[]{failureScopeController, logData, this});
        }
    }

    public XARecoveryData(RecoveryLog partnerLog, byte[] serializedLogData, long id, int priority) {
        super(serializedLogData, null, id, partnerLog);
        this._priority = priority;
        int delimiterPosition = 0;
        for (int i = 0; i < serializedLogData.length; ++i) {
            if (serializedLogData[i] != 0) continue;
            delimiterPosition = i;
            break;
        }
        this._wrapperData = new byte[serializedLogData.length - delimiterPosition - 1];
        System.arraycopy(serializedLogData, delimiterPosition + 1, this._wrapperData, 0, this._wrapperData.length);
        if (delimiterPosition > 0) {
            byte[] classpathBytes = new byte[delimiterPosition];
            System.arraycopy(serializedLogData, 0, classpathBytes, 0, classpathBytes.length);
            String xaResInfoClasspath = new String(classpathBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Classpath data recovered", (Object)xaResInfoClasspath);
            }
            StringTokenizer tokenizer = new StringTokenizer(xaResInfoClasspath, File.pathSeparator);
            this._extDirs = new String[tokenizer.countTokens()];
            for (int i = 0; i < this._extDirs.length; ++i) {
                this._extDirs[i] = tokenizer.nextToken();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("_extDirs[" + i + "] = " + this._extDirs[i]));
            }
        } else {
            this._extDirs = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"XARecoveryData", (Object)new Object[]{partnerLog, serializedLogData, id, priority, this});
        }
    }

    @Override
    protected void preLogData() throws Exception {
        this._fsc.getRecoveryManager().waitForReplayCompletion();
    }

    @Override
    protected void postLogData(RecoverableUnit ru) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postLogData");
        }
        if (this._priority != 0) {
            RecoverableUnitSection section = ru.createSection(37, true);
            section.addData(Util.intToBytes(this._priority));
        }
    }

    public void deserialize(ClassLoader parentClassLoader) {
        XARecoveryWrapper wrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deserialize", (Object)new Object[]{this, parentClassLoader});
        }
        if ((wrapper = XARecoveryWrapper.deserialize(this._wrapperData)) != null) {
            if (this._extDirs != null) {
                wrapper.setXAResourceFactoryClasspath(this._extDirs);
            }
            wrapper.setPriority(this._priority);
            this._logData = wrapper;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deserialize");
        }
    }

    public XARecoveryWrapper getXARecoveryWrapper() {
        return (XARecoveryWrapper)this._logData;
    }

    public Serializable getXAResourceInfo() {
        return ((XARecoveryWrapper)this._logData).getXAResourceInfo();
    }

    public int getPriority() {
        return this._priority;
    }

    public XARminst getXARminst() throws XAException {
        XAResourceFactory xaResFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getXARminst", (Object)new Object[]{this});
        }
        XAResource xaRes = null;
        Serializable xaResInfo = null;
        XARecoveryWrapper xarw = (XARecoveryWrapper)this._logData;
        xaResInfo = this.getXAResourceInfo();
        if (xaResInfo instanceof DirectEnlistXAResourceInfo) {
            xaResFactory = null;
            xaRes = ((DirectEnlistXAResourceInfo)xaResInfo).getXAResource();
        } else {
            String xaResFactoryClassName;
            block22: {
                xaResFactoryClassName = xarw.getXAResourceFactoryClassName();
                xaResFactory = XARecoveryDataHelper.lookupXAResourceFactory(xaResFactoryClassName);
                if (xaResFactory != null) {
                    try {
                        xaRes = xaResFactory.getXAResource(xaResInfo);
                    }
                    catch (XAResourceNotAvailableException e) {
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug((TraceComponent)tc, (String)"getXARminst", (Object)e);
                    }
                }
            }
            if (xaRes == null) {
                if (xaResFactoryClassName.startsWith("(")) {
                    XAException e = new XAException(-7);
                    e.initCause(new XAResourceNotAvailableException());
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getXARminst", (Object)e);
                    }
                    throw e;
                }
                Class<?> xaResFactoryClass = null;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"calling Class.forName", (Object)xaResFactoryClassName);
                    }
                    xaResFactoryClass = Class.forName(xaResFactoryClassName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"xaResFactoryClass", (Object)new Object[]{xaResFactoryClass, xaResFactoryClass.getClassLoader()});
                    }
                    xaResFactory = (XAResourceFactory)xaResFactoryClass.newInstance();
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.impl.XARecoveryData.getXARminst", (String)"419");
                    Tr.error((TraceComponent)tc, (String)"WTRN0004_CANT_CREATE_XARESOURCEFACTORY", (Object)new Object[]{xaResFactoryClassName, t});
                    XAException xae = new XAException(-3);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getXARminst", (Object)xae);
                    }
                    throw xae;
                }
                try {
                    xaResInfo = this.getXAResourceInfo();
                    xaRes = xaResFactory.getXAResource(xaResInfo);
                    if (null == xaRes) {
                        throw new XAResourceNotAvailableException();
                    }
                }
                catch (XAResourceNotAvailableException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.XARecoveryData.getXARminst", (String)"491", (Object)this);
                    Throwable t = new XAException(-7).initCause(e);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getXARminst", (Object)t);
                    }
                    throw (XAException)t;
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.XARecoveryData.getXARminst", (String)"563");
                    Tr.error((TraceComponent)tc, (String)"WTRN0005_CANT_RECREATE_XARESOURCE", (Object)new Object[]{xaResInfo, e});
                    Throwable t = new XAException(-3).initCause(e);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getXARminst", (Object)t);
                    }
                    throw (XAException)t;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"xaResource", (Object)new Object[]{xaRes, xaRes.getClass().getClassLoader()});
        }
        XARminst xarm = new XARminst(xaRes, xaResFactory);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getXARminst", (Object)xarm);
        }
        return xarm;
    }

    @Override
    public boolean recover(ClassLoader cl, Xid[] knownXids, byte[] failedStoken, byte[] cruuid, int restartEpoch) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)new Object[]{cl, knownXids, failedStoken, cruuid, restartEpoch, this});
        }
        if (this._recovered) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)"recovered");
            }
            return true;
        }
        if (this._terminating) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)"terminating");
            }
            return false;
        }
        if (this._logData == null) {
            this.deserialize(cl);
            if (this._logData == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recover", (Object)"deserialize failed");
                }
                return RecoveryManager.recoveryOnlyMode;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"recovering", (Object)this._logData);
        }
        XARminst xarm = null;
        try {
            this.auditXaRecover(this.getXAResourceInfo());
            xarm = this.getXARminst();
            if (xarm == null) {
                throw new XAException(-3);
            }
        }
        catch (XAException xae) {
            boolean result;
            switch (xae.errorCode) {
                case 5: {
                    this.decrementCount();
                    this._recovered = true;
                }
                case -7: {
                    result = this._recovered;
                    break;
                }
                default: {
                    result = RecoveryManager.recoveryOnlyMode;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)result);
            }
            return result;
        }
        Xid[] inDoubt = null;
        int numXids = 0;
        try {
            inDoubt = xarm.recover();
            this._recovered = true;
            numXids = inDoubt.length;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.tx.jta.impl.XARecoveryData.recover", (String)"564", (Object)this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Resource returned " + numXids + " Xids"));
            for (int n = 0; n < numXids; ++n) {
                if (inDoubt[n] == null) continue;
                int formatID = inDoubt[n].getFormatId();
                byte[] gtrid = inDoubt[n].getGlobalTransactionId();
                byte[] bqual = inDoubt[n].getBranchQualifier();
                Tr.debug((TraceComponent)tc, (String)("Trace Xid[" + n + "] FormatID: " + Integer.toHexString(formatID)));
                Tr.debug((TraceComponent)tc, (String)("Trace Xid[" + n + "] Gtrid: " + Util.toHexString(gtrid)));
                Tr.debug((TraceComponent)tc, (String)("Trace Xid[" + n + "] Bqual: " + Util.toHexString(bqual)));
            }
        }
        ArrayList xidList = this.filterXidsByType(inDoubt);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("After type filter, Xids to recover " + xidList.size()));
        }
        xidList = this.filterXidsByCruuidAndEpoch(xidList, cruuid, restartEpoch);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("After filter by cruuid and epoch, Xids to recover " + xidList.size()));
        }
        this.auditXaRecoverCount(this.getXAResourceInfo(), numXids, xidList.size());
        for (int y = 0; y < xidList.size(); ++y) {
            XidImpl ourXid = (XidImpl)xidList.get(y);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Recovering Xid[" + y + "]"), (Object)ourXid);
            }
            if (ourXid.getEpoch() < restartEpoch - 1) {
                this.auditLateEpoch(ourXid, this.getXAResourceInfo());
            }
            if (knownXids != null && !this.canWeForgetXid(ourXid, knownXids)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found XID with no associated transaction");
            }
            try {
                this.auditSendRollback(ourXid, this.getXAResourceInfo());
                xarm.rollback(ourXid);
                this.auditRollbackResponse(0, ourXid, this.getXAResourceInfo());
                continue;
            }
            catch (XAException xae) {
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.tx.jta.impl.XARecoveryData.recover", (String)"660", (Object)this);
                int errorCode = xae.errorCode;
                this.auditRollbackResponse(errorCode, ourXid, this.getXAResourceInfo());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XAException: error code " + XAReturnCodeHelper.convertXACode(errorCode)), (Object)xae);
                }
                if (errorCode != -7 && errorCode != -3) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Forcing retry of recovery");
                }
                this._recovered = false;
            }
        }
        xarm.closeConnection();
        if (this._recovered) {
            this.decrementCount();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover", (Object)new Boolean(this._recovered));
        }
        return this._recovered;
    }

    protected ArrayList filterXidsByType(Xid[] xidArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filterXidsByType", (Object)xidArray);
        }
        ArrayList<XidImpl> xidList = new ArrayList<XidImpl>();
        if (xidArray != null) {
            for (int y = 0; y < xidArray.length; ++y) {
                if (xidArray[y] == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("RM has returned null inDoubt Xid entry - " + y));
                    continue;
                }
                if (!XidImpl.isOurFormatId(xidArray[y].getFormatId())) continue;
                XidImpl ourXid = null;
                if (xidArray[y] instanceof XidImpl) {
                    ourXid = (XidImpl)xidArray[y];
                } else {
                    ourXid = new XidImpl(xidArray[y]);
                    if (ourXid.getBranchQualifier().length != 54) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Xid is wrong length - " + y));
                        continue;
                    }
                }
                xidList.add(ourXid);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"filterXidsByType", xidList);
        }
        return xidList;
    }

    protected ArrayList filterXidsByCruuidAndEpoch(ArrayList xidList, byte[] cruuid, int epoch) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filterXidsByCruuidAndEpoch", (Object)new Object[]{xidList, cruuid, epoch});
        }
        for (int x = xidList.size() - 1; x >= 0; --x) {
            XidImpl ourXid = (XidImpl)xidList.get(x);
            byte[] xidCruuid = ourXid.getCruuid();
            int xidEpoch = ourXid.getEpoch();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Trace other Cruuid: " + xidCruuid + ", or: " + Util.toHexString(xidCruuid)));
                Tr.debug((TraceComponent)tc, (String)("Trace my Cruuid: " + cruuid + ", or: " + Util.toHexString(cruuid)));
            }
            if (!Arrays.equals(cruuid, xidCruuid)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("filterXidsByCruuidAndEpoch: cruuid is different: " + ourXid.getCruuid()));
                }
                xidList.remove(x);
                continue;
            }
            if (xidEpoch < epoch) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("filterXidsByCruuidAndEpoch: xid epoch is " + xidEpoch));
            }
            xidList.remove(x);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"filterXidsByCruuidAndEpoch", (Object)xidList);
        }
        return xidList;
    }

    protected boolean canWeForgetXid(XidImpl ourXid, Xid[] knownXids) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"canWeForgetXid", (Object)new Object[]{ourXid, knownXids});
        }
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < knownXids.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("tx xid[" + i + "] " + knownXids[i]));
            }
        }
        boolean forgetMe = true;
        int jtaFormatId = ourXid.getFormatId();
        byte[] jtaGtrid = ourXid.getGlobalTransactionId();
        byte[] fullJtaBqual = ourXid.getBranchQualifier();
        byte[] jtaBqual = null;
        for (int x = 0; x < knownXids.length && forgetMe; ++x) {
            if (x == 0) {
                int bqualLength = knownXids[x].getBranchQualifier().length;
                jtaBqual = new byte[bqualLength];
                System.arraycopy(fullJtaBqual, 0, jtaBqual, 0, bqualLength);
            }
            int txnFormatId = knownXids[x].getFormatId();
            byte[] txnGtrid = knownXids[x].getGlobalTransactionId();
            byte[] txnBqual = knownXids[x].getBranchQualifier();
            if (jtaFormatId != txnFormatId || !Arrays.equals(jtaGtrid, txnGtrid) || !Arrays.equals(jtaBqual, txnBqual)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Xid has been matched to a transaction:", (Object)ourXid);
            }
            this.auditTransactionXid(ourXid, knownXids[x], this.getXAResourceInfo());
            forgetMe = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"canWeForgetXid", (Object)forgetMe);
        }
        return forgetMe;
    }

    @Override
    public synchronized boolean clearIfNotInUse() {
        boolean cleared = super.clearIfNotInUse();
        if (cleared) {
            this._recoveryClassLoader = null;
        }
        return cleared;
    }

    public ClassLoader getRecoveryClassLoader() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryClassLoader", (Object)this._recoveryClassLoader);
        }
        return this._recoveryClassLoader;
    }

    public boolean supportsIsSameRM() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"supportsIsSameRM");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"supportsIsSameRM", (Object)this._supportsIsSameRM);
        }
        return this._supportsIsSameRM;
    }

    protected void auditXaRecover(Serializable xaResInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditXaRecover", (Object)xaResInfo);
        }
        if (this.auditRecovery) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0151_REC_XA_RECOVER", (Object)this.getRMInfo(xaResInfo));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditXaRecover");
        }
    }

    protected void auditXaRecoverCount(Serializable xaResInfo, int rms, int ours) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditXaRecoverCount", (Object)new Object[]{xaResInfo, rms, ours});
        }
        if (this.auditRecovery) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0146_REC_XA_RECOVERED", (Object)new Object[]{rms, this.getRMInfo(xaResInfo), ours});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditXaRecoverCount");
        }
    }

    public String getRMInfo(Serializable xaResInfo) {
        if (xaResInfo instanceof DirectEnlistXAResourceInfo) {
            return ((DirectEnlistXAResourceInfo)xaResInfo).getXAResource().toString();
        }
        return xaResInfo.toString();
    }

    protected void auditLateEpoch(XidImpl xid, Serializable xaResInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditLateEpoch", (Object)new Object[]{xid, xaResInfo});
        }
        if (this.auditRecovery) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0147_REC_XID_LATE", (Object)new Object[]{xid.printOtid(), this.getRMInfo(xaResInfo), xid.getEpoch()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditLateEpoch");
        }
    }

    protected void auditSendRollback(XidImpl xid, Serializable xaResInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditSendRollback", (Object)new Object[]{xid, xaResInfo});
        }
        if (this.auditRecovery) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0148_REC_XA_ROLLBACK", (Object)new Object[]{xid.printOtid(), this.getRMInfo(xaResInfo)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditSendRollback");
        }
    }

    protected void auditRollbackResponse(int code, XidImpl xid, Serializable xaResInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditRollbackResponse", (Object)new Object[]{xid, xaResInfo});
        }
        if (this.auditRecovery) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0150_REC_XA_ROLLEDBACK", (Object)new Object[]{xid.printOtid(), this.getRMInfo(xaResInfo), XAReturnCodeHelper.convertXACode(code)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditRollbackResponse");
        }
    }

    private void auditTransactionXid(XidImpl xid, Xid txnXid, Serializable xaResInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"auditTransactionXid", (Object)new Object[]{xid, txnXid, xaResInfo});
        }
        if (this.auditRecovery) {
            if (txnXid instanceof XidImpl) {
                String txnid = ((XidImpl)txnXid).printOtid();
            } else {
                String txnid = txnXid.toString();
            }
            Tr.audit((TraceComponent)tc, (String)"WTRN0149_REC_XA_TRAN", (Object)new Object[]{xid.printOtid(), this.getRMInfo(xaResInfo), this.getTransactionId(txnXid), Util.printStatus(this.getTransactionStatus(txnXid))});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"auditTransactionXid");
        }
    }

    protected int getTransactionStatus(Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransactionStatus", (Object)xid);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"fsc, rm", (Object)new Object[]{this._fsc, this._fsc.getRecoveryManager()});
        }
        TransactionImpl[] trans = this._fsc.getRecoveryManager().getRecoveringTransactions();
        for (int i = 0; i < trans.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Matching xid with ", (Object)trans[i]);
            }
            if (!xid.equals(trans[i].getXidImpl())) continue;
            int status = trans[i].getStatus();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getTransactionStatus", (Object)Util.printStatus(status));
            }
            return status;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransactionStatus", (Object)"Failed to find a transaction - error");
        }
        return 5;
    }

    protected String getTransactionId(Xid xid) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransactionId", (Object)xid);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"fsc, rm", (Object)new Object[]{this._fsc, this._fsc.getRecoveryManager()});
        }
        TransactionImpl[] trans = this._fsc.getRecoveryManager().getRecoveringTransactions();
        for (int i = 0; i < trans.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Matching xid with ", (Object)trans[i]);
            }
            if (!xid.equals(trans[i].getXidImpl())) continue;
            long id = trans[i].getLocalTID();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)id);
            }
            return Long.toString(id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)"Failed to find a transaction - error");
        }
        return "null";
    }

    public boolean continuePropagatingXAResourceTimeout() {
        return _continuePropagatingXAResourceTimeout;
    }

    public boolean propagateXAResourceTransactionTimeout() {
        return this._propagateXAResourceTransactionTimeout;
    }

    public void disablePropagatingXAResourceTimeout() {
        this._propagateXAResourceTransactionTimeout = false;
    }
}

