/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.impl.EventSemaphore;
import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.JCARecoveryData;
import com.ibm.tx.jta.impl.PartnerLogTable;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TxExecutionContextHandler;
import com.ibm.tx.jta.impl.XARecoveryData;
import com.ibm.tx.jta.util.TxTMHelper;
import com.ibm.tx.util.TMHelper;
import com.ibm.tx.util.Utils;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycle;
import com.ibm.ws.Transaction.JTA.FailureScopeLifeCycleHelper;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.NotSupportedException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;

public class RecoveryManager
implements Runnable {
    private static final TraceComponent tc = Tr.register(RecoveryManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static boolean recoveryOnlyMode;
    public static boolean _waitForRecovery;
    private boolean _recoveryFailed;
    protected final EventSemaphore _replayInProgress = new EventSemaphore();
    protected boolean _replayCompleted;
    protected final EventSemaphore _recoveryInProgress = new EventSemaphore();
    protected boolean _recoveryCompleted;
    protected boolean _shutdownInProgress;
    protected final RecoveryAgent _agent;
    protected RecoveryLog _tranLog;
    protected RecoveryLog _xaLog;
    protected final RecoveryLog _recoverXaLog;
    protected SharedServerLeaseLog _leaseLog;
    protected String _recoveryGroup;
    protected String _localRecoveryIdentity;
    protected PartnerLogTable _recoveryPartnerLogTable;
    protected byte[] _ourApplId;
    protected int _ourEpoch;
    protected byte[] _recoveredApplId;
    protected int _recoveredEpoch;
    protected String _recoveredServerName;
    protected int _partnerEntryLowWatermark = -1;
    protected int _partnerEntryNextId = -1;
    protected static final int TRANSACTION_SERVICE_ITEMS = 3;
    protected static final int PARTNERLOG_SERVICE_ITEMS = 6;
    protected RecoverableUnit _partnerServiceData;
    protected RecoverableUnitSection _stateSection;
    protected RecoverableUnitSection _classpathSection;
    protected RecoverableUnitSection _partnerServerSection;
    protected RecoverableUnitSection _partnerApplIdSection;
    protected RecoverableUnitSection _partnerEpochSection;
    protected RecoverableUnitSection _partnerLowWatermarkSection;
    protected RecoverableUnitSection _partnerNextIdSection;
    protected RecoverableUnit _tranlogServiceData;
    protected RecoverableUnitSection _tranlogServerSection;
    protected RecoverableUnitSection _tranlogApplIdSection;
    protected RecoverableUnitSection _tranlogEpochSection;
    protected String _classPath;
    protected static String _loggedClassPath;
    public static final int STARTING = 1;
    public static final int STOPPING = 3;
    protected FailureScopeController _failureScopeController;
    private boolean _recoveryPrevented;
    protected HashSet<TransactionImpl> _recoveringTransactions;
    protected final Object _recoveryMonitor = new Object();
    protected boolean _cleanRemoteShutdown;

    public RecoveryManager(FailureScopeController fsc, RecoveryAgent agent, RecoveryLog tranLog, RecoveryLog xaLog, RecoveryLog recoverXaLog, byte[] defaultApplId, int defaultEpoch) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryManager", (Object)new Object[]{fsc, agent, tranLog, xaLog, recoverXaLog, defaultApplId == null ? "null" : Util.toHexString(defaultApplId), defaultEpoch});
        }
        this._failureScopeController = fsc;
        this._agent = agent;
        this._tranLog = tranLog;
        this._xaLog = xaLog;
        this._recoverXaLog = recoverXaLog;
        this._ourApplId = defaultApplId;
        this._ourEpoch = defaultEpoch;
        this._recoveringTransactions = new HashSet();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryManager", (Object)this);
        }
    }

    public PartnerLogTable getPartnerLogTable() {
        if (this._recoveryPartnerLogTable == null) {
            this._recoveryPartnerLogTable = new PartnerLogTable(this._failureScopeController);
        }
        return this._recoveryPartnerLogTable;
    }

    byte[] getApplId() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getApplId", (Object)this._ourApplId);
        }
        return this._ourApplId;
    }

    int getCurrentEpoch() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCurrentEpoch", (Object)this._ourEpoch);
        }
        return this._ourEpoch;
    }

    public FailureScopeController getFailureScopeController() {
        return this._failureScopeController;
    }

    protected void replayTranLog() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"replayTranLog");
        }
        LogCursor recoverableUnits = this._tranLog.recoverableUnits();
        LogCursor recoverableUnitSections = null;
        int recoveredServiceItems = 0;
        boolean shuttingDown = false;
        boolean recoveredTransactions = false;
        try {
            while (recoverableUnits.hasNext() && !shuttingDown) {
                RecoverableUnit ru = (RecoverableUnit)recoverableUnits.next();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Replaying record " + ru.identity() + " from the transaction log"));
                }
                recoverableUnitSections = ru.sections();
                boolean tranRecord = false;
                block11: while (!tranRecord && recoverableUnitSections.hasNext()) {
                    RecoverableUnitSection rus = (RecoverableUnitSection)recoverableUnitSections.next();
                    int rusId = rus.identity();
                    byte[] logData = rus.lastData();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Replaying section " + rusId), (Object)Util.toHexString(logData));
                    }
                    switch (rusId) {
                        case 255: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Server name data record");
                            }
                            if (this._tranlogServerSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log SERVER_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = ru;
                            } else if (this._tranlogServiceData != ru) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogServerSection = rus;
                            ++recoveredServiceItems;
                            if (logData == null || logData.length == 0) continue block11;
                            String recoveredServerName = new String(logData);
                            if (this._recoveredServerName == null) {
                                this._recoveredServerName = recoveredServerName;
                                if (this._failureScopeController.serverName().equals(this._recoveredServerName)) continue block11;
                                Tr.warning((TraceComponent)tc, (String)"WTRN0020_RECOVERING_TRANSACTIONS", (Object)this._recoveredServerName);
                                break;
                            }
                            if (this._recoveredServerName.equals(recoveredServerName)) continue block11;
                            Tr.error((TraceComponent)tc, (String)"WTRN0024_INCONSISTENT_LOGS");
                            throw new IOException("Inconsistent Transaction and XA Resource recovery logs");
                        }
                        case 253: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Applid data record");
                            }
                            if (this._tranlogApplIdSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log APPLID_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = ru;
                            } else if (this._tranlogServiceData != ru) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogApplIdSection = rus;
                            ++recoveredServiceItems;
                            if (logData == null) continue block11;
                            if (this._recoveredApplId == null) {
                                this._recoveredApplId = logData;
                                break;
                            }
                            if (Util.equal(this._recoveredApplId, logData)) continue block11;
                            Tr.error((TraceComponent)tc, (String)"WTRN0024_INCONSISTENT_LOGS");
                            throw new IOException("Inconsistent Transaction and XA Resource recovery logs");
                        }
                        case 254: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Epoch data record");
                            }
                            if (this._tranlogEpochSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log EPOCH_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = ru;
                            } else if (this._tranlogServiceData != ru) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogEpochSection = rus;
                            ++recoveredServiceItems;
                            if (logData == null || logData.length <= 3) continue block11;
                            int recoveredEpoch = Util.getIntFromBytes(logData, 0, 4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Recovered epoch: " + recoveredEpoch));
                            }
                            if (recoveredEpoch <= this._recoveredEpoch) continue block11;
                            this._recoveredEpoch = recoveredEpoch;
                            break;
                        }
                        default: {
                            tranRecord = true;
                        }
                    }
                }
                recoverableUnitSections.close();
                recoverableUnitSections = null;
                if (tranRecord) {
                    recoveredTransactions = this.handleTranRecord(ru, recoveredTransactions, recoverableUnits);
                }
                shuttingDown = this.shutdownInProgress();
            }
            if (!shuttingDown) {
                if (recoveredTransactions) {
                    if (recoveredServiceItems != 3) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Recoverable log records found without service data records");
                        }
                        Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                        throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                    }
                } else if (recoveredServiceItems != 0 && recoveredServiceItems != 3) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Only a subset of service data records recovered");
                    }
                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                    throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                }
            }
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RecoveryManager.replayTranLog", (String)"512", (Object)this);
            if (recoverableUnitSections != null) {
                recoverableUnitSections.close();
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0025_TRAN_RECOVERY_FAILED", (Object)exc);
            SystemException se = new SystemException(exc.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"replayTranLog", (Object)((Object)se));
            }
            throw se;
        }
        finally {
            recoverableUnits.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replayTranLog");
        }
    }

    protected boolean handleTranRecord(RecoverableUnit ru, boolean recoveredTransactions, LogCursor recoverableUnits) throws SystemException, NotSupportedException, InternalLogException {
        TransactionImpl tx;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleTranRecord", (Object)new Object[]{ru, recoveredTransactions, recoverableUnits, new Exception("handleTranRecord Stack")});
        }
        if ((tx = new TransactionImpl(this._failureScopeController)).reconstruct(ru, this._tranLog)) {
            if (tx.isRAImport()) {
                TxExecutionContextHandler.addTxn(tx);
            }
            recoveredTransactions = true;
        } else {
            recoverableUnits.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleTranRecord", (Object)recoveredTransactions);
        }
        return recoveredTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareToShutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareToShutdown");
        }
        Object object = this._recoveryMonitor;
        synchronized (object) {
            this._shutdownInProgress = true;
            this._recoveryMonitor.notify();
        }
        this.waitForRecoveryCompletion();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareToShutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preShutdown(boolean transactionsLeft) throws Exception {
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"preShutdown", (Object)transactionsLeft);
            }
            try {
                this.getPartnerLogTable().terminate();
                if (this._tranLog == null) break block24;
                if (!transactionsLeft) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is no transaction data requiring future recovery");
                    }
                    if (this._tranlogServiceData != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Erasing service data from transaction log");
                        }
                        try {
                            this._tranLog.removeRecoverableUnit(this._tranlogServiceData.identity());
                            break block24;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.preShutdown", (String)"359", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                            throw e;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No service data to erase from transaction log");
                    }
                    break block24;
                }
                if (this._tranlogServiceData == null) break block24;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is transaction data requiring future recovery. Updating epoch");
                }
                if (this._failureScopeController.localFailureScope() || this._tranlogServiceData != null && this._tranlogEpochSection != null) {
                    try {
                        this._tranlogEpochSection.addData(Util.intToBytes(this._ourEpoch));
                        this._tranlogServiceData.forceSections();
                        break block24;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.preShutdown", (String)"608", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception raised forcing tranlog at shutdown", (Object)e);
                        }
                        throw e;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No service data to update in transaction log");
                }
            }
            finally {
                if (!(this._tranLog == null || this._failureScopeController.localFailureScope() && transactionsLeft)) {
                    try {
                        this._tranLog.closeLog();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.preShutdown", (String)"360", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"preShutdown");
                        }
                        throw e;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"preShutdown");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postShutdown(boolean partnersLeft) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postShutdown", (Object)new Object[]{this, partnersLeft});
        }
        try {
            if (this._xaLog != null) {
                if (partnersLeft && this._partnerServiceData != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is partner data requiring future recovery. Updating server state");
                    }
                    try {
                        this.updateServerState(3);
                        this._partnerServiceData.forceSections();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.postShutdown", (String)"779", (Object)this);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"updateServerState failed at shutdown on XAResources log", (Object)e);
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is no partner data requiring future recovery");
                    }
                    if (this._partnerServiceData != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Erasing service data from partner log");
                        }
                        try {
                            this._xaLog.removeRecoverableUnit(this._partnerServiceData.identity());
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.postShutdown", (String)"793", (Object)this);
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"removeRecoverableUnit failed at shutdown on XAResources log", (Object)e);
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No service data to erase from partner log");
                    }
                }
            }
        }
        finally {
            if (this._xaLog != null) {
                try {
                    this._xaLog.closeLog();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.postShutdown", (String)"824", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                }
                try {
                    if (this._leaseLog != null) {
                        this._leaseLog.deleteServerLease(this._failureScopeController.serverName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postShutdown");
        }
    }

    protected void checkPartnerServiceData(RecoverableUnit ru) throws IOException {
        if (this._partnerServiceData == null) {
            this._partnerServiceData = ru;
        } else if (this._partnerServiceData != ru) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
            }
            throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
        }
    }

    protected int replayPartnerLog() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"replayPartnerLog");
        }
        int result = 0;
        int recoveredServiceItems = 0;
        int records = 0;
        LogCursor recoverableUnits = null;
        LogCursor recoverableUnitSections = null;
        ArrayList<RecoveryLog> logs = new ArrayList<RecoveryLog>(2);
        if (this._recoverXaLog != null) {
            logs.add(this._recoverXaLog);
        }
        logs.add(this._xaLog);
        Iterator logIterator = logs.iterator();
        boolean shuttingDown = false;
        try {
            while (logIterator.hasNext() && !shuttingDown) {
                RecoveryLog currentLog = (RecoveryLog)logIterator.next();
                recoverableUnits = currentLog.recoverableUnits();
                while (recoverableUnits.hasNext() && !shuttingDown) {
                    ++records;
                    RecoverableUnit ru = (RecoverableUnit)recoverableUnits.next();
                    long id = ru.identity();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Replaying record " + id + " from the partner log"));
                    }
                    byte[] xaLogData = null;
                    int xaPriority = 0;
                    recoverableUnitSections = ru.sections();
                    block17: while (recoverableUnitSections.hasNext()) {
                        RecoverableUnitSection rus = (RecoverableUnitSection)recoverableUnitSections.next();
                        int rusId = rus.identity();
                        byte[] logData = rus.lastData();
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Replaying section " + rusId), (Object)Util.toHexString(logData));
                        }
                        switch (rusId) {
                            case 34: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"XA resources data record");
                                }
                                if (logData == null || currentLog == this._recoverXaLog) continue block17;
                                xaLogData = logData;
                                if (!tc.isDebugEnabled()) continue block17;
                                Tr.debug((TraceComponent)tc, (String)"XA resource", (Object)xaLogData);
                                continue block17;
                            }
                            case 37: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Resources priority record");
                                }
                                if (logData != null && logData.length == 4) {
                                    xaPriority = Util.getIntFromBytes(logData, 0, 4);
                                    if (!tc.isDebugEnabled()) continue block17;
                                    Tr.debug((TraceComponent)tc, (String)"Resources priority", (Object)xaPriority);
                                    continue block17;
                                }
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Invalid RESOURCE_PRIORITY_SECTION found");
                                }
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            case 35: {
                                this.handleWSCSection(logData, id);
                                continue block17;
                            }
                            case 36: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"JCA provider data record");
                                }
                                if (logData == null) continue block17;
                                JCARecoveryData jcard = new JCARecoveryData(this, logData, id);
                                this.getPartnerLogTable().addEntry(jcard);
                                continue block17;
                            }
                            case 33: {
                                this.handleClasspathSection(ru, logData, rus);
                                continue block17;
                            }
                            case 32: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Server state data record");
                                }
                                if (this._stateSection != null) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Multiple log SERVER_STATE_SECTIONs found");
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                this.checkPartnerServiceData(ru);
                                this._stateSection = rus;
                                ++recoveredServiceItems;
                                int flag = -1;
                                if (logData != null && logData.length > 3) {
                                    flag = Util.getIntFromBytes(logData, 0, 4);
                                }
                                if (flag == 1) {
                                    if (!tc.isEventEnabled()) continue block17;
                                    Tr.event((TraceComponent)tc, (String)"previous server may have crashed");
                                    continue block17;
                                }
                                if (flag == 3) {
                                    if (!tc.isEventEnabled()) continue block17;
                                    Tr.event((TraceComponent)tc, (String)"previous server closed down cleanly with transactions still running");
                                    continue block17;
                                }
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Invalid log record data in SERVER_STATE_SECTION");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            case 255: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Server name data record");
                                }
                                if (this._partnerServerSection != null) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Multiple log SERVER_DATA_SECTIONs found");
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                this.checkPartnerServiceData(ru);
                                this._partnerServerSection = rus;
                                ++recoveredServiceItems;
                                if (logData == null || logData.length == 0) continue block17;
                                this._recoveredServerName = new String(logData);
                                if (this._failureScopeController.serverName().equals(this._recoveredServerName)) continue block17;
                                Tr.warning((TraceComponent)tc, (String)"WTRN0020_RECOVERING_TRANSACTIONS", (Object)this._recoveredServerName);
                                continue block17;
                            }
                            case 253: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Applid data record");
                                }
                                if (this._partnerApplIdSection != null) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Multiple log APPLID_DATA_SECTIONs found");
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                this.checkPartnerServiceData(ru);
                                this._partnerApplIdSection = rus;
                                ++recoveredServiceItems;
                                if (logData == null) continue block17;
                                this._recoveredApplId = logData;
                                continue block17;
                            }
                            case 254: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Epoch data record");
                                }
                                if (this._partnerEpochSection != null) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Multiple log EPOCH_DATA_SECTIONs found");
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                this.checkPartnerServiceData(ru);
                                this._partnerEpochSection = rus;
                                ++recoveredServiceItems;
                                if (logData == null || logData.length <= 3) continue block17;
                                this._recoveredEpoch = Util.getIntFromBytes(logData, 0, 4);
                                if (!tc.isDebugEnabled()) continue block17;
                                Tr.debug((TraceComponent)tc, (String)("Recovered epoch: " + this._recoveredEpoch));
                                continue block17;
                            }
                            case 31: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Low Watermark section");
                                }
                                if (this._partnerLowWatermarkSection != null) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Multiple log LOW_WATERMARKs found");
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                this.checkPartnerServiceData(ru);
                                this._partnerLowWatermarkSection = rus;
                                ++recoveredServiceItems;
                                if (logData != null && logData.length > 3) {
                                    this._partnerEntryLowWatermark = Util.getIntFromBytes(logData, 0, 4);
                                    continue block17;
                                }
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"LowWatermark data is invalid");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            case 30: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Next Id section");
                                }
                                if (this._partnerNextIdSection != null) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Multiple log NEXT_IDs found");
                                    }
                                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                                }
                                this.checkPartnerServiceData(ru);
                                this._partnerNextIdSection = rus;
                                ++recoveredServiceItems;
                                if (logData != null && logData.length > 3) {
                                    this._partnerEntryNextId = Util.getIntFromBytes(logData, 0, 4);
                                    continue block17;
                                }
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"NextId data is invalid");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Invalid partner log data records found");
                        }
                        Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                        throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                    }
                    recoverableUnitSections.close();
                    recoverableUnitSections = null;
                    if (this.handleXAResourceRecord(currentLog, xaLogData, id, xaPriority)) {
                        ++result;
                    }
                    if (!this.shutdownInProgress()) continue;
                    shuttingDown = true;
                }
                recoverableUnits.close();
                recoverableUnits = null;
            }
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.tx.jta.impl.RecoveryManager.replayPartnerLog", (String)"1100", (Object)this);
            if (recoverableUnitSections != null) {
                recoverableUnitSections.close();
            }
            if (recoverableUnits != null) {
                recoverableUnits.close();
            }
            Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"replayPartnerLog", (Object)ioe);
            }
            throw ioe;
        }
        if (!shuttingDown) {
            if (records > 1) {
                if (recoveredServiceItems != 6) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Recoverable log records found without service data records. Got " + recoveredServiceItems + " expected " + 6));
                    }
                    ioe = new IOException(this._xaLog.logProperties().logName() + " corrupted");
                    FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.tx.jta.impl.RecoveryManager.replayPartnerLog", (String)"1118", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"replayPartnerLog", (Object)ioe);
                    }
                    throw ioe;
                }
            } else if (recoveredServiceItems != 0 && recoveredServiceItems != 6) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Only a subset of service data records recovered");
                }
                ioe = new IOException(this._xaLog.logProperties().logName() + " corrupted");
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.tx.jta.impl.RecoveryManager.replayPartnerLog", (String)"1124", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"replayPartnerLog", (Object)ioe);
                }
                throw ioe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replayPartnerLog", (Object)result);
        }
        return result;
    }

    protected boolean handleXAResourceRecord(RecoveryLog currentLog, byte[] xaLogData, long id, int xaPriority) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleXAResourceRecord", (Object)new Object[]{currentLog, xaLogData, id, xaPriority});
        }
        if (xaLogData != null) {
            XARecoveryData xard = new XARecoveryData(currentLog, xaLogData, id, xaPriority);
            xard.setFailureScopeController(this._failureScopeController);
            this.getPartnerLogTable().addEntry(xard);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleXAResourceRecord", (Object)Boolean.TRUE);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleXAResourceRecord", (Object)Boolean.FALSE);
        }
        return false;
    }

    protected void handleClasspathSection(RecoverableUnit ru, byte[] logData, RecoverableUnitSection rus) throws IOException {
    }

    protected void handleWSCSection(byte[] logData, long id) throws Exception {
    }

    protected void updateTranLogServiceData() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateTranLogServiceData");
        }
        try {
            if (this._tranlogServiceData == null) {
                this._tranlogServiceData = this._tranLog.createRecoverableUnit();
                this._tranlogServerSection = this._tranlogServiceData.createSection(255, true);
                this._tranlogApplIdSection = this._tranlogServiceData.createSection(253, true);
                this._tranlogEpochSection = this._tranlogServiceData.createSection(254, true);
                this._tranlogServerSection.addData(Utils.byteArray((String)this._failureScopeController.serverName()));
                this._tranlogApplIdSection.addData(this._ourApplId);
            }
            this._tranlogEpochSection.addData(Util.intToBytes(this._ourEpoch));
            this._tranlogServiceData.forceSections();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.updateTranLogSeviceData", (String)"1130", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateTranLogServiceData", (Object)e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateTranLogServiceData");
        }
    }

    protected void updatePartnerServiceData() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updatePartnerServiceData");
        }
        try {
            if (this._partnerServiceData == null) {
                this._partnerServiceData = this._recoverXaLog != null ? this._recoverXaLog.createRecoverableUnit() : this._xaLog.createRecoverableUnit();
                this._partnerServerSection = this._partnerServiceData.createSection(255, true);
                this._partnerApplIdSection = this._partnerServiceData.createSection(253, true);
                this._partnerEpochSection = this._partnerServiceData.createSection(254, true);
                this._partnerLowWatermarkSection = this._partnerServiceData.createSection(31, true);
                this._partnerNextIdSection = this._partnerServiceData.createSection(30, true);
                this._partnerServerSection.addData(Utils.byteArray((String)this._failureScopeController.serverName()));
                this._partnerApplIdSection.addData(this._ourApplId);
                this._partnerEntryLowWatermark = 1;
                this._partnerLowWatermarkSection.addData(Util.intToBytes(this._partnerEntryLowWatermark));
                this._partnerEntryNextId = 2;
                this._partnerNextIdSection.addData(Util.intToBytes(this._partnerEntryNextId));
            }
            this._partnerEpochSection.addData(Util.intToBytes(this._ourEpoch));
            this.updateServerState(1);
            this._partnerServiceData.forceSections();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.updatePartnerSeviceData", (String)"1224", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updatePartnerServiceData", (Object)e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updatePartnerServiceData");
        }
    }

    private void updateServerState(int flag) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateServerState", (Object)flag);
        }
        try {
            if (this._stateSection == null) {
                this._stateSection = this._partnerServiceData.createSection(32, true);
            }
            this._stateSection.addData(Util.intToBytes(flag));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.jta.impl.RecoveryManager.updateServerState", (String)"1250", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateServerState", (Object)e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerState");
        }
    }

    public void waitForReplayCompletion() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForReplayCompletion");
            }
            if (!this._replayCompleted) {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"starting to wait for replay completion");
                    }
                    this._replayInProgress.waitEvent();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"completed wait for replay completion");
                    }
                }
                catch (InterruptedException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RecoveryManager.waitForReplayCompletion", (String)"1242", (Object)this);
                    if (!tc.isEventEnabled()) break block7;
                    Tr.event((TraceComponent)tc, (String)"Wait for resync complete interrupted.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitForReplayCompletion");
        }
    }

    public void replayComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"replayComplete");
        }
        FailureScopeLifeCycle fslc = this.makeFailureScopeActive(this._failureScopeController.failureScope(), this._failureScopeController.localFailureScope());
        this._failureScopeController.setFailureScopeLifeCycle(fslc);
        this._replayCompleted = true;
        this._replayInProgress.post();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replayComplete");
        }
    }

    protected FailureScopeLifeCycle makeFailureScopeActive(FailureScope fs, boolean isLocal) {
        return FailureScopeLifeCycleHelper.addToActiveList(fs, isLocal);
    }

    private void waitForRecoveryCompletion() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForRecoveryCompletion");
            }
            if (!this._recoveryCompleted) {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"starting to wait for recovery completion");
                    }
                    this._recoveryInProgress.waitEvent();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"completed wait for recovery completion");
                    }
                }
                catch (InterruptedException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RecoveryManager.waitForRecoveryCompletion", (String)"1242", (Object)this);
                    if (!tc.isEventEnabled()) break block7;
                    Tr.event((TraceComponent)tc, (String)"Wait for recovery complete interrupted.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitForRecoveryCompletion");
        }
    }

    public void recoveryComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete");
        }
        if (!this._recoveryCompleted) {
            this._recoveryCompleted = true;
            this._recoveryInProgress.post();
        }
        if (this._agent != null) {
            try {
                RecoveryDirectorFactory.recoveryDirector().initialRecoveryComplete(this._agent, this._failureScopeController.failureScope());
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RecoveryManager.recoveryComplete", (String)"1546", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public boolean recoveryFailed() {
        return this._recoveryFailed;
    }

    protected void recoveryFailed(Throwable t) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryFailed");
        }
        this._recoveryFailed = true;
        this.replayComplete();
        if (!this._recoveryCompleted) {
            this._recoveryCompleted = true;
            this._recoveryInProgress.post();
            this.signalRecoveryComplete();
        }
        if (this._failureScopeController.localFailureScope()) {
            TMHelper.asynchRecoveryProcessingComplete((Throwable)t);
        } else if (this._agent != null) {
            try {
                RecoveryDirectorFactory.recoveryDirector().initialRecoveryFailed(this._agent, this._failureScopeController.failureScope());
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RecoveryManager.recoveryFailed", (String)"1547", (Object)this);
            }
        }
        this.resyncComplete(new RuntimeException(t));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryFailed");
        }
    }

    protected void signalRecoveryComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownInProgress() {
        Object object = this._recoveryMonitor;
        synchronized (object) {
            if (this._shutdownInProgress && !this._recoveryCompleted) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Shutdown is in progress, stopping recovery processing");
                }
                this.recoveryComplete();
                if (this._failureScopeController.localFailureScope()) {
                    TMHelper.asynchRecoveryProcessingComplete(null);
                }
            }
        }
        return this._shutdownInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resync(int XAEntries) {
        block44: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"resync", (Object)XAEntries);
            }
            try {
                boolean XArecovered = XAEntries == 0;
                boolean auditRecovery = ConfigurationProviderManager.getConfigurationProvider().getAuditRecovery();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (auditRecovery) {
                    Tr.audit((TraceComponent)tc, (String)"WTRN0134_RECOVERING_XARMS", (Object)XAEntries);
                }
                int retryAttempts = 0;
                int configuredWait = ConfigurationProviderManager.getConfigurationProvider().getHeuristicRetryInterval();
                int retryWait = configuredWait <= 0 ? 60 : configuredWait;
                boolean callRecoveryComplete = true;
                boolean stopProcessing = this.shutdownInProgress();
                while (!stopProcessing) {
                    boolean waitForTxComplete;
                    TransactionImpl[] recoveredTransactions = this.getRecoveringTransactions();
                    if (!XArecovered) {
                        Xid[] txnXids = new Xid[recoveredTransactions.length];
                        for (int i = 0; i < recoveredTransactions.length; ++i) {
                            txnXids[i] = recoveredTransactions[i].getXid();
                        }
                        XArecovered = this.getPartnerLogTable().recover(this, cl, txnXids);
                    }
                    for (int i = 0; i < recoveredTransactions.length && !(stopProcessing = this.shutdownInProgress()); ++i) {
                        try {
                            if (recoveryOnlyMode && recoveredTransactions[i].isRAImport()) continue;
                            recoveredTransactions[i].recover();
                            if (!recoveryOnlyMode || recoveredTransactions[i].getTransactionState().getState() == -1) continue;
                            Tr.warning((TraceComponent)tc, (String)"WTRN0114_TRAN_RETRY_NEEDED", (Object)new Object[]{recoveredTransactions[i].getTranName(), retryWait});
                            continue;
                        }
                        catch (Throwable exc) {
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RecoveryManager.resync", (String)"1654", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object)exc);
                        }
                    }
                    stopProcessing = this.shutdownInProgress();
                    if (stopProcessing) break;
                    if (recoveryOnlyMode || _waitForRecovery) {
                        waitForTxComplete = !this.recoveryModeTxnsComplete();
                    } else {
                        boolean bl = waitForTxComplete = this._recoveringTransactions.size() > 0;
                    }
                    if (!XArecovered || waitForTxComplete) {
                        if (retryAttempts == 0 && !recoveryOnlyMode && this._failureScopeController.localFailureScope()) {
                            this.recoveryComplete();
                            callRecoveryComplete = false;
                        }
                        if (++retryAttempts % 10 == 0 && retryWait < 0x3FFFFFFF) {
                            retryWait *= 2;
                        }
                        Object object = this._recoveryMonitor;
                        synchronized (object) {
                            long timeout = (long)retryWait * 1000L;
                            long startTime = System.currentTimeMillis();
                            long startTimeout = timeout;
                            while (!this._shutdownInProgress) {
                                long elapsedTime;
                                block43: {
                                    try {
                                        this._recoveryMonitor.wait(timeout);
                                    }
                                    catch (InterruptedException e) {
                                        if (!tc.isDebugEnabled()) break block43;
                                        Tr.debug((TraceComponent)tc, (String)"Resync wait interrupted");
                                    }
                                }
                                if (this._shutdownInProgress || (elapsedTime = System.currentTimeMillis() - startTime) >= startTimeout) break;
                                timeout = startTimeout - elapsedTime;
                            }
                        }
                        stopProcessing = this.shutdownInProgress();
                        continue;
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Resync completed");
                    break;
                }
                if (stopProcessing) {
                    if (this._failureScopeController.localFailureScope()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"local failure scope resync interupted");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Non-local failure scope resync interupted");
                    }
                    break block44;
                }
                if (XArecovered && this._recoveringTransactions.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Clearing any unused partners from partner log");
                    }
                    if (!this._failureScopeController.localFailureScope()) {
                        this._cleanRemoteShutdown = true;
                        try {
                            this.preShutdown(true);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.postShutdown(true);
                    } else {
                        boolean failed = false;
                        if (this._tranLog != null && this._tranLog instanceof DistributedRecoveryLog) {
                            try {
                                ((DistributedRecoveryLog)this._tranLog).keypoint();
                            }
                            catch (Exception exc2) {
                                FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.tx.jta.impl.RecoveryManager.resync", (String)"1974", (Object)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"keypoint of transaction log failed ... partner log will not be tidied", (Object)exc2);
                                }
                                failed = true;
                            }
                        }
                        if (!failed) {
                            this.getPartnerLogTable().clearUnused();
                            if (auditRecovery) {
                                Tr.audit((TraceComponent)tc, (String)"WTRN0133_RECOVERY_COMPLETE");
                            }
                        }
                    }
                    if (callRecoveryComplete) {
                        this.recoveryComplete();
                    }
                    break block44;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Transactions were active. Not clearing any unused partners from partner log");
                }
                if (callRecoveryComplete) {
                    this.recoveryComplete();
                }
            }
            catch (RuntimeException r) {
                FFDCFilter.processException((Throwable)r, (String)"com.ibm.tx.jta.impl.RecoveryManager.resync", (String)"1729", (Object)this);
                this.resyncComplete(r);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"resync", (Object)r);
                }
                throw r;
            }
        }
        this.resyncComplete(null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resync");
        }
    }

    protected void resyncComplete(RuntimeException r) {
        TxTMHelper.resyncComplete(r);
    }

    protected TransactionImpl[] getRecoveringTransactions() {
        TransactionImpl[] recoveredTransactions = new TransactionImpl[this._recoveringTransactions.size()];
        this._recoveringTransactions.toArray(recoveredTransactions);
        return recoveredTransactions;
    }

    public void cleanupRemoteFailureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanupRemoteFailureScope");
        }
        if (!this._failureScopeController.localFailureScope()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Stop processing. Clear down any transactions");
            }
            if (this._recoveringTransactions.size() > 0) {
                TransactionImpl[] recoveredTransactions = new TransactionImpl[this._recoveringTransactions.size()];
                this._recoveringTransactions.toArray(recoveredTransactions);
                for (int i = 0; i < recoveredTransactions.length; ++i) {
                    try {
                        recoveredTransactions[i].forgetTransaction(false);
                        continue;
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.tx.jta.impl.RecoveryManager.cleanupRemoteFailureScope", (String)"2069", (Object)this);
                    }
                }
            }
            if (!this._cleanRemoteShutdown) {
                try {
                    this.preShutdown(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.postShutdown(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanupRemoteFailureScope");
        }
    }

    protected void closeLogs(boolean closeLeaseLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLogs", (Object)new Object[]{this, closeLeaseLog});
        }
        if (this._tranLog != null && this._tranLog instanceof DistributedRecoveryLog) {
            try {
                ((DistributedRecoveryLog)this._tranLog).closeLogImmediate();
            }
            catch (Exception e) {
                // empty catch block
            }
            this._tranLog = null;
        }
        if (this._xaLog != null && this._xaLog instanceof DistributedRecoveryLog) {
            try {
                ((DistributedRecoveryLog)this._xaLog).closeLogImmediate();
            }
            catch (Exception e) {
                // empty catch block
            }
            this._xaLog = null;
        }
        try {
            if (this._leaseLog != null && closeLeaseLog) {
                this._leaseLog.deleteServerLease(this._failureScopeController.serverName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLogs");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void registerGlobalCoordinator() {
    }

    protected void performResync(int xaEntries) {
        int recoveredTransactions;
        boolean auditRecovery = ConfigurationProviderManager.getConfigurationProvider().getAuditRecovery();
        if (auditRecovery) {
            if (this._recoveredServerName == null) {
                Tr.audit((TraceComponent)tc, (String)"WTRN0132_RECOVERY_INITIATED", (Object)new Object[]{this._failureScopeController.serverName(), this._ourApplId == null ? "null" : Util.toHexString(this._ourApplId), this._recoveredEpoch});
            } else {
                Tr.audit((TraceComponent)tc, (String)"WTRN0132_RECOVERY_INITIATED", (Object)new Object[]{this._recoveredServerName, this._recoveredApplId == null ? "null" : Util.toHexString(this._recoveredApplId), this._recoveredEpoch});
            }
        }
        if ((recoveredTransactions = this._recoveringTransactions.size()) == 1) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0027_RECOVERING_TXN");
        } else if (recoveredTransactions > 0) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0028_RECOVERING_TXNS", (Object)recoveredTransactions);
        } else {
            Tr.info((TraceComponent)tc, (String)"WTRN0135_RECOVERING_NOTXNS");
        }
        this.resync(xaEntries);
    }

    protected void validateServiceData() {
        if (this._recoveredApplId != null) {
            this._ourApplId = this._recoveredApplId;
        }
        if (this._recoveredEpoch >= this._ourEpoch) {
            this._ourEpoch = this._recoveredEpoch + 1;
        }
    }

    public void registerTransaction(TransactionImpl tran) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerTransaction", (Object)new Object[]{this, tran});
        }
        this._recoveringTransactions.add(tran);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerTransaction", (Object)this._recoveringTransactions.size());
        }
    }

    public void deregisterTransaction(TransactionImpl tran) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deregisterTransaction", (Object)new Object[]{this, tran});
        }
        this._recoveringTransactions.remove(tran);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deregisterTransaction", (Object)this._recoveringTransactions.size());
        }
    }

    protected boolean recoveryModeTxnsComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryModeTxnsComplete");
        }
        if (this._recoveringTransactions != null) {
            for (TransactionImpl tx : this._recoveringTransactions) {
                if (tx == null || tx.isRAImport()) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"recoveryModeTxnsComplete", (Object)Boolean.FALSE);
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryModeTxnsComplete", (Object)Boolean.TRUE);
        }
        return true;
    }

    public boolean recoveryPrevented() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"recoveryPrevented", (Object)this._recoveryPrevented);
        }
        return this._recoveryPrevented;
    }

    public void haltDownlevelRecovery() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"haltDownlevelRecovery");
        }
        this._recoveryPrevented = true;
        FailureScope failureScope = this._failureScopeController.failureScope();
        Tr.warning((TraceComponent)tc, (String)"WTRN0113_LOG_DOWNLEVEL", (Object)failureScope);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Halting recovery processing of downlevel transaction recovery log for failure scope" + failureScope + ")"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"haltDownlevelRecovery");
        }
    }

    public void setLeaseLog(SharedServerLeaseLog leaseLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLeaseLog", (Object)new Object[]{leaseLog});
        }
        this._leaseLog = leaseLog;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryManager", (Object)this);
        }
    }

    public void setRecoveryGroup(String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRecoveryGroup", (Object)new Object[]{recoveryGroup});
        }
        this._recoveryGroup = recoveryGroup;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryGroup");
        }
    }

    public void setLocalRecoveryIdentity(String recoveryIdentity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLocalRecoveryIdentity", (Object)new Object[]{recoveryIdentity});
        }
        this._localRecoveryIdentity = recoveryIdentity;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLocalRecoveryIdentity");
        }
    }
}

