/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.webcontainer31.osgi.response.BlockingWriteNotAllowedException;
import com.ibm.ws.webcontainer31.upgrade.UpgradedWebConnectionImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer31.WCCustomProperties31;
import java.io.IOException;
import javax.servlet.WriteListener;

public class UpgradeOutputByteBufferUtil {
    private static final TraceComponent tc = Tr.register(UpgradeOutputByteBufferUtil.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    public UpgradedWebConnectionImpl _upConn = null;
    private TCPConnectionContext _tcpContext = null;
    private WsByteBuffer[] _output = null;
    private int outputIndex = 0;
    private int amountToBuffer = 0;
    private int bbSize;
    private int bufferedCount = 0;
    private long bytesRemaining = -1L;
    private long bytesWritten = 0L;
    private IOException error = null;
    private VirtualConnection _vc = null;
    public TCPWriteCompletedCallback _callback;
    private WriteListener _listener;
    private boolean _isInternalReady = true;
    private boolean _isReady = true;
    private int _bytesRemainingWhenAsync = 0;
    private byte[] _remValue = null;
    private boolean _dataSaved = false;
    private boolean _asyncFlushCalledFromCloseWork = false;
    public boolean status_not_ready_checked = false;
    public boolean write_crlf_pending = false;
    private final Object _lockObj = new Object(){};
    Object _writeReadyLockObj = new Object(){};
    private boolean outputStream_close_initiated_but_not_Flush_ready = false;
    private boolean outputStream_closed = false;
    private static final byte[] CRLF = new byte[]{13, 10};

    public UpgradeOutputByteBufferUtil(UpgradedWebConnectionImpl up) {
        this._upConn = up;
        this._tcpContext = this._upConn.getTCPConnectionContext();
        this._vc = this._upConn.getVirtualConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"constructor", (Object[])new Object[0]);
        }
    }

    public void writeWork(byte[] value, int start, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write len --> " + len + ", bytesRemaining->" + this.bytesRemaining), (Object[])new Object[0]);
        }
        this.validate();
        this.writeToBuffers(value, start, len);
    }

    public void write_NonBlocking(byte[] value, int start, int len) throws IOException {
        WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
        if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread") != null) {
            this.validate();
            this.writeToBuffers(value, start, len);
            if (reqState.getAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread") != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("back to write_NonBlocking , remove write allowed attribute, -> WriteListener enabled: " + this._listener), (Object[])new Object[0]);
                }
                reqState.removeAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread");
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"blocking.write.not.allowed", (Object[])new Object[]{this._listener});
            throw new BlockingWriteNotAllowedException(Tr.formatMessage((TraceComponent)tc, (String)"blocking.write.not.allowed", (Object[])new Object[]{this._listener}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print_NonBlocking(String value) throws IOException {
        UpgradeOutputByteBufferUtil upgradeOutputByteBufferUtil = this;
        synchronized (upgradeOutputByteBufferUtil) {
            if (this.isOutputStream_closed() || this.isOutputStream_close_initiated_but_not_Flush_ready()) {
                Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
                throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
            }
            this.write_NonBlocking(value.getBytes(), 0, value.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println_NonBlocking(String value) throws IOException {
        UpgradeOutputByteBufferUtil upgradeOutputByteBufferUtil = this;
        synchronized (upgradeOutputByteBufferUtil) {
            if (this.isOutputStream_closed() || this.isOutputStream_close_initiated_but_not_Flush_ready()) {
                Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
                throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
            }
            this.write_NonBlocking(value.getBytes(), 0, value.length());
            if (this.isWriteReadyForApp()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("println crlf , write allowed now , WriteListener enabled: " + this._listener + " , check crlf_pending " + this.write_crlf_pending), (Object[])new Object[0]);
                }
                WebContainerRequestState.getInstance((boolean)true).setAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread", (Object)true);
                this.writeCRLFIfNeeded();
            } else {
                this.write_crlf_pending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCRLFIfNeeded() throws IOException {
        UpgradeOutputByteBufferUtil upgradeOutputByteBufferUtil = this;
        synchronized (upgradeOutputByteBufferUtil) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("write queue is empty and now write crlf, WriteListener enabled: " + this._listener), (Object[])new Object[0]);
            }
            this.write_crlf_pending = false;
            this.write_NonBlocking(CRLF, 0, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushHelper() throws IOException {
        boolean crlfWrite = false;
        if (this._callback != null) {
            UpgradeOutputByteBufferUtil upgradeOutputByteBufferUtil = this;
            synchronized (upgradeOutputByteBufferUtil) {
                WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
                if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.upgrade.CRLFWriteinPorgress") != null) {
                    crlfWrite = true;
                }
                if (!this.isWriteReadyForApp() && !crlfWrite) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Cannot flush Upgraded output stream , output not ready: " + this), (Object[])new Object[0]);
                    }
                    return;
                }
                this.validate();
                this.flushUpgradedOutputBuffers();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Flushing Upgraded output stream: " + this), (Object[])new Object[0]);
            }
            this.validate();
            this.flushUpgradedOutputBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRemainingToBuffers() throws Exception {
        this.clearBuffersAfterWrite();
        if (this.is_asyncFlushCalledFromCloseWork()) {
            this.setInternalReady(true);
            this.set_asyncFlushCalledFromCloseWork(false);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Write out remainig bytes --> " + this._bytesRemainingWhenAsync), (Object[])new Object[0]);
        }
        if (this._bytesRemainingWhenAsync > 0) {
            Object object = this._lockObj;
            synchronized (object) {
                if (!this.isDataSaved()) {
                    this._lockObj.wait();
                }
                this.setDataSaved(false);
            }
            this.setInternalReady(true);
            this.writeToBuffers(this._remValue, 0, this._bytesRemainingWhenAsync);
        } else {
            this.setInternalReady(true);
        }
    }

    private void setBufferSize(int size) {
        this.amountToBuffer = size;
        this.bbSize = 49152 < size ? 32768 : 8192;
        int numBuffers = size / this.bbSize;
        if (0 == size || 0 != size % this.bbSize) {
            ++numBuffers;
        }
        this._output = new WsByteBuffer[numBuffers];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBufferSize=[" + size + "]; " + this), (Object[])new Object[0]);
        }
    }

    private void validate() throws IOException {
        if (null != this.error) {
            throw this.error;
        }
        if (null == this._output) {
            this.setBufferSize(32768);
        }
    }

    private WsByteBuffer getBuffer() {
        WsByteBuffer buffer = this._output[this.outputIndex];
        if (null == buffer) {
            buffer = this.getNewByteBuffer();
            buffer.clear();
            this._output[this.outputIndex] = buffer;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getBuffer, new buffer -->" + buffer + " ,outputIndex -->" + this.outputIndex), (Object[])new Object[0]);
            }
        } else if (!buffer.hasRemaining()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getBuffer, buffer  -->" + buffer + " ,outputIndex -->" + this.outputIndex + " ,outputLength -->" + this._output.length), (Object[])new Object[0]);
            }
            buffer.flip();
            ++this.outputIndex;
            if (null == this._output[this.outputIndex]) {
                this._output[this.outputIndex] = this.getNewByteBuffer();
            }
            buffer = this._output[this.outputIndex];
            buffer.clear();
        }
        return buffer;
    }

    private WsByteBuffer getNewByteBuffer() {
        return ChannelFrameworkFactory.getBufferManager().allocateDirect(this.bbSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToBuffers(byte[] value, int start, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeToBuffers, Writing " + len + ", buffered=" + this.bufferedCount), (Object[])new Object[0]);
        }
        if (value.length < start + len) {
            throw new IllegalArgumentException("Length outside value range");
        }
        int remaining = len;
        int offset = start;
        while (0 < remaining) {
            if (this._callback != null && !this.isInternalReady()) {
                this._remValue = new byte[remaining];
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeToBuffers, Save of bytesRemainingWhenAsync -->" + this._bytesRemainingWhenAsync + ", value size -->" + value.length + ", remValue size -->" + this._remValue.length), (Object[])new Object[0]);
                }
                Object object = this._lockObj;
                synchronized (object) {
                    System.arraycopy(value, offset, this._remValue, 0, remaining);
                    this.setDataSaved(true);
                    this._lockObj.notifyAll();
                    break;
                }
            }
            WsByteBuffer buffer = this.getBuffer();
            int avail = buffer.remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("writeToBuffers: avail -->" + avail + " ,bytesRemaining --> " + remaining), (Object[])new Object[0]);
            }
            if (avail >= remaining) {
                this.bufferedCount += remaining;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeToBuffers: remaining --> " + remaining), (Object[])new Object[0]);
                }
                buffer.put(value, offset, remaining);
                remaining = 0;
            } else {
                this.bufferedCount += avail;
                buffer.put(value, offset, avail);
                offset += avail;
                remaining -= avail;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing " + len + ", buffered=" + this.bufferedCount + ", this.amountToBuffer=" + this.amountToBuffer + ", remaining=" + remaining), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("writeToBuffers: buffer now -->" + buffer), (Object[])new Object[0]);
            }
            if (this.bufferedCount < this.amountToBuffer) continue;
            if (this._callback == null) {
                this.flushUpgradedOutputBuffers();
                continue;
            }
            this._bytesRemainingWhenAsync = remaining;
            this.flushAsyncUpgradedOutputBuffers();
        }
    }

    @FFDCIgnore(value={IOException.class})
    private void flushUpgradedOutputBuffers() throws IOException {
        boolean writingBody;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("flushUpgraded: Flushing buffers for Upgraded output: " + this), (Object[])new Object[0]);
        }
        if ((writingBody = this.hasBufferedContent()) && null != this._output[this.outputIndex]) {
            this._output[this.outputIndex].flip();
        }
        try {
            WsByteBuffer[] content;
            WsByteBuffer[] wsByteBufferArray = content = writingBody ? this._output : null;
            if (content != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"flushUpgraded:: Now write the content ", (Object[])new Object[0]);
                }
                this._tcpContext.getWriteInterface().setBuffers(content);
                this._tcpContext.getWriteInterface().write(-1L, WCCustomProperties31.UPGRADE_WRITE_TIMEOUT);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushUpgraded: No more data to flush ", (Object[])new Object[0]);
            }
        }
        catch (IOException ioe) {
            this.error = ioe;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("flushUpgraded: Received exception during write: " + ioe), (Object[])new Object[0]);
            }
            throw ioe;
        }
        finally {
            this.bytesWritten += (long)this.bufferedCount;
            this.bufferedCount = 0;
            this.outputIndex = 0;
            if (writingBody && null != this._output) {
                if (null != this._output[0]) {
                    this._output[0].clear();
                }
                for (int i = 1; i < this._output.length; ++i) {
                    if (null == this._output[i]) continue;
                    this._output[i].position(0);
                    this._output[i].limit(0);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushUpgraded: disconnect write buffers in TCP when done", (Object[])new Object[0]);
            }
            this._tcpContext.getWriteInterface().setBuffers(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAsyncUpgradedOutputBuffers() throws IOException {
        boolean writingBody;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("flushAsyncUpgraded: Flushing async buffers  for Upgraded output: " + this), (Object[])new Object[0]);
        }
        if ((writingBody = this.hasBufferedContent()) && null != this._output[this.outputIndex]) {
            this._output[this.outputIndex].flip();
        }
        VirtualConnection _vcWrite = null;
        try {
            WsByteBuffer[] content;
            WsByteBuffer[] wsByteBufferArray = content = writingBody ? this._output : null;
            if (content != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"flushAsyncUpgraded: Now write it out to TCP", (Object[])new Object[0]);
                }
                this._tcpContext.getWriteInterface().setBuffers(content);
                _vcWrite = this._tcpContext.getWriteInterface().write(-1L, this._callback, false, WCCustomProperties31.UPGRADE_WRITE_TIMEOUT);
                if (_vcWrite == null) {
                    this.setInternalReady(false);
                    this.setReadyForApp(false);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"flushAsyncUpgraded:  wait for data to be written, async write in progress, set ready to false", (Object[])new Object[0]);
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"flushAsyncUpgraded: No more data to flush ", (Object[])new Object[0]);
            }
        }
        finally {
            this.bytesWritten += (long)this.bufferedCount;
            this.bufferedCount = 0;
            this.outputIndex = 0;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("flushAsyncUpgraded: finally, this " + this + " , bytesWritten -->" + this.bytesWritten), (Object[])new Object[0]);
            }
            if (writingBody && _vcWrite != null) {
                this.clearBuffersAfterWrite();
            }
        }
    }

    private boolean hasBufferedContent() {
        return 0 < this.bufferedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeWork() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close upgrade output", (Object[])new Object[0]);
        }
        boolean clearBuffers = true;
        try {
            if (this._listener != null) {
                this.setOutputStream_close_initiated_but_not_Flush_ready(false);
                if (this._isReady) {
                    this.validate();
                    this.set_asyncFlushCalledFromCloseWork(true);
                    this.flushAsyncUpgradedOutputBuffers();
                    if (this._isReady) return;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close called but output not ready ,return, close will be done later after complete of pending write", (Object[])new Object[0]);
                    }
                    clearBuffers = false;
                    this.setOutputStream_close_initiated_but_not_Flush_ready(true);
                    return;
                }
                clearBuffers = false;
                this.setOutputStream_close_initiated_but_not_Flush_ready(true);
                return;
            }
            this.validate();
            this.flushUpgradedOutputBuffers();
            return;
        }
        finally {
            if (clearBuffers) {
                this.setOutputStream_closed(true);
                this.clear();
            }
        }
    }

    private void clear() {
        if (null != this._output) {
            for (int i = 0; i < this._output.length; ++i) {
                if (null == this._output[i]) continue;
                this._output[i].release();
                this._output[i] = null;
            }
        }
        this.outputIndex = 0;
        this.bufferedCount = 0;
        this.bytesWritten = 0L;
        this.setWriteListenerCallBack(null);
    }

    private void clearBuffersAfterWrite() {
        if (null != this._output) {
            if (null != this._output[0]) {
                this._output[0].clear();
            }
            for (int i = 1; i < this._output.length; ++i) {
                if (null == this._output[i]) continue;
                this._output[i].position(0);
                this._output[i].limit(0);
            }
        }
    }

    private boolean isDataSaved() {
        return this._dataSaved;
    }

    private void setDataSaved(boolean dataSaved) {
        this._dataSaved = dataSaved;
    }

    public TCPWriteCompletedCallback getWriteListenerCallBack() {
        return this._callback;
    }

    public void setWriteListenerCallBack(TCPWriteCompletedCallback callback) {
        if (callback != null) {
            this._vc.getStateMap().put("UpgradedListener", "true");
        }
        this._callback = callback;
    }

    public void set_listener(WriteListener _listener) {
        this._listener = _listener;
    }

    public void setReadyForApp(boolean isReady) {
        this._isReady = isReady;
    }

    public boolean isWriteReadyForApp() {
        return this._isReady;
    }

    public boolean isInternalReady() {
        return this._isInternalReady;
    }

    public void setInternalReady(boolean _isInternalReady) {
        this._isInternalReady = _isInternalReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteReadyWork(boolean externalCall) {
        if (this.isOutputStream_closed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"output stream closed, ready->false", (Object[])new Object[0]);
            }
            return false;
        }
        boolean ready = true;
        Object object = this._writeReadyLockObj;
        synchronized (object) {
            if (!this.isWriteReadyForApp()) {
                ready = false;
                if (externalCall) {
                    this.status_not_ready_checked = true;
                    WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
                    if (reqState != null && reqState.getAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread") != null) {
                        reqState.removeAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread");
                    }
                }
            } else {
                WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)true);
                reqState.setAttribute("com.ibm.ws.webcontainer.upgrade.WriteAllowedonThisThread", (Object)true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" ready->" + ready), (Object[])new Object[0]);
        }
        return ready;
    }

    public VirtualConnection get_vc() {
        return this._vc;
    }

    public boolean isOutputStream_close_initiated_but_not_Flush_ready() {
        return this.outputStream_close_initiated_but_not_Flush_ready;
    }

    public void setOutputStream_close_initiated_but_not_Flush_ready(boolean outputStream_close_initiated_but_not_Flush_ready) {
        this.outputStream_close_initiated_but_not_Flush_ready = outputStream_close_initiated_but_not_Flush_ready;
    }

    public boolean isOutputStream_closed() {
        return this.outputStream_closed;
    }

    public void setOutputStream_closed(boolean outputStream_closed) {
        this.outputStream_closed = outputStream_closed;
    }

    public boolean is_asyncFlushCalledFromCloseWork() {
        return this._asyncFlushCalledFromCloseWork;
    }

    public void set_asyncFlushCalledFromCloseWork(boolean _asyncFlushCalledFromCloseWork) {
        this._asyncFlushCalledFromCloseWork = _asyncFlushCalledFromCloseWork;
    }
}

