/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OsgiPropertyUtils {
    private static final BundleContext bContext;
    static final long serialVersionUID = 7503882555132811165L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={IllegalStateException.class})
    private static String get(String propertyName) {
        String tmpObj = null;
        if (bContext != null) {
            try {
                tmpObj = bContext.getProperty(propertyName);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (tmpObj == null) {
            tmpObj = System.getProperty(propertyName);
        }
        return tmpObj;
    }

    public static String getProperty(String propertyName, String defaultValue) {
        String value = OsgiPropertyUtils.get(propertyName);
        return value == null ? defaultValue : value;
    }

    public static int getInteger(String propertyName, int defaultValue) {
        String tmpObj = OsgiPropertyUtils.get(propertyName);
        if (tmpObj != null) {
            try {
                return Integer.parseInt(tmpObj);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.wsspi.kernel.service.utils.OsgiPropertyUtils", (String)"104", null, (Object[])new Object[]{propertyName, defaultValue});
            }
        }
        return defaultValue;
    }

    public static long getLong(String propertyName, long defaultValue) {
        String tmpObj = OsgiPropertyUtils.get(propertyName);
        if (tmpObj != null) {
            try {
                return Long.parseLong(tmpObj);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.wsspi.kernel.service.utils.OsgiPropertyUtils", (String)"124", null, (Object[])new Object[]{propertyName, defaultValue});
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(String propertyName) {
        String tmpObj = OsgiPropertyUtils.get(propertyName);
        return Boolean.parseBoolean(tmpObj);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OsgiPropertyUtils.class);
        BundleContext bc = null;
        try {
            Bundle b = FrameworkUtil.getBundle(OsgiPropertyUtils.class);
            bc = b.getBundleContext();
            bc = bc.getBundle("System Bundle").getBundleContext();
        }
        catch (Throwable b) {
            FFDCFilter.processException((Throwable)b, (String)"com.ibm.wsspi.kernel.service.utils.OsgiPropertyUtils", (String)"44", null, (Object[])new Object[0]);
        }
        bContext = bc;
    }
}

