/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SearchBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2012";
    private static final TraceComponent tc = Tr.register(SearchBridge.class);
    private TypeMappings propertyMap;
    private BridgeUtils mappingUtils;
    private String groupRDN;
    static final long serialVersionUID = -8274377172336292275L;

    @FFDCIgnore(value={Exception.class})
    public SearchBridge(BridgeUtils mappingUtil) {
        block3: {
            this.propertyMap = null;
            this.mappingUtils = null;
            this.groupRDN = "cn";
            String methodName = "SearchBridge";
            this.mappingUtils = mappingUtil;
            this.propertyMap = new TypeMappings(mappingUtil);
            try {
                String[] groupRDNList = this.mappingUtils.getCoreConfiguration().getRDNProperties("Group");
                if (groupRDNList != null && groupRDNList.length > 0) {
                    this.groupRDN = groupRDNList[0];
                }
            }
            catch (Exception excp) {
                if (!tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)(methodName + " " + excp.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={WIMException.class})
    public SearchResult getUsers(String inputPattern, int inputLimit) throws RegistryException {
        String methodName = "getUsers";
        SearchResult returnValue = new SearchResult();
        try {
            String inputAttrName;
            boolean isInputAttrIdentifier;
            this.mappingUtils.validateId(inputPattern);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputPattern);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            if (isInputAttrIdentifier = this.mappingUtils.isIdentifierTypeProperty(inputAttrName = this.propertyMap.getInputUserSecurityName(idAndRealm.getRealm()))) {
                inputAttrName = "principalName";
            }
            List controls = root.getControls();
            SearchControl searchControl = new SearchControl();
            if (controls != null) {
                controls.add(searchControl);
            }
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm()))) {
                searchControl.getProperties().add(this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm()));
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            searchControl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrName + "=" + quote + id + quote + "]");
            if (inputLimit > 0) {
                searchControl.setCountLimit(inputLimit + 1);
            } else {
                searchControl.setCountLimit(inputLimit);
            }
            Context context = new Context();
            context.set("key", (Object)"useUserFilterForSearch");
            context.set("value", (Object)id);
            root.getContexts().add(context);
            root = this.mappingUtils.getWimService().search(root);
            List returnedList = root.getEntities();
            if (!returnedList.isEmpty()) {
                ArrayList<Object> people = new ArrayList<Object>();
                for (int count = 0; count < returnedList.size() && (inputLimit <= 0 || count != inputLimit); ++count) {
                    PersonAccount loginAccount = (PersonAccount)returnedList.get(count);
                    if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm()))) {
                        people.add(loginAccount.get(this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm())));
                        continue;
                    }
                    people.add(loginAccount.getIdentifier().get(this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm())));
                }
                returnValue = new SearchResult(people, true);
            } else {
                returnValue = new SearchResult(new ArrayList(), false);
            }
        }
        catch (WIMException toCatch) {
            if (toCatch instanceof EntityNotFoundException) {
                returnValue = new SearchResult(new ArrayList(), false);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[0]);
            }
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[0]);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class, InvalidNameException.class})
    public SearchResult getGroups(String inputPattern, int inputLimit) throws RegistryException {
        String methodName = "getGroups";
        SearchResult returnValue = new SearchResult();
        try {
            String inputAttrName;
            boolean isInputAttrIdentifier;
            this.mappingUtils.validateId(inputPattern);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputPattern);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            if (isInputAttrIdentifier = this.mappingUtils.isIdentifierTypeProperty(inputAttrName = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm()))) {
                inputAttrName = this.groupRDN;
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            boolean callGetAPI = false;
            String groupSecNameAttr = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm());
            if (UniqueNameHelper.isDN((String)id) != null && groupSecNameAttr.equals("uniqueName")) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)(methodName + " " + "Group Security name mapped to uniqueName. Invoking get instead of search"), (Object[])new Object[]{methodName});
                }
                callGetAPI = true;
                List entities = root.getEntities();
                Group entity = new Group();
                if (entities != null) {
                    entities.add(entity);
                }
                IdentifierType idfType = new IdentifierType();
                idfType.setUniqueName(id);
                entity.setIdentifier(idfType);
                root = this.mappingUtils.getWimService().get(root);
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm()))) {
                    searchControl.getProperties().add(this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm()));
                }
                LdapName dnName = null;
                try {
                    dnName = new LdapName(inputPattern);
                }
                catch (InvalidNameException e) {
                    // empty catch block
                }
                if (dnName != null) {
                    int index = inputPattern.indexOf("=");
                    int endIndex = inputPattern.indexOf(",", index);
                    String attrName = inputAttrName;
                    String value = null;
                    if (index > 0) {
                        attrName = inputPattern.substring(0, index);
                        value = inputPattern.substring(index + 1, endIndex);
                    }
                    String searchBase = null;
                    if (endIndex + 1 < inputPattern.length()) {
                        searchBase = inputPattern.substring(endIndex + 1);
                        searchControl.getSearchBases().add(searchBase);
                    }
                    searchControl.setExpression("//entities[@xsi:type='Group' and " + attrName + "=" + quote + value + quote + "]");
                } else {
                    searchControl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                }
                if (inputLimit > 0) {
                    searchControl.setCountLimit(inputLimit + 1);
                } else {
                    searchControl.setCountLimit(inputLimit);
                }
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnedList = root.getEntities();
            if (!returnedList.isEmpty()) {
                ArrayList<Object> groups = new ArrayList<Object>();
                for (int count = 0; count < returnedList.size() && (inputLimit <= 0 || count != inputLimit); ++count) {
                    Group group = (Group)returnedList.get(count);
                    boolean isEntityTypeGrp = false;
                    isEntityTypeGrp = callGetAPI ? group.isSubType("Group") : true;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)(methodName + " " + "Value of isEntityTypGrp :" + isEntityTypeGrp), (Object[])new Object[]{methodName});
                    }
                    if (isEntityTypeGrp) {
                        if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm()))) {
                            groups.add(group.get(this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm())));
                            continue;
                        }
                        groups.add(group.getIdentifier().get(this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm())));
                        continue;
                    }
                    if (!tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)(methodName + " " + "The Entity type was not compatible with Group. The entityType is : " + group.getTypeName()), (Object[])new Object[0]);
                }
                returnValue = new SearchResult(groups, true);
            } else {
                returnValue = new SearchResult(new ArrayList(), false);
            }
        }
        catch (WIMException toCatch) {
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof InvalidUniqueNameException) {
                returnValue = new SearchResult(new ArrayList(), false);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[0]);
            }
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[0]);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }
}

