/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.internal.ImmediateFutureImpl;
import com.ibm.ws.threading.internal.NonCancelableResultFuture;
import com.ibm.ws.threading.listeners.CompletionListener;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FutureMonitorImpl
implements FutureMonitor {
    private final Queue<FutureMonitorInfo<?>> _monitor = new ConcurrentLinkedQueue();
    private ScheduledExecutorService _executor;
    private final AtomicBoolean _threadRunning = new AtomicBoolean(false);
    private final Runnable _thread = new Runnable(){
        static final long serialVersionUID = 2422512430832938099L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public void run() {
            Iterator iterator = FutureMonitorImpl.this._monitor.iterator();
            while (iterator.hasNext()) {
                FutureMonitorInfo info = (FutureMonitorInfo)iterator.next();
                if (!info.test() || !info.notifyListener()) continue;
                iterator.remove();
            }
            FutureMonitorImpl.this._threadRunning.set(false);
            if (FutureMonitorImpl.this._monitor.isEmpty()) {
                return;
            }
            if (FutureMonitorImpl.this._threadRunning.compareAndSet(false, true)) {
                FutureMonitorImpl.this._executor.schedule(FutureMonitorImpl.this._thread, 100L, TimeUnit.MILLISECONDS);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = 2765238413969174390L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public <T> void onCompletion(Future<T> work, CompletionListener<T> l) {
        boolean queue = true;
        FutureMonitorInfo<T> info = new FutureMonitorInfo<T>(work, l);
        if (info.test()) {
            boolean bl = queue = !info.notifyListener();
        }
        if (queue && work instanceof NonCancelableResultFuture) {
            ((NonCancelableResultFuture)work).queueListener(l);
            queue = false;
        }
        if (queue) {
            this._monitor.add(info);
            if (this._threadRunning.compareAndSet(false, true)) {
                this._executor.schedule(this._thread, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void setExecutor(ScheduledExecutorService ses) {
        this._executor = ses;
    }

    public void unsetExecutor(ScheduledExecutorService ses) {
        this._executor = null;
    }

    @Override
    public <T> Future<T> createFuture(Class<T> type) {
        return new NonCancelableResultFuture();
    }

    @Override
    public <T> Future<T> createFutureWithResult(T result) {
        return new ImmediateFutureImpl<T>(result);
    }

    @Override
    public <T> Future<T> createFutureWithResult(Class<T> type, Throwable t) {
        return new ImmediateFutureImpl(t);
    }

    @Override
    public <T> void setResult(Future<T> future, T result) {
        if (future instanceof NonCancelableResultFuture) {
            NonCancelableResultFuture futureImpl = (NonCancelableResultFuture)future;
            futureImpl.complete(result);
            futureImpl.callListeners();
        }
    }

    @Override
    public void setResult(Future<?> future, Throwable error) {
        if (future instanceof NonCancelableResultFuture) {
            NonCancelableResultFuture futureImpl = (NonCancelableResultFuture)future;
            futureImpl.fail(error);
            futureImpl.callListeners();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FutureMonitorImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class FutureMonitorInfo<T> {
        private final Future<T> _future;
        private final CompletionListener<T> _listener;
        static final long serialVersionUID = 1180329288913696228L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FutureMonitorInfo(Future<T> work, CompletionListener<T> l) {
            this._future = work;
            this._listener = l;
        }

        public boolean test() {
            return this._future.isDone();
        }

        @FFDCIgnore(value={ExecutionException.class, TimeoutException.class})
        public boolean notifyListener() {
            try {
                T result = this._future.get(100L, TimeUnit.MILLISECONDS);
                this._listener.successfulCompletion(this._future, result);
            }
            catch (InterruptedException result) {
                FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.threading.internal.FutureMonitorImpl$FutureMonitorInfo", (String)"52", (Object)this, (Object[])new Object[0]);
                return false;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                try {
                    this._listener.failedCompletion(this._future, cause);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.threading.internal.FutureMonitorImpl$FutureMonitorInfo", (String)"58", (Object)this, (Object[])new Object[0]);
                }
            }
            catch (TimeoutException e) {
                return false;
            }
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FutureMonitorInfo.class);
        }
    }
}

