/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletResponse;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTConnectionContext
implements Cloneable {
    protected IExtendedRequest _request;
    protected WebAppDispatcherContext _dispatchContext = null;
    protected IExtendedResponse _response;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    protected static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTConnectionContext";

    public SRTConnectionContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "SRTConnectionContext", "Constructor");
        }
        this._request = this.newSRTServletRequest();
        this._response = this.newSRTServletResponse();
        this._request.setWebAppDispatcherContext(this._dispatchContext);
    }

    protected SRTServletRequest newSRTServletRequest() {
        return new SRTServletRequest(this);
    }

    protected SRTServletResponse newSRTServletResponse() {
        return new SRTServletResponse(this);
    }

    public void prepareForNextConnection(IRequest req, IResponse res) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "prepareForNextConnection");
            logger.logp(Level.FINE, CLASS_NAME, "prepareForNextConnection", "channel req->" + req + ", channel res->" + res + ", IExtendedRequest->" + this._request + ", IExtendedResponse" + this._response);
        }
        this._request.initForNextRequest(req);
        this._response.initForNextResponse(res);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "prepareForNextConnection");
        }
    }

    public void start() {
        this._response.start();
        this._request.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishConnection() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "finishConnection");
            logger.logp(Level.FINE, CLASS_NAME, "finishConnection", "IExtendedRequest->" + this._request + ", IExtendedResponse" + this._response);
        }
        try {
            try {
                this._response.finish();
            }
            catch (Throwable th) {
                FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", "64", this);
            }
            try {
                this._request.finish();
            }
            catch (Throwable th) {
                FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", "74", this);
                WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)this._request.getWebAppDispatcherContext();
                dispatchContext.getWebApp().logError("Error while finishing the connection", th);
            }
            this.dispatchContextFinish();
        }
        finally {
            this._request.initForNextRequest(null);
            this._response.initForNextResponse(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "finishConnection");
        }
    }

    protected void dispatchContextFinish() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "dispatchContextFinish");
            logger.logp(Level.FINE, CLASS_NAME, "dispatchContextFinish", "IExtendedRequest->" + this._request + ", IExtendedResponse" + this._response);
        }
        try {
            this._dispatchContext.finish();
        }
        catch (Throwable th) {
            FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.srt.SRTConnectionContext.dispatchContextFinish", "84", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "dispatchContextFinish");
        }
    }

    public IExtendedRequest getRequest() {
        return this._request;
    }

    public IExtendedResponse getResponse() {
        return this._response;
    }

    protected Object clone(SRTServletRequest clonedRequest, WebAppDispatcherContext clonedDispatchContext) throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " entry");
        }
        SRTConnectionContext clonedConnContext = (SRTConnectionContext)super.clone();
        clonedConnContext._request = clonedRequest;
        clonedConnContext._dispatchContext = clonedDispatchContext;
        if (this._response instanceof IServletResponse) {
            clonedConnContext._response = (IExtendedResponse)((IServletResponse)((Object)this._response)).clone();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " exit original -->" + this + " cloned -->" + clonedConnContext);
        }
        return clonedConnContext;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " entry");
        }
        this._request.destroy();
        this._response.destroy();
        this._dispatchContext = null;
        this._request = null;
        this._response = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " exit");
        }
    }

    public void setResponse(IExtendedResponse extResp) {
        this._response = extResp;
    }
}

