/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.session.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.session.SessionAffinityManager;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionCrossoverStackTrace;
import com.ibm.ws.session.SessionIDGeneratorImpl;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.SessionAffinityContext;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class SessionAffinityManagerImpl
extends SessionAffinityManager {
    private static final String methodClassName = "SessionAffinityManagerImpl";

    public SessionAffinityManagerImpl(SessionManagerConfig smc, SessionContext sctx, IStore istore) {
        super(smc, sctx, istore);
        this._cloneID = SessionManagerConfig.getCloneId();
        if (this._smc.isUsingMemory() && SessionManagerConfig.isTurnOffCacheId()) {
            this._versionPrefixLength = 0;
            this._versionPlusIdLength = SessionManagerConfig.getSessionIDLength();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodClassName, "Clone ID of this server=" + this._cloneID);
        }
    }

    public String getRequestedSessionIdFromURL(ServletRequest request) {
        return this.getRequestedSessionIdFromURL(request, false);
    }

    public String getRequestedSessionIdFromURL(ServletRequest request, boolean force) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], "force=" + force);
        }
        String sessionID = null;
        if (this._smc.getEnableUrlRewriting() || force) {
            int prefix;
            String requestURI = ((IExtendedRequest)request).getEncodedRequestURI();
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "request uri:" + requestURI);
            }
            if ((prefix = requestURI.indexOf(this._smc.getSessUrlRewritePrefix())) != -1) {
                int sessionIDstart = requestURI.indexOf("=", prefix + 1);
                int i = requestURI.indexOf(";", prefix + 1);
                int j = requestURI.indexOf("?", prefix + 1);
                int postfix = -1;
                postfix = i == -1 ? j : (j == -1 ? i : (i > j ? j : i));
                sessionID = postfix != -1 ? requestURI.substring(sessionIDstart + 1, postfix) : requestURI.substring(sessionIDstart + 1);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], sessionID);
        }
        return sessionID;
    }

    public List getAllCookieValues(ServletRequest request) {
        return ((IExtendedRequest)request).getAllCookieValues(this._smc.getSessionCookieName());
    }

    public SessionAffinityContext analyzeRequest(ServletRequest request) {
        byte[] byteSessId;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1]);
        }
        String sessionID = null;
        boolean reqFromCookie = false;
        boolean reqFromURL = false;
        boolean reqFromSSL = false;
        boolean reqFromClient = false;
        SessionAffinityContext sessionAffinityContext = null;
        ArrayList<String> allSessionIds = null;
        if (this._smc.useSSLId()) {
            String sessionId = this.getActualSSLSessionId(request);
            sessionAffinityContext = this.analyzeSSLRequest(request, sessionId);
        }
        if (sessionAffinityContext != null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], "Affinity Context found from SSL");
            }
            return sessionAffinityContext;
        }
        if (this._smc.getEnableCookies()) {
            byteSessId = ((IExtendedRequest)request).getCookieValueAsBytes(this._smc.getSessionCookieName());
            if (byteSessId != null) {
                allSessionIds = new ArrayList<String>(1);
                allSessionIds.add(0, new String(byteSessId));
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "Found session id(s) in cookie");
                }
                reqFromCookie = true;
            } else if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "No session id(s) found in cookie");
            }
        }
        if (!reqFromCookie && this._smc.getEnableUrlRewriting()) {
            sessionID = this.getRequestedSessionIdFromURL(request);
            if (sessionID != null) {
                reqFromURL = true;
                allSessionIds = new ArrayList(1);
                allSessionIds.add(0, sessionID);
            }
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "Found session id in URL: " + sessionID);
            }
        }
        if (!reqFromCookie && !reqFromURL) {
            if (this._smc.getEnableCookies()) {
                sessionID = this.getRequestedSessionIdFromURL(request, true);
                if (sessionID != null) {
                    if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "Found client session id in URL: " + sessionID);
                    }
                    reqFromClient = true;
                    allSessionIds = new ArrayList(1);
                    allSessionIds.add(0, sessionID);
                }
            } else {
                byteSessId = ((IExtendedRequest)request).getCookieValueAsBytes(this._smc.getSessionCookieName());
                if (byteSessId != null) {
                    allSessionIds = new ArrayList(1);
                    allSessionIds.add(0, new String(byteSessId));
                    if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "Found client session id(s) in cookie");
                    }
                    reqFromClient = true;
                } else if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "No session id(s) found in cookie");
                }
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[1], "allSessionIds size = " + (allSessionIds == null ? "0" : Integer.valueOf(allSessionIds.size())));
        }
        sessionAffinityContext = new SessionAffinityContext(allSessionIds, reqFromCookie, reqFromURL, reqFromSSL, reqFromClient);
        this.setNextId(sessionAffinityContext);
        String idFromRequest = ((IExtendedRequest)request).getUpdatedSessionId();
        if (idFromRequest != null) {
            this.setResponseData(idFromRequest, sessionAffinityContext);
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1]);
        }
        return sessionAffinityContext;
    }

    public SessionAffinityContext analyzeSSLRequest(ServletRequest request, String sslSessionId) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[6]);
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "SSL Id from Request = " + sslSessionId);
        }
        String sessionId = sslSessionId;
        boolean reqFromCookie = false;
        boolean reqFromURL = false;
        boolean reqFromSSL = false;
        SessionAffinityContext sessionAffinityContext = null;
        ArrayList<String> allSessionIds = null;
        IExtendedRequest sessReq = (IExtendedRequest)request;
        if (sessionId != null) {
            reqFromSSL = true;
            String tempCacheId = this._smc.isUsingMemory() ? "0000" : "0001";
            String tempCloneInfo = "";
            String extendedId = null;
            byte[] byteExtendedId = sessReq.getCookieValueAsBytes("SSLJSESSION");
            if (byteExtendedId != null) {
                extendedId = new String(byteExtendedId);
            }
            if (extendedId == null) {
                extendedId = this.getRequestedSessionIdFromURL(request);
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "getRequestedSessionId - encoded URL contains: " + extendedId);
                }
            }
            if (extendedId != null) {
                tempCacheId = extendedId.substring(0, 4);
                int index = extendedId.indexOf(SessionManagerConfig.getCloneSeparator());
                if (index != -1) {
                    String tempDummyId = extendedId.substring(4, index);
                    tempCloneInfo = extendedId.substring(index);
                }
            }
            sessionId = tempCacheId + "SESSIONMANAGEMENTAFFINI" + tempCloneInfo;
            allSessionIds = new ArrayList<String>(1);
            allSessionIds.add(0, sessionId);
            sessionAffinityContext = new SessionAffinityContext(allSessionIds, reqFromCookie, reqFromURL, reqFromSSL);
            this.setNextId(sessionAffinityContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[6], "getRequestedSessionId - massaged long SSL id is now: " + sessionId);
        }
        return sessionAffinityContext;
    }

    public String getActualSSLSessionId(ServletRequest request) {
        String sessionID = null;
        byte[] sslBytes = ((IExtendedRequest)request).getSSLId();
        if (sslBytes != null) {
            sessionID = SessionIDGeneratorImpl.convertSessionIdBytesToSessionId((byte[])sslBytes, (int)SessionManagerConfig.getSessionIDLength());
        }
        return sessionID;
    }

    protected WebAppConfig getWebAppConfig() {
        WebModuleMetaData wmmd;
        WebAppConfig wac = null;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd instanceof WebComponentMetaData && !((wac = (wmmd = (WebModuleMetaData)((WebComponentMetaData)cmd).getModuleMetaData()).getConfiguration()) instanceof WebAppConfiguration)) {
            wac = null;
        }
        return wac;
    }

    public String getFeatureAuthzRoleHeaderValue() {
        Dictionary<String, String> headers;
        String name = null;
        WebAppConfig wac = this.getWebAppConfig();
        if (wac != null && wac instanceof WebAppConfiguration && (headers = ((WebAppConfiguration)wac).getBundleHeaders()) != null) {
            name = headers.get("IBM-Authorization-Roles");
        }
        return name;
    }

    public void setCookie(ServletRequest request, ServletResponse response, SessionAffinityContext affinityContext, Object session) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[4]);
        }
        if (!this._smc.getEnableCookies()) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[4], "Cookies not enabled.");
            }
            return;
        }
        int sessionVersion = affinityContext.getResponseSessionVersion();
        String sessionID = affinityContext.getResponseSessionID();
        String incomingCloneIDs = affinityContext.getInputCloneInfo();
        String incomingSessionID = affinityContext.getRequestedSessionID();
        int incomingSessionVersion = affinityContext.getRequestedSessionVersion();
        String cloneSeparatorPlusID = this.getSeparatorPlusAffinityToken(sessionID);
        boolean previouslySetSessionCookie = affinityContext.isSessionCookieSet();
        if (null == incomingSessionID || !incomingSessionID.equals(sessionID) || incomingSessionVersion != sessionVersion || incomingCloneIDs.indexOf(cloneSeparatorPlusID) == -1) {
            if (this._smc.isDebugSessionCrossover() && this._sessCtx.crossoverCheck((HttpSession)session)) {
                Object[] parms = new Object[]{this._sessCtx.getAppName(), ((HttpSession)session).getId(), this._sessCtx.getCurrentSessionId()};
                LoggingUtil.logParamsAndException((Logger)LoggingUtil.SESSION_LOGGER_CORE, (Level)Level.SEVERE, (String)methodClassName, (String)methodNames[4], (String)"SessionContext.CrossoverOnReturn", (Object[])parms, (Throwable)new SessionCrossoverStackTrace());
            } else {
                String sessionVersionString = this.getVersionString(sessionVersion);
                StringBuffer cookieString = new StringBuffer();
                cookieString.append(sessionVersionString).append(sessionID);
                String cloneInfo = this.updateCloneInfo(affinityContext, cloneSeparatorPlusID);
                cookieString.append(cloneInfo);
                if (cookieString.length() > SessionManagerConfig.getMaxSessionIdentifierLength() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.WARNING)) {
                    Object[] parms = new String[]{cookieString.toString(), new Integer(SessionManagerConfig.getMaxSessionIdentifierLength()).toString()};
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[4], "SessionContext.maxSessionIdLengthExceeded", parms);
                }
                this.whichCookie = this._smc.getSessionCookieName();
                StringBuffer logStringBuffer = new StringBuffer();
                Cookie cookie = new Cookie(this.whichCookie, cookieString.toString());
                cookie.setPath(this._smc.getSessionCookiePath());
                cookie.setComment(this._smc.getSessionCookieComment());
                cookie.setMaxAge(this._smc.getSessionCookieMaxAge());
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[4], "AppName = " + this.getFeatureAuthzRoleHeaderValue() + "; Global Security = " + WSSecurityHelper.isGlobalSecurityEnabled());
                }
                if (this.getFeatureAuthzRoleHeaderValue() != null) {
                    cookie.setSecure(WSSecurityHelper.isGlobalSecurityEnabled());
                } else {
                    cookie.setSecure(this._smc.getSessionCookieSecure());
                }
                cookie.setHttpOnly(this._smc.getSessionCookieHttpOnly());
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    logStringBuffer.append("Setting cookie: ").append(this.whichCookie).append(";Path: ").append(this._smc.getSessionCookiePath()).append(";Comment: ").append(this._smc.getSessionCookieComment()).append(";MaxAge: ").append(this._smc.getSessionCookieMaxAge()).append(";Secure: ").append(cookie.getSecure()).append(";HttpOnly: ").append(this._smc.getSessionCookieHttpOnly());
                }
                if (this._smc.getSessionCookieDomain() != null && !this._smc.getSessionCookieDomain().equals("")) {
                    cookie.setDomain(this._smc.getSessionCookieDomain());
                    if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        logStringBuffer.append(";Domain: ").append(this._smc.getSessionCookieDomain());
                    }
                }
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[4], logStringBuffer.toString());
                }
                if (!previouslySetSessionCookie || !response.isCommitted()) {
                    affinityContext.setSessionCookieSet(true);
                    if (response.isCommitted()) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[4], "SessionContext.responseAlreadyCommitted");
                        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                            try {
                                throw new Exception("Stack trace for SESN0066E:");
                            }
                            catch (Throwable th) {
                                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.webcontainer.session.impl.SessionAffinityManagerImpl", (String)"398", null);
                            }
                        }
                    }
                    ((IExtendedResponse)response).addSessionCookie(cookie);
                } else if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[4], "The session cookie was already set for this request and the response has already been committed.");
                }
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[4]);
        }
    }

    public void setSIPCookie(ServletRequest request, ServletResponse response, String sipCookieString) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[5]);
        }
        if (!this._smc.getEnableCookies()) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[5], "Cookies not enabled.");
            }
            return;
        }
        SessionAffinityManagerImpl sessionAffinityManagerImpl = this;
        String whichSIPCookie = sessionAffinityManagerImpl._smc.getSipSessionCookieName();
        Cookie cookie = new Cookie(whichSIPCookie, sipCookieString);
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[5], "Setting cookie: " + whichSIPCookie);
        }
        if (response.isCommitted()) {
            boolean cookieSetInSameRequest = new Boolean((String)request.getAttribute("com.ibm.ws.session.cookie.already.set"));
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[5], "request.getAttribute(com.ibm.ws.session.cookie.already.set): " + request.getAttribute("com.ibm.ws.session.cookie.already.set"));
            }
            if (!cookieSetInSameRequest) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.WARNING, methodClassName, methodNames[5], "SessionContext.responseAlreadyCommitted");
                request.setAttribute("com.ibm.ws.session.cookie.already.set", (Object)"true");
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[5], "Set request attribute com.ibm.ws.session.cookie.already.set to true");
                    try {
                        throw new Exception("Stack trace for SESN0066E:");
                    }
                    catch (Throwable th) {
                        FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.webcontainer.session.impl.SessionAffinityManagerImpl", (String)"467", null);
                    }
                }
            } else {
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[5], "responseAlreadyCommitted already logged");
                }
                return;
            }
        }
        ((IExtendedResponse)response).addSessionCookie(cookie);
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[5]);
        }
    }
}

