/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.mbeans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.osgi.mbeans.GeneratePluginConfigMBean;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.webcontainer.osgi.mbeans.GeneratePluginConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.servlet.SessionCookieConfig;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={ApplicationStateListener.class, RuntimeUpdateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class GeneratePluginConfigListener
implements RuntimeUpdateListener,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(GeneratePluginConfigListener.class);
    private int updatesInProgress = 0;
    private int appsInService = 0;
    private volatile ExecutorService executorSrvc;
    private GeneratePluginConfig gpc;
    private ConcurrentHashMap<String, String> cookieNames = new ConcurrentHashMap();
    private SessionManager smgr;
    private static GeneratePluginConfigListener theListener = null;

    public static GeneratePluginConfigListener getGeneratePluginConfigListener() {
        return theListener;
    }

    @Activate
    protected void activate(BundleContext bc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: activate called.", (Object[])new Object[0]);
        }
        theListener = this;
    }

    @Deactivate
    protected void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: deactivate called.", (Object[])new Object[0]);
        }
    }

    @Reference(service=GeneratePluginConfig.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setGeneratePluginConfig(GeneratePluginConfig mb) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: GPC set", (Object[])new Object[0]);
        }
        this.gpc = mb;
    }

    protected void unsetGeneratePluginConfig() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: GPC unset", (Object[])new Object[0]);
        }
        this.gpc = null;
    }

    @Reference(service=ExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setExecutor(ExecutorService executorSrvc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: executorService set", (Object[])new Object[0]);
        }
        this.executorSrvc = executorSrvc;
    }

    protected void unsetExecutor(ExecutorService executorSrvc) {
        this.executorSrvc = null;
    }

    @Reference(service=SessionManager.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setSessionManager(SessionManager ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Session Manager set", (Object[])new Object[0]);
        }
        this.smgr = ref;
    }

    protected void unsetSessionManager(SessionManager ref) {
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        this.setFutureGeneratePluginTask();
        ++this.appsInService;
        if (this.smgr != null) {
            this.cookieNames.put(appInfo.getName(), this.smgr.getDefaultAffinityCookie());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application starting, add app to cookie map. app name : " + appInfo.getName() + ", cookie name : " + this.smgr.getDefaultAffinityCookie()), (Object[])new Object[0]);
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application started : " + appInfo.getName() + ", updatesinProgress : " + this.updatesInProgress), (Object[])new Object[0]);
        }
        this.runFutureGeneratePluginTask();
    }

    public void applicationStopping(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application stopping, remove stored cookie name : " + appInfo.getName() + ", cookie name : " + this.cookieNames.get(appInfo.getName())), (Object[])new Object[0]);
        }
        this.setFutureGeneratePluginTask();
        this.cookieNames.remove(appInfo.getName());
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application stopped : " + appInfo.getName() + ", updatesinProgress : " + (this.updatesInProgress - 1)), (Object[])new Object[0]);
        }
        this.runFutureGeneratePluginTask();
        --this.appsInService;
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("GPCL: RuntimeUpdate notification " + notification.getName() + ", apps in service = " + this.appsInService), (Object[])new Object[0]);
        }
        if (this.appsInService > 0 && notification.getName().equals("ConfigUpdatesDelivered")) {
            this.setFutureGeneratePluginTask();
            notification.onCompletion((CompletionListener)new ConfigUpdateListener());
        }
    }

    private void setFutureGeneratePluginTask() {
        ++this.updatesInProgress;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setFutureGeneratePluginTask : future updates = " + this.updatesInProgress), (Object[])new Object[0]);
        }
    }

    private boolean unsetFutureGeneratePluginTask() {
        --this.updatesInProgress;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("unsetFutureGeneratePluginTask : future updates = " + this.updatesInProgress), (Object[])new Object[0]);
        }
        return this.updatesInProgress == 0;
    }

    private boolean isFuturePluginTask() {
        return this.updatesInProgress == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFutureGeneratePluginTask() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("runFutureGeneratePluginTask : future updates = " + this.updatesInProgress), (Object[])new Object[0]);
        }
        GeneratePluginConfigListener generatePluginConfigListener = this;
        synchronized (generatePluginConfigListener) {
            if (this.unsetFutureGeneratePluginTask()) {
                this.submitGeneratePluginTask();
            }
        }
    }

    private void submitGeneratePluginTask() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("submitGeneratePluginTask : FrameworkState.isStopping() = " + FrameworkState.isStopping()), (Object[])new Object[0]);
        }
        if (!FrameworkState.isStopping() && this.gpc != null && this.executorSrvc != null) {
            this.executorSrvc.submit(new Runnable(){

                @Override
                public void run() {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"generating webserver plugin", (Object[])new Object[0]);
                    }
                    ((GeneratePluginConfigMBean)GeneratePluginConfigListener.this.gpc).generatePluginConfig(null, null, true);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationInitialized(WebApp webApp, SessionCookieConfig sccfg) {
        String cookieName = this.cookieNames.get(webApp.getApplicationName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application initialized, updates in progress = " + this.updatesInProgress + ", app : " + webApp.getApplicationName() + ", old cookie name : " + this.cookieNames.get(webApp.getApplicationName()) + ", new cookie name : " + sccfg.getName()), (Object[])new Object[0]);
        }
        if (cookieName != null && !cookieName.equals(sccfg.getName())) {
            GeneratePluginConfigListener generatePluginConfigListener = this;
            synchronized (generatePluginConfigListener) {
                if (this.isFuturePluginTask()) {
                    this.submitGeneratePluginTask();
                }
            }
        }
    }

    private class ConfigUpdateListener
    implements CompletionListener {
        GeneratePluginConfigListener gpcl;

        public ConfigUpdateListener() {
            this.gpcl = GeneratePluginConfigListener.this;
        }

        public void successfulCompletion(Future future, Object result) {
            this.gpcl.runFutureGeneratePluginTask();
        }

        public void failedCompletion(Future future, Throwable t) {
            this.gpcl.unsetFutureGeneratePluginTask();
        }
    }
}

