/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.container.config;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.config.ServletConfigurator;
import com.ibm.ws.container.service.config.ServletConfiguratorHelper;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.javaee.dd.DeploymentDescriptor;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.dd.web.WebFragment;
import com.ibm.ws.javaee.dd.webbnd.WebBnd;
import com.ibm.ws.javaee.dd.webext.WebExt;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.container.config.WebAppConfiguratorHelper;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;

public class WebAppConfigurator
implements ServletConfigurator {
    private static final TraceComponent tc = Tr.register(WebAppConfigurator.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS(WebAppConfigurator.class, (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private final Container moduleContainer;
    private final NonPersistentCache overlayCache;
    private final List<ServletConfiguratorHelper> configHelpers;
    private final List<String> errorMessages;
    private final WebApp webApp;
    private final WebBnd webBnd;
    private final WebExt webExt;
    private final VersionInfo webVersionInfo;
    private WebAnnotations webAnnotations;
    private final AtomicLong uniqueId = new AtomicLong(1L);
    private final Map<String, Object> attributes;
    private ServletConfigurator.ConfigSource currentSource;
    private String currentLibraryURI;
    private boolean currentMetadataComplete;
    private final Class<?>[] SERVLET30_LISTENER_INTERFACES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class};
    private static final String HTTP_ID_LISTENER_CLASS_NAME = "javax.servlet.http.HttpSessionIdListener";
    ServletConfiguratorHelper webAppHelper;

    private List<Class<?>> getListenerInterfaces() {
        Class<?> httpIDListenerInterface;
        ArrayList listenerInterfaces = new ArrayList(Arrays.asList(this.SERVLET30_LISTENER_INTERFACES));
        if (WebContainer.getServletContainerSpecLevel() < 31) {
            return listenerInterfaces;
        }
        try {
            httpIDListenerInterface = Class.forName(HTTP_ID_LISTENER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            httpIDListenerInterface = null;
        }
        if (httpIDListenerInterface != null) {
            listenerInterfaces.add(httpIDListenerInterface);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Servlet 3.1 is enabled but failed to find the HTTP ID Listener class [ javax.servlet.http.HttpSessionIdListener ]", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Supported listener interfaces: " + listenerInterfaces), (Object[])new Object[0]);
        }
        return listenerInterfaces;
    }

    public WebAppConfigurator(Container moduleContainer, NonPersistentCache overlayCache, ResourceRefConfigFactory resourceRefConfigFactory) throws UnableToAdaptException {
        this.moduleContainer = moduleContainer;
        this.overlayCache = overlayCache;
        this.configHelpers = new ArrayList<ServletConfiguratorHelper>();
        this.webAppHelper = new WebAppConfiguratorHelper(this, resourceRefConfigFactory, this.getListenerInterfaces());
        this.configHelpers.add(this.webAppHelper);
        this.webApp = (WebApp)moduleContainer.adapt(WebApp.class);
        this.webBnd = (WebBnd)moduleContainer.adapt(WebBnd.class);
        this.webExt = (WebExt)moduleContainer.adapt(WebExt.class);
        this.webVersionInfo = new VersionInfo(this.webApp);
        this.errorMessages = new ArrayList<String>();
        this.attributes = new HashMap<String, Object>();
    }

    public void addHelper(ServletConfiguratorHelper helper) {
        this.configHelpers.add(helper);
    }

    public int getServletVersion() {
        return this.webVersionInfo.versionId;
    }

    public boolean isMetadataComplete() {
        return this.webVersionInfo.isMetadataComplete;
    }

    public Container getModuleContainer() {
        return this.moduleContainer;
    }

    public Object getFromModuleCache(Class<?> owner) {
        return this.overlayCache.getFromCache(owner);
    }

    public void addToModuleCache(Class<?> owner, Object data) {
        this.overlayCache.addToCache(owner, data);
    }

    public ServletConfigurator.ConfigSource getConfigSource() {
        return this.currentSource;
    }

    public String getLibraryURI() {
        return this.currentLibraryURI;
    }

    public boolean getMetadataCompleted() {
        return this.currentMetadataComplete;
    }

    public WebAnnotations getWebAnnotations() {
        return this.webAnnotations;
    }

    public long generateUniqueId() {
        return this.uniqueId.getAndIncrement();
    }

    public void addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public boolean haveAnyErrorMessages() {
        return !this.errorMessages.isEmpty();
    }

    public String getErrorMessageText() {
        String separatorString = System.getProperty("line.separator");
        StringBuilder errorMessageBuffer = new StringBuilder();
        for (String errorMessage : this.errorMessages) {
            errorMessageBuffer.append(errorMessage).append(separatorString);
        }
        return errorMessageBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure() throws UnableToAdaptException {
        boolean webIsMetadataComplete = this.isMetadataComplete();
        this.webAnnotations = (WebAnnotations)this.moduleContainer.adapt(WebAnnotations.class);
        if (!webIsMetadataComplete) {
            this.webAnnotations.openInfoStore();
        }
        try {
            for (ServletConfiguratorHelper configHelper : this.configHelpers) {
                configHelper.configureInit();
            }
            if (this.webApp != null) {
                this.currentLibraryURI = "WEB-INF/web.xml";
                this.currentSource = ServletConfigurator.ConfigSource.WEB_XML;
                this.currentMetadataComplete = this.isMetadataComplete();
                for (ServletConfiguratorHelper configHelper : this.configHelpers) {
                    configHelper.configureFromWebApp(this.webApp);
                }
            }
            if (!webIsMetadataComplete) {
                for (WebFragmentInfo webFragmentItem : this.webAnnotations.getOrderedItems()) {
                    WebFragment webFragment = webFragmentItem.getWebFragment();
                    this.currentLibraryURI = webFragmentItem.getLibraryURI();
                    this.currentSource = ServletConfigurator.ConfigSource.WEB_FRAGMENT;
                    boolean bl = this.currentMetadataComplete = webFragment != null && webFragment.isMetadataComplete();
                    if (webFragment != null) {
                        for (ServletConfiguratorHelper configHelper : this.configHelpers) {
                            configHelper.configureFromWebFragment(webFragmentItem);
                        }
                    }
                    if (!this.currentMetadataComplete) {
                        for (ServletConfiguratorHelper configHelper : this.configHelpers) {
                            configHelper.configureFromAnnotations(webFragmentItem);
                        }
                    }
                    ((WebAppConfiguratorHelper)this.webAppHelper).processIgnoredMappings((DeploymentDescriptor)this.webApp);
                }
            }
            for (ServletConfiguratorHelper configHelper : this.configHelpers) {
                configHelper.configureDefaults();
            }
        }
        finally {
            if (!webIsMetadataComplete) {
                this.webAnnotations.closeInfoStore();
            }
        }
        this.clearContext();
        if (this.webBnd != null) {
            for (ServletConfiguratorHelper configHelper : this.configHelpers) {
                configHelper.configureWebBnd(this.webBnd);
            }
        }
        if (this.webExt != null) {
            for (ServletConfiguratorHelper configHelper : this.configHelpers) {
                configHelper.configureWebExt(this.webExt);
            }
        }
        for (ServletConfiguratorHelper configHelper : this.configHelpers) {
            configHelper.finish();
        }
        if (this.haveAnyErrorMessages()) {
            throw new UnableToAdaptException(this.getErrorMessageText());
        }
    }

    public <T> void validateDuplicateConfiguration(String parentElementName, String elementName, T newValue, ServletConfigurator.ConfigItem<T> priorConfigItem) {
        String newLibraryURI;
        String priorLibraryURI;
        Object priorValue = priorConfigItem.getValue();
        if (priorValue == null ? newValue == null : newValue != null && priorConfigItem.compareValue(newValue)) {
            return;
        }
        ServletConfigurator.ConfigSource priorSource = priorConfigItem.getSource();
        ServletConfigurator.ConfigSource newSource = this.getConfigSource();
        if (priorSource == ServletConfigurator.ConfigSource.WEB_XML) {
            if (newSource == ServletConfigurator.ConfigSource.WEB_FRAGMENT && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"{0}.{1} with value {2} is configured in web.xml, the value {3} from web-fragment.xml in {4} is ignored", (Object[])new Object[]{parentElementName, elementName, priorConfigItem.getValue(), newValue, this.getLibraryURI()});
            }
        } else if (priorSource == ServletConfigurator.ConfigSource.WEB_FRAGMENT && !(priorLibraryURI = priorConfigItem.getLibraryURI()).equals(newLibraryURI = this.getLibraryURI())) {
            this.errorMessages.add(nls.getFormattedMessage("CONFLICT_SINGLE_VALUE_CONFIG_BETWEEN_WEB_FRAGMENT_XML", new Object[]{parentElementName, elementName, priorValue, priorLibraryURI, newValue, newLibraryURI}, "Conflict configurations are found in the web-fragment.xml files"));
        }
    }

    public <T> void validateDuplicateKeyValueConfiguration(String parentElementName, String keyElementName, String keyElementValue, String valueElementName, T newValue, ServletConfigurator.ConfigItem<T> priorConfigItem) {
        String newLibraryURI;
        String priorLibraryURI;
        Object priorValue = priorConfigItem.getValue();
        if (priorValue == null ? newValue == null : newValue != null && priorConfigItem.compareValue(newValue)) {
            return;
        }
        ServletConfigurator.ConfigSource priorSource = priorConfigItem.getSource();
        ServletConfigurator.ConfigSource newSource = this.getConfigSource();
        if (priorSource == ServletConfigurator.ConfigSource.WEB_XML) {
            if (newSource == ServletConfigurator.ConfigSource.WEB_FRAGMENT && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"{0} {1} == {2} {3} == {4} is configured in web.xml, the value {5} from web-fragment.xml in {6} is ignored", (Object[])new Object[]{parentElementName, keyElementName, keyElementValue, valueElementName, priorValue, newValue, this.getLibraryURI()});
            }
        } else if (priorSource == ServletConfigurator.ConfigSource.WEB_FRAGMENT && !(priorLibraryURI = priorConfigItem.getLibraryURI()).equals(newLibraryURI = this.getLibraryURI())) {
            this.errorMessages.add(nls.getFormattedMessage("CONFLICT_KEY_VALUE_CONFIG_BETWEEN_WEB_FRAGMENT_XML", new Object[]{valueElementName, parentElementName, keyElementName, keyElementValue, priorValue, priorLibraryURI, newValue, newLibraryURI}, "Conflict configurations are found in the web-fragment.xml files"));
        }
    }

    public void validateDuplicateDefaultErrorPageConfiguration(String newLocation, ServletConfigurator.ConfigItem<String> priorLocationItem) {
        String newLibraryURI;
        String priorLibraryURI;
        String priorLocation = (String)priorLocationItem.getValue();
        if (priorLocation == null ? newLocation == null : newLocation != null && priorLocation.equals(newLocation)) {
            return;
        }
        ServletConfigurator.ConfigSource priorSource = priorLocationItem.getSource();
        ServletConfigurator.ConfigSource newSource = this.getConfigSource();
        if (priorSource == ServletConfigurator.ConfigSource.WEB_XML) {
            if (newSource == ServletConfigurator.ConfigSource.WEB_FRAGMENT && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Default error page with location {0} in web.xml overrides default error page with location {1} in web-fragment.xml in {2}.", (Object[])new Object[]{priorLocation, newLocation, this.getLibraryURI()});
            }
        } else if (priorSource == ServletConfigurator.ConfigSource.WEB_FRAGMENT && !(priorLibraryURI = priorLocationItem.getLibraryURI()).equals(newLibraryURI = this.getLibraryURI())) {
            this.errorMessages.add(nls.getFormattedMessage("CONFLICT_DEFAULT_ERROR_PAGE_WEB_FRAGMENT_XML", new Object[]{priorLocation, priorLibraryURI, newLocation, newLibraryURI}, "Multiple default error pages with different locations in one or more web-fragment.xml."));
        }
    }

    public <T> Map<String, ServletConfigurator.ConfigItem<T>> getConfigItemMap(String key) {
        HashMap configItemMap = (HashMap)this.attributes.get(key);
        if (configItemMap == null) {
            configItemMap = new HashMap();
            this.attributes.put(key, configItemMap);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ConfigContext create map instance for {0}", (Object[])new Object[]{key});
            }
        }
        return configItemMap;
    }

    public <T> Set<T> getContextSet(String key) {
        HashSet set = (HashSet)this.attributes.get(key);
        if (set == null) {
            set = new HashSet();
            this.attributes.put(key, set);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ConfigContext create set instance for {0}", (Object[])new Object[]{key});
            }
        }
        return set;
    }

    private void clearContext() {
        this.attributes.clear();
    }

    public <T> ServletConfigurator.ConfigItem<T> createConfigItem(T value) {
        return this.createConfigItem(value, null);
    }

    public <T> ServletConfigurator.ConfigItem<T> createConfigItem(T value, ServletConfigurator.MergeComparator<T> comparator) {
        return new ConfigItemImpl<T>(value, this.getConfigSource(), this.getLibraryURI(), comparator);
    }

    private static class ConfigItemImpl<I>
    implements ServletConfigurator.ConfigItem<I> {
        private final I value;
        private final ServletConfigurator.ConfigSource source;
        private final String libraryURI;
        private final ServletConfigurator.MergeComparator<I> comparator;

        public ConfigItemImpl(I value, ServletConfigurator.ConfigSource source, String libraryURI, ServletConfigurator.MergeComparator<I> comparator) {
            this.value = value;
            this.source = source;
            this.libraryURI = libraryURI;
            this.comparator = comparator;
        }

        public I getValue() {
            return this.value;
        }

        public ServletConfigurator.ConfigSource getSource() {
            return this.source;
        }

        public String getLibraryURI() {
            return this.libraryURI;
        }

        public boolean compareValue(I otherValue) {
            if (this.value == otherValue) {
                return true;
            }
            if (this.value == null || otherValue == null) {
                return false;
            }
            if (this.comparator == null) {
                return this.value.equals(otherValue);
            }
            return this.comparator.compare(this.value, otherValue);
        }

        public <T> T getValue(Class<T> cls) {
            return cls.cast(this.value);
        }
    }

    private static class VersionInfo {
        public final int versionId;
        public final boolean isMetadataComplete;

        public VersionInfo(WebApp webApp) {
            if (webApp == null) {
                this.versionId = WebAppConfiguratorHelper.getDefaultVersionId();
                this.isMetadataComplete = false;
            } else {
                this.versionId = WebAppConfiguratorHelper.getVersionId(webApp.getVersion());
                this.isMetadataComplete = this.versionId <= 24 ? true : webApp.isSetMetadataComplete() && webApp.isMetadataComplete();
            }
        }
    }
}

