/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.metadata.extended.DeferredMetaDataFactory;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModuleMetaDataListener.class, AllServiceListener.class, ApplicationStateListener.class, DeferredMetaDataFactory.class}, property={"service.vendor=IBM", "deferredMetaData=WEB", "supportsDeferredInit:Boolean=true"})
public class WebContainerListener
implements ModuleMetaDataListener,
ApplicationStateListener,
AllServiceListener,
DeferredMetaDataFactory {
    private static final TraceComponent tc = Tr.register(WebContainerListener.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private J2EENameFactory jeeNameFactory;
    ConcurrentHashMap<String, ConcurrentHashMap<J2EEName, WebModuleMetaData>> webModulesInStartingApps = new ConcurrentHashMap();
    ConcurrentHashMap<String, ConcurrentHashMap<J2EEName, WebModuleMetaData>> webModulesInStartedApps = new ConcurrentHashMap();
    private Object webModulesInStartingApps_lock = new Object(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) throws MetaDataException {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            String appName = ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication();
            Object object = this.webModulesInStartingApps_lock;
            synchronized (object) {
                if (this.webModulesInStartingApps.containsKey(appName)) {
                    this.webModulesInStartingApps.get(appName).put(((ModuleMetaData)event.getMetaData()).getJ2EEName(), (WebModuleMetaData)event.getMetaData());
                } else {
                    ConcurrentHashMap<J2EEName, WebModuleMetaData> moduleMetadatas = new ConcurrentHashMap<J2EEName, WebModuleMetaData>();
                    moduleMetadatas.put(((ModuleMetaData)event.getMetaData()).getJ2EEName(), (WebModuleMetaData)event.getMetaData());
                    this.webModulesInStartingApps.put(appName, moduleMetadatas);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WebModule metadata saved for " + ((ModuleMetaData)event.getMetaData()).getJ2EEName()), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        String appName = appInfo.getDeploymentName();
        if (null == appName) {
            return;
        }
        ConcurrentHashMap<J2EEName, WebModuleMetaData> modules = this.webModulesInStartingApps.remove(appName);
        if (null != modules) {
            this.webModulesInStartedApps.put(appName, modules);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Web application started - " + appName), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={NullPointerException.class})
    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        if (null == appName) {
            return;
        }
        this.webModulesInStartingApps.remove(appName);
        this.webModulesInStartedApps.remove(appName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Web application stopped- " + appName), (Object[])new Object[0]);
        }
    }

    public void serviceChanged(ServiceEvent event) {
    }

    @Activate
    protected void activate(ComponentContext context) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
    }

    public ComponentMetaData createComponentMetaData(String identifier) {
        String[] parts = identifier.split("#");
        J2EEName jeeName = this.jeeNameFactory.create(parts[1], parts[2], null);
        Map wmmdMap = this.webModulesInStartedApps.get(parts[1]);
        if (wmmdMap == null) {
            return null;
        }
        WebModuleMetaData wmmd = (WebModuleMetaData)wmmdMap.get(jeeName);
        if (wmmd == null) {
            return null;
        }
        WebAppConfiguration webAppConfiguration = (WebAppConfiguration)wmmd.getConfiguration();
        return webAppConfiguration.getDefaultComponentMetaData();
    }

    public void initialize(ComponentMetaData metadata) {
        WebModuleMetaData wmmd = (WebModuleMetaData)metadata.getModuleMetaData();
        WebAppConfiguration webAppConfiguration = (WebAppConfiguration)wmmd.getConfiguration();
        WebApp webApp = webAppConfiguration.getWebApp();
        if (!webApp.isInitialized()) {
            try {
                webApp.initialize();
            }
            catch (Error x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Throwable x) {
                throw new IllegalStateException(x);
            }
        }
    }

    @Reference
    protected void setJEENameFactory(J2EENameFactory svc) {
        this.jeeNameFactory = svc;
    }

    protected void unsetJ2EENameFactory(J2EENameFactory svc) {
        this.jeeNameFactory = null;
    }

    public static String getPersistentIdentifierImpl(String app, String module) {
        return "WEB#" + app + "#" + module;
    }

    public String getMetaDataIdentifier(String appName, String moduleName, String componentName) {
        return WebContainerListener.getPersistentIdentifierImpl(appName, moduleName);
    }

    public ClassLoader getClassLoader(ComponentMetaData metaData) {
        ModuleMetaData moduleMetaData;
        ModuleMetaData moduleMetaData2 = moduleMetaData = metaData != null ? metaData.getModuleMetaData() : null;
        if (moduleMetaData instanceof WebModuleMetaData) {
            WebAppConfiguration webAppConfiguration = (WebAppConfiguration)((WebModuleMetaData)moduleMetaData).getConfiguration();
            return webAppConfiguration.getWebApp().getClassLoader();
        }
        return null;
    }
}

