/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webcontainer.async.AsyncIllegalStateException;
import com.ibm.ws.webcontainer.async.AsyncListenerEntry;
import com.ibm.ws.webcontainer.async.AsyncListenerEnum;
import com.ibm.ws.webcontainer.async.AsyncServletReentrantLock;
import com.ibm.ws.webcontainer.async.AsyncTimeoutRunnable;
import com.ibm.ws.webcontainer.async.CompleteRunnable;
import com.ibm.ws.webcontainer.async.ContextWrapper;
import com.ibm.ws.webcontainer.async.DispatchRunnable;
import com.ibm.ws.webcontainer.async.ListenerHelper;
import com.ibm.ws.webcontainer.async.ServiceWrapper;
import com.ibm.ws.webcontainer.async.WrapperRunnableImpl;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.async.WrapperRunnable;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.AsyncContext;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AsyncContextImpl
implements AsyncContext {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.async.AsyncContextImpl";
    protected IExtendedRequest iExtendedRequest;
    private IExtendedResponse iExtendedResponse;
    protected ServletRequest servletRequest;
    protected ServletResponse servletResponse;
    protected IServletContext webApp;
    protected String originalRequestURI;
    private boolean completePending = false;
    private boolean dispatching = true;
    private CompleteRunnable completeRunnable;
    private DispatchRunnable dispatchRunnable;
    private boolean dispatchAllowed = true;
    protected List<AsyncListenerEntry> asyncListenerEntryList;
    private long _asyncTimeout = WCCustomProperties.DEFAULT_ASYNC_SERVLET_TIMEOUT;
    public static AtomicBoolean executorRetrieved = new AtomicBoolean(false);
    private ScheduledFuture<?> timeoutScheduledFuture;
    private boolean dispatchPending;
    private Collection<WrapperRunnable> startRunnables;
    private AsyncServletReentrantLock errorHandlingLock = new AsyncServletReentrantLock();
    private boolean invokeErrorHandling = false;
    private boolean complete;
    private long startTime;
    protected String dispatchURI = null;
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(AsyncContextImpl.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected ServiceWrapper serviceWrapper;

    @Override
    public IServletContext getWebApp() {
        return this.webApp;
    }

    public void setWebApp(IServletContext webApp) {
        this.webApp = webApp;
    }

    @Override
    public void setDispatching(boolean dispatching) {
        this.dispatching = dispatching;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "setDispatching", "dispatching -->" + this.dispatching);
        }
    }

    @Override
    public boolean isDispatching() {
        return this.dispatching;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public AsyncContextImpl(IExtendedRequest iExtendedRequest, IExtendedResponse iExtendedResponse, IWebAppDispatcherContext webAppDispatcherContext) {
        this.iExtendedRequest = iExtendedRequest;
        this.servletRequest = this.iExtendedRequest;
        this.iExtendedResponse = iExtendedResponse;
        this.servletResponse = this.iExtendedResponse;
        this.originalRequestURI = webAppDispatcherContext.getOriginalRelativeURI();
        this.webApp = webAppDispatcherContext.getWebApp();
        if (this.transferContext()) {
            this.captureContext();
        }
        this.startTime = System.currentTimeMillis();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "<init>", "[this servletRequest servletResponse originalRequestURI webApp] [" + this + " " + this.servletRequest + " " + this.servletResponse + " " + this.originalRequestURI + " " + this.webApp + "]");
        }
    }

    public synchronized boolean lockHeldByDifferentThread() {
        AsyncServletReentrantLock lock = this.getErrorHandlingLock();
        boolean isLocked = lock.isLocked();
        boolean heldByCurrentThread = lock.isHeldByCurrentThread();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "lockHeldByDifferentThread", "isLocked [{0}] heldByCurrentThread [{1}]", new Object[]{isLocked, heldByCurrentThread});
        }
        return isLocked && !heldByCurrentThread;
    }

    public synchronized void complete() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "complete", this);
        }
        if (!this.lockHeldByDifferentThread()) {
            if (!this.completePending) {
                this.iExtendedRequest.setAsyncStarted(false);
                this.createNewAsyncServletReeentrantLock();
                this.cancelAsyncTimer();
                this.completeRunnable = new CompleteRunnable(this.iExtendedRequest, this);
                this.completePending = true;
                if (!this.dispatching) {
                    this.executeNextRunnable();
                }
            }
        } else if (WCCustomProperties.THROW_EXCEPTION_WHEN_UNABLE_TO_COMPLETE_OR_DISPATCH) {
            throw new IllegalStateException(nls.getString("AsyncContext.lock.already.held", "Unable to obtain the lock.  Error processing has already been invoked by another thread."));
        }
        this.dispatchURI = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "complete", this);
        }
    }

    public synchronized void dispatch(ServletContext context, String path) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "dispatch(ctx,path)", new Object[]{this, context, path});
        }
        if (!this.lockHeldByDifferentThread()) {
            if (this.completePending) {
                throw new IllegalStateException(nls.getString("called.dispatch.after.complete"));
            }
            if (!this.dispatchAllowed) {
                throw new IllegalStateException(nls.getString("trying.to.call.dispatch.twice.for.the.same.async.operation"));
            }
            this.createNewAsyncServletReeentrantLock();
            this.cancelAsyncTimer();
            WebAppRequestDispatcher requestDispatcher = (WebAppRequestDispatcher)context.getRequestDispatcher(path);
            this.dispatchRunnable = new DispatchRunnable(requestDispatcher, this);
            this.dispatchPending = true;
            this.dispatchAllowed = false;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "dispatch(ctx,path)", "dispatching -->" + this.dispatching);
            }
            if (!this.dispatching) {
                this.executeNextRunnable();
            }
        } else if (WCCustomProperties.THROW_EXCEPTION_WHEN_UNABLE_TO_COMPLETE_OR_DISPATCH) {
            throw new IllegalStateException(nls.getString("AsyncContext.lock.already.held", "Unable to obtain the lock.  Error processing has already been invoked by another thread."));
        }
        this.dispatchURI = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "dispatch(ctx,path)", this);
        }
    }

    @Override
    public synchronized boolean cancelAsyncTimer() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "cancelAsyncTimer", this);
        }
        boolean timerCancelled = true;
        if (this.timeoutScheduledFuture != null) {
            this.timeoutScheduledFuture.cancel(false);
            if (ExecutorFieldHolder.field.getQueue().size() > WCCustomProperties.ASYNC_MAX_SIZE_TASK_POOL && ExecutorFieldHolder.fieldTimeout.get() + (long)WCCustomProperties.ASYNC_PURGE_INTERVAL < System.currentTimeMillis()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "cancelAsyncTimer", "purging the tasks queue, size ->[" + ExecutorFieldHolder.field.getQueue().size() + "]");
                }
                ExecutorFieldHolder.fieldTimeout.set(System.currentTimeMillis());
                ExecutorFieldHolder.field.purge();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "cancelAsyncTimer", "purged the tasks queue, size ->[" + ExecutorFieldHolder.field.getQueue().size() + "]");
                }
            }
            this.timeoutScheduledFuture = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "cancelAsyncTimer", timerCancelled);
        }
        return timerCancelled;
    }

    private synchronized void startAsyncTimer() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "startAsyncTimer", this);
        }
        if (this.getTimeout() > 0L) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "startAsyncTimer", "about to start async timer, timeout->" + this.getTimeout());
            }
            this.scheduleTimeout();
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "startAsyncTimer", "not starting async timer");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "startAsyncTimer", this);
        }
    }

    protected void scheduleTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "scheduleTimeout", this);
        }
        if (this.timeoutScheduledFuture != null) {
            throw new AsyncIllegalStateException(nls.getString("trying.to.schedule.timeout.without.cancelling.previous.timeout"));
        }
        AsyncTimeoutRunnable asyncTimeoutRunnable = new AsyncTimeoutRunnable(this);
        this.timeoutScheduledFuture = ExecutorFieldHolder.field.schedule(asyncTimeoutRunnable, this.getTimeout(), TimeUnit.MILLISECONDS);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "scheduleTimeout", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNextRunnable() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "executeNextRunnable", this);
        }
        boolean invokeAsyncErrorHandlingOutsideLock = false;
        AsyncContextImpl asyncContextImpl = this;
        synchronized (asyncContextImpl) {
            if (this.dispatchRunnable != null) {
                this.setDispatching(true);
                this.dispatchPending = false;
                DispatchRunnable localDispatchRunnable = this.dispatchRunnable;
                this.dispatchRunnable = null;
                if (!this.transferContext()) {
                    localDispatchRunnable.pushContextData();
                }
                this.startWithExecutorThread(localDispatchRunnable);
            } else if (this.completeRunnable != null) {
                this.setDispatching(true);
                CompleteRunnable localCompleteRunnable = this.completeRunnable;
                this.completeRunnable = null;
                this.startWithExecutorThread(localCompleteRunnable);
            } else if (this.isInvokeErrorHandling()) {
                invokeAsyncErrorHandlingOutsideLock = true;
                this.setInvokeErrorHandling(false);
            } else if (!this.isComplete()) {
                this.setDispatching(false);
                this.startAsyncTimer();
            }
        }
        if (invokeAsyncErrorHandlingOutsideLock) {
            WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
            ListenerHelper.invokeAsyncErrorHandling(this, reqState, null, AsyncListenerEnum.ERROR, ListenerHelper.ExecuteNextRunnable.TRUE, ListenerHelper.CheckDispatching.FALSE);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "executeNextRunnable", this);
        }
    }

    public void dispatch() throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "dispatch", this);
        }
        if (WCCustomProperties.SET_ASYNC_DISPATCH_REQUEST_URI && this.dispatchURI != null) {
            this.dispatchURI = this.dispatchURI.substring(this.webApp.getContextPath().length());
            this.dispatch(this.webApp, this.dispatchURI);
        } else {
            this.dispatch(this.webApp, this.originalRequestURI);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "dispatch()", "AsyncContextImpl->" + this);
            logger.exiting(CLASS_NAME, "dispatch", this);
        }
    }

    public void dispatch(String path) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "dispatch(path)", new Object[]{this, path});
        }
        this.dispatch(this.webApp, path);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "dispatch(path))", this);
        }
    }

    public void startWithExecutorThread(Runnable run) {
        this.startWithExecutorThread(run, false);
    }

    public void startWithExecutorThread(Runnable run, boolean startWrappedRunnable) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "startWithExecutorThread", new Object[]{this, run, startWrappedRunnable});
        }
        try {
            if (this.transferContext()) {
                run = new ContextWrapper(run, ServiceWrapper.newFromPushedData(this.serviceWrapper));
            }
            if (startWrappedRunnable) {
                WrapperRunnableImpl wrapperRunnable = new WrapperRunnableImpl(run, this);
                if (!this.transferContext()) {
                    wrapperRunnable.pushContextData();
                }
                this.addStartRunnable(wrapperRunnable);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "startWithExecutorThread(Runnable...)", "start new thread with wrapperRunnable");
                }
                WebContainer.getExecutorService().execute(wrapperRunnable);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "startWithExecutorThread(Runnable...)", "start new thread with Runnable");
                }
                WebContainer.getExecutorService().execute(run);
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "startWithExecutorThread(Runnable...)", "thread.interrupted.scheduling.async.runnable.on.thread.pool", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "startWithExecutorThread(Runnable...)", this);
        }
    }

    @Override
    public synchronized void addStartRunnable(WrapperRunnable wrapperRunnable) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "addStartRunnable", new Object[]{this, wrapperRunnable});
        }
        if (this.startRunnables == null) {
            this.startRunnables = new ArrayList<WrapperRunnable>();
        }
        this.startRunnables.add(wrapperRunnable);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "addStartRunnable", this);
        }
    }

    @Override
    public synchronized void removeStartRunnable(WrapperRunnable wrapperRunnable) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "removeStartRunnable", new Object[]{this, wrapperRunnable});
        }
        if (this.startRunnables != null) {
            this.startRunnables.remove(wrapperRunnable);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "removeStartRunnable", this);
        }
    }

    public synchronized void start(Runnable run) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "start", new Object[]{this, run});
        }
        if (!this.lockHeldByDifferentThread()) {
            this.startWithExecutorThread(run, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "start", this);
        }
    }

    @Override
    public void setRequestAndResponse(ServletRequest servletRequest, ServletResponse servletResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    @Override
    public boolean isCompletePending() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "isCompletePending", this);
            logger.exiting(CLASS_NAME, "isCompletePending", this.completePending);
        }
        return this.completePending;
    }

    public IExtendedRequest getIExtendedRequest() {
        return this.iExtendedRequest;
    }

    public IExtendedResponse getIExtendedResponse() {
        return this.iExtendedResponse;
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        boolean hasOriginal;
        boolean bl = hasOriginal = this.servletRequest == this.iExtendedRequest && this.servletResponse == this.iExtendedResponse;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "hasOriginalRequestAndResponse", this);
            logger.exiting(CLASS_NAME, "hasOriginalRequestAndResponse", hasOriginal);
        }
        return hasOriginal;
    }

    @Override
    public void invalidate() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "invalidate", this);
        }
        this.servletRequest = null;
        this.iExtendedRequest = null;
        this.servletResponse = null;
        this.iExtendedResponse = null;
        this.dispatchRunnable = null;
        this.completeRunnable = null;
        this.serviceWrapper = null;
        this.webApp = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "invalidate", this);
        }
    }

    public boolean isDispatchAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "isDispatchAllowed", this);
            logger.exiting(CLASS_NAME, "isDispatchAllowed", this.dispatchAllowed);
        }
        return this.dispatchAllowed;
    }

    public <T extends AsyncListener> T createListener(Class<T> listenerClass) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "createListener", new Object[]{this, listenerClass});
        }
        AsyncListener listener = (AsyncListener)this.webApp.createListener(listenerClass);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "createListener", listener);
        }
        return (T)listener;
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "addListener", new Object[]{this, listener, servletRequest, servletResponse});
        }
        if (this.asyncListenerEntryList == null) {
            this.asyncListenerEntryList = new ArrayList<AsyncListenerEntry>();
            this.registerPreEventAsyncListeners();
        }
        AsyncListenerEntry asyncListenerEntry = new AsyncListenerEntry(this, listener, servletRequest, servletResponse);
        this.asyncListenerEntryList.add(asyncListenerEntry);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "addListener", this);
        }
    }

    public long getTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "getTimeout", this);
            logger.exiting(CLASS_NAME, "getTimeout", this._asyncTimeout);
        }
        return this._asyncTimeout;
    }

    public void addListener(AsyncListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "addListener", new Object[]{this, listener});
        }
        if (this.asyncListenerEntryList == null) {
            this.asyncListenerEntryList = new ArrayList<AsyncListenerEntry>();
            this.registerPreEventAsyncListeners();
        }
        AsyncListenerEntry asyncListenerEntry = new AsyncListenerEntry(this, listener);
        this.asyncListenerEntryList.add(asyncListenerEntry);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "addListener", this);
        }
    }

    @Override
    public List<AsyncListenerEntry> getAsyncListenerEntryList() {
        return this.asyncListenerEntryList;
    }

    public void setTimeout(long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "setTimeout", new Object[]{this, timeout});
        }
        WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
        if (!this.dispatching || reqState == null || !reqState.isAsyncMode()) {
            throw new IllegalStateException("called setTimeout after the container-initiated dispatch which called startAsync has returned");
        }
        this._asyncTimeout = timeout;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "setTimeout", this);
        }
    }

    @Override
    public boolean isDispatchPending() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "isDispatchPending", this);
            logger.exiting(CLASS_NAME, "isDispatchPending", this.dispatchPending);
        }
        return this.dispatchPending;
    }

    @Override
    public void initialize() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "initialize", this);
        }
        if (this.asyncListenerEntryList != null) {
            List<AsyncListenerEntry> tempList = this.asyncListenerEntryList;
            this.asyncListenerEntryList = new ArrayList<AsyncListenerEntry>();
            for (AsyncListenerEntry asyncListenerEntry : tempList) {
                asyncListenerEntry.invokeOnStartAsync();
            }
        }
        this.dispatchAllowed = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "initialize", this);
        }
    }

    protected void captureContext() {
        this.serviceWrapper = new ServiceWrapper();
        this.serviceWrapper.pushContextData();
    }

    @Override
    public synchronized Collection<WrapperRunnable> getAndClearStartRunnables() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "getAndClearStartRunnables", this);
        }
        Collection<WrapperRunnable> tempStartRunnables = this.startRunnables;
        this.startRunnables = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "getAndClearStartRunnables", this);
        }
        return tempStartRunnables;
    }

    @Override
    public synchronized AsyncServletReentrantLock getErrorHandlingLock() {
        return this.errorHandlingLock;
    }

    @Override
    public void setInvokeErrorHandling(boolean invokeErrorHandling) {
        this.invokeErrorHandling = invokeErrorHandling;
    }

    public boolean isInvokeErrorHandling() {
        return this.invokeErrorHandling;
    }

    public synchronized void createNewAsyncServletReeentrantLock() {
        this.errorHandlingLock.getAndSetIsValid(false);
        this.errorHandlingLock = new AsyncServletReentrantLock();
    }

    public void setComplete(boolean b) {
        this.complete = b;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public boolean registerPreEventAsyncListeners() {
        return false;
    }

    public boolean registerPostEventAsyncListeners() {
        return false;
    }

    public boolean transferContext() {
        return WCCustomProperties.TRANSFER_CONTEXT_IN_ASYNC_SERVLET_REQUEST;
    }

    public void setDispatchURI(String uri) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "setDispatchURI", "uri -> " + uri);
        }
        this.dispatchURI = uri;
    }

    public static class ExecutorFieldHolder {
        public static final ScheduledThreadPoolExecutor field;
        public static final AtomicLong fieldTimeout;

        static {
            executorRetrieved.set(true);
            field = new ScheduledThreadPoolExecutor(WCCustomProperties.NUMBER_ASYNC_TIMER_THREADS);
            fieldTimeout = new AtomicLong(System.currentTimeMillis());
        }
    }
}

