/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.transaction.impl;

import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.apache.aries.jpa.container.context.impl.NLS;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.apache.aries.jpa.container.context.transaction.impl.JTAPersistenceContextRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTAEntityManagerHandler
implements InvocationHandler {
    private static final String[] TRANSACTED_METHODS = new String[]{"flush", "lock", "merge", "isJoinedToTransaction", "persist", "remove", "getLockMode", "lock", "refresh"};
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private final Set<String> transactedMethods = new HashSet<String>(Arrays.asList(TRANSACTED_METHODS));
    private final EntityManagerFactory emf;
    private final Map<String, Object> props;
    private final JTAPersistenceContextRegistry reg;
    private final AtomicLong instanceCount;
    private final DestroyCallback callback;
    private final ThreadLocal<AtomicInteger> activeCalls = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    private final ThreadLocal<EntityManager> activeManager = new ThreadLocal();
    private final ConcurrentLinkedQueue<EntityManager> pool = new ConcurrentLinkedQueue();

    public JTAEntityManagerHandler(EntityManagerFactory factory, Map<String, Object> properties, JTAPersistenceContextRegistry registry, AtomicLong activeCount, DestroyCallback onDestroy) {
        this.emf = factory;
        this.props = properties;
        this.reg = registry;
        this.instanceCount = activeCount;
        this.callback = onDestroy;
    }

    public void preCall() {
        this.activeCalls.get().incrementAndGet();
    }

    public void postCall() {
        EntityManager manager;
        if (this.activeCalls.get().decrementAndGet() == 0 && (manager = this.activeManager.get()) != null) {
            this.activeManager.set(null);
            manager.clear();
            this.pool.add(manager);
        }
    }

    private EntityManager getPersistenceContext(boolean forceTransaction) {
        EntityManager manager;
        if (forceTransaction) {
            EntityManager manager2 = this.activeManager.get();
            if (manager2 != null) {
                manager2.clear();
            }
            return this.reg.getCurrentPersistenceContext(this.emf, this.props, this.instanceCount, this.callback);
        }
        if (this.reg.isTransactionActive()) {
            EntityManager manager3 = this.activeManager.get();
            if (manager3 != null) {
                manager3.clear();
            }
            return this.reg.getCurrentPersistenceContext(this.emf, this.props, this.instanceCount, this.callback);
        }
        if (!this.reg.jtaIntegrationAvailable() && _logger.isDebugEnabled()) {
            _logger.debug("No integration with JTA transactions is available. No transaction context is active.");
        }
        if ((manager = this.activeManager.get()) == null) {
            manager = this.pool.poll();
            if (manager == null) {
                manager = this.emf.createEntityManager(this.props);
            }
            this.activeManager.set(manager);
        }
        return manager;
    }

    public void internalClose() {
        EntityManager temp;
        while ((temp = this.pool.poll()) != null) {
            temp.close();
        }
    }

    @Override
    @FFDCIgnore(value={Throwable.class})
    public Object invoke(@Sensitive Object proxy, Method method, @Sensitive Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("close".equals(methodName)) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("close.called.on.container.manged.em", new Object[0]));
        }
        if ("getTransaction".equals(methodName)) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("getTransaction.called.on.container.managed.em", new Object[0]));
        }
        if ("isOpen".equals(methodName)) {
            return true;
        }
        if ("joinTransaction".equals(methodName)) {
            return null;
        }
        if ("postCall".equals(methodName)) {
            this.postCall();
            return null;
        }
        if ("preCall".equals(methodName)) {
            this.preCall();
            return null;
        }
        if ("internalClose".equals(methodName)) {
            this.internalClose();
            return null;
        }
        boolean forceTransaction = this.transactedMethods.contains(methodName);
        if ("joinTransaction".equals(methodName) && args != null && args.length > 2 && args[2].getClass() == LockModeType.class) {
            boolean bl = forceTransaction = args[2] != LockModeType.NONE;
        }
        if ("find".equals(methodName) && args != null && args.length >= 3 && args[2].getClass() == LockModeType.class) {
            forceTransaction = args[2] != LockModeType.NONE;
        }
        EntityManager delegate = this.getPersistenceContext(forceTransaction);
        Object res = null;
        try {
            res = method.invoke((Object)delegate, args);
        }
        catch (IllegalArgumentException e) {
            throw new PersistenceException(NLS.MESSAGES.getMessage("wrong.JPA.version", new Object[]{method.getName(), delegate}), (Throwable)e);
        }
        catch (Throwable tActual) {
            Throwable t = tActual;
            while (t != null && t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t == null) {
                throw new PersistenceException("unknown invocation target exception", tActual);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            for (Class<?> declaredException : method.getExceptionTypes()) {
                if (!declaredException.isAssignableFrom(t.getClass())) continue;
                throw t;
            }
            throw new PersistenceException("unexpected un-declared exception " + tActual, tActual);
        }
        return res;
    }
}

