/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.ws.security.filemonitor.SecurityFileMonitor;
import com.ibm.ws.security.token.ltpa.internal.LTPAConfiguration;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyCreateTask;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyInfoManager;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeysChangeNotifier;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LTPAConfigurationImpl
implements LTPAConfiguration,
FileBasedActionable {
    private static final TraceComponent tc = Tr.register(LTPAConfigurationImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    static final String KEY_LOCATION_SERVICE = "locationService";
    static final String KEY_EXECUTOR_SERVICE = "executorService";
    static final String KEY_CHANGE_SERVICE = "ltpaKeysChangeNotifier";
    static final String DEFAULT_CONFIG_LOCATION = "${server.config.dir}/resources/security/ltpa.keys";
    static final String DEFAULT_OUTPUT_LOCATION = "${server.output.dir}/resources/security/ltpa.keys";
    private final AtomicServiceReference<WsLocationAdmin> locationService = new AtomicServiceReference("locationService");
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("executorService");
    private final AtomicServiceReference<LTPAKeysChangeNotifier> ltpaKeysChangeNotifierService = new AtomicServiceReference("ltpaKeysChangeNotifier");
    private ServiceRegistration<LTPAConfiguration> registration = null;
    private volatile ComponentContext cc = null;
    private LTPAKeyCreateTask createTask;
    private TokenFactory factory;
    private LTPAKeyInfoManager ltpaKeyInfoManager;
    private String keyImportFile;
    @Sensitive
    private String keyPassword;
    private long keyTokenExpiration;
    private long monitorInterval;
    private SecurityFileMonitor ltpaFileMonitor;
    private ServiceRegistration<FileMonitor> ltpaFileMonitorRegistration;
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    static final long serialVersionUID = 4618103202035010598L;

    protected void setExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorService.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorService.unsetReference(ref);
    }

    protected void setLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationService.setReference(reference);
    }

    protected void unsetLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationService.unsetReference(reference);
    }

    protected void setLtpaKeysChangeNotifier(ServiceReference<LTPAKeysChangeNotifier> ref) {
        this.ltpaKeysChangeNotifierService.setReference(ref);
    }

    protected void unsetLtpaKeysChangeNotifier(ServiceReference<LTPAKeysChangeNotifier> ref) {
        this.ltpaKeysChangeNotifierService.unsetReference(ref);
    }

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.cc = context;
        this.locationService.activate(context);
        this.executorService.activate(context);
        this.ltpaKeysChangeNotifierService.activate(context);
        this.loadConfig(props);
        this.setupRuntimeLTPAInfrastructure();
    }

    private void loadConfig(Map<String, Object> props) {
        this.keyImportFile = (String)props.get("keysFileName");
        SerializableProtectedString sps = (SerializableProtectedString)props.get("keysPassword");
        this.keyPassword = sps == null ? null : new String(sps.getChars());
        this.keyTokenExpiration = (Long)props.get("expiration");
        this.monitorInterval = (Long)props.get("monitorInterval");
        this.resolveActualKeysFileLocation();
    }

    private void resolveActualKeysFileLocation() {
        WsResource keysFileInServerConfig;
        if (this.isInDefaultOutputLocation() && (keysFileInServerConfig = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveResource(DEFAULT_CONFIG_LOCATION)) != null && keysFileInServerConfig.exists()) {
            String expandedKeysFileInServerConfig;
            this.keyImportFile = expandedKeysFileInServerConfig = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveString(DEFAULT_CONFIG_LOCATION);
        }
    }

    private boolean isInDefaultOutputLocation() {
        String expandedKeysFileInServerOutput = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveString(DEFAULT_OUTPUT_LOCATION);
        return this.keyImportFile.equals(expandedKeysFileInServerOutput);
    }

    private void setupRuntimeLTPAInfrastructure() {
        this.optionallyCreateFileMonitor();
        this.createTask = new LTPAKeyCreateTask((WsLocationAdmin)this.locationService.getService(), this);
        this.submitTaskToCreateLTPAKeys();
    }

    private void optionallyCreateFileMonitor() {
        if (this.monitorInterval > 0L) {
            this.createFileMonitor();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createFileMonitor() {
        block2: {
            try {
                this.ltpaFileMonitor = new SecurityFileMonitor((FileBasedActionable)this);
                this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.ltpaFileMonitor.monitorFiles(Arrays.asList(this.keyImportFile), this.monitorInterval));
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl", (String)"161", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Exception creating the LTPA file monitor.", (Object[])new Object[]{e});
            }
        }
    }

    public void performFileBasedAction(Collection<File> files) {
        Tr.audit((TraceComponent)tc, (String)"LTPA_KEYS_TO_LOAD", (Object[])new Object[]{this.keyImportFile});
        this.submitTaskToCreateLTPAKeys();
    }

    private void submitTaskToCreateLTPAKeys() {
        ((ExecutorService)this.executorService.getService()).execute(this.createTask);
    }

    protected void modified(Map<String, Object> props) {
        String oldKeyImportFile = this.keyImportFile;
        Long oldKeyTokenExpiration = this.keyTokenExpiration;
        Long oldMonitorInterval = this.monitorInterval;
        this.loadConfig(props);
        if (this.isKeysConfigChanged(oldKeyImportFile, oldKeyTokenExpiration)) {
            this.unsetFileMonitorRegistration();
            Tr.audit((TraceComponent)tc, (String)"LTPA_KEYS_TO_LOAD", (Object[])new Object[]{this.keyImportFile});
            this.setupRuntimeLTPAInfrastructure();
        } else if (this.isMonitorIntervalChanged(oldMonitorInterval)) {
            this.unsetFileMonitorRegistration();
            this.optionallyCreateFileMonitor();
        }
    }

    private boolean isKeysConfigChanged(String oldKeyImportFile, Long oldKeyTokenExpiration) {
        return !oldKeyImportFile.equals(this.keyImportFile) || oldKeyTokenExpiration != this.keyTokenExpiration;
    }

    private boolean isMonitorIntervalChanged(Long oldMonitorInterval) {
        return oldMonitorInterval != this.monitorInterval;
    }

    protected void deactivate(ComponentContext context) {
        this.cc = null;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.unsetFileMonitorRegistration();
        this.executorService.deactivate(context);
        this.locationService.deactivate(context);
        this.ltpaKeysChangeNotifierService.deactivate(context);
    }

    protected void unsetFileMonitorRegistration() {
        if (this.ltpaFileMonitorRegistration != null) {
            this.ltpaFileMonitorRegistration.unregister();
            this.ltpaFileMonitorRegistration = null;
        }
    }

    protected void setFileMonitorRegistration(ServiceRegistration<FileMonitor> ltpaFileMonitorRegistration) {
        this.ltpaFileMonitorRegistration = ltpaFileMonitorRegistration;
    }

    public BundleContext getBundleContext() {
        if (this.cc != null) {
            return this.cc.getBundleContext();
        }
        return null;
    }

    void setRegistration(ServiceRegistration<LTPAConfiguration> registration) {
        this.registration = registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTokenFactory(TokenFactory factory) {
        this.writeLock.lock();
        try {
            this.factory = factory;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenFactory getTokenFactory() {
        this.readLock.lock();
        try {
            TokenFactory tokenFactory = this.factory;
            return tokenFactory;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void setLTPAKeyInfoManager(LTPAKeyInfoManager ltpaKeyInfoManager) {
        this.ltpaKeyInfoManager = ltpaKeyInfoManager;
    }

    @Override
    public LTPAKeyInfoManager getLTPAKeyInfoManager() {
        return this.ltpaKeyInfoManager;
    }

    @Override
    public String getKeyFile() {
        return this.keyImportFile;
    }

    @Override
    @Sensitive
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public long getTokenExpiration() {
        return this.keyTokenExpiration;
    }

    protected void configReady() {
        LTPAKeysChangeNotifier notifier = this.getLTPAKeysChangeNotifier();
        if (notifier != null) {
            notifier.notifyListeners();
        }
    }

    protected LTPAKeysChangeNotifier getLTPAKeysChangeNotifier() {
        return (LTPAKeysChangeNotifier)((Object)this.ltpaKeysChangeNotifierService.getService());
    }
}

