/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.urbridge.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeEntity;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgeGroup;
import com.ibm.ws.security.wim.adapter.urbridge.utils.URBridgePerson;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class URBridgeEntityFactory {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2014";
    private static final TraceComponent tc = Tr.register(URBridgeEntityFactory.class);
    static final long serialVersionUID = -3203282252984569419L;

    public URBridgeEntity createObject(Entity entity, URBridge urBridge, Map<String, String> attrMap, String baseEntryName, Map<String, String> entityConfigMap) throws WIMException {
        String entityType = entity.getTypeName();
        URBridgeEntity obj = null;
        if ("Group".equals(entityType) || Entity.getSubEntityTypes((String)"Group").contains(entityType)) {
            obj = new URBridgeGroup(entity, urBridge, attrMap, baseEntryName, entityConfigMap);
        } else if ("LoginAccount".equals(entityType) || Entity.getSubEntityTypes((String)"LoginAccount").contains(entityType)) {
            obj = new URBridgePerson(entity, urBridge, attrMap, baseEntryName, entityConfigMap);
        } else {
            throw new WIMApplicationException("ENTITY_TYPE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_TYPE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)entityType)));
        }
        return obj;
    }
}

