/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CORBA;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.Request;
import org.apache.yoko.orb.CORBA.RetryInfo;
import org.apache.yoko.orb.CORBA.StubForObject;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.ClientManager;
import org.apache.yoko.orb.OB.CoreTraceLevels;
import org.apache.yoko.orb.OB.DowncallStub;
import org.apache.yoko.orb.OB.FailureException;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OBPortableServer.DirectServant;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory_impl;
import org.apache.yoko.orb.exceptions.Transients;
import org.apache.yoko.orb.logging.VerboseLogging;
import org.apache.yoko.util.Factory;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyListHolder;
import org.omg.CORBA.REBIND;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.PortableServer.Servant;

public final class Delegate
extends org.omg.CORBA_2_4.portable.Delegate {
    private static final Logger logger = Logger.getLogger(Delegate.class.getName());
    private static final Policy[] EMPTY_POLICY_ARRAY = new Policy[0];
    private final ORBInstance orbInstance;
    private IOR ior;
    private IOR origIor;
    private final RefCountPolicyList policyList;
    private DowncallStub downcallStub_;
    private DirectServant directServant;
    private final java.lang.Object directServantMutex = new java.lang.Object(){};
    private boolean checkLocal = true;
    private final ThreadSpecificRetryInfo threadSpecificRetryInfo = new ThreadSpecificRetryInfo();

    private synchronized void checkRetry(int retry, SystemException ex, boolean remote) {
        this.downcallStub_ = null;
        this.ior = this.origIor;
        this.directServant = null;
        this.checkLocal = true;
        CoreTraceLevels coreTraceLevels = this.orbInstance.getCoreTraceLevels();
        try {
            throw ex;
        }
        catch (COMM_FAILURE | NO_RESPONSE | TRANSIENT throwable) {
        }
        catch (SystemException e) {
            logger.log(Level.FINE, "System exception during operation", e);
            throw VerboseLogging.logged(VerboseLogging.RETRY_LOG, e, "Caught a non-retryable exception");
        }
        if (!this.policyList.retry.remote && remote) {
            throw VerboseLogging.logged(VerboseLogging.RETRY_LOG, ex, "Caught a non-local exception");
        }
        if (this.policyList.retry.max != 0 && retry > this.policyList.retry.max) {
            throw VerboseLogging.logged(VerboseLogging.RETRY_LOG, ex, "Exceeded retry limit");
        }
        if (this.policyList.retry.mode == 0) {
            throw VerboseLogging.logged(VerboseLogging.RETRY_LOG, ex, "Honor RETRY_NEVER policy");
        }
        if (this.policyList.retry.mode == 1 && ex.completed != CompletionStatus.COMPLETED_NO) {
            throw VerboseLogging.logged(VerboseLogging.RETRY_LOG, ex, "Honor RETRY_STRICT policy");
        }
        if (this.policyList.retry.interval != 0) {
            VerboseLogging.logged(VerboseLogging.RETRY_LOG, ex, "Delay retry for " + this.policyList.retry.interval + "ms");
            try {
                Thread.sleep(this.policyList.retry.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        VerboseLogging.logged(VerboseLogging.RETRY_LOG, ex, "Allow retry");
    }

    protected void finalize() throws Throwable {
        if (this.directServant != null) {
            this.directServant.destroy();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InterfaceDef get_interface(Object self) {
        ServantObject so;
        while (true) {
            if (!this.is_local(self)) {
                InputStream in = null;
                try {
                    org.omg.CORBA.portable.OutputStream out = this.request(self, "_interface", true);
                    in = this.invoke(self, out);
                    InterfaceDef interfaceDef = InterfaceDefHelper.read((InputStream)in);
                    this.releaseReply(self, in);
                    return interfaceDef;
                }
                catch (ApplicationException ex) {
                    throw Assert.fail(ex);
                    catch (RemarshalException remarshalException) {
                    }
                }
                finally {
                    this.releaseReply(self, in);
                }
                continue;
            }
            so = this.servant_preinvoke(self, "_interface", null);
            if (so != null) break;
        }
        try {
            Servant servant = (Servant)so.servant;
            InterfaceDef interfaceDef = servant._get_interface();
            return interfaceDef;
        }
        finally {
            this.servant_postinvoke(self, so);
        }
    }

    public Object get_interface_def(Object self) {
        return this.get_interface(self);
    }

    public Object duplicate(Object self) {
        return self;
    }

    public void release(Object self) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean is_a(Object self, String repository_id) {
        ServantObject servantObject;
        int n;
        if (repository_id.equals("IDL:omg.org/CORBA/Object:1.0")) {
            return true;
        }
        ObjectImpl o = (ObjectImpl)self;
        for (String id : o._ids()) {
            if (!repository_id.equals(id)) continue;
            return true;
        }
        Delegate delegate = this;
        synchronized (delegate) {
            if (repository_id.equals(this.ior.type_id)) return true;
            if (repository_id.equals(this.origIor.type_id)) {
                return true;
            }
        }
        while (true) {
            if (!this.is_local(self)) {
                InputStream in = null;
                try {
                    org.omg.CORBA.portable.OutputStream outputStream = this.request(self, "_is_a", true);
                    outputStream.write_string(repository_id);
                    in = this.invoke(self, outputStream);
                    n = in.read_boolean() ? 1 : 0;
                    this.releaseReply(self, in);
                    return n != 0;
                }
                catch (ApplicationException ex) {
                    throw Assert.fail(ex);
                    catch (RemarshalException remarshalException) {
                    }
                }
                finally {
                    this.releaseReply(self, in);
                }
                continue;
            }
            servantObject = this.servant_preinvoke(self, "_is_a", null);
            if (servantObject != null) break;
        }
        try {
            Servant servant = (Servant)servantObject.servant;
            n = servant._is_a(repository_id) ? 1 : 0;
            return n != 0;
        }
        finally {
            this.servant_postinvoke(self, servantObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean non_existent(Object self) {
        ServantObject so;
        while (true) {
            if (!this.is_local(self)) {
                InputStream in = null;
                try {
                    org.omg.CORBA.portable.OutputStream out = this.request(self, "_non_existent", true);
                    in = this.invoke(self, out);
                    boolean bl = in.read_boolean();
                    this.releaseReply(self, in);
                    return bl;
                }
                catch (ApplicationException ex) {
                    throw Assert.fail(ex);
                    catch (RemarshalException remarshalException) {
                    }
                }
                finally {
                    this.releaseReply(self, in);
                }
                continue;
            }
            so = this.servant_preinvoke(self, "_non_existent", null);
            if (so != null) break;
        }
        try {
            Servant servant = (Servant)so.servant;
            boolean bl = servant._non_existent();
            return bl;
        }
        finally {
            this.servant_postinvoke(self, so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is_equivalent(Object self, Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (self == rhs) {
            return true;
        }
        if (self instanceof LocalObject || rhs instanceof LocalObject) {
            return false;
        }
        Delegate p = (Delegate)((ObjectImpl)rhs)._get_delegate();
        if (p == this) {
            return true;
        }
        Delegate delegate = this;
        synchronized (delegate) {
            ClientManager clientManager = this.orbInstance.getClientManager();
            return clientManager.equivalent(this.origIor, p._OB_origIOR());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hash(Object self, int maximum) {
        Delegate delegate = this;
        synchronized (delegate) {
            ClientManager clientManager = this.orbInstance.getClientManager();
            return clientManager.hash(this.origIor, maximum);
        }
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result) {
        Request request = new Request(self, operation, arg_list, result);
        request.ctx(ctx);
        return request;
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList excepts, ContextList contexts) {
        Request request = new Request(self, operation, arg_list, result, excepts, contexts);
        request.ctx(ctx);
        return request;
    }

    public org.omg.CORBA.Request request(Object self, String operation) {
        return new Request(self, operation);
    }

    public org.omg.CORBA.portable.OutputStream request(Object self, String operation, boolean responseExpected) {
        RetryInfo info = this.threadSpecificRetryInfo.get();
        while (true) {
            try {
                DowncallStub downcallStub = this._OB_getDowncallStub();
                OutputStream out = downcallStub.setupRequest(self, operation, responseExpected);
                out._OB_delegateContext(info);
                return out;
            }
            catch (Exception ex) {
                this._OB_handleException(ex, info, false);
                continue;
            }
            break;
        }
    }

    public InputStream invoke(Object self, org.omg.CORBA.portable.OutputStream out) throws ApplicationException, RemarshalException {
        OutputStream outImpl = (OutputStream)out;
        RetryInfo info = (RetryInfo)outImpl._OB_delegateContext();
        try {
            DowncallStub downcallStub = this._OB_getDowncallStub();
            return downcallStub.invoke(self, outImpl);
        }
        catch (ApplicationException ex) {
            logger.log(Level.FINE, "Received ApplicationException for request", ex);
            throw ex;
        }
        catch (RemarshalException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Received unexpected exception for request", ex);
            this._OB_handleException(ex, info, false);
            this.threadSpecificRetryInfo.set(info);
            throw (RemarshalException)new RemarshalException().initCause((Throwable)ex);
        }
    }

    public void releaseReply(Object self, InputStream in) {
    }

    public Policy get_policy(Object self, int policy_type) {
        Policy policy = this._OB_getPolicy(policy_type);
        if (policy == null) {
            throw new INV_POLICY(MinorCodes.describeInvPolicy(1095974913), 1095974913, CompletionStatus.COMPLETED_NO);
        }
        return policy;
    }

    public DomainManager[] get_domain_managers(Object self) {
        throw new NO_IMPLEMENT();
    }

    public Object set_policy_override(Object self, Policy[] np, SetOverrideType set_add) {
        Policy[] newPolicies;
        HashSet<Integer> policyTypes = new HashSet<Integer>();
        for (Policy policy : np) {
            if (policyTypes.add(policy.policy_type())) continue;
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446366), 1330446366, CompletionStatus.COMPLETED_NO);
        }
        if (set_add == SetOverrideType.SET_OVERRIDE) {
            newPolicies = Arrays.copyOf(np, np.length);
        } else {
            LinkedHashMap<Integer, Policy> policiesByType = new LinkedHashMap<Integer, Policy>();
            for (Policy p : this.policyList.value) {
                policiesByType.put(p.policy_type(), p);
            }
            for (Policy p : np) {
                policiesByType.put(p.policy_type(), p);
            }
            newPolicies = policiesByType.values().toArray(EMPTY_POLICY_ARRAY);
        }
        Delegate p = new Delegate(this.orbInstance, this.ior, this.origIor, newPolicies);
        StubForObject obj = new StubForObject();
        obj._set_delegate((org.omg.CORBA.portable.Delegate)p);
        return obj;
    }

    public ORB orb(Object self) {
        return this.orbInstance.getORB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is_local(Object self) {
        if (this.checkLocal) {
            java.lang.Object object = this.directServantMutex;
            synchronized (object) {
                if (this.directServant != null && !this.directServant.deactivated()) {
                    return true;
                }
                POAManagerFactory pmFactory = this.orbInstance.getPOAManagerFactory();
                POAManagerFactory_impl factory = (POAManagerFactory_impl)pmFactory;
                while (true) {
                    try {
                        this.directServant = factory._OB_getDirectServant(this.ior, this.policyList);
                        break;
                    }
                    catch (LocationForward ex) {
                        Delegate delegate = this;
                        synchronized (delegate) {
                            this.ior = ex.ior;
                            if (ex.perm) {
                                this.origIor = ex.ior;
                            }
                            this.downcallStub_ = null;
                        }
                    }
                }
                if (this.directServant != null && this.directServant.servant.getClass().getClassLoader() == self.getClass().getClassLoader()) {
                    this.threadSpecificRetryInfo.remove();
                    if (!this.directServant.locate_request()) {
                        throw new OBJECT_NOT_EXIST();
                    }
                    return true;
                }
                this.checkLocal = false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        DirectServant ds;
        java.lang.Object object = this.directServantMutex;
        synchronized (object) {
            if (this.directServant == null) {
                return null;
            }
            if (this.directServant.deactivated()) {
                this.directServant = null;
                return null;
            }
            ds = this.directServant;
        }
        ServantObject result = ds.preinvoke(operation);
        if (expectedType == null) {
            return result;
        }
        if (result == null) {
            return null;
        }
        if (expectedType.isInstance(result.servant)) {
            return result;
        }
        throw new BAD_PARAM("Servant class " + result.servant.getClass().getName() + " does not match expected type " + expectedType.getName());
    }

    public void servant_postinvoke(Object self, ServantObject servant) {
        DirectServant directServant = (DirectServant)servant;
        directServant.postinvoke();
    }

    public String get_codebase(Object self) {
        return null;
    }

    public Policy[] get_policy_overrides(Object self, int[] types) {
        Policy[] policies = this.policyList.value;
        if (types.length == 0) {
            return Arrays.copyOf(policies, policies.length);
        }
        ArrayList<Policy> list = new ArrayList<Policy>();
        block0: for (Policy policy : policies) {
            for (int type : types) {
                if (policy.policy_type() != type) continue;
                list.add(policy);
                continue block0;
            }
        }
        return list.toArray(EMPTY_POLICY_ARRAY);
    }

    public Policy get_client_policy(Object self, int type) {
        return this.get_policy(self, type);
    }

    public boolean validate_connection(Object self, PolicyListHolder policies) {
        RetryInfo info = new RetryInfo();
        while (true) {
            try {
                DowncallStub downcallStub = this._OB_getDowncallStub();
                return downcallStub.locate_request();
            }
            catch (Exception ex) {
                this._OB_handleException(ex, info, true);
                continue;
            }
            break;
        }
    }

    public Delegate(ORBInstance orbInstance, IOR ior, IOR origIor, Policy ... policies) {
        this.orbInstance = orbInstance;
        this.ior = ior;
        this.origIor = origIor;
        this.policyList = new RefCountPolicyList(policies);
    }

    public ORBInstance _OB_ORBInstance() {
        return this.orbInstance;
    }

    public synchronized IOR _OB_IOR() {
        return this.ior;
    }

    public synchronized IOR _OB_origIOR() {
        return this.origIor;
    }

    public synchronized void _OB_marshalOrigIOR(org.omg.CORBA.portable.OutputStream out) {
        IORHelper.write((org.omg.CORBA.portable.OutputStream)out, (IOR)this.origIor);
    }

    private Policy _OB_getPolicy(int policy_type) {
        for (Policy policy : this.policyList.value) {
            if (policy.policy_type() != policy_type) continue;
            return policy;
        }
        return null;
    }

    void _OB_handleException(Exception ex, RetryInfo info, boolean ignoreRebind) {
        try {
            throw ex;
        }
        catch (LocationForward e) {
            this.handleLocationForward(e, info, ignoreRebind);
        }
        catch (FailureException e) {
            this.handleFailure(e, info);
        }
        catch (TRANSIENT e) {
            this.handleTRANSIENT(e, info);
        }
        catch (SystemException e) {
            logger.log(Level.FINE, "Received SystemException", e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.log(Level.FINE, "Received RuntimeException", e);
            throw e;
        }
        catch (Exception shouldNeverHappen) {
            throw Assert.fail(shouldNeverHappen);
        }
    }

    private void handleTRANSIENT(TRANSIENT e, RetryInfo info) {
        info.incrementRetryCount();
        this.checkRetry(info.getRetry(), (SystemException)((java.lang.Object)e), false);
    }

    private void handleFailure(FailureException e, RetryInfo info) {
        if (e.incrementRetry) {
            info.incrementRetryCount();
        }
        this.checkRetry(info.getRetry(), e.exception, false);
    }

    private synchronized void handleLocationForward(LocationForward e, RetryInfo info, boolean ignoreRebind) {
        if (this.policyList.rebindMode == 2 && !ignoreRebind) {
            throw VerboseLogging.wrapped(VerboseLogging.RETRY_LOG, e, "Honouring NO_RECONNECT policy", new Factory<REBIND>(){

                public REBIND create() {
                    return new REBIND();
                }
            });
        }
        info.incrementHopCount();
        if (info.getHop() > 10) {
            throw VerboseLogging.wrapped(VerboseLogging.RETRY_LOG, e, "Exceeded location forward hop count", Transients.LOCATION_FORWARD_TOO_MANY_HOPS);
        }
        this.ior = e.ior;
        if (e.perm) {
            this.origIor = e.ior;
        }
        this.downcallStub_ = null;
        this.checkLocal = true;
        VerboseLogging.logged(VerboseLogging.RETRY_LOG, e, "Retrying");
    }

    public synchronized DowncallStub _OB_getDowncallStub() throws LocationForward, FailureException {
        if (this.downcallStub_ == null) {
            this.downcallStub_ = new DowncallStub(this.orbInstance, this.ior, this.origIor, this.policyList);
            if (!this.downcallStub_.locate_request()) {
                throw new OBJECT_NOT_EXIST();
            }
        }
        return this.downcallStub_;
    }

    private static class ThreadSpecificRetryInfo
    extends ThreadLocal<RetryInfo> {
        private ThreadSpecificRetryInfo() {
        }

        @Override
        protected RetryInfo initialValue() {
            return new RetryInfo();
        }

        @Override
        public RetryInfo get() {
            try {
                RetryInfo retryInfo = (RetryInfo)super.get();
                return retryInfo;
            }
            finally {
                this.remove();
            }
        }
    }
}

