/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.NotificationManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}/serverRegistrations"})
public class NotificationServerRegistrationsHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(NotificationServerRegistrationsHandler.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    static final long serialVersionUID = 7175982186624078902L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (RESTHelper.isPostMethod(method)) {
            this.serverNotificationRegistration(request, response);
        } else if (RESTHelper.isDeleteMethod(method)) {
            this.removeServerNotifications(request, response);
        } else {
            throw new RESTHandlerMethodNotAllowedError("POST,DELETE");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeServerNotifications(RESTRequest request, RESTResponse response) {
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationServerRegistrationsHandler", (String)"74", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        NotificationManager.getNotificationManager().removeAllServerRegistrations(request, clientID);
        response.setStatus(204);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConversionException.class, IOException.class, ClassNotFoundException.class})
    private void serverNotificationRegistration(RESTRequest request, RESTResponse response) {
        RESTHelper.ensureConsumesJson(request);
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationServerRegistrationsHandler", (String)"92", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        ServerNotificationRegistration serverNotificationRegistration = null;
        InputStream is = RESTHelper.getInputStream(request);
        try {
            serverNotificationRegistration = converter.readServerNotificationRegistration(is);
        }
        catch (ConversionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (IOException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ClassNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        if (serverNotificationRegistration.operation != null) {
            NotificationManager.getNotificationManager().handleServerNotificationRegistration(request, clientID, serverNotificationRegistration, converter);
            response.setStatus(204);
            return;
        }
        String returningURL = NotificationManager.getNotificationManager().addServerNotificationHTTP(request, clientID, serverNotificationRegistration, converter);
        OutputHelper.writeStringStreamingOutput(response, returningURL, converter);
    }
}

