/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.model.converter;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.jaxb.model.converter.JAXBModelConverter;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationContext;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class BooleanDV
extends TypeValidator {
    private static final int[] trueChars = new int[]{114, 117, 101};
    private static final int[] falseChars = new int[]{97, 108, 115, 101};
    public static final BooleanDV INSTANCE = new BooleanDV();

    private BooleanDV() {
        super(null, null, null, 3, 3, null, 0, false);
    }

    public BooleanDV(String string) {
        super(null, null, string, 3, 3, null, 0, false);
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        Boolean bl;
        Boolean bl2 = bl = xMLString.bytes != null ? BooleanDV.parseBooleanUnbuffered(xMLString) : BooleanDV.parseBooleanBuffered(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = bl;
            validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        }
        return bl;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        Boolean bl;
        validatedInfo2.typeValidator = this;
        Boolean bl2 = bl = xMLString.bytes != null ? BooleanDV.parseBooleanUnbuffered(xMLString) : BooleanDV.parseBooleanBuffered(xMLString);
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = bl.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        validatedInfo2.actualValue = bl;
        validatedInfo2.errorCode = validatedInfo2.actualValue != null ? 0 : 1;
    }

    private static Boolean parseBooleanUnbuffered(XMLString xMLString) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) >= n2) {
            return null;
        }
        if (xMLString.bytes[n] == 116) {
            if (++n < n2 && xMLString.bytes[n++] == 114 && n < n2 && xMLString.bytes[n++] == 117 && n < n2 && xMLString.bytes[n] == 101) {
                ++n;
                if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                    return null;
                }
                return Boolean.TRUE;
            }
            return null;
        }
        if (xMLString.bytes[n] == 102) {
            if (++n < n2 && xMLString.bytes[n++] == 97 && n < n2 && xMLString.bytes[n++] == 108 && n < n2 && xMLString.bytes[n++] == 115 && n < n2 && xMLString.bytes[n] == 101) {
                ++n;
                if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                    return null;
                }
                return Boolean.FALSE;
            }
            return null;
        }
        if (xMLString.bytes[n] == 49) {
            ++n;
            if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                return null;
            }
            return Boolean.TRUE;
        }
        if (xMLString.bytes[n] == 48) {
            ++n;
            if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
                return null;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private static Boolean parseBooleanBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        int n3 = 0;
        if (by == 116) {
            while (true) {
                if (++n < n2) {
                    if (n3 == 3 || trueChars[n3++] != (by = dataBuffer.bytes[n])) break;
                    continue;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (n3 != 3) {
                return null;
            }
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                        by = dataBuffer.bytes[n];
                        continue;
                    }
                    if (n != n2 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = dataBuffer.bytes[n];
                }
            }
            if (n < n2) {
                return null;
            }
            return Boolean.TRUE;
        }
        if (by == 102) {
            while (true) {
                if (++n < n2) {
                    if (n3 == 4 || falseChars[n3++] != (by = dataBuffer.bytes[n])) break;
                    continue;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (n3 != 4) {
                return null;
            }
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                        by = dataBuffer.bytes[n];
                        continue;
                    }
                    if (n != n2 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = dataBuffer.bytes[n];
                }
            }
            if (n < n2) {
                return null;
            }
            return Boolean.FALSE;
        }
        if (by == 49) {
            while (true) {
                if (++n < n2) break;
                if (dataBuffer == dataBuffer2) {
                    return Boolean.TRUE;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by = dataBuffer.bytes[n];
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                        by = dataBuffer.bytes[n];
                        continue;
                    }
                    if (n != n2 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = dataBuffer.bytes[n];
                }
            }
            if (n < n2) {
                return null;
            }
            return Boolean.TRUE;
        }
        if (by == 48) {
            while (true) {
                if (++n < n2) break;
                if (dataBuffer == dataBuffer2) {
                    return Boolean.FALSE;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset - 1;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            by = dataBuffer.bytes[n];
            if (by <= 32) {
                while (true) {
                    if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                        by = dataBuffer.bytes[n];
                        continue;
                    }
                    if (n != n2 || dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    by = dataBuffer.bytes[n];
                }
            }
            if (n < n2) {
                return null;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean scanContent(ParsedEntity parsedEntity, XMLString xMLString, VMContext vMContext) {
        DeserializationContext deserializationContext = (DeserializationContext)vMContext.dvContext;
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        boolean[] blArray = deserializationContext.getNormalizedArray();
        blArray[0] = true;
        if (n + 1 < n2 && byArray[n] == 60 && byArray[n + 1] == 47) {
            xMLString.setValues(parsedEntity.buffer, n, n);
            vMContext.setContentScanner(null);
            return true;
        }
        DeserializationContext.XBoolean xBoolean = deserializationContext.getXBoolean();
        n = BooleanDV.parseBooleanUnbuffered(parsedEntity, xBoolean, blArray);
        if (n == -1 || byArray[n] != 60 || n + 2 >= n2 || byArray[n + 1] != 47) {
            vMContext.setContentScanner(null);
            return vMContext.scanContent();
        }
        parsedEntity.offset = n;
        deserializationContext.elementContentDeserialized = true;
        vMContext.isValidated = true;
        vMContext.setEntityContent(parsedEntity);
        vMContext.setContentScanner(null);
        deserializationContext.currentStub.write(deserializationContext.currentPropertyId, xBoolean.value);
        return true;
    }

    private static int parseBooleanUnbuffered(ParsedEntity parsedEntity, DeserializationContext.XBoolean xBoolean, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        if ((n = JAXBModelConverter.ScanUtil.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        if (byArray[n] == 116) {
            if (n + 3 < n2 && byArray[++n] == 114 && byArray[++n] == 117 && byArray[++n] == 101) {
                ++n;
                if ((n = JAXBModelConverter.ScanUtil.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                    return -1;
                }
                xBoolean.value = true;
                return n;
            }
            return -1;
        }
        if (byArray[n] == 102) {
            if (n + 4 < n2 && byArray[++n] == 97 && byArray[++n] == 108 && byArray[++n] == 115 && byArray[++n] == 101) {
                ++n;
                if ((n = JAXBModelConverter.ScanUtil.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                    return -1;
                }
                xBoolean.value = false;
                return n;
            }
            return -1;
        }
        if (byArray[n] == 49) {
            ++n;
            if ((n = JAXBModelConverter.ScanUtil.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xBoolean.value = true;
            return n;
        }
        if (byArray[n] == 48) {
            ++n;
            if ((n = JAXBModelConverter.ScanUtil.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
                return -1;
            }
            xBoolean.value = false;
            return n;
        }
        return -1;
    }
}

