/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.XDateTime;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class AbstractDateTimeDV
extends TypeValidator {
    protected final XDateTime[] enumeration;
    protected final XDateTime maxInclusive;
    protected final XDateTime maxExclusive;
    protected final XDateTime minInclusive;
    protected final XDateTime minExclusive;
    private final int position;

    public AbstractDateTimeDV(String string, String string2, String string3, String[] stringArray, XDateTime[] xDateTimeArray, XDateTime xDateTime, XDateTime xDateTime2, XDateTime xDateTime3, XDateTime xDateTime4, int n, int n2) {
        super(string, string2, string3, n, n, stringArray, n2, false);
        switch (n) {
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                this.position = 0;
                break;
            }
            case 13: 
            case 15: {
                this.position = 1;
                break;
            }
            case 14: {
                this.position = 2;
                break;
            }
            default: {
                this.position = 3;
            }
        }
        this.enumeration = xDateTimeArray;
        this.maxInclusive = xDateTime3;
        this.maxExclusive = xDateTime4;
        this.minInclusive = xDateTime;
        this.minExclusive = xDateTime2;
    }

    public int preCheckFacets(XDateTime xDateTime, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xDateTime, xMLString);
        }
        return 0;
    }

    public int checkFacets(XDateTime xDateTime, XMLString xMLString) {
        short s;
        if ((this.definedFacets & 0x100) != 0 ? (s = xDateTime.compareDates(this.minInclusive, true)) != 0 && s != 1 : (this.definedFacets & 0x80) != 0 && (s = xDateTime.compareDates(this.minExclusive, true)) != 1) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 ? (s = xDateTime.compareDates(this.maxInclusive, true)) != 0 && s != -1 : (this.definedFacets & 0x40) != 0 && (s = xDateTime.compareDates(this.maxExclusive, true)) != -1) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!xDateTime.equals(this.enumeration[i])) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static int parseUYear(byte[] byArray, XDateTime xDateTime, int n, int n2) {
        if (n < n2) {
            byte by = byArray[n];
            int n3 = 1;
            if (by == 45) {
                n3 = -1;
                if (++n < n2) {
                    by = byArray[n];
                }
            }
            if (by >= 48 && by <= 57) {
                int n4;
                for (n4 = 0; by == 48 && ++n < n2 && n4 < 4; ++n4) {
                    by = byArray[n];
                }
                if (n4 >= 4 || n == n2) {
                    return -1;
                }
                int n5 = by - 48;
                int n6 = 1;
                while (++n < n2 && (by = byArray[n]) >= 48 && by <= 57) {
                    ++n6;
                    n5 = n5 * 10 + by - 48;
                }
                if (n >= n2 || n4 + n6 < 4 || n5 == 0 || n4 + n6 > 4 && n4 > 0) {
                    return -1;
                }
                xDateTime.year = n3 * n5;
                return n;
            }
        }
        return -1;
    }

    public static int parseUMonth(byte[] byArray, XDateTime xDateTime, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2) {
                xDateTime.month = n3 * 10 + by - 48;
                return n;
            }
        }
        return -1;
    }

    public static int parseUDay(byte[] byArray, XDateTime xDateTime, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2) {
                xDateTime.day = n3 * 10 + by - 48;
                return n;
            }
        }
        return -1;
    }

    public static int parseUHour(byte[] byArray, XDateTime xDateTime, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2) {
                xDateTime.hour = n3 * 10 + by - 48;
                return n;
            }
        }
        return -1;
    }

    public static int parseUMinute(byte[] byArray, XDateTime xDateTime, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            int n3 = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2) {
                xDateTime.minute = n3 * 10 + by - 48;
                return n;
            }
        }
        return -1;
    }

    public static int parseUSeconds(byte[] byArray, XDateTime xDateTime, int n, int n2) {
        byte by;
        if (n < n2 && (by = byArray[n]) >= 48 && by <= 57 && ++n < n2) {
            double d = by - 48;
            by = byArray[n];
            if (by >= 48 && by <= 57 && ++n < n2) {
                d = d * 10.0 + (double)by - 48.0;
                if (byArray[n] == 46) {
                    if (++n < n2 && (by = byArray[n]) >= 48 && by <= 57) {
                        d += (double)(by - 48) / 10.0;
                        double d2 = 10.0;
                        while (++n < n2) {
                            by = byArray[n];
                            if (by < 48 || by > 57) {
                                xDateTime.second = d;
                                return n;
                            }
                            d += (double)(by - 48) / (d2 *= 10.0);
                        }
                    }
                    return -1;
                }
                xDateTime.second = d;
                return n;
            }
        }
        return -1;
    }

    public static int parseUTimeZone(byte[] byArray, XDateTime xDateTime, int n, int n2) {
        if (n < n2) {
            int n3 = byArray[n];
            if (n3 == 43 || n3 == 45) {
                xDateTime.utc = n3;
                int n4 = 1;
                if (n3 == 45) {
                    n4 = -1;
                }
                int n5 = 0;
                int n6 = 0;
                while (++n < n2) {
                    if (n6 > 2) {
                        return -1;
                    }
                    n3 = byArray[n];
                    if (n3 >= 48 && n3 <= 57) {
                        n5 *= 10;
                        n5 += n3 - 48;
                    } else {
                        if (n3 == 58) break;
                        return -1;
                    }
                    ++n6;
                }
                if (n6 != 2 || n >= n2) {
                    return -1;
                }
                xDateTime.timezoneHr = n4 * n5;
                n5 = 0;
                n6 = 0;
                while (++n < n2) {
                    if (n6 > 2) {
                        return -1;
                    }
                    n3 = byArray[n];
                    if (n3 < 48 || n3 > 57) break;
                    n5 *= 10;
                    n5 += n3 - 48;
                    ++n6;
                }
                if (n6 != 2 || n >= n2) {
                    return -1;
                }
                xDateTime.timezoneMin = n4 * n5;
                return n;
            }
            if (n3 == 90) {
                if (++n >= n2) {
                    return -1;
                }
                xDateTime.utc = 90;
                return n;
            }
        }
        return -1;
    }

    public static boolean validateDateTime(XDateTime xDateTime) {
        if (xDateTime.month < 1 || xDateTime.month > 12 || xDateTime.day > xDateTime.maxDayInMonthFor() || xDateTime.day < 1) {
            return false;
        }
        if (xDateTime.hour > 23 || xDateTime.hour < 0) {
            if (xDateTime.hour == 24 && xDateTime.minute == 0 && xDateTime.second == 0.0) {
                xDateTime.hour = 0;
                if (++xDateTime.day > xDateTime.maxDayInMonthFor()) {
                    xDateTime.day = 1;
                    if (++xDateTime.month > 12) {
                        xDateTime.month = 1;
                        if (++xDateTime.year == 0) {
                            xDateTime.year = 1;
                        }
                    }
                }
            } else {
                return false;
            }
        }
        if (xDateTime.minute > 59 || xDateTime.minute < 0 || xDateTime.second > 60.0 || xDateTime.second < 0.0 || xDateTime.timezoneHr > 14 || xDateTime.timezoneHr < -14) {
            return false;
        }
        if ((xDateTime.timezoneHr == 14 || xDateTime.timezoneHr == -14) && xDateTime.timezoneMin != 0) {
            return false;
        }
        return xDateTime.timezoneMin <= 59 && xDateTime.timezoneMin >= -59;
    }

    protected abstract int parseDateTimeUnbuffered(ParsedEntity var1, XDateTime var2, boolean[] var3);

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XDateTime xDateTime = vMContext.dvContext.getXDateTime(this.builtInKind, this.position);
        int n = this.parseDateTimeUnbuffered(parsedEntity, xDateTime, this.fNormalized);
        if (n == -1) {
            return null;
        }
        parsedEntity.offset = n;
        return xDateTime;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets((XDateTime)object, xMLString);
    }
}

