/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.InputStream;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class RewindableInputStream
extends InputStream {
    private static final int INITIAL_BYTE_COUNT = 4096;
    private InputStream fInputStream;
    private byte[] fData = ArrayAllocator.newByteArray(4096);
    private int fStartOffset;
    private int fOffset;
    private int fLength;
    private int fMark;

    public void setStream(InputStream inputStream, byte[] byArray, int n) {
        this.fInputStream = inputStream;
        if (this.fData.length < n) {
            int n2;
            for (n2 = this.fData.length << 1; n2 < n; n2 <<= 1) {
            }
            this.fData = ArrayAllocator.replaceByteArray(this.fData, n2);
        }
        System.arraycopy(byArray, 0, this.fData, 0, n);
        this.fStartOffset = 0;
        this.fOffset = 0;
        this.fLength = n;
        this.fMark = 0;
    }

    public void setStartOffset(int n) {
        this.fStartOffset = n;
    }

    public void rewind() {
        this.fOffset = this.fStartOffset;
    }

    public int read() throws IOException {
        if (this.fOffset < this.fLength) {
            return this.fData[this.fOffset++] & 0xFF;
        }
        if (this.fInputStream == null) {
            return -1;
        }
        return this.fInputStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = this.fLength - this.fOffset;
        if (n4 == 0) {
            if (this.fInputStream != null) {
                int n5 = this.fInputStream.read(byArray, n, n2);
                if (n5 != -1) {
                    return n5;
                }
                this.fInputStream.close();
                this.fInputStream = null;
                return -1;
            }
            return -1;
        }
        if (n2 < n4) {
            if (n2 <= 0) {
                return 0;
            }
            n3 = n2;
        } else {
            n3 = n4;
        }
        if (byArray != null) {
            System.arraycopy(this.fData, this.fOffset, byArray, n, n3);
        }
        this.fOffset += n3;
        if (n3 == n2 || this.fInputStream == null || this.fInputStream.available() == 0) {
            return n3;
        }
        int n6 = this.fInputStream.read(byArray, n += n3, n2 -= n3);
        if (n6 == -1) {
            this.fInputStream.close();
            this.fInputStream = null;
            return n3;
        }
        return n3 + n6;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.fLength - this.fOffset;
        if (n == 0) {
            if (this.fInputStream == null) {
                return 0L;
            }
            return this.fInputStream.skip(l);
        }
        if (l <= (long)n) {
            this.fOffset = (int)((long)this.fOffset + l);
            return l;
        }
        this.fOffset += n;
        if (this.fInputStream == null) {
            return n;
        }
        return this.fInputStream.skip(l -= (long)n) + (long)n;
    }

    public int available() throws IOException {
        int n = this.fLength - this.fOffset;
        if (n == 0) {
            if (this.fInputStream == null) {
                return -1;
            }
            return this.fInputStream.available();
        }
        if (this.fInputStream == null) {
            return n;
        }
        return this.fInputStream.available() + n;
    }

    public void mark(int n) {
        this.fMark = this.fOffset;
    }

    public void reset() {
        this.fOffset = this.fMark;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.fInputStream != null) {
            this.fInputStream.close();
            this.fInputStream = null;
        }
    }
}

