/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.FastSyncHashBucket;
import com.ibm.ws.bytebuffer.internal.FastSyncHashEntry;
import java.util.ArrayList;

public class FastSynchHashTable {
    protected int xVar = 1000;
    private static final int yVar = 3;
    protected FastSyncHashBucket[][] mainTable;
    private static final TraceComponent tc = Tr.register(FastSynchHashTable.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");

    public FastSynchHashTable(int buckets) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Created FastSyncHashTable(int): " + buckets), (Object[])new Object[0]);
        }
        this.xVar = buckets / 3 + 1;
        this.initBuckets();
    }

    public FastSynchHashTable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Created FastSyncHashTable()", (Object[])new Object[0]);
        }
        this.initBuckets();
    }

    private void initBuckets() {
        this.mainTable = new FastSyncHashBucket[this.xVar][3];
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mainTable[i][j] = new FastSyncHashBucket();
            }
        }
    }

    public Object get(int key) {
        return this.syncGetValueFromBucket(this.getBucket(key), key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncGetValueFromBucket(FastSyncHashBucket hb, int key, boolean remove) {
        FastSyncHashEntry e = null;
        FastSyncHashEntry last = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("syncGetValueFromBucket: key, remove " + key + " " + remove), (Object[])new Object[0]);
        }
        FastSyncHashBucket fastSyncHashBucket = hb;
        synchronized (fastSyncHashBucket) {
            e = hb.root;
            while (e != null) {
                if (e.key == key) {
                    if (remove) {
                        if (last == null) {
                            hb.root = e.next;
                        } else {
                            last.next = e.next;
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"syncGetValueFromBucket: found value in bucket");
                    }
                    return e.value;
                }
                last = e;
                e = e.next;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"syncGetValueFromBucket-returned null");
        }
        return null;
    }

    public Object put(int key, Object value) {
        FastSyncHashBucket bucket;
        Object retVal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put", (Object[])new Object[0]);
        }
        if (value == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value == null", (Object[])new Object[0]);
            }
            throw new NullPointerException("Missing value");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("key " + key), (Object[])new Object[0]);
        }
        if ((retVal = this.syncGetValueFromBucket(bucket = this.getBucket(key), key, false)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"put: key is already defined in bucket...returning value from bucket and new key value will be discarded.");
            }
            return retVal;
        }
        FastSyncHashEntry e = new FastSyncHashEntry(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put: put new key and value into bucket");
        }
        return this.syncPutIntoBucket(bucket, e);
    }

    public Object forcePut(int key, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forcePut(int,Object):", (Object[])new Object[0]);
        }
        if (value == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value is null", (Object[])new Object[0]);
            }
            throw new NullPointerException("Missing value");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("key: " + key), (Object[])new Object[0]);
        }
        FastSyncHashBucket bucket = this.getBucket(key);
        this.syncGetValueFromBucket(bucket, key, true);
        FastSyncHashEntry e = new FastSyncHashEntry(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forcePut:  put new hash and key in bucket");
        }
        return this.syncPutIntoBucket(bucket, e);
    }

    private FastSyncHashBucket getBucket(int hc) {
        return this.mainTable[(hc & Integer.MAX_VALUE) % this.xVar][(hc & Integer.MAX_VALUE) % 3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncPutIntoBucket(FastSyncHashBucket hb, FastSyncHashEntry newEntry) {
        FastSyncHashEntry e = null;
        FastSyncHashEntry last = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"syncPutIntoBucket", (Object[])new Object[0]);
        }
        FastSyncHashBucket fastSyncHashBucket = hb;
        synchronized (fastSyncHashBucket) {
            e = hb.root;
            while (e != null) {
                if (e.key == newEntry.key) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"syncPutIntoBucket: key/hash pair is already in the bucket");
                    }
                    return e.value;
                }
                last = e;
                e = e.next;
            }
            if (last == null) {
                if (hb.root == null) {
                    hb.root = newEntry;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"syncPutIntoBucket: Adding new entry at the beginning (root)");
                    }
                    return newEntry.value;
                }
                last = hb.root;
                while (last.next != null) {
                    last = last.next;
                }
            }
            last.next = newEntry;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"syncPutIntoBucket: Adding new entry at the end");
            }
            return newEntry.value;
        }
    }

    public Object remove(int key) {
        return this.syncGetValueFromBucket(this.getBucket(key), key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllEntryValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        FastSyncHashBucket hb = null;
        FastSyncHashEntry e = null;
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                FastSyncHashBucket fastSyncHashBucket = hb = this.mainTable[i][j];
                synchronized (fastSyncHashBucket) {
                    e = hb.root;
                    while (e != null) {
                        values.add(e.value);
                        e = e.next;
                    }
                    continue;
                }
            }
        }
        return values.toArray();
    }
}

