/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

public class GenKeyTask
extends BaseCommandTask {
    private static final String className = GenKeyTask.class.getName();
    private final ICollectiveRegistrationMBeanConnection registrationMBean;

    public GenKeyTask(String scriptName, IFileUtility fileUtility, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(scriptName, fileUtility);
        this.registrationMBean = registrationMBean;
        this.reqArgs.add("--keystorePassword");
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.confirmedArgs.add("--keystorePassword");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.knownArgs.add("--certificateSubject");
        this.knownArgs.add("--certificateValidity");
        this.knownArgs.add("--encoding");
        this.knownArgs.add("--key");
        this.knownArgs.add("--keystoreFile");
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "genKey";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("genKey.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("genKey.required-option-key.keystorePassword", "genKey.required-option-desc.keystorePassword") + this.buildScriptOptions("genKey.option-key.", "genKey.option-desc.") + this.buildScriptOptions("encoding.option-key.", "encoding.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept");
        return this.getTaskHelp("genKey.desc", "genKey.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("genKey.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("genKey.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("genKey.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File keyFile) throws TaskErrorException {
        this.stdout.println(this.getMessage("genKey.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(keyFile)) {
            this.stdout.println(this.getMessage("genKey.cleanupFail", keyFile));
        }
        throw new TaskErrorException(message);
    }

    private void abortAndPerformCleanup(String message, File keyFile, String methodName) throws TaskErrorException {
        Trlog.exit(className, methodName, message);
        this.stdout.println(this.getMessage("genKey.abort", new Object[0]));
        if (!this.fileUtility.recurisveDelete(keyFile)) {
            this.stdout.println(this.getMessage("genKey.cleanupFail", keyFile));
        }
        throw new TaskErrorException(message);
    }

    private Map<String, byte[]> genKey(String controllerHost, int controllerPort, String user, String password, String keystorePassword, Map<String, Object> certProps) throws TaskErrorException {
        String methodName = "getKey";
        Trlog.enter(keystorePassword, methodName, new Object[]{controllerHost, controllerPort, user, password.replaceAll(".", "*"), keystorePassword.replaceAll(".", "*")});
        try {
            Map<String, byte[]> ret = this.registrationMBean.genKey(controllerHost, controllerPort, user, password, keystorePassword, certProps, Boolean.FALSE);
            this.stdout.println(this.getMessage("genKey.mbeanComplete", new Object[0]));
            Trlog.debug(className, methodName, "Successfully completed MBean request to the controller.");
            return ret;
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Caught RuntimeMBeanException: ");
            if (e.getCause() instanceof IllegalArgumentException) {
                this.abort(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), methodName);
            } else {
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), methodName);
            }
        }
        catch (UnknownHostException e) {
            this.abort(this.getMessage("common.hostError", controllerHost), methodName);
        }
        catch (ConnectException e) {
            this.abort(this.getMessage("common.portError", String.valueOf(controllerPort)), methodName);
        }
        catch (IOException e) {
            this.abort(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), methodName);
        }
        catch (Exception e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), methodName);
        }
        return null;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        File oldKSFile;
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, true);
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        Trlog.debug(className, methodName, "Connection info: ", new Object[]{controllerHost, controllerPort, user});
        this.handleAutoAcceptArgument(args);
        String keystorePassword = this.getArgumentValue("--keystorePassword", args, null);
        String defaultCertificateSubject = "CN=localhost,OU=client,O=ibm,C=us";
        String certificateSubject = this.getArgumentValue("--certificateSubject", args, defaultCertificateSubject);
        Integer certificateValidity = Integer.valueOf(this.getArgumentValue("--certificateValidity", args, String.valueOf(1825)));
        if (certificateValidity < 365) {
            this.abort(this.getMessage("common.validityTooShort", "--certificateValidity"), methodName);
        }
        try {
            new LdapName(certificateSubject);
        }
        catch (InvalidNameException e) {
            this.abort(this.getMessage("common.invalidDN", "--certificateSubject", certificateSubject), methodName);
        }
        String encoding = this.getArgumentValue("--encoding", args, "xor");
        String key = this.getArgumentValue("--key", args, null);
        this.validateEncoding(encoding, key);
        String encodedKeystorePassword = this.encodePassword(keystorePassword, "--keystorePassword", encoding, key);
        if (encodedKeystorePassword == null) {
            this.abort("Encoded kyestore password is null", methodName);
        }
        HashMap<String, Object> certProps = new HashMap<String, Object>();
        certProps.put("certificateSubject", certificateSubject);
        certProps.put("certificateValidity", certificateValidity);
        certProps.put("18004member", "true");
        String defaultKeyStoreName = "key.p12";
        String keyStoreName = this.getArgumentValue("--keystoreFile", args, defaultKeyStoreName);
        File kSFile = new File(keyStoreName);
        File tmpKSFile = new File(keyStoreName + ".tmp");
        if (kSFile.exists()) {
            Trlog.debug(className, methodName, "Default HTTPS keystore file exists at " + kSFile.getAbsolutePath());
            stdout.println(this.getMessage("common.regenerateKey", kSFile.getAbsolutePath()));
        }
        Trlog.debug(className, methodName, "Generating keystore with target controller " + controllerHost + ":" + String.valueOf(controllerPort));
        stdout.println(this.getMessage("genKey.start", controllerHost, String.valueOf(controllerPort)));
        Map<String, byte[]> genKeyResult = this.genKey(controllerHost, controllerPort, user, password, keystorePassword, certProps);
        if (genKeyResult.get("18004controller") != null) {
            if (!this.fileUtility.writeBytesToFile(stderr, genKeyResult.get("key.p12"), tmpKSFile)) {
                this.abortAndPerformCleanup(this.getMessage("genKey.writeKeystoreFail", tmpKSFile.getAbsolutePath(), methodName), tmpKSFile);
            }
        } else if (!this.fileUtility.writeBytesToFile(stderr, genKeyResult.get("key.jks"), tmpKSFile)) {
            this.abortAndPerformCleanup(this.getMessage("genKey.writeKeystoreFail", tmpKSFile.getAbsolutePath(), methodName), tmpKSFile);
        }
        if (this.fileUtility.exists(kSFile) && !this.fileUtility.renameFile(kSFile, oldKSFile = this.findAvailableBackupFile(kSFile))) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", kSFile.getAbsolutePath(), oldKSFile.getAbsolutePath()), tmpKSFile, methodName);
        }
        if (!this.fileUtility.renameFile(tmpKSFile, kSFile)) {
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", tmpKSFile.getAbsolutePath(), kSFile.getAbsolutePath()), tmpKSFile, methodName);
        }
        stdout.println();
        stdout.println(this.getMessage("genKey.generatedKeystore", keyStoreName));
        Trlog.exit(className, methodName, "Successfully generated keystore " + keyStoreName);
    }
}

