/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.classloading;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.ArrayList;
import java.util.EnumSet;

@Trivial
public enum ApiType {
    SPEC("spec"),
    IBMAPI("ibm-api"),
    API("api"),
    THIRDPARTY("third-party"),
    STABLE("stable");

    private static final TraceComponent tc;
    private final String attributeName;
    private static final EnumSet<ApiType> DEFAULT_API_TYPES;

    private ApiType(String attributeName) {
        this.attributeName = attributeName;
    }

    public static ApiType fromString(String value) {
        if (value != null) {
            value = value.trim();
            for (ApiType t : ApiType.values()) {
                if (!t.attributeName.equals(value)) continue;
                return t;
            }
        } else {
            return API;
        }
        return null;
    }

    public static EnumSet<ApiType> createApiTypeSet(String ... apiTypes) {
        EnumSet<ApiType> set = EnumSet.noneOf(ApiType.class);
        EnumSet<ApiType> removeSet = EnumSet.noneOf(ApiType.class);
        EnumSet<ApiType> addSet = EnumSet.noneOf(ApiType.class);
        ArrayList<String> notFoundSet = new ArrayList<String>();
        StringBuffer initialtypes = new StringBuffer();
        if (apiTypes != null) {
            for (String types : apiTypes) {
                if (initialtypes.length() == 0) {
                    initialtypes.append("\"" + types + "\"");
                } else {
                    initialtypes.append(" \"" + types + "\"");
                }
                if (types == null) continue;
                for (String stype : types.split("[ ,]+")) {
                    ApiType type;
                    if (stype.indexOf("+") == 0) {
                        type = ApiType.fromString(stype = stype.replaceFirst("\\+", ""));
                        if (type != null) {
                            if (addSet.add(type)) continue;
                            if (tc.isErrorEnabled()) {
                                Tr.error((TraceComponent)tc, (String)"cls.classloader.config.duplicate", (Object[])new Object[]{stype, initialtypes});
                            }
                            set.clear();
                            return set;
                        }
                        if (tc.isErrorEnabled()) {
                            Tr.error((TraceComponent)tc, (String)"cls.classloader.config.typo", (Object[])new Object[]{stype, initialtypes, EnumSet.allOf(ApiType.class)});
                        }
                        set.clear();
                        return set;
                    }
                    if (stype.indexOf("-") == 0) {
                        type = ApiType.fromString(stype = stype.replaceFirst("-", ""));
                        if (type != null) {
                            if (removeSet.add(type)) continue;
                            if (tc.isErrorEnabled()) {
                                Tr.error((TraceComponent)tc, (String)"cls.classloader.config.duplicate", (Object[])new Object[]{stype, initialtypes});
                            }
                            set.clear();
                            return set;
                        }
                        if (tc.isErrorEnabled()) {
                            Tr.error((TraceComponent)tc, (String)"cls.classloader.config.typo", (Object[])new Object[]{stype, initialtypes, EnumSet.allOf(ApiType.class)});
                        }
                        set.clear();
                        return set;
                    }
                    type = ApiType.fromString(stype);
                    if (type != null) {
                        set.add(type);
                        continue;
                    }
                    notFoundSet.add(stype);
                }
            }
        }
        if (!removeSet.isEmpty() || !addSet.isEmpty()) {
            if (set.isEmpty() && notFoundSet.isEmpty()) {
                for (ApiType apiType : addSet) {
                    if (!removeSet.contains((Object)apiType)) continue;
                    if (tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"cls.classloader.config.duplicate", (Object[])new Object[]{apiType, initialtypes});
                    }
                    set.clear();
                    return set;
                }
            } else {
                EnumSet<ApiType> invalidSet = EnumSet.noneOf(ApiType.class);
                for (ApiType apiType1 : DEFAULT_API_TYPES) {
                    for (ApiType set1 : set) {
                        if (!set1.equals((Object)apiType1)) continue;
                        invalidSet.add(set1);
                    }
                }
                if (!(invalidSet.isEmpty() && notFoundSet.isEmpty() && set.isEmpty())) {
                    if (tc.isErrorEnabled()) {
                        if (!notFoundSet.isEmpty()) {
                            Tr.error((TraceComponent)tc, (String)"cls.classloader.config.typo", (Object[])new Object[]{notFoundSet, initialtypes, EnumSet.allOf(ApiType.class)});
                        }
                        if (!invalidSet.isEmpty()) {
                            Tr.error((TraceComponent)tc, (String)"cls.classloader.config.not.allowed", (Object[])new Object[]{invalidSet, initialtypes});
                        }
                        if (!set.isEmpty()) {
                            Tr.error((TraceComponent)tc, (String)"cls.classloader.config.typo2", (Object[])new Object[]{set, initialtypes});
                        }
                    }
                    set.clear();
                    return set;
                }
            }
            for (ApiType apiType : addSet) {
                if (!removeSet.contains((Object)apiType) && !set.contains((Object)apiType)) continue;
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"cls.classloader.config.duplicate", (Object[])new Object[]{apiType, initialtypes});
                }
                set.clear();
                return set;
            }
            for (ApiType apiType : removeSet) {
                if (!set.contains((Object)apiType)) continue;
                if (tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"cls.classloader.config.duplicate", (Object[])new Object[]{apiType, initialtypes});
                }
                set.clear();
                return set;
            }
            for (ApiType apiType : DEFAULT_API_TYPES) {
                set.add(apiType);
            }
            for (ApiType apiType : addSet) {
                set.add(apiType);
            }
            for (ApiType apiType : removeSet) {
                set.remove((Object)apiType);
            }
        }
        return set;
    }

    public String toString() {
        return this.attributeName;
    }

    static {
        tc = Tr.register(ApiType.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        DEFAULT_API_TYPES = EnumSet.of(SPEC, IBMAPI, API, STABLE);
    }
}

