/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.TargetCache_Readable;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Reader;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Utils;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary;
import com.ibm.ws.annocache.targets.internal.TargetsTableAnnotationsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableTimeStampImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_Options;
import com.ibm.wsspi.annocache.util.Util_Consumer;
import com.ibm.wsspi.annocache.util.Util_Function;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class TargetCacheImpl_DataBase {
    private static final String CLASS_NAME = TargetCacheImpl_DataBase.class.getSimpleName();
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final String NO_CHILD_PREFIX = null;
    protected final TargetCacheImpl_Factory factory;
    protected final TargetCache_Options cacheOptions;
    protected final String name;
    protected final String e_name;
    protected final File dataFile;
    public static final boolean DO_TRUNCATE = true;
    public static final boolean DO_NOT_TRUNCATE = false;
    private long readTime;
    private long writeTime;
    static final long serialVersionUID = -1962529004969074516L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_DataBase(TargetCacheImpl_Factory factory, String name, String e_name, File dataFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "<init>", new Object[]{factory, name, e_name, dataFile});
        }
        this.factory = factory;
        this.cacheOptions = factory.getCacheOptions();
        this.name = name;
        this.e_name = e_name;
        this.dataFile = dataFile;
        this.readTime = 0L;
        this.writeTime = 0L;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Factory getFactory() {
        return this.factory;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetCacheImpl_DataCon createConData(TargetCacheImpl_DataBase parentCache, String conPath, String e_conPath, File conFile, boolean isSource) {
        return this.getFactory().createConData(parentCache, conPath, e_conPath, conFile, isSource);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCache_Options getCacheOptions() {
        return this.cacheOptions;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isDisabled() {
        return this.getCacheOptions().getDisabled();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAlwaysValid() {
        return this.getCacheOptions().getAlwaysValid();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadOnly() {
        return this.getCacheOptions().getReadOnly();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getWriteThreads() {
        return this.getCacheOptions().getWriteThreads();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getLogQueries() {
        return this.getCacheOptions().getLogQueries();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean shouldWrite(String outputDescription) {
        String methodName = "shouldWrite";
        if (this.isDisabled()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Disabled: Skipping write of [ {0} ]", outputDescription);
            }
            return false;
        }
        if (this.isReadOnly()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Read-only: Skipping write of [ {0} ]", outputDescription);
            }
            return false;
        }
        if (this.getDataFile() == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Unnamed: Skipping write of [ {0} ]", outputDescription);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Enabled and not read-only: Allowing write of [ {0} ]", outputDescription);
        }
        return true;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean shouldRead(String inputDescription) {
        String methodName = "shouldRead";
        if (this.isDisabled()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Disabled: Skipping read of [ {0} ]", inputDescription);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Enabled: Allowing read of [ {0} ]", inputDescription);
        }
        return true;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Writer createWriter(File outputFile) throws IOException {
        return this.createWriter(outputFile, true);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Writer createWriter(File outputFile, boolean doTruncate) throws IOException {
        String outputName = outputFile.getName();
        File parentFile = outputFile.getParentFile();
        this.mkdirs(parentFile);
        if (!this.exists(parentFile)) {
            throw new IOException("Parent [ " + parentFile.getName() + " ] for write [ " + outputName + " ] does not exist");
        }
        if (!this.isDirectory(parentFile)) {
            throw new IOException("Parent [ " + parentFile.getName() + " ] for write [ " + outputName + " ] exists but is not a directory");
        }
        OutputStream outputStream = this.openOutputStream(outputFile, doTruncate);
        return this.createWriter(outputName, outputStream);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Writer createWriter(String outputName, OutputStream outputStream) {
        return this.getFactory().createWriter(outputName, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void performWrite(String description, File outputFile, boolean doTruncate, Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction) {
        TargetCacheImpl_Writer useWriter;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "performWrite", new Object[]{description, outputFile, doTruncate, writeAction});
        }
        String methodName = "performWrite";
        if (description != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER {0}", description);
        }
        long writeStart = System.nanoTime();
        try {
            useWriter = this.createWriter(outputFile, doTruncate);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"403", (Object)this, (Object[])new Object[]{description, outputFile, doTruncate, writeAction});
            useWriter = null;
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
        }
        if (useWriter != null) {
            try {
                writeAction.accept(useWriter);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"412", (Object)this, (Object[])new Object[]{description, outputFile, doTruncate, writeAction});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
            }
            finally {
                useWriter.close();
            }
        }
        long duration = this.addWriteTime(writeStart, description);
        if (description != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN {0}", description);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "performWrite");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_WriterBinary createBinaryWriter(File outputFile) throws IOException {
        return this.createBinaryWriter(outputFile, true);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_WriterBinary createBinaryWriter(File outputFile, boolean doTruncate) throws IOException {
        String outputName = outputFile.getName();
        File parentFile = outputFile.getParentFile();
        this.mkdirs(parentFile);
        if (!this.exists(parentFile)) {
            throw new IOException("Parent [ " + parentFile.getName() + " ] for write [ " + outputName + " ] does not exist");
        }
        if (!this.isDirectory(parentFile)) {
            throw new IOException("Parent [ " + parentFile.getName() + " ] for write [ " + outputName + " ] exists but is not a directory");
        }
        OutputStream outputStream = this.openOutputStream(outputFile, doTruncate);
        return this.createBinaryWriter(outputName, outputStream);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_WriterBinary createBinaryWriter(String outputName, OutputStream outputStream) throws IOException {
        return this.getFactory().createBinaryWriter(outputName, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void performBinaryWrite(String description, File outputFile, boolean doTruncate, Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeAction) {
        TargetCacheImpl_WriterBinary useWriter;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "performBinaryWrite", new Object[]{description, outputFile, doTruncate, writeAction});
        }
        String methodName = "performWrite";
        if (description != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER {0}", description);
        }
        long writeStart = System.nanoTime();
        try {
            useWriter = this.createBinaryWriter(outputFile, doTruncate);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"535", (Object)this, (Object[])new Object[]{description, outputFile, doTruncate, writeAction});
            useWriter = null;
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
        }
        if (useWriter != null) {
            try {
                writeAction.accept(useWriter);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"544", (Object)this, (Object[])new Object[]{description, outputFile, doTruncate, writeAction});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
            }
            finally {
                useWriter.close();
            }
        }
        long duration = this.addWriteTime(writeStart, description);
        if (description != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN {0}", description);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "performBinaryWrite");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Reader createReader(File inputFile) throws IOException {
        String inputPath = inputFile.getName();
        InputStream inputStream = this.openInputStream(inputFile);
        return this.createReader(inputPath, inputStream);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Reader createReader(String inputPath, InputStream inputStream) {
        return this.getFactory().createReader(inputPath, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean read(File inputFile, TargetCache_Readable ... readables) {
        List<TargetCache_ParseError> parseErrors;
        Exception boundException;
        block11: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "read", new Object[]{inputFile, readables});
            }
            boundException = null;
            parseErrors = null;
            String methodName = "read";
            try {
                TargetCacheImpl_Reader reader = this.createReader(inputFile);
                if (reader == null) break block11;
                try {
                    for (TargetCache_Readable readable : readables) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, methodName, "Read [ {0} ]", readable);
                        }
                        if ((parseErrors = readable.readUsing(reader)).isEmpty()) continue;
                        break;
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException reader) {
                void e;
                FFDCFilter.processException((Throwable)reader, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"635", (Object)this, (Object[])new Object[]{inputFile, readables});
                boundException = e;
            }
        }
        if (this.readError(inputFile, boundException, parseErrors)) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "read", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "read", bl);
        }
        return bl;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean readError(File file, Exception boundException, List<TargetCache_ParseError> parseErrors) {
        String methodName = "readError";
        if (boundException == null && (parseErrors == null || parseErrors.isEmpty())) {
            return false;
        }
        logger.logp(Level.WARNING, CLASS_NAME, methodName, "Failed to read table [ {0} ]", file.getPath());
        if (boundException != null) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Read exception: {0}", boundException);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Read failure", boundException);
        }
        if (parseErrors != null && !parseErrors.isEmpty()) {
            for (TargetCache_ParseError parseError : parseErrors) {
                parseError.emit(logger);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String basicValidCombined(File inputFile, String currentStamp, TargetsTableTimeStampImpl stampTable, TargetsTableClassesImpl classesTable, TargetsTableAnnotationsImpl targetsTable) {
        boolean stampDifference;
        List<TargetCache_ParseError> parseErrors;
        Throwable boundException;
        block20: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombined", new Object[]{inputFile, currentStamp, stampTable, classesTable, targetsTable});
            }
            String methodName = "read";
            boundException = null;
            parseErrors = null;
            stampDifference = false;
            try {
                TargetCacheImpl_Reader reader = this.createReader(inputFile);
                if (reader == null) break block20;
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, methodName, "Read [ {0} ]", stampTable);
                    }
                    if ((parseErrors = stampTable.readUsing(reader)).isEmpty()) {
                        if (!currentStamp.equals(stampTable.getStamp())) {
                            stampDifference = true;
                        } else {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, CLASS_NAME, methodName, "Read [ {0} ]", classesTable);
                            }
                            if ((parseErrors = classesTable.readUsing(reader)).isEmpty()) {
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.FINER, CLASS_NAME, methodName, "Read [ {0} ]", targetsTable);
                                }
                                parseErrors = targetsTable.readUsing(reader);
                            }
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException reader) {
                void e;
                FFDCFilter.processException((Throwable)reader, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"732", (Object)this, (Object[])new Object[]{inputFile, currentStamp, stampTable, classesTable, targetsTable});
                boundException = e;
            }
        }
        if (this.readError(inputFile, (Exception)boundException, parseErrors)) {
            if (boundException != null) {
                String string = "Read exception: " + boundException.getMessage();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombined", string);
                }
                return string;
            }
            String string = "Parse error";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombined", string);
            }
            return string;
        }
        if (stampDifference) {
            String string = "Stamp difference";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombined", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombined", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_ReaderBinary createBinaryReader(String inputPath, boolean readStrings, boolean readFull) throws IOException {
        return this.getFactory().createBinaryReader(inputPath, readStrings, readFull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean readBinary(File inputFile, boolean readStrings, boolean readFull, Util_Consumer<TargetCacheImpl_ReaderBinary, IOException> readAction) {
        Exception boundException;
        block9: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "readBinary", new Object[]{inputFile, readStrings, readFull, readAction});
            }
            boundException = null;
            try {
                TargetCacheImpl_ReaderBinary reader = this.createBinaryReader(inputFile.getPath(), readStrings, readFull);
                if (reader == null) break block9;
                try {
                    readAction.accept(reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException reader) {
                void e;
                FFDCFilter.processException((Throwable)reader, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"813", (Object)this, (Object[])new Object[]{inputFile, readStrings, readFull, readAction});
                boundException = e;
            }
        }
        if (this.readError(inputFile, boundException, null)) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "readBinary", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "readBinary", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String basicValidCombinedBinary(File inputFile, boolean readStrings, boolean readFull, Util_Function<TargetCacheImpl_ReaderBinary, IOException, String> readAction) {
        String readResult;
        Throwable boundException;
        block9: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombinedBinary", new Object[]{inputFile, readStrings, readFull, readAction});
            }
            boundException = null;
            readResult = null;
            try {
                TargetCacheImpl_ReaderBinary reader = this.createBinaryReader(inputFile.getPath(), readStrings, readFull);
                if (reader == null) break block9;
                try {
                    readResult = readAction.apply(reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException reader) {
                void e;
                FFDCFilter.processException((Throwable)reader, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", (String)"846", (Object)this, (Object[])new Object[]{inputFile, readStrings, readFull, readAction});
                boundException = e;
            }
        }
        if (this.readError(inputFile, (Exception)boundException, null)) {
            String string = "Read exception: " + boundException.getMessage();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombinedBinary", string);
            }
            return string;
        }
        String string = readResult;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "basicValidCombinedBinary", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        return this.name;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_getName() {
        return this.e_name;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isNamed() {
        return this.e_name != null;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public File getDataFile() {
        return this.dataFile;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean exists() {
        return this.exists(this.getDataFile());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public File getDataFile(String relativePath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "getDataFile", new Object[]{relativePath});
        }
        if (relativePath == null) {
            File file = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                file = file;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "getDataFile", file);
            }
            return file;
        }
        File useDataDir = this.getDataFile();
        if (useDataDir == null) {
            File file = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                file = file;
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "getDataFile", file);
            }
            return file;
        }
        File file = new File(useDataDir, relativePath);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            file = file;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "getDataFile", file);
        }
        return file;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected File e_getConFile(String e_conPath) {
        return this.getDataFile(this.e_addConPrefix(e_conPath));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_addAppPrefix(String e_appName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_addAppPrefix", new Object[]{e_appName});
        }
        String string = TargetCacheImpl_Utils.APP_PREFIX_WIDGET.e_addPrefix(e_appName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_addAppPrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_removeAppPrefix(String e_appName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_removeAppPrefix", new Object[]{e_appName});
        }
        String string = TargetCacheImpl_Utils.APP_PREFIX_WIDGET.e_removePrefix(e_appName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_removeAppPrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_addModPrefix(String e_modName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_addModPrefix", new Object[]{e_modName});
        }
        String string = TargetCacheImpl_Utils.MOD_PREFIX_WIDGET.e_addPrefix(e_modName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_addModPrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_removeModPrefix(String e_modName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_removeModPrefix", new Object[]{e_modName});
        }
        String string = TargetCacheImpl_Utils.MOD_PREFIX_WIDGET.e_removePrefix(e_modName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_removeModPrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_addConPrefix(String e_conPath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_addConPrefix", new Object[]{e_conPath});
        }
        String string = TargetCacheImpl_Utils.CON_PREFIX_WIDGET.e_addPrefix(e_conPath);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_addConPrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_removeConPrefix(String e_conPath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_removeConPrefix", new Object[]{e_conPath});
        }
        String string = TargetCacheImpl_Utils.CON_PREFIX_WIDGET.e_removePrefix(e_conPath);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "e_removeConPrefix", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String encode(String useName) {
        return TargetCacheImpl_Utils.encodePath(useName);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String decode(String useName) {
        return TargetCacheImpl_Utils.decodePath(useName);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean exists(File targetFile) {
        return targetFile != null && UtilImpl_FileUtils.exists(targetFile);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isDirectory(File targetFile) {
        return UtilImpl_FileUtils.isDirectory(targetFile);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean mkdirs(File targetFile) {
        return UtilImpl_FileUtils.mkdirs(targetFile);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected FileOutputStream openOutputStream(File file) throws IOException {
        return UtilImpl_FileUtils.createFileOutputStream(file);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected OutputStream openOutputStream(File file, boolean doTruncate) throws IOException {
        if (doTruncate) {
            return UtilImpl_FileUtils.createFileOutputStream(file, false);
        }
        return UtilImpl_FileUtils.createOverwriteOutputStream(file);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InputStream openInputStream(File file) throws IOException {
        return UtilImpl_FileUtils.createFileInputStream(file);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected RandomAccessFile openRandomInputFile(File file) throws IOException {
        return UtilImpl_FileUtils.createRandomInputFile(file);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getReadTime() {
        return this.readTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long addReadTime(long start, String description) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "addReadTime", new Object[]{start, description});
        }
        long duration = System.nanoTime() - start;
        this.readTime += duration;
        long l = duration;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "addReadTime", l);
        }
        return l;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getWriteTime() {
        return this.writeTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long addWriteTime(long start, String description) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "addWriteTime", new Object[]{start, description});
        }
        long duration = System.nanoTime() - start;
        this.writeTime += duration;
        long l = duration;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase", "addWriteTime", l);
        }
        return l;
    }
}

