/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CollectiveDNUtil {
    public static final String COLLECTIVE_REALM = "collective";
    public static final String RDN_COLLECTIVE_FLAG = "dc";
    public static final String RDN_COLLECTIVE_UUID = "o";
    public static final String RDN_COLLECTIVE_ROLE = "ou";
    public static final String RDN_HOST_NAME = "l";
    public static final String RDN_USER_DIR = "l";
    public static final String RDN_SERVER_NAME = "cn";
    public static final String COLLECTIVE_FLAG = "com.ibm.ws.collective";
    public static final String COLLECTIVE_ROLE_CONTROLLER = "controller";
    public static final String COLLECTIVE_ROLE_MEMBER = "member";
    public static final String CONTROLLER_ROLE_COLLECTIVE_ROOT_CERT = "controllerRoot";
    public static final String COLLECTIVE_ROLE_MEMBER_ROOT_CERT = "memberRoot";
    static final long serialVersionUID = 5284927420526898250L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static String buildCommonRootDN(String root, String collectiveUUID) {
        if (collectiveUUID == null) {
            throw new IllegalArgumentException("buildCommonRootDN: collectiveUUID is null");
        }
        if (collectiveUUID.isEmpty()) {
            throw new IllegalArgumentException("buildCommonRootDN: collectiveUUID is empty");
        }
        StringBuilder sb = new StringBuilder(RDN_COLLECTIVE_ROLE);
        sb.append("=");
        sb.append(root);
        sb.append(",");
        sb.append(RDN_COLLECTIVE_UUID);
        sb.append("=");
        sb.append(collectiveUUID);
        sb.append(",");
        sb.append(RDN_COLLECTIVE_FLAG);
        sb.append("=");
        sb.append(COLLECTIVE_FLAG);
        return sb.toString();
    }

    public static String buildControllerRootCertificateDN(String collectiveUUID) {
        return CollectiveDNUtil.buildCommonRootDN(CONTROLLER_ROLE_COLLECTIVE_ROOT_CERT, collectiveUUID);
    }

    public static String buildMemberRootCertificateDN(String collectiveUUID) {
        return CollectiveDNUtil.buildCommonRootDN(COLLECTIVE_ROLE_MEMBER_ROOT_CERT, collectiveUUID);
    }

    private static String buildCommonMemberDN(String serverName, String userDir, String hostName, String role, String collectiveUUID) {
        if (serverName == null) {
            throw new IllegalArgumentException("buildCommonMemberDN: serverName is null");
        }
        if (serverName.isEmpty()) {
            throw new IllegalArgumentException("buildCommonMemberDN: serverName is empty");
        }
        if (userDir == null) {
            throw new IllegalArgumentException("buildCommonMemberDN: userDir is null");
        }
        if (userDir.isEmpty()) {
            throw new IllegalArgumentException("buildCommonMemberDN: userDir is empty");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("buildCommonMemberDN: hostName is null");
        }
        if (hostName.isEmpty()) {
            throw new IllegalArgumentException("buildCommonMemberDN: hostName is empty");
        }
        if (collectiveUUID == null) {
            throw new IllegalArgumentException("buildCommonMemberDN: collectiveUUID is null");
        }
        if (collectiveUUID.isEmpty()) {
            throw new IllegalArgumentException("buildCommonMemberDN: collectiveUUID is empty");
        }
        StringBuilder sb = new StringBuilder(RDN_SERVER_NAME);
        sb.append("=");
        sb.append(serverName);
        sb.append(",");
        sb.append("l");
        sb.append("=\"");
        sb.append(RepositoryPathUtility.getURLEncodedPath(userDir));
        sb.append("\",");
        sb.append("l");
        sb.append("=");
        sb.append(hostName.toLowerCase());
        sb.append(",");
        sb.append(RDN_COLLECTIVE_ROLE);
        sb.append("=");
        sb.append(role);
        sb.append(",");
        sb.append(RDN_COLLECTIVE_UUID);
        sb.append("=");
        sb.append(collectiveUUID);
        sb.append(",");
        sb.append(RDN_COLLECTIVE_FLAG);
        sb.append("=");
        sb.append(COLLECTIVE_FLAG);
        return sb.toString();
    }

    public static String buildControllerDN(String serverName, String userDir, String hostName, String collectiveUUID) {
        return CollectiveDNUtil.buildCommonMemberDN(serverName, userDir, hostName, COLLECTIVE_ROLE_CONTROLLER, collectiveUUID);
    }

    public static String buildMemberDN(String serverName, String userDir, String hostName, String collectiveUUID) {
        return CollectiveDNUtil.buildCommonMemberDN(serverName, userDir, hostName, COLLECTIVE_ROLE_MEMBER, collectiveUUID);
    }

    public static void validateCollectiveRootDNSyntax(String dn) throws InvalidNameException {
        LdapName name = new LdapName(dn);
        if (name.size() != 3) {
            throw new InvalidNameException("Validation of the Collective Root DN failed. Incorrect number of elements. Size was: " + name.size() + ". DN: " + dn);
        }
        Rdn shouldBeDC = name.getRdn(0);
        if (!RDN_COLLECTIVE_FLAG.equalsIgnoreCase(shouldBeDC.getType())) {
            throw new InvalidNameException("Validation of the Collective Root DN failed. 0th element type was not dc. DN: " + dn);
        }
        if (!COLLECTIVE_FLAG.equals(shouldBeDC.getValue())) {
            throw new InvalidNameException("Validation of the Collective Root DN failed. DC element value was not com.ibm.ws.collective. Value is " + shouldBeDC.getValue() + ". DN: " + dn);
        }
        Rdn shouldBeO = name.getRdn(1);
        if (!RDN_COLLECTIVE_UUID.equalsIgnoreCase(shouldBeO.getType())) {
            throw new InvalidNameException("Validation of the Collective Root DN failed. 1st element type was not o. DN: " + dn);
        }
        Rdn shouldBeOU = name.getRdn(2);
        if (!RDN_COLLECTIVE_ROLE.equalsIgnoreCase(shouldBeOU.getType())) {
            throw new InvalidNameException("Validation of the Collective Root DN failed. 2nd element type was not ou. DN: " + dn);
        }
        if (!CONTROLLER_ROLE_COLLECTIVE_ROOT_CERT.equals(shouldBeOU.getValue()) && !COLLECTIVE_ROLE_MEMBER_ROOT_CERT.equals(shouldBeOU.getValue())) {
            throw new InvalidNameException("Validation of the Collective Root DN failed. OU element value was not recognized. Value is " + shouldBeOU.getValue() + ". DN: " + dn);
        }
    }

    public static void validateCollectiveDNSyntax(String dn) throws InvalidNameException {
        LdapName name = new LdapName(dn);
        if (name.size() != 6) {
            throw new InvalidNameException("Validation of the Collective DN failed. Incorrect number of elements. Size was: " + name.size() + ". DN: " + dn);
        }
        Rdn shouldBeDC = name.getRdn(0);
        if (!RDN_COLLECTIVE_FLAG.equalsIgnoreCase(shouldBeDC.getType())) {
            throw new InvalidNameException("Validation of the Collective DN failed. 0th element type was not dc. DN: " + dn);
        }
        if (!COLLECTIVE_FLAG.equals(shouldBeDC.getValue())) {
            throw new InvalidNameException("Validation of the Collective DN failed. DC element value was not com.ibm.ws.collective. Value is " + shouldBeDC.getValue() + ". DN: " + dn);
        }
        Rdn shouldBeO = name.getRdn(1);
        if (!RDN_COLLECTIVE_UUID.equalsIgnoreCase(shouldBeO.getType())) {
            throw new InvalidNameException("Validation of the Collective DN failed. 1st element type was not o. DN: " + dn);
        }
        Rdn shouldBeOU = name.getRdn(2);
        if (!RDN_COLLECTIVE_ROLE.equalsIgnoreCase(shouldBeOU.getType())) {
            throw new InvalidNameException("Validation of the Collective DN failed. 2nd element type was not ou. DN: " + dn);
        }
        if (!COLLECTIVE_ROLE_CONTROLLER.equals(shouldBeOU.getValue()) && !COLLECTIVE_ROLE_MEMBER.equals(shouldBeOU.getValue())) {
            throw new InvalidNameException("Validation of the Collective DN failed. OU element value was not recognized. Value is " + shouldBeOU.getValue() + ". DN: " + dn);
        }
        Rdn shouldBeL = name.getRdn(3);
        if (!"l".equalsIgnoreCase(shouldBeL.getType())) {
            throw new InvalidNameException("Validation of the Collective DN failed. 3rd element type was not l. DN: " + dn);
        }
        shouldBeL = name.getRdn(4);
        if (!"l".equalsIgnoreCase(shouldBeL.getType())) {
            throw new InvalidNameException("Validation of the Collective DN failed. 4th element type was not l. DN: " + dn);
        }
        Rdn shouldBeCN = name.getRdn(5);
        if (!RDN_SERVER_NAME.equalsIgnoreCase(shouldBeCN.getType())) {
            throw new InvalidNameException("Validation of the Collective DN failed. 5th element type was not cn. DN: " + dn);
        }
    }

    public static String getServerName(String dn) throws InvalidNameException {
        CollectiveDNUtil.validateCollectiveDNSyntax(dn);
        LdapName name = new LdapName(dn);
        return (String)name.getRdn(5).getValue();
    }

    public static String getURLEncodedUserDir(String dn) throws InvalidNameException {
        CollectiveDNUtil.validateCollectiveDNSyntax(dn);
        LdapName name = new LdapName(dn);
        return (String)name.getRdn(4).getValue();
    }

    public static String getHostName(String dn) throws InvalidNameException {
        CollectiveDNUtil.validateCollectiveDNSyntax(dn);
        LdapName name = new LdapName(dn);
        return (String)name.getRdn(3).getValue();
    }

    public static String getCollectiveRole(String dn) throws InvalidNameException {
        CollectiveDNUtil.validateCollectiveDNSyntax(dn);
        LdapName name = new LdapName(dn);
        return (String)name.getRdn(2).getValue();
    }

    public static String getCollectiveUUID(String dn) throws InvalidNameException {
        CollectiveDNUtil.validateCollectiveDNSyntax(dn);
        LdapName name = new LdapName(dn);
        return (String)name.getRdn(1).getValue();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.security.CollectiveDNUtil", CollectiveDNUtil.class, (String)"Collective", null);
    }
}

