/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.smime.SMIMEMessage;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class parsePKCS7 {
    public static void main(String[] args) {
        String inputfile;
        block40: {
            inputfile = null;
            String origmsgfile = null;
            boolean bbase64 = false;
            String certfile = null;
            String privatekeyfile = null;
            String password = null;
            char[] passwordChars = null;
            String recipientcertfile = null;
            boolean bsmime = false;
            try {
                FileInputStream fis;
                if (args.length < 1) {
                    System.out.println("Usage: parsePKCS7 -file=PKCS7FileName [-msg=OriginalMessageFile] [-base64] [-bsmime]\r\n\t[-cert=certificateFile] [-recipientcert=recipientCertFilename]\r\n\t[-privatekey=privatekeyfile] [-password=privatekeyPassword]");
                    System.exit(1);
                }
                for (int i2 = 0; i2 < args.length; ++i2) {
                    String param = args[i2].toLowerCase();
                    boolean bfound = false;
                    if (param.startsWith("-file=")) {
                        inputfile = args[i2].substring(6);
                        bfound = true;
                    }
                    if (param.startsWith("-msg=")) {
                        origmsgfile = args[i2].substring(5);
                        bfound = true;
                    }
                    if (param.startsWith("-base64")) {
                        bbase64 = true;
                        bfound = true;
                    }
                    if (param.startsWith("-bsmime")) {
                        bsmime = true;
                        bfound = true;
                    }
                    if (param.startsWith("-recipientcert=")) {
                        recipientcertfile = args[i2].substring(15);
                        bfound = true;
                    }
                    if (param.startsWith("-cert=")) {
                        certfile = args[i2].substring(6);
                        bfound = true;
                    }
                    if (param.startsWith("-privatekey=")) {
                        privatekeyfile = args[i2].substring(12);
                        bfound = true;
                    }
                    if (param.startsWith("-password=")) {
                        password = args[i2].substring(10);
                        passwordChars = password.toCharArray();
                        bfound = true;
                    }
                    if (bfound) continue;
                    System.out.println("ERROR:  Unknown parameter " + args[i2] + ".");
                    System.exit(1);
                }
                if (inputfile == null) {
                    System.out.println("ERROR:  input file must be specified.");
                    System.exit(1);
                }
                System.out.println("parsePKCS7 invoked with:");
                System.out.println("\tInput file = " + inputfile);
                System.out.println("\tInput file in Base64 format = " + bbase64);
                System.out.println("\tSignedData parameters:");
                System.out.println("\t\tOriginal message file = " + origmsgfile);
                System.out.println("\tEnvelopedData parameters:");
                System.out.println("\t\tCertificate file = " + certfile);
                System.out.println("\t\tPrivate key file = " + privatekeyfile);
                System.out.println("\t\tPrivate key password = " + password);
                System.out.println("\t\tRecipient Certificate file = " + recipientcertfile);
                System.out.println("\t\tParse contained S/MIME message = " + bsmime);
                ContentInfo cinfo = new ContentInfo(inputfile, bbase64);
                System.out.println("PKCS#7 object:");
                System.out.println(cinfo);
                byte[] msg = null;
                if (origmsgfile != null) {
                    FileInputStream fis2 = new FileInputStream(origmsgfile);
                    msg = new byte[fis2.available()];
                    fis2.read(msg);
                    fis2.close();
                    System.out.println("\r\n**** Begin Message from file " + origmsgfile + " ****");
                    try {
                        System.out.println(new String(msg, "8859_1"));
                    }
                    catch (UnsupportedEncodingException e2) {
                        System.out.println(new String(msg));
                    }
                    System.out.println("**** End Message from file " + origmsgfile + " ****\r\n");
                }
                byte[] bytes = null;
                X509CertImpl cert = null;
                if (certfile != null) {
                    fis = new FileInputStream(certfile);
                    bytes = new byte[fis.available()];
                    fis.read(bytes);
                    fis.close();
                    cert = new X509CertImpl(bytes);
                }
                PrivateKey privateKey = null;
                if (privatekeyfile != null) {
                    if (password == null) {
                        System.out.println("Reading in the private key from " + privatekeyfile);
                        fis = new FileInputStream(privatekeyfile);
                        bytes = new byte[fis.available()];
                        fis.read(bytes);
                        fis.close();
                        privateKey = parsePKCS7.convertPrivateKey(bytes);
                    } else {
                        System.out.println("Reading in the encrypted private key from " + privatekeyfile);
                        fis = new FileInputStream(privatekeyfile);
                        bytes = new byte[fis.available()];
                        fis.read(bytes);
                        fis.close();
                        System.out.println("Decrypting the private key.");
                        EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(bytes);
                        bytes = epki.decrypt(passwordChars);
                        privateKey = parsePKCS7.convertPrivateKey(bytes);
                    }
                }
                X509CertImpl recipientcert = null;
                if (recipientcertfile == null) {
                    recipientcert = cert;
                } else {
                    System.out.println("Reading in the recipient certificate from " + recipientcertfile);
                    fis = new FileInputStream(recipientcertfile);
                    bytes = new byte[fis.available()];
                    fis.read(bytes);
                    fis.close();
                    recipientcert = new X509CertImpl(bytes);
                }
                System.out.println("Input object is of type: " + cinfo.getContentTypeString());
                if (cinfo.isSignedData()) {
                    parsePKCS7.verifySignedData(cinfo, msg);
                    break block40;
                }
                if (cinfo.isEnvelopedData()) {
                    if (privateKey != null) {
                        System.out.println("Decrypting EnvelopedData ContentInfo with key of type " + privateKey.getClass().getName() + ".");
                        ContentInfo decryptedContentInfo = parsePKCS7.decryptEnvelopedData(cinfo, privateKey, recipientcert);
                        if (decryptedContentInfo == null) {
                            System.out.println("Decrypted ContentInfo is null");
                            break block40;
                        }
                        if (decryptedContentInfo.isData()) {
                            Data data = (Data)decryptedContentInfo.getContent();
                            try {
                                System.out.println("Decrypted Content:\r\n" + new String(data.getData(), "8859_1"));
                            }
                            catch (UnsupportedEncodingException e3) {
                                System.out.println("Decrypted Content:\r\n" + new String(data.getData()));
                            }
                            if (bsmime) {
                                SMIMEMessage smimemessage = new SMIMEMessage(data.getData());
                                System.out.println("*** Contained SMIMEMessage:\r\n" + smimemessage);
                                ContentInfo cicontained = smimemessage.getContentInfo();
                                if (cicontained != null && !cicontained.isSignedData()) {
                                    System.out.println("*** Contained ContentInfo is of type " + cicontained.getContentTypeString());
                                } else if (cicontained != null) {
                                    SignedData sd = (SignedData)cicontained.getContent();
                                    byte[] messagecontained = smimemessage.getMessage();
                                    System.out.println("*** Contained SignedData: " + sd);
                                    if (messagecontained != null) {
                                        try {
                                            System.out.println("*** Verifying contained message:\r\n" + new String(messagecontained, "8859_1"));
                                        }
                                        catch (UnsupportedEncodingException e4) {
                                            System.out.println("*** Verifying contained message:\r\n" + new String(messagecontained));
                                        }
                                    } else {
                                        System.out.println("*** Verifying contained message: null");
                                    }
                                    parsePKCS7.verifySignedData(cicontained, messagecontained);
                                }
                            }
                            break block40;
                        }
                        System.out.println("Decrypted ContentInfo is of type " + decryptedContentInfo.getContentTypeString());
                        break block40;
                    }
                    System.out.println("ERROR:  Private key must be specified to decrypt EnvelopedData ContentInfo.");
                    break block40;
                }
                System.out.println("No special processing for this content type.");
            }
            catch (PKCSException e2) {
                System.out.println("\r\nERROR:  PKCSException: " + e2);
                e2.printStackTrace();
                Exception e3 = e2.getRelatedException();
                if (e3 != null) {
                    System.out.println("\r\nOriginal PKCSException stack:");
                    e3.printStackTrace();
                } else {
                    System.out.println("\r\nNo Original PKCSException stack available");
                }
            }
            catch (Exception e5) {
                System.out.println("\r\nERROR:  Exception");
                e5.printStackTrace();
            }
        }
        System.out.println("EXIT:  parsePKCS7 input file = " + inputfile);
    }

    static ContentInfo decryptEnvelopedData(ContentInfo cinfo, PrivateKey privatekey, Certificate cert) throws IOException, PKCSException {
        if (privatekey == null) {
            System.out.println("Cannot decrypt contents.  Private key not specified.");
            return null;
        }
        if (cert == null) {
            System.out.println("Cannot decrypt contents.  Certificate not specified.");
            return null;
        }
        System.out.println("Certificate:\r\n" + cert);
        System.out.println("Private key:\r\n" + privatekey);
        EnvelopedData ed = (EnvelopedData)cinfo.getContent();
        ContentInfo decryptedContentInfo = ed.decrypt(privatekey, cert);
        System.out.println("Decrypted ContentInfo:\r\n" + decryptedContentInfo);
        return decryptedContentInfo;
    }

    static void verifySignedData(ContentInfo cinfo, byte[] msg) throws IOException {
        System.out.println("SignedData .... verifying ...");
        SignedData sd = (SignedData)cinfo.getContent();
        EncapsulatedContentInfo eci = sd.getEncapsulatedContentInfo();
        byte[] content = eci.getContent();
        System.out.println("**** BEGIN CONTENT ****");
        if (content != null) {
            try {
                System.out.println(new String(content, "8859_1"));
            }
            catch (UnsupportedEncodingException e2) {
                System.out.println(new String(content));
            }
        } else {
            System.out.println("N/A");
        }
        System.out.println("**** END CONTENT ****");
        Certificate[] certs = sd.getCertificates();
        int numcerts = 0;
        if (certs != null) {
            numcerts = certs.length;
        }
        if (numcerts == 0) {
            System.out.println("No certificates to verify.");
            return;
        }
        SignerInfo[] signerinfos = sd.getSignerInfos();
        if (signerinfos == null || signerinfos.length == 0) {
            System.out.println("SignedData contains certificates only.  No verification will occur.");
            return;
        }
        if (content == null && msg == null) {
            System.out.println("No content stored with the SignedData or passed in message to verify against.");
            return;
        }
        for (int i2 = 0; i2 < numcerts; ++i2) {
            Certificate cert = certs[i2];
            System.out.println("Checking certificate[" + i2 + "].");
            try {
                if (sd.verify(cert, msg)) {
                    System.out.println("SUCCESS:  Verified okay.");
                    return;
                }
                System.out.println("Verification failed for certificate[" + i2 + "].");
                parsePKCS7.examineError(sd, cert, msg);
                continue;
            }
            catch (PKCSException e2) {
                System.out.println("\r\nERROR:  PKCSException: " + e2);
                e2.printStackTrace();
                Exception e3 = e2.getRelatedException();
                if (e3 != null) {
                    System.out.println("\r\nOriginal PKCSException stack:");
                    e3.printStackTrace();
                    continue;
                }
                System.out.println("\r\nNo Original PKCSException stack available");
                continue;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                System.out.println("ERROR: " + e3);
                parsePKCS7.examineError(sd, cert, msg);
            }
        }
        System.out.println("ERROR:  All verification failed.");
    }

    static void examineError(SignedData sd, Certificate cert, byte[] msg) throws IOException {
        System.out.println("ERROR CONDITIONAL:");
        SignerInfo si = sd.getSignerInfo(cert);
        EncapsulatedContentInfo eci = sd.getEncapsulatedContentInfo();
        byte[] content = eci.getContent();
        if (si == null) {
            System.out.println("\tCould not find a SignerInfo to match the certificate.");
            return;
        }
        byte[] contentbytes = msg;
        if (contentbytes == null) {
            contentbytes = content;
        }
        if (contentbytes == null) {
            System.out.println("\tNo content stored with the SignedData or passed in message to verify against.");
            return;
        }
        byte[] mdstored = si.getMessageDigest();
        byte[] mdcalculated = parsePKCS7.calculateMessageDigest(si, contentbytes);
        if (mdstored == null || mdstored.length == 0) {
            System.out.println("\tCannot retrieve the message digest bytes from the SignerInfo.");
            if (si.hasSignedAttributes()) {
                System.out.println("\t\tThere are signed attributes, but they do not include the message digest.");
            } else {
                System.out.println("\t\tThere are no signed attributes.");
                System.out.println("\t\tThe computed message digest as the bytes to be verified could\r\n\t\thave been rejected by the signature verification method.");
            }
            return;
        }
        if (mdcalculated == null || mdcalculated.length == 0) {
            System.out.println("\tCannot calculate the message digest bytes from the message.");
            return;
        }
        if (mdstored.length != mdcalculated.length) {
            System.out.println("\tDigest lengths are not the same.");
            System.out.println("\t\tStored digest length = " + mdstored.length);
            System.out.println("\t\tCalculated digest length = " + mdcalculated.length);
            return;
        }
        for (int i2 = 0; i2 < mdstored.length; ++i2) {
            if (mdstored[i2] == mdcalculated[i2]) continue;
            System.out.println("\tStored and calculated values are not the same.");
            HexDumpEncoder hd = new HexDumpEncoder();
            System.out.println("\tStored digest:\r\n" + hd.encodeBuffer(mdstored));
            System.out.println("\tCalculated digest:\r\n" + hd.encodeBuffer(mdcalculated));
            return;
        }
        System.out.println("\tStored and calculated digest values are the same.");
        System.out.println("\tThe problem might lie with the signature verification.");
    }

    static byte[] calculateMessageDigest(SignerInfo si, byte[] msg) throws IOException {
        String mdname = si.getDigestAlgorithm().getName();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(mdname);
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
            System.out.println("ERROR: " + e2);
            return null;
        }
        byte[] digest = md.digest(msg);
        return digest;
    }

    private static PrivateKey convertPrivateKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keyspec);
        return privateKey;
    }
}

