/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.x509.X509CRLImpl;
import java.io.FileInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;

public class parseCRLs {
    public static void main(String[] argv) throws Throwable {
        if (argv.length < 1) {
            System.out.println("usage: parseCRLs CRLFile [CRLFile CRLFile ...]");
        }
        for (int i2 = 0; i2 < argv.length; ++i2) {
            X509CRLImpl crl = null;
            try {
                FileInputStream fis = new FileInputStream(argv[i2]);
                crl = new X509CRLImpl(fis);
                fis.close();
                System.out.println(crl);
                continue;
            }
            catch (CRLException ce) {
                ce.printStackTrace();
                ContentInfo ci = new ContentInfo(argv[i2], false);
                if (ci.isSignedData()) {
                    Content content = ci.getContent();
                    SignedData sd = (SignedData)content;
                    CRL[] crls = sd.getCRLs();
                    if (crls != null && crls.length != 0) {
                        for (int j2 = 0; j2 < crls.length; ++j2) {
                            CRL c2 = crls[j2];
                            System.out.println(c2);
                        }
                        continue;
                    }
                    System.out.println("No CRLs in object");
                    continue;
                }
                System.out.println("Unknown format");
            }
        }
    }
}

