/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.smime.jmail.PKCS7NewMimeDataSource;
import com.ibm.security.smime.jmail.SMIMEMimeMessage;
import com.ibm.security.smime.jmail.SMIMEUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.ParseException;

public class PKCS7NewMimeHandler
implements DataContentHandler {
    private static String PKCS7NEWMIMEDATASOURCE_CLASSNAME = "com.ibm.security.smime.jmail.PKCS7NewMimeDataSource";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS7NewMimeHandler";

    public PKCS7NewMimeHandler() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7NewMimeHandler");
            debug.exit(16384L, className, "PKCS7NewMimeHandler");
        }
    }

    public PKCS7NewMimeHandler(String provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS7NewMimeHandler", provider);
            debug.exit(16384L, className, "PKCS7NewMimeHandler");
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
    }

    public Object getContent(DataSource ds) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getContent", ds);
        }
        try {
            if (ds instanceof PKCS7NewMimeDataSource) {
                PKCS7NewMimeDataSource mimeds = (PKCS7NewMimeDataSource)ds;
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getContent_1", mimeds.getContentInfo());
                }
                return mimeds.getContentInfo();
            }
            if (ds instanceof MimePartDataSource) {
                MimePartDataSource mpds = (MimePartDataSource)ds;
                MessageContext msgcontext = mpds.getMessageContext();
                Message msg = msgcontext.getMessage();
                MessageContext mc2 = mpds.getMessageContext();
                Session session = mc2.getSession();
                if (msg instanceof SMIMEMimeMessage) {
                    SMIMEMimeMessage smimemsg = (SMIMEMimeMessage)msg;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getContent_2", this.parseSMIMEMimeMessage(smimemsg));
                    }
                    return this.parseSMIMEMimeMessage(smimemsg);
                }
                if (msg instanceof MimeMessage) {
                    MimeMessage mimemsg = (MimeMessage)msg;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    mimemsg.writeTo((OutputStream)baos);
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    SMIMEMimeMessage smimemsg = new SMIMEMimeMessage(session, (InputStream)bais, this.provider);
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getContent_3", this.parseSMIMEMimeMessage(smimemsg));
                    }
                    return this.parseSMIMEMimeMessage(smimemsg);
                }
            }
        }
        catch (ParseException pe) {
            if (debug != null) {
                debug.exception(16384L, className, "getContent", pe);
            }
            throw new IOException(pe.toString());
        }
        catch (MessagingException me) {
            if (debug != null) {
                debug.exception(16384L, className, "getContent", me);
            }
            throw new IOException(me.toString());
        }
        if (debug != null) {
            debug.text(16384L, className, "getContent", "DataSource class " + ds.getClass().getName() + " is not supported.");
        }
        throw new IOException("DataSource class " + ds.getClass().getName() + " is not supported.");
    }

    private Object parseSMIMEMimeMessage(SMIMEMimeMessage smimemsg) throws IOException, MessagingException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseSMIMEMimeMessage", (Object)smimemsg);
        }
        if (smimemsg.isSignedDataSignatureOnly()) {
            Object msgcontent = smimemsg.getContent();
            if (msgcontent instanceof MimeMultipart) {
                MimeMultipart mpart = (MimeMultipart)msgcontent;
                int count = mpart.getCount();
                if (count == 2) {
                    MimeBodyPart mbodypart = (MimeBodyPart)mpart.getBodyPart(1);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    mbodypart.writeTo((OutputStream)baos);
                    byte[] bytes = SMIMEUtils.getMessageBody(baos.toByteArray());
                    PKCS7NewMimeDataSource p7ds = new PKCS7NewMimeDataSource(bytes, true, this.provider);
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "parseSMIMEMimeMessage_1", p7ds.getContentInfo());
                    }
                    return p7ds.getContentInfo();
                }
                if (debug != null) {
                    debug.text(8192L, className, "parseSMIMEMimeMessage_1", "Expected two parts to this S/MIME signature-only message, but found " + count + " parts.");
                }
                throw new IOException("Expected two parts to this S/MIME signature-only message, but found " + count + " parts.");
            }
        } else {
            if (smimemsg.isEnvelopedData() || smimemsg.isSignedData() || smimemsg.isSignedDataCertificateOnly()) {
                byte[] content = SMIMEUtils.getMessageBodyRemoveTrailer(smimemsg.getContentBytes());
                PKCS7NewMimeDataSource p7ds = new PKCS7NewMimeDataSource(content, true, this.provider);
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "parseSMIMEMimeMessage_2", p7ds.getContentInfo());
                }
                return p7ds.getContentInfo();
            }
            if (debug != null) {
                debug.text(8192L, className, "parseSMIMEMimeMessage_2", "Unknown S/MIME PKCS #7 message type.");
            }
            throw new IOException("Unknown S/MIME PKCS #7 message type.");
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "parseSMIMEMimeMessage_3", null);
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors;
        block7: {
            block6: {
                flavors = new DataFlavor[4];
                if (debug != null) {
                    debug.entry(16384L, className, "getTransferDataFlavors");
                }
                try {
                    flavors[0] = new ActivationDataFlavor(Class.forName("java.lang.String"), "application/pkcs7-mime", "PKCS7 MIME");
                }
                catch (Exception e2) {
                    if (debug == null) break block6;
                    debug.exception(16384L, className, "getTransferDataFlavors", e2);
                }
            }
            flavors[1] = new DataFlavor("application/pkcs7-mime", "PKCS7 MIME");
            try {
                flavors[2] = new ActivationDataFlavor(Class.forName("java.lang.String"), "application/pkcs7-signature", "PKCS7 Signature MIME");
            }
            catch (Exception e3) {
                if (debug == null) break block7;
                debug.exception(16384L, className, "getTransferDataFlavors", e3);
            }
        }
        flavors[3] = new DataFlavor("application/pkcs7-signature", "PKCS7 Signature MIME");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getTransferDataFlavors", flavors);
        }
        return flavors;
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getTransferData", df, ds);
        }
        if (df == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataFlavor is null");
            }
            throw new IOException("DataFlavor is null");
        }
        if (ds == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "DataSource is null");
            }
            throw new IOException("DataSource is null");
        }
        String mimeType = df.getMimeType();
        if (!mimeType.equals("application/pkcs7-mime") && !mimeType.equals("application/pkcs7-signature")) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", "Dataflavor mimetype " + mimeType + " is not supported by PKCS7NewMimeHandler.");
            }
            throw new IOException("Dataflavor mimetype " + mimeType + " is not supported by PKCS7NewMimeHandler.");
        }
        if (!df.getRepresentationClass().getName().equals(PKCS7NEWMIMEDATASOURCE_CLASSNAME)) {
            if (debug != null) {
                debug.text(16384L, className, "getTransferData", df.getRepresentationClass().getName() + " not supported by PKCS7NewMimeHandler.");
            }
            throw new IOException(df.getRepresentationClass().getName() + " not supported by PKCS7NewMimeHandler.");
        }
        try {
            ContentInfo ci = null;
            if (ds instanceof PKCS7NewMimeDataSource) {
                ci = ((PKCS7NewMimeDataSource)ds).getContentInfo();
            } else {
                ByteArrayInputStream bais = (ByteArrayInputStream)ds.getInputStream();
                int i2 = bais.available();
                byte[] bytes = new byte[i2];
                int read = bais.read(bytes, 0, i2);
                ci = new ContentInfo(bytes, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_1", ci);
            }
            return ci;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getTransferData", e2);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTransferData_2", null);
            }
            return null;
        }
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{obj, mimeType, os};
            debug.entry(16384L, (Object)className, "writeTo", parms);
        }
        if (obj instanceof ContentInfo) {
            ContentInfo ci = (ContentInfo)obj;
            ci.encode(os);
            if (debug != null) {
                debug.exit(16384L, className, "writeTo");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "writeTo", "obj must be of type ContentInfo.  Instead obj is of class " + obj.getClass().getName());
        }
        throw new IOException("obj must be of type ContentInfo.  Instead obj is of class " + obj.getClass().getName());
    }

    public String toString() {
        String out = "PKCS7NewMimeHandler";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

