/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.ec;

import com.ibm.misc.Debug;
import com.ibm.security.ec.ECParameters;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPublicKeyImpl
extends X509Key
implements ECPublicKey {
    private static final long serialVersionUID = -2462037275160462289L;
    private ECPoint w;
    private ECParameterSpec params;
    private static Debug debug = Debug.getInstance("ibmpkcs");

    public ECPublicKeyImpl(ECPoint w2, ECParameterSpec params) throws InvalidKeyException {
        this.w = w2;
        this.params = params;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(params));
        this.key = ECParameters.encodePoint(w2, params.getCurve());
    }

    public ECPublicKeyImpl(byte[] encoded) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, "ECPublicKeyImpl", "ECPublicKeyImpl(byte[])");
        }
        this.decode(encoded);
        if (debug != null) {
            debug.exit(16384L, "ECPublicKeyImpl", "ECPublicKeyImpl(byte[])");
        }
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public byte[] getEncodedPublicValue() {
        return (byte[])this.key.clone();
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, "ECPublicKeyImpl", "parseKeyBits");
        }
        try {
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (debug != null) {
                debug.text(16384L, "ECPublicKeyImpl", "parseKeyBits", algParams.toString());
            }
            this.params = algParams.getParameterSpec(ECParameterSpec.class);
            this.w = ECParameters.decodePoint(this.key, this.params.getCurve());
        }
        catch (IOException e2) {
            throw new InvalidKeyException("Invalid EC key", e2);
        }
        catch (InvalidParameterSpecException e3) {
            throw new InvalidKeyException("Invalid EC key", e3);
        }
        if (debug != null) {
            debug.exit(16384L, "ECPublicKeyImpl", "parseKeyBits");
        }
    }

    @Override
    public String toString() {
        return "IBM EC public key, " + this.params.getCurve().getField().getFieldSize() + " bits\n  public x coord: " + this.w.getAffineX() + "\n  public y coord: " + this.w.getAffineY() + "\n  parameters: " + this.params;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }
}

