/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class Challenge
extends CMPDerObject {
    private AlgorithmId owf;
    private byte[] witness;
    private byte[] challenge;

    public Challenge(AlgorithmId algorithmId, byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Challenge error, witness not specified");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Challenge error, challenge not specified");
        }
        this.owf = algorithmId;
        this.witness = (byte[])byArray.clone();
        this.challenge = (byte[])byArray2.clone();
    }

    public Challenge(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new Challenge(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("Challenge parsing error, not a SEQUENCE");
        }
        this.owf = null;
        this.witness = null;
        this.challenge = null;
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() == 48) {
            this.owf = AlgorithmId.parse(derValue2);
            if (derValue.getData().available() == 0) {
                throw new IOException("Challenge parsing error, missing data");
            }
            derValue2 = derValue.getData().getDerValue();
        }
        this.witness = derValue2.getOctetString();
        if (derValue.getData().available() == 0) {
            throw new IOException("Challenge parsing error, missing data");
        }
        this.challenge = derValue.getData().getOctetString();
        if (derValue.getData().available() != 0) {
            throw new IOException("Challenge parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.owf != null) {
            this.owf.encode(derOutputStream);
        }
        if (this.witness == null) {
            throw new IOException("Challenge encoding error, witness not specified");
        }
        derOutputStream.putOctetString(this.witness);
        if (this.challenge == null) {
            throw new IOException("Challenge encoding error, challenge not specified");
        }
        derOutputStream.putOctetString(this.challenge);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(Challenge challenge) {
        DerValue derValue;
        DerValue derValue2;
        if (challenge == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            challenge.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof Challenge) {
            return this.equals((Challenge)object);
        }
        return false;
    }

    public byte[] getChallenge() {
        return (byte[])this.challenge.clone();
    }

    public AlgorithmId getOwf() throws IOException {
        if (this.owf == null) {
            return null;
        }
        return new AlgorithmId(this.owf.getOID(), this.owf.getParameters());
    }

    public byte[] getWitness() {
        return (byte[])this.witness.clone();
    }

    public String toString() {
        String string = "Challenge:";
        if (this.owf != null) {
            string = String.valueOf(string) + "\r\n\tone-way-function: " + this.owf.toString();
        }
        if (this.witness != null) {
            string = String.valueOf(string) + "\r\n\twitness: " + new String(this.witness);
        }
        if (this.challenge != null) {
            string = String.valueOf(string) + "\r\n\tchallenge: " + new String(this.challenge);
        }
        return string;
    }
}

