/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.routing.member.ApplicationRoutingInfoMBean;
import com.ibm.ws.collective.routing.member.internal.ApplicationRoutingInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.Hashtable;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.StandardEmitterMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ApplicationRoutingInfoMBeanImpl
extends StandardEmitterMBean
implements ApplicationRoutingInfoMBean {
    private static final TraceComponent tc = Tr.register(ApplicationRoutingInfoMBeanImpl.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    private ServiceRegistration<ApplicationRoutingInfoMBean> serviceRegistration;
    private ApplicationRoutingInfo ari;
    private JSONObject ariAsJSON = new JSONObject();
    private int sequenceRoutingInfo = 0;
    static final long serialVersionUID = -9198511754959756586L;

    @Override
    @Trivial
    public String getRoutingInfo() {
        return this.ariAsJSON.toString();
    }

    public ApplicationRoutingInfoMBeanImpl(ApplicationRoutingInfo ari) throws NotCompliantMBeanException {
        super(ApplicationRoutingInfoMBean.class, false, (NotificationEmitter)new NotificationBroadcasterSupport(new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Attribute change notifications")));
        this.fillAttributes(ari);
    }

    protected void update(ApplicationRoutingInfo ari) {
        String prevappRoutingInfo = this.ariAsJSON.toString();
        this.fillAttributes(ari);
        this.notifyMBeanServer(++this.sequenceRoutingInfo, "RoutingInfo", prevappRoutingInfo, this.getRoutingInfo());
        Tr.info((TraceComponent)tc, (String)"Routing.application.routing.info.mbean.updated", (Object[])new Object[]{ari.getApplicationName()});
    }

    private void fillAttributes(ApplicationRoutingInfo ari) {
        this.ari = ari;
        JSONArray webmodules = new JSONArray();
        for (int i = 0; i < ari.getWMRIs().size(); ++i) {
            for (int j = 0; j < ari.getWMRIs().get(i).getJsonRepresentation().size(); ++j) {
                webmodules.addAll((Collection)ari.getWMRIs().get(i).getJsonRepresentation());
            }
        }
        this.ariAsJSON = new JSONObject();
        this.ariAsJSON.put((Object)"name", (Object)ari.getJ2EEName().toString());
        this.ariAsJSON.put((Object)"webModules", (Object)webmodules);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attributes filled as  " + this.ariAsJSON.toString()), (Object[])new Object[0]);
        }
    }

    protected void register() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.vendor", "IBM");
        properties.put("jmx.objectname", "WebSphere:feature=collectiveMember,type=ApplicationRoutingInfoMBean,name=" + this.ari.getApplicationName());
        BundleContext bundleContext = FrameworkUtil.getBundle(ApplicationRoutingInfoMBeanImpl.class).getBundleContext();
        this.serviceRegistration = bundleContext.registerService(ApplicationRoutingInfoMBean.class.getName(), (Object)this, properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("ApplicationRoutingInfoMBean registered for application " + this.ari.getApplicationName() + " with " + this.ari.getWMRIs().size() + " web modules."), (Object[])new Object[0]);
        }
    }

    protected void unregister() {
        this.serviceRegistration.unregister();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("ApplicationRoutingInfoMBean unregistered for application " + this.ari.getApplicationName()), (Object[])new Object[0]);
        }
    }

    private void notifyMBeanServer(int sequence, String attributeName, Object prevValue, Object newValue) {
        super.sendNotification(new AttributeChangeNotification(this, sequence, System.currentTimeMillis(), attributeName + " updated", attributeName, newValue.getClass().getName(), prevValue, newValue));
    }
}

