/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATOrderingContext;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSideConnection;
import com.ibm.ws.sib.comms.server.clientsupport.ServerTransportAcceptListener;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.server.ServerConnectionManager;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ServerCommsDiagnosticDump {
    private static final TraceComponent tc = SibTr.register(ServerCommsDiagnosticDump.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static void dump(FormattedWriter writer, String arg) {
        new ServerCommsDiagnosticDump().dumpCommunications(writer, arg);
    }

    private ServerCommsDiagnosticDump() {
    }

    private void dumpCommunications(FormattedWriter writer, String arg) {
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpCommunications", (Object)new Object[]{writer, arg});
            }
            StringTokenizer st = new StringTokenizer(arg, ":");
            boolean found = false;
            while (st.hasMoreElements()) {
                if (!st.nextToken().endsWith("ServerCommsDiagnosticDump")) continue;
                found = true;
                break;
            }
            try {
                if (found) {
                    writer.newLine();
                    writer.startTag(this.getClass().getSimpleName());
                    writer.indent();
                    writer.newLine();
                    writer.startTag("MEtoMECommunications");
                    writer.indent();
                    this.dumpMEtoMEConversations(writer);
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("MEtoMECommunications");
                    writer.newLine();
                    writer.startTag("InboundCommunications");
                    writer.indent();
                    this.dumpInboundConversations(writer);
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("InboundCommunications");
                    writer.outdent();
                    writer.newLine();
                    writer.endTag(this.getClass().getSimpleName());
                }
            }
            catch (Exception exception) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught writing ServerCommunications dump!", (Object)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpCommunications");
        }
    }

    private void dumpMEtoMEConversations(FormattedWriter writer) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpMEtoMEConversations", (Object)writer);
        }
        List conversations = ServerConnectionManager.getRef().getActiveOutboundMEtoMEConversations();
        Map<Object, List<Conversation>> connectionToConversationMap = this.buildConnectionMap(conversations);
        for (Map.Entry<Object, List<Conversation>> entry : connectionToConversationMap.entrySet()) {
            Object connectionObject = entry.getKey();
            writer.newLine();
            writer.startTag("CommsConnection");
            writer.newLine();
            writer.taggedValue("ME-ME connection", connectionObject);
            for (Conversation conversation : entry.getValue()) {
                this.dumpMEtoMEConversation(writer, conversation);
            }
            writer.outdent();
            writer.newLine();
            writer.endTag("CommsConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpMEtoMEConversations");
        }
    }

    private void dumpInboundConversations(FormattedWriter writer) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpInboundConversations", (Object)writer);
        }
        List conversations = ServerTransportAcceptListener.getInstance().getActiveConversations();
        Map<Object, List<Conversation>> connectionToConversationMap = this.buildConnectionMap(conversations);
        for (Map.Entry<Object, List<Conversation>> entry : connectionToConversationMap.entrySet()) {
            Object connectionObject = entry.getKey();
            writer.newLine();
            writer.startTag("CommsConnection");
            writer.newLine();
            writer.taggedValue("Inbound connection", connectionObject);
            for (Conversation conversation : entry.getValue()) {
                this.dumpServerConversation(writer, conversation);
            }
            writer.outdent();
            writer.newLine();
            writer.endTag("CommsConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpInboundConversations");
        }
    }

    private Map<Object, List<Conversation>> buildConnectionMap(List<Conversation> conversations) throws IOException {
        HashMap<Object, List<Conversation>> connectionToConversationMap = new HashMap<Object, List<Conversation>>();
        if (conversations != null) {
            for (Conversation c : conversations) {
                List<Conversation> conversationList;
                ConnectionInterface connectionObject = c.getConnectionReference();
                if (!connectionToConversationMap.containsKey(connectionObject)) {
                    conversationList = new LinkedList();
                    connectionToConversationMap.put(connectionObject, conversationList);
                } else {
                    conversationList = (List)connectionToConversationMap.get(connectionObject);
                }
                conversationList.add(c);
            }
        }
        return connectionToConversationMap;
    }

    private void dumpServerConversation(FormattedWriter writer, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpServerConversation", (Object)new Object[]{writer, conversation});
        }
        try {
            writer.newLine();
            writer.startTag("Conversation");
            writer.indent();
            writer.newLine();
            writer.taggedValue("Summary", (Object)conversation.getFullSummary());
            ConversationState conversationState = (ConversationState)conversation.getAttachment();
            List conversatiobObjects = conversationState.getAllObjects();
            for (Object object : conversatiobObjects) {
                if (object instanceof CATConnection) {
                    writer.newLine();
                    writer.taggedValue("CATConnection", (Object)((CATConnection)object));
                    continue;
                }
                if (object instanceof ServerSideConnection) {
                    writer.newLine();
                    writer.startTag("ServerSideConnection");
                    writer.indent();
                    ServerSideConnection conn = (ServerSideConnection)((Object)object);
                    writer.newLine();
                    writer.taggedValue("toString", (Object)conn);
                    writer.newLine();
                    writer.taggedValue("CommsConnection", (Object)conn.getCommsConnection());
                    writer.newLine();
                    writer.taggedValue("Info", (Object)conn.getConnectionInfo());
                    writer.newLine();
                    writer.taggedValue("ObjectID", (long)conn.getConnectionObjectID());
                    writer.newLine();
                    writer.taggedValue("MetaData", (Object)conn.getMetaData());
                    writer.newLine();
                    writer.taggedValue("RequestNumber", (long)conn.getRequestNumber());
                    writer.outdent();
                    writer.newLine();
                    writer.endTag("ServerSideConnection");
                    continue;
                }
                if (object instanceof CATOrderingContext) {
                    writer.newLine();
                    writer.taggedValue("CATOrderingContext", (Object)((CATOrderingContext)object));
                    continue;
                }
                if (object instanceof CATMainConsumer) {
                    ((CATMainConsumer)object).dump(writer);
                    continue;
                }
                writer.newLine();
                writer.taggedValue("other", object);
            }
            writer.outdent();
            writer.newLine();
            writer.endTag("Conversation");
        }
        catch (Throwable t) {
            try {
                writer.write("\nUnable to dump conversation " + t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpServerConversation");
        }
    }

    private void dumpMEtoMEConversation(FormattedWriter writer, Conversation conversation) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpMEtoMEConversation", (Object)new Object[]{writer, conversation});
        }
        try {
            writer.newLine();
            writer.startTag("Conversation");
            writer.indent();
            writer.newLine();
            writer.taggedValue("Summary", (Object)conversation.getFullSummary());
            ConversationState convState = (ConversationState)conversation.getAttachment();
            MEConnection commsConnection = (MEConnection)convState.getCommsConnection();
            writer.taggedValue("commsConnection", (Object)commsConnection);
            JsMessagingEngine me = commsConnection.getMessagingEngine();
            String meInfo = me == null ? "<null>" : me.getName() + " [" + me.getUuid() + "]";
            writer.taggedValue("Local ME: ", (Object)meInfo);
            writer.taggedValue("Target ME: ", (Object)commsConnection.getTargetInformation());
            writer.outdent();
            writer.newLine();
            writer.endTag("Conversation");
        }
        catch (Throwable t) {
            try {
                writer.write("\nUnable to dump conversation " + t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpMEtoMEConversation");
        }
    }
}

