/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.extprocessor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsf.shared.JSFConstants;
import com.ibm.ws.jsf.shared.cdi.CDIJSFInitializer;
import com.ibm.ws.jsf.shared.extprocessor.JSFExtensionProcessor;
import com.ibm.ws.jsf.shared.util.FacesMessages;
import com.ibm.ws.jsf.shared.util.JspURIMatcher;
import com.ibm.ws.jsf.shared.util.WSFacesUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.net.URL;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.servlet.ServletContextListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JSFExtensionFactory
implements ExtensionFactory {
    protected static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.extprocessor.JSFExtensionFactory";
    private static final String FACES_SERVLET_RESOURCE = "javax/faces/webapp/FacesServlet.class";
    private static final String SUN_CONFIGURE_LISTENER_CLASSNAME = "com.sun.faces.config.ConfigureListener";
    private static final String MYFACES_LIFECYCLE_LISTENER_CLASSNAME = "org.apache.myfaces.webapp.StartupServletContextListener";
    private static final String sunRIClassToSearch = "com/sun/faces/vendor/WebSphereInjectionProvider.class";
    private URL defaultFacesServlet;
    private String applicationName;
    private static final String SUN_LISTENER_REGISTERED_STRING = "sunListenerRegistered";
    private static final String MYFACES_LISTENER_REGISTERED_STRING = "myfacesListenerRegistered";
    private static final String NO_LISTENER_REGISTERED_STRING = "noListenerFound";
    private JSFConstants.JSFImplEnabled jsfImplEnabled;
    private final AtomicReference<ClassLoadingService> classLoadingSRRef;
    private static final AtomicServiceReference<SerializationService> serializationServiceRef = new AtomicServiceReference("serializationService");
    protected final AtomicServiceReference<CDIJSFInitializer> cdiJSFInitializerService;
    private static final AtomicReference<JSFExtensionFactory> instance = new AtomicReference();
    static final long serialVersionUID = 5176916594225276531L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSFExtensionFactory() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        this.defaultFacesServlet = null;
        this.applicationName = null;
        this.jsfImplEnabled = null;
        this.classLoadingSRRef = new AtomicReference<Object>(null);
        this.cdiJSFInitializerService = new AtomicServiceReference("cdiJSFInitializerService");
        this.defaultFacesServlet = WSFacesUtil.getClassLoader((Object)this).getResource(FACES_SERVLET_RESOURCE);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "<clinit>", "defaultFacesServlet = " + this.defaultFacesServlet);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void activate(ComponentContext compcontext, Map<String, Object> properties) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "activate", new Object[]{compcontext, properties});
        }
        instance.set(this);
        serializationServiceRef.activate(compcontext);
        this.cdiJSFInitializerService.activate(compcontext);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deactivate(ComponentContext compcontext) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "deactivate", new Object[]{compcontext});
        }
        serializationServiceRef.deactivate(compcontext);
        this.cdiJSFInitializerService.deactivate(compcontext);
        instance.compareAndSet(this, null);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setCdiJSFInitializerService(ServiceReference<CDIJSFInitializer> cdiJSFInitializerService) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "setCdiJSFInitializerService", new Object[]{cdiJSFInitializerService});
        }
        this.cdiJSFInitializerService.setReference(cdiJSFInitializerService);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "setCdiJSFInitializerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetCdiJSFInitializerService(ServiceReference<CDIJSFInitializer> setCdiJSFInitializerService) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "unsetCdiJSFInitializerService", new Object[]{setCdiJSFInitializerService});
        }
        this.cdiJSFInitializerService.unsetReference(setCdiJSFInitializerService);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "unsetCdiJSFInitializerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setClassLoadingService(ClassLoadingService ref) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "setClassLoadingService", new Object[]{ref});
        }
        this.classLoadingSRRef.set(ref);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "setClassLoadingService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetClassLoadingService(ClassLoadingService ref) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "unsetClassLoadingService", new Object[]{ref});
        }
        this.classLoadingSRRef.set(null);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "unsetClassLoadingService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setSerializationService(ServiceReference<SerializationService> ref) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "setSerializationService", new Object[]{ref});
        }
        serializationServiceRef.setReference(ref);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "setSerializationService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetSerializationService(ServiceReference<SerializationService> ref) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "unsetSerializationService", new Object[]{ref});
        }
        serializationServiceRef.unsetReference(ref);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "unsetSerializationService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SerializationService getSerializationService() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "getSerializationService", new Object[0]);
        }
        SerializationService serializationService = (SerializationService)serializationServiceRef.getService();
        if (log != null && log.isLoggable(Level.FINER)) {
            serializationService = serializationService;
            log.exiting(CLASS_NAME, "getSerializationService", serializationService);
        }
        return serializationService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExtensionProcessor createExtensionProcessor(IServletContext webapp) throws Exception {
        WebAppConfig config;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "createExtensionProcessor", new Object[]{webapp});
        }
        this.applicationName = webapp.getServletContextName();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Enter createExtensionProcessor(): webapp =[" + this.applicationName + "]");
        }
        if (!this.isFacesApp(config = webapp.getWebAppConfig())) {
            webapp.setAttribute("com.ibm.ws.jsf.JSF_IMPL_ENABLED", (Object)JSFConstants.JSFImplEnabled.None);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Exit createExtensionProcessor(): JSF is not enabled for webapp =[" + this.applicationName + "]");
            }
            ExtensionProcessor extensionProcessor = null;
            if (log != null && log.isLoggable(Level.FINER)) {
                extensionProcessor = extensionProcessor;
                log.exiting(CLASS_NAME, "createExtensionProcessor", extensionProcessor);
            }
            return extensionProcessor;
        }
        this.initFaces(webapp, config);
        webapp.setAttribute("com.ibm.ws.jsf.JSF_IMPL_ENABLED", (Object)this.jsfImplEnabled);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Exit createExtensionProcessor(): JSF is enabled for webapp: [" + this.applicationName + "] using implementation=[" + this.jsfImplEnabled + "]");
        }
        JSFExtensionProcessor jSFExtensionProcessor = new JSFExtensionProcessor(webapp);
        if (log != null && log.isLoggable(Level.FINER)) {
            jSFExtensionProcessor = jSFExtensionProcessor;
            log.exiting(CLASS_NAME, "createExtensionProcessor", jSFExtensionProcessor);
        }
        return jSFExtensionProcessor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initFaces(IServletContext webapp, WebAppConfig config) throws Exception {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "initFaces", new Object[]{webapp, config});
        }
        ClassLoader appClassLoader = WSFacesUtil.getContextClassLoader((IServletContext)webapp);
        ClassLoader ourClassLoader = JSFExtensionFactory.class.getClassLoader();
        URL webappFacesServlet = appClassLoader.getResource(FACES_SERVLET_RESOURCE);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "initFaces", "webappFacesServlet equals " + webappFacesServlet.getPath());
            log.logp(Level.FINE, CLASS_NAME, "initFaces", "webappFacesServlet path equals " + webappFacesServlet.getPath());
        }
        boolean usingCustomJar = false;
        boolean usingDefaultSunRIJar = false;
        boolean usingDefaultMyFacesJar = false;
        if (!this.defaultFacesServlet.equals(webappFacesServlet)) {
            usingCustomJar = true;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "using a custom jar");
            }
        } else if (appClassLoader.getResource(sunRIClassToSearch) != null) {
            usingDefaultSunRIJar = true;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Using the sunRI runtime jar");
            }
        } else {
            usingDefaultMyFacesJar = true;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Using the myFaces runtime jar");
            }
        }
        String listenerFound = this.checkForListeners(config);
        if (usingCustomJar) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Webapp [" + this.applicationName + "] overrode default Faces Servlet. WebSphere Myfaces JSF config will be ignored.");
            }
            this.handleJSPUpdateCheck(webapp);
            this.jsfImplEnabled = JSFConstants.JSFImplEnabled.Custom;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Webapp [" + this.applicationName + "] is providing a third party JSF runtime.");
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "FacesServlet URL path=[" + webappFacesServlet.getPath() + "]");
            }
        } else if (usingDefaultSunRIJar) {
            this.handleJSPUpdateCheck(webapp);
            this.jsfImplEnabled = JSFConstants.JSFImplEnabled.SunRI;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Sun RI 1.2 JSF Implementation detected and will be used to configure the webapp for  [" + this.applicationName + "].");
            }
            if (!listenerFound.equals(SUN_LISTENER_REGISTERED_STRING)) {
                boolean sunListenerInitialized;
                if (listenerFound.equals(MYFACES_LISTENER_REGISTERED_STRING) && log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg((String)"jsf.warn.myfaces.listener.for.ri.app", (Object[])new Object[]{this.applicationName}));
                }
                if (sunListenerInitialized = this.registerListener(webapp, SUN_CONFIGURE_LISTENER_CLASSNAME, appClassLoader)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "initFaces", "Sun RI 1.2 JSF Implementation listener is initialized for [" + this.applicationName + "].");
                    }
                    this.jsfImplEnabled = JSFConstants.JSFImplEnabled.SunRI;
                } else {
                    this.jsfImplEnabled = JSFConstants.JSFImplEnabled.Custom;
                    if (log.isLoggable(Level.WARNING)) {
                        log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg((String)"jsf.warn.ri.impl.not.initialized", (Object[])new Object[]{this.applicationName}));
                    }
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Sun RI 1.2 listener already configured, skipping listener registration for  [" + this.applicationName + "].");
            }
        } else if (usingDefaultMyFacesJar) {
            this.jsfImplEnabled = JSFConstants.JSFImplEnabled.MyFaces;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "MyFaces JSF Implementation detected and will be used to configure the webapp for  [" + this.applicationName + "].");
            }
            if (listenerFound.equals(MYFACES_LISTENER_REGISTERED_STRING)) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initFaces", "MyFaces listener already configured, skipping listener registration for  [" + this.applicationName + "].");
                }
            } else {
                boolean myfacesListenerInitialized;
                if (listenerFound.equals(SUN_LISTENER_REGISTERED_STRING) && log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg((String)"jsf.warn.ri.listener.for.myfaces.app", (Object[])new Object[]{this.applicationName}));
                }
                if ((myfacesListenerInitialized = this.registerListener(webapp, MYFACES_LIFECYCLE_LISTENER_CLASSNAME, ourClassLoader)) && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initFaces", "MyFaces listener is initialized for [" + this.applicationName + "].");
                }
                if (!myfacesListenerInitialized && log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg((String)"jsf.warn.myfaces.not.initialized", (Object[])new Object[]{this.applicationName}));
                }
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "initFaces");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List getPatternList() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "getPatternList", new Object[0]);
        }
        List list = Collections.EMPTY_LIST;
        if (log != null && log.isLoggable(Level.FINER)) {
            list = list;
            log.exiting(CLASS_NAME, "getPatternList", list);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean registerListener(IServletContext webapp, String listenerClassName, ClassLoader classLoader) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "registerListener", new Object[]{webapp, listenerClassName, classLoader});
        }
        try {
            ServletContextListener listener = (ServletContextListener)Class.forName(listenerClassName, true, classLoader).newInstance();
            webapp.addLifecycleListener((EventListener)listener);
        }
        catch (Exception listener) {
            FFDCFilter.processException((Throwable)listener, (String)CLASS_NAME, (String)"282", (Object)this, (Object[])new Object[]{webapp, listenerClassName, classLoader});
            if (log.isLoggable(Level.WARNING)) {
                void e;
                log.logp(Level.WARNING, CLASS_NAME, "registerListener", FacesMessages.getMsg((String)"jsf.warn.exception.during.listener", (Object[])new Object[]{listenerClassName, this.applicationName}), (Throwable)e);
            }
            boolean bl = false;
            if (log != null && log.isLoggable(Level.FINER)) {
                bl = bl;
                log.exiting(CLASS_NAME, "registerListener", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting(CLASS_NAME, "registerListener", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String checkForListeners(WebAppConfig config) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "checkForListeners", new Object[]{config});
        }
        String listenerFound = NO_LISTENER_REGISTERED_STRING;
        if (config != null) {
            List listeners = config.getListeners();
            for (Object listener : listeners) {
                if (!(listener instanceof String)) continue;
                String listenerClassname = (String)listener;
                if (listenerClassname.equals(SUN_CONFIGURE_LISTENER_CLASSNAME)) {
                    listenerFound = SUN_LISTENER_REGISTERED_STRING;
                    break;
                }
                if (!listenerClassname.equals(MYFACES_LIFECYCLE_LISTENER_CLASSNAME)) continue;
                listenerFound = MYFACES_LISTENER_REGISTERED_STRING;
                break;
            }
        }
        String string = listenerFound;
        if (log != null && log.isLoggable(Level.FINER)) {
            string = string;
            log.exiting(CLASS_NAME, "checkForListeners", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isFacesApp(WebAppConfig config) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "isFacesApp", new Object[]{config});
        }
        Iterator servletConfigs = config.getServletInfos();
        while (servletConfigs.hasNext()) {
            String servletClass = ((IServletConfig)servletConfigs.next()).getClassName();
            if (!"javax.faces.webapp.FacesServlet".equals(servletClass) && !"org.apache.myfaces.webapp.MyFacesServlet".equals(servletClass)) continue;
            boolean bl = true;
            if (log != null && log.isLoggable(Level.FINER)) {
                bl = bl;
                log.exiting(CLASS_NAME, "isFacesApp", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (log != null && log.isLoggable(Level.FINER)) {
            bl = bl;
            log.exiting(CLASS_NAME, "isFacesApp", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void handleJSPUpdateCheck(IServletContext webapp) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "handleJSPUpdateCheck", new Object[]{webapp});
        }
        String jspUpdateCheckEnabled = webapp.getInitParameter("com.ibm.ws.jsf.JSP_UPDATE_CHECK");
        if (jspUpdateCheckEnabled != null && jspUpdateCheckEnabled.equalsIgnoreCase("TRUE")) {
            JspURIMatcher matcher = new JspURIMatcher(webapp);
            webapp.setAttribute("com.ibm.ws.jsf.JSP_URI_MATCHER", (Object)matcher);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "handleJSPUpdateCheck");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void initializeCDIJSFELContextListenerAndELResolver(Application application) {
        CDIJSFInitializer cdiInitializer;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "initializeCDIJSFELContextListenerAndELResolver", new Object[]{application});
        }
        JSFExtensionFactory factory = instance.get();
        if (factory != null && factory.cdiJSFInitializerService != null && (cdiInitializer = (CDIJSFInitializer)factory.cdiJSFInitializerService.getService()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initializeCDIJSFELContextListenerAndELResolver", "Initializing app ELContextListener and ELResolver");
            }
            cdiInitializer.initializeCDIJSFELContextListenerAndELResolver(application);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "initializeCDIJSFELContextListenerAndELResolver");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void initializeCDIJSFViewHandler(Application application) {
        CDIJSFInitializer cdiInitializer;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "initializeCDIJSFViewHandler", new Object[]{application});
        }
        JSFExtensionFactory factory = instance.get();
        if (factory != null && factory.cdiJSFInitializerService != null && (cdiInitializer = (CDIJSFInitializer)factory.cdiJSFInitializerService.getService()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initializeCDIJSFViewHandler", "Initializing app ViewHandler");
            }
            cdiInitializer.initializeCDIJSFViewHandler(application);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "initializeCDIJSFViewHandler");
        }
    }
}

