/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.ref;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.CacheStatistics;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionCache;
import com.ibm.ws.sib.msgstore.cache.ref.StoredItemManager;
import com.ibm.ws.sib.msgstore.cache.ref.UnstoredItemManager;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public final class ItemStorageManager
implements MessageStoreConstants,
CacheStatistics,
XmlConstants {
    private static TraceComponent tc = SibTr.register(ItemStorageManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private StoredItemManager _storedItemManager = null;
    private UnstoredItemManager _unstoredItemManager = null;

    public final IndirectionCache register(int storageStrategy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"register", (Object)("StorageStrategy=" + storageStrategy));
        }
        IndirectionCache cache = null;
        if (1 == storageStrategy) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using UnstoredItemManager");
            }
            cache = this._unstoredItemManager;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using StoredItemManager");
            }
            cache = this._storedItemManager;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"register", (Object)cache);
        }
        return cache;
    }

    public final long getCurrentCount() {
        long result = 0L;
        result += this._storedItemManager.getCurrentCount();
        return result += this._unstoredItemManager.getCurrentCount();
    }

    public final long getCurrentSize() {
        long result = 0L;
        result += this._storedItemManager.getCurrentSize();
        return result += this._unstoredItemManager.getCurrentSize();
    }

    public final long getDiscardableSize() {
        long result = 0L;
        result += this._storedItemManager.getStatistics().getDiscardableSize();
        return result += this._unstoredItemManager.getStatistics().getDiscardableSize();
    }

    public final long getMaximumSize() {
        long result = 0L;
        result += this._storedItemManager.getMaximumSize();
        return result += this._unstoredItemManager.getMaximumSize();
    }

    public final CacheStatistics getNonStoredCacheStatistics() {
        return this._unstoredItemManager.getStatistics();
    }

    public final CacheStatistics getStoredCacheStatistics() {
        return this._storedItemManager.getStatistics();
    }

    public final long getTotalCount() {
        long result = 0L;
        result += this._storedItemManager.getStatistics().getTotalCount();
        return result += this._unstoredItemManager.getStatistics().getTotalCount();
    }

    public final long getTotalDiscardCount() {
        long result = 0L;
        result += this._storedItemManager.getTotalDiscardCount();
        return result += this._unstoredItemManager.getTotalDiscardCount();
    }

    public final long getTotalDiscardSize() {
        long result = 0L;
        result += this._storedItemManager.getTotalDiscardSize();
        return result += this._unstoredItemManager.getTotalDiscardSize();
    }

    public final long getTotalRefusalCount() {
        long result = 0L;
        result += this._storedItemManager.getStatistics().getTotalRefusalCount();
        return result += this._unstoredItemManager.getStatistics().getTotalRefusalCount();
    }

    public final long getTotalSize() {
        long result = 0L;
        result += this._storedItemManager.getStatistics().getTotalSize();
        return result += this._unstoredItemManager.getStatistics().getTotalSize();
    }

    public final void initialize(MessageStoreImpl messageStore) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize");
        }
        String str = messageStore.getProperty("cachedDataBufferSize", "40000000");
        long maximumSize = Long.parseLong(str);
        str = messageStore.getProperty("cachedDataItemMaximumSize", "400000");
        long maximumItemSize = Long.parseLong(str);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("StoredItemManager size = " + maximumSize));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("StoredItemManager max size = " + maximumItemSize));
        }
        if (maximumSize <= 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
            }
            throw new SevereMessageStoreException("invalid setting: cachedDataBufferSize=" + maximumSize);
        }
        this._storedItemManager = new StoredItemManager(maximumSize, maximumItemSize);
        str = messageStore.getProperty("discardableDataBufferSize", "1280000");
        maximumSize = Long.parseLong(str);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("UnstoredItemManager size = " + maximumSize));
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("UnstoredItemManager max size = " + maximumItemSize));
        }
        if (maximumSize <= 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
            }
            throw new SevereMessageStoreException("invalid setting: discardableDataBufferSize=" + maximumSize);
        }
        this._unstoredItemManager = new UnstoredItemManager(maximumSize, maximumItemSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    public final void resetTotals() {
        this._storedItemManager.getStatistics().resetTotals();
        this._unstoredItemManager.getStatistics().resetTotals();
    }

    public final void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.startTag("itemStorageManager");
        writer.indent();
        this._storedItemManager.xmlWriteOn(writer);
        this._unstoredItemManager.xmlWriteOn(writer);
        writer.outdent();
        writer.newLine();
        writer.endTag("itemStorageManager");
    }
}

