/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.provisioning.AbstractResourceRepository;
import com.ibm.ws.kernel.provisioning.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class NameBasedLocalBundleRepository
extends AbstractResourceRepository {
    private static final String DEFAULT_LOCATION = "lib/";
    private final File rootDirectory;
    private final Messages msgs;
    private final Map<String, SymbolicNameResources> resourcesBySymbolicName = new HashMap<String, SymbolicNameResources>(1024);
    private final Set<String> locations = new HashSet<String>();

    public NameBasedLocalBundleRepository(File installDir) {
        this.rootDirectory = installDir;
        this.msgs = new Messages(){

            @Override
            public void warning(String key, Object ... inserts) {
                String msg = BootstrapConstants.messages.getString(key);
                if (inserts == null || inserts.length == 0) {
                    System.out.println(msg);
                } else {
                    System.out.println(MessageFormat.format(msg, inserts));
                }
            }
        };
        this.includeBaseLocation(DEFAULT_LOCATION);
    }

    public File selectBundle(String symbolicName, VersionRange versionRange) {
        return this.selectResource("", symbolicName, versionRange);
    }

    @Override
    public File getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    protected String getDefaultBaseLocation() {
        return DEFAULT_LOCATION;
    }

    @Override
    protected List<AbstractResourceRepository.Resource> getResourcesBySymbolicName(String symbolicName) {
        SymbolicNameResources resources = this.resourcesBySymbolicName.get(symbolicName);
        return resources == null ? Collections.emptyList() : resources.getResources();
    }

    @Override
    protected void includeBaseLocation(String baseLocation) {
        this.locations.add(baseLocation);
        File[] files = new File(this.rootDirectory, baseLocation).listFiles();
        if (files != null) {
            for (File file : files) {
                SymbolicNameResources resources;
                String symbolicName;
                SymbolicNameResources oldResources;
                int index;
                String name = file.getName();
                if (!name.endsWith(".jar") || (index = name.lastIndexOf(95)) == -1 || (oldResources = this.resourcesBySymbolicName.put(symbolicName = name.substring(0, index), resources = new SymbolicNameResources(file, baseLocation))) == null) continue;
                this.resourcesBySymbolicName.put(symbolicName, oldResources);
                oldResources.addFile(file, baseLocation);
            }
        }
    }

    @Override
    protected boolean isBaseLocationIncluded(String baseLocation) {
        return this.locations.contains(baseLocation);
    }

    @Override
    protected void warnThatAnIFixWasIgnored(String fileName, String symbolicName, int majorVersion, int minorVersion, int microVersion) {
        this.msgs.warning("warn.ifix.ignored", fileName, symbolicName + '_' + majorVersion + '.' + minorVersion + '.' + microVersion + ".jar");
    }

    private class BootstrapResource
    extends AbstractResourceRepository.Resource {
        private final File file;
        private final String baseLocation;
        private final Version version;
        private final boolean isFix;
        private final String symbolicName;

        public BootstrapResource(File file, String baseLocation) throws IOException {
            this.file = file;
            this.baseLocation = baseLocation;
            JarFile jar = new JarFile(file);
            Manifest man = jar.getManifest();
            jar.close();
            Attributes a = man.getMainAttributes();
            this.symbolicName = this.getSymbolicName(a);
            this.version = Version.parseVersion(a.getValue("Bundle-Version"));
            String iFixHeader = a.getValue("IBM-Interim-Fixes");
            String tFixHeader = a.getValue("IBM-Test-Fixes");
            this.isFix = iFixHeader != null || tFixHeader != null;
        }

        @Override
        protected File getFile() {
            return this.file;
        }

        @Override
        protected Version getVersion() {
            return this.version;
        }

        @Override
        protected String getBaseLocation() {
            return this.baseLocation;
        }

        @Override
        protected boolean isFix() {
            return this.isFix;
        }

        @Override
        protected String getSymbolicName() {
            return this.symbolicName;
        }

        private String getSymbolicName(Attributes attributes) {
            String value = attributes.getValue("Bundle-SymbolicName");
            int index = value != null ? value.indexOf(59) : -1;
            return index > 0 ? value.substring(0, index).trim() : value;
        }
    }

    private class SymbolicNameResources {
        private final File file;
        private final String baseLocation;
        private List<File> files;
        private List<String> baseLocations;
        private List<AbstractResourceRepository.Resource> resources;

        SymbolicNameResources(File file, String baseLocation) {
            this.file = file;
            this.baseLocation = baseLocation;
        }

        void addFile(File file, String baseLocation) {
            if (this.files == null) {
                this.files = new ArrayList<File>();
                this.files.add(this.file);
                this.baseLocations = new ArrayList<String>();
                this.baseLocations.add(this.baseLocation);
            }
            this.files.add(file);
            this.baseLocations.add(baseLocation);
            this.resources = null;
        }

        List<AbstractResourceRepository.Resource> getResources() {
            if (this.resources == null) {
                List<File> files = this.files != null ? this.files : Collections.singletonList(this.file);
                List<String> baseLocations = this.baseLocations != null ? this.baseLocations : Collections.singletonList(this.baseLocation);
                this.resources = new ArrayList<AbstractResourceRepository.Resource>(files.size());
                for (int i = 0; i < files.size(); ++i) {
                    try {
                        File file = files.get(i);
                        String baseLocation = baseLocations.get(i);
                        this.resources.add(new BootstrapResource(file, baseLocation));
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return this.resources;
        }
    }
}

