/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.client;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventImpl;
import org.apache.cxf.jaxrs.sse.client.InboundSseEventListener;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class InboundSseEventProcessor {
    public static final String SERVER_SENT_EVENTS = "text/event-stream";
    public static final MediaType SERVER_SENT_EVENTS_TYPE = MediaType.valueOf((String)"text/event-stream");
    private static final Logger LOG = LogUtils.getL7dLogger(InboundSseEventProcessor.class);
    private static final String COMMENT = ": ";
    private static final String EVENT = "event: ";
    private static final String ID = "id: ";
    private static final String RETRY = "retry: ";
    private static final String DATA = "data: ";
    private final Endpoint endpoint;
    private final InboundSseEventListener listener;
    private final ExecutorService executor;
    private volatile boolean closed;
    static final long serialVersionUID = 8385933904611815975L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InboundSseEventProcessor(Endpoint endpoint, InboundSseEventListener listener) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "<init>", new Object[]{endpoint, listener});
        }
        this.endpoint = endpoint;
        this.listener = listener;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void run(Response response) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "run", new Object[]{response});
        }
        if (this.closed) {
            throw new IllegalStateException("The SSE Event Processor is already closed");
        }
        InputStream is = (InputStream)response.readEntity(InputStream.class);
        ClientProviderFactory factory = ClientProviderFactory.getInstance((Endpoint)this.endpoint);
        Message message = null;
        if (response instanceof ResponseImpl) {
            message = ((ResponseImpl)response).getOutMessage();
        }
        this.executor.submit(this.process(response, is, factory, message));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "run");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Callable<?> process(Response response, InputStream is, ClientProviderFactory factory, Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "process", new Object[]{response, is, factory, message});
        }
        Callable<Object> callable = () -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                InboundSseEventImpl.Builder builder = null;
                while (line != null && !Thread.interrupted() && !this.closed) {
                    if (StringUtils.isEmpty((String)line) && builder != null) {
                        InboundSseEvent event = builder.build(factory, message);
                        builder = null;
                        this.listener.onNext(event);
                    } else if (line.startsWith(EVENT)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).name(line.substring(EVENT.length()));
                    } else if (line.startsWith(ID)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).id(line.substring(ID.length()));
                    } else if (line.startsWith(COMMENT)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).comment(line.substring(COMMENT.length()));
                    } else if (line.startsWith(RETRY)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).reconnectDelay(line.substring(RETRY.length()));
                    } else if (line.startsWith(DATA)) {
                        builder = InboundSseEventProcessor.getOrCreate(builder).data(line.substring(DATA.length()));
                    }
                    line = reader.readLine();
                }
                if (builder != null) {
                    this.listener.onNext(builder.build(factory, message));
                }
            }
            catch (Exception ex) {
                this.listener.onError(ex);
            }
            finally {
                this.listener.onComplete();
            }
            if (response != null) {
                LOG.fine("Closing the response");
                response.close();
            }
            return null;
        };
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            callable = callable;
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "process", callable);
        }
        return callable;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean isClosed() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "isClosed", new Object[0]);
        }
        boolean bl = this.closed;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "isClosed", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    boolean close(long timeout, TimeUnit unit) {
        boolean bl;
        block7: {
            block5: {
                boolean bl2;
                block6: {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.entering("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "close", new Object[]{timeout, unit});
                    }
                    try {
                        this.closed = true;
                        if (!this.executor.isShutdown()) break block5;
                        bl2 = true;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", (String)"147", (Object)this, (Object[])new Object[]{timeout, unit});
                        boolean bl3 = false;
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            bl3 = bl3;
                            LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "close", bl3);
                        }
                        return bl3;
                    }
                    bl2 = bl2;
                    LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "close", bl2);
                }
                return bl2;
            }
            AccessController.doPrivileged(() -> {
                this.executor.shutdown();
                return null;
            });
            bl = this.executor.awaitTermination(timeout, unit);
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "close", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static InboundSseEventImpl.Builder getOrCreate(InboundSseEventImpl.Builder builder) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "getOrCreate", new Object[]{builder});
        }
        InboundSseEventImpl.Builder builder2 = builder == null ? new InboundSseEventImpl.Builder() : builder;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            builder2 = builder2;
            LOG.exiting("org.apache.cxf.jaxrs.sse.client.InboundSseEventProcessor", "getOrCreate", builder2);
        }
        return builder2;
    }
}

