/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.ProducerType;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessageType;
import com.ibm.ws.sib.mfp.impl.JsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.schema.SubscriptionAccess;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SubscriptionMessageImpl
extends JsMessageImpl
implements SubscriptionMessage {
    private static final long serialVersionUID = 1L;
    private static final byte[] flattenedClassName;
    private static final TraceComponent tc;

    SubscriptionMessageImpl() {
    }

    SubscriptionMessageImpl(int flag) throws MessageDecodeFailedException {
        super(flag);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.jmo.getPayloadPart().setPart(1, SubscriptionAccess.schema);
        this.setJsMessageType(MessageType.SUBSCRIPTION);
        this.setProducerType(ProducerType.MP);
        this.setSubtype(0);
        this.setTopics(null);
        this.setTopicSpaces(null);
        this.setTopicSpaceMappings(null);
        this.setMEName(null);
        this.setMEUUID(null);
        this.setBusName(null);
    }

    SubscriptionMessageImpl(JsMsgObject inJmo) {
        super(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>, inbound jmo ");
        }
    }

    JsMsgPart getPayload() {
        return this.getPayload(SubscriptionAccess.schema);
    }

    @Override
    public final SubscriptionMessageType getSubscriptionMessageType() {
        int mType = this.getSubtype();
        return SubscriptionMessageType.getSubscriptionMessageType(mType);
    }

    @Override
    public final List<String> getTopics() {
        return (List)this.getPayload().getField(0);
    }

    @Override
    public final List<String> getTopicSpaces() {
        return (List)this.getPayload().getField(1);
    }

    @Override
    public final List<String> getTopicSpaceMappings() {
        return (List)this.getPayload().getField(2);
    }

    @Override
    public final String getMEName() {
        return (String)this.getPayload().getField(3);
    }

    @Override
    public final byte[] getMEUUID() {
        return (byte[])this.getPayload().getField(4);
    }

    @Override
    public String getBusName() {
        return (String)this.getPayload().getField(5);
    }

    private int getIntKeyForString(ArrayList<String> uniqueStrings, Object value) {
        String stringValue = String.valueOf(value);
        int retval = uniqueStrings.indexOf(stringValue);
        if (retval < 0) {
            retval = uniqueStrings.size();
            uniqueStrings.add(stringValue);
        }
        return retval;
    }

    @Override
    public void getTraceSummaryLine(StringBuilder buff) {
        super.getTraceSummaryLine(buff);
        buff.append(",subMsgType=");
        buff.append(this.getSubscriptionMessageType());
        List<String> topics = this.getTopics();
        buff.append(",topicCount=");
        buff.append(topics.size());
        Iterator<String> tIterator = topics.iterator();
        Iterator<String> tsIterator = this.getTopicSpaces().iterator();
        Iterator<String> tsmIterator = this.getTopicSpaceMappings().iterator();
        ArrayList<String> uniqueNames = new ArrayList<String>();
        buff.append(",topics=[");
        while (tIterator.hasNext()) {
            String topic = String.valueOf(tIterator.next());
            int tsInteger = this.getIntKeyForString(uniqueNames, tsIterator.hasNext() ? tsIterator.next() : null);
            int tsmInteger = this.getIntKeyForString(uniqueNames, tsmIterator.hasNext() ? tsmIterator.next() : null);
            buff.append(topic);
            buff.append('|');
            buff.append(tsInteger);
            buff.append('|');
            buff.append(tsmInteger);
            if (buff.length() > 4000) {
                buff.append(",...");
                break;
            }
            if (!tIterator.hasNext()) continue;
            buff.append(',');
        }
        buff.append(']');
        for (int i = 0; i < uniqueNames.size(); ++i) {
            buff.append(',');
            buff.append(i);
            buff.append('=');
            buff.append(uniqueNames.get(i));
        }
        buff.append(",meName=");
        buff.append(this.getMEName());
        buff.append(",meUuid=");
        buff.append(new SIBUuid8(this.getMEUUID()));
        buff.append(",busName=");
        buff.append(this.getBusName());
    }

    @Override
    public final void setSubscriptionMessageType(SubscriptionMessageType value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("setSubscriptionMessageType to " + value));
        }
        this.setSubtype(value.toInt());
    }

    @Override
    public final void setTopics(List<String> value) {
        this.getPayload().setField(0, value);
    }

    @Override
    public final void setTopicSpaces(List<String> value) {
        this.getPayload().setField(1, value);
    }

    @Override
    public final void setTopicSpaceMappings(List<String> value) {
        this.getPayload().setField(2, value);
    }

    @Override
    public final void setMEName(String value) {
        this.getPayload().setField(3, value);
    }

    @Override
    public final void setMEUUID(byte[] value) {
        this.getPayload().setField(4, value);
    }

    @Override
    public void setBusName(String value) {
        this.getPayload().setField(5, value);
    }

    @Override
    final byte[] getFlattenedClassName() {
        return flattenedClassName;
    }

    static {
        tc = SibTr.register(SubscriptionMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        flattenedClassName = SubscriptionMessageImpl.flattenClassName(SubscriptionMessageImpl.class.getName());
    }
}

