/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.ee7;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.channel.internal.inbound.HttpInputStreamImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpInputStreamEE7
extends HttpInputStreamImpl {
    private static final TraceComponent tc = Tr.register(HttpInputStreamEE7.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    static final long serialVersionUID = -8499080915448970206L;

    public HttpInputStreamEE7(HttpInboundServiceContext context) {
        super(context);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public HttpInboundServiceContext getISC() {
        return this.isc;
    }

    /*
     * WARNING - void declaration
     */
    public void initialRead() {
        block4: {
            try {
                this.buffer = this.isc.getRequestBodyBuffer();
                if (null != this.buffer) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Buffer returned from getRequestBodyBuffer : " + this.buffer), (Object[])new Object[0]);
                    }
                    this.bytesRead += (long)this.buffer.remaining();
                }
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.wsspi.http.ee7.HttpInputStreamEE7", (String)"68", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception encountered during initialRead : " + e), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={BodyCompleteException.class})
    public boolean asyncCheckBuffers(InterChannelCallback callback) {
        block7: {
            try {
                VirtualConnection vc = this.isc.getRequestBodyBuffer(callback, false);
                if (vc != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Async body read worked immediately", (Object[])new Object[0]);
                    }
                    return this.checkBuffer();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Async body read returned null", (Object[])new Object[0]);
                }
            }
            catch (BodyCompleteException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("We have read the entire body, returning false : " + e), (Object[])new Object[0]);
                }
            }
            catch (IOException e) {
                void ioe;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.http.ee7.HttpInputStreamEE7", (String)"94", (Object)this, (Object[])new Object[]{callback});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("We should never get to this point, exception was : " + ioe), (Object[])new Object[0]);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFinished() {
        boolean isFinished = false;
        try {
            if (this.isClosed()) {
                return true;
            }
            if (this.available() <= 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is no data currently available in the buffer", (Object[])new Object[0]);
                }
                if (this.isc != null && this.isc.isIncomingMessageFullyRead()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"HTTP Channel believes it has read all the data, checking to ensure it has given us all the data", (Object[])new Object[0]);
                    }
                    isFinished = !this.checkBuffer();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HTTP Channel does not believe it has read all the data", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.http.ee7.HttpInputStreamEE7", (String)"130", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Encountered an exception while attempting to determine if the stream is finished : " + e), (Object[])new Object[0]);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isFinished returning : " + isFinished), (Object[])new Object[0]);
        }
        return isFinished;
    }
}

