/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.internal.HostAlias;
import com.ibm.ws.http.internal.HttpEndpointImpl;
import com.ibm.ws.http.internal.VirtualHostImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class VirtualHostConfig {
    private final VirtualHostImpl owner;
    final boolean isDefaultHost;
    final boolean enabled;
    final Collection<String> allowedEndpointPids;
    private volatile Collection<HostAlias> hostAliases;
    static final long serialVersionUID = 410315589515429979L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public VirtualHostConfig(VirtualHostImpl owner) {
        this.owner = owner;
        this.enabled = false;
        this.isDefaultHost = false;
        this.allowedEndpointPids = Collections.emptyList();
        this.hostAliases = Collections.emptyList();
        this.hostAliases = Collections.unmodifiableCollection(this.hostAliases);
    }

    public VirtualHostConfig(VirtualHostImpl owner, Map<String, Object> properties) {
        this.owner = owner;
        boolean newEnabled = MetatypeUtils.parseBoolean((Object)"virtualHost", (String)"enabled", (Object)properties.get("enabled"), (boolean)true);
        Collection newAliasStrings = MetatypeUtils.parseStringCollection((Object)"virtualHost", (String)"hostAlias", (Object)properties.get("hostAlias"), null);
        boolean newDefaultHost = false;
        Collection<Object> newAliases = Collections.emptyList();
        if (owner.name.equals("default_host")) {
            if (!newEnabled) {
                Tr.warning((TraceComponent)VirtualHostImpl.tc, (String)"defaultHostDisabled", (Object[])new Object[0]);
            }
            newEnabled = true;
            if (newAliasStrings == null || newAliasStrings.isEmpty()) {
                newDefaultHost = true;
                newAliases = new HashSet();
                newAliases.add(new HostAlias("*", -1));
            }
        }
        if (newEnabled && !newDefaultHost) {
            if (newAliasStrings != null && !newAliasStrings.isEmpty()) {
                newAliases = new HashSet();
                for (String alias : newAliasStrings) {
                    HostAlias hs = new HostAlias(alias, owner.name);
                    if (!hs.isValid) continue;
                    newAliases.add(hs);
                }
            }
            if (newAliases.isEmpty()) {
                Tr.warning((TraceComponent)VirtualHostImpl.tc, (String)"noHostAliases", (Object[])new Object[]{owner.name});
            }
        }
        Collection<String> endpoints = this.processAllowedEndpoints(MetatypeUtils.parseStringCollection((Object)"virtualHost", (String)"allowFromEndpointRef", (Object)properties.get("allowFromEndpointRef"), null));
        this.enabled = newEnabled;
        this.isDefaultHost = newDefaultHost;
        this.hostAliases = newAliases;
        this.allowedEndpointPids = endpoints == null ? Collections.emptyList() : endpoints;
    }

    public boolean isDefaultHost() {
        return this.isDefaultHost;
    }

    public boolean isSameVirtualHost(VirtualHostConfig other) {
        if (other == null) {
            return false;
        }
        return this == other || this.getVirtualHost() == other.getVirtualHost();
    }

    public String getName() {
        return this.owner.name;
    }

    public boolean acceptFromEndpoint(String endpointPid) {
        Collection<String> endpoints = this.allowedEndpointPids;
        if (!endpoints.isEmpty()) {
            return endpoints.contains(endpointPid);
        }
        return true;
    }

    public Collection<HostAlias> getHostAliases() {
        return Collections.unmodifiableCollection(this.hostAliases);
    }

    public Collection<String> getAllowedEndpoints() {
        return Collections.unmodifiableCollection(this.allowedEndpointPids);
    }

    public synchronized Collection<HostAlias> regenerateAliases() {
        if (this.isDefaultHost) {
            HashSet<HostAlias> newAliases = new HashSet<HostAlias>();
            for (VirtualHostImpl.EndpointState es : this.owner.myEndpoints.values()) {
                if (es.httpPort > 0) {
                    newAliases.add(new HostAlias("*", es.httpPort));
                }
                if (es.httpsPort <= 0) continue;
                newAliases.add(new HostAlias("*", es.httpsPort));
            }
            if (!newAliases.isEmpty()) {
                newAliases.add(new HostAlias("*", -1));
            }
            this.hostAliases = newAliases;
            return Collections.unmodifiableCollection(newAliases);
        }
        return Collections.unmodifiableCollection(this.hostAliases);
    }

    public String toString() {
        return "config[name=" + this.owner.name + ",enabled=" + this.enabled + ",hostAliases=" + this.hostAliases + ",isDefaultHost=" + this.isDefaultHost + ",allowedEndpoints=" + this.allowedEndpointPids + "]";
    }

    private Collection<String> processAllowedEndpoints(Collection<String> endpointIds) {
        if (endpointIds == null || endpointIds.isEmpty()) {
            return null;
        }
        return endpointIds;
    }

    public VirtualHostImpl getVirtualHost() {
        return this.owner;
    }

    public void listenerStarted(HttpEndpointImpl e, String resolvedHostName, int port, boolean isHttps) {
        this.owner.listenerStarted(e, this, resolvedHostName, port, isHttps);
    }

    public void listenerStopped(HttpEndpointImpl e, String resolvedHostName, int port, boolean isHttps) {
        this.owner.listenerStopped(e, this, resolvedHostName, port, isHttps);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(VirtualHostConfig.class);
    }
}

