/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.internal.HttpEndpointImpl;
import com.ibm.ws.http.logging.internal.DisabledLogger;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.logging.AccessLog;
import com.ibm.wsspi.http.logging.DebugLog;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class HttpChannelConfig {
    private static final TraceComponent tc = Tr.register(HttpChannelConfig.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int TIMEOUT_MODIFIER = 1000;
    private int maxPersistRequest = 100;
    private VersionValues outgoingHttpVersion = VersionValues.V11;
    private boolean bDirectBuffers = true;
    private boolean bKeepAliveEnabled = true;
    private int outgoingHdrBuffSize = 1024;
    private int incomingHdrBuffSize = 8192;
    private int incomingBodyBuffSize = 32768;
    private int persistTimeout = 30000;
    private int readTimeout = 60000;
    private int writeTimeout = 60000;
    private int byteCacheSize = 512;
    private boolean bExtractValue = true;
    private boolean bBinaryTransport = false;
    private AtomicReference<AccessLog> accessLogger = new AtomicReference<DisabledLogger>(DisabledLogger.getRef());
    private final DebugLog debugLogger = DisabledLogger.getRef();
    private int limitFieldSize = 32768;
    private int limitNumHeaders = 500;
    private int limitNumResponses = 10;
    private long limitMessageSize = -1L;
    private boolean bAllowRetries = true;
    private final boolean bServantRegion = false;
    private final boolean bRunningOnZOS = false;
    private final boolean bControlRegion = false;
    private boolean bHeaderValidation = true;
    private boolean bJITOnlyReads = false;
    private boolean bStrictURLFormat = false;
    private boolean bRemoveServerHeader = false;
    private byte[] baServerHeaderValue = null;
    private long lDateHeaderRange = 1000L;
    private boolean bCookiesConfigureNoCache = true;
    private int headerChangeLimit = -1;
    private boolean bAutoDecompression = true;
    private boolean bEnableSmugglingProtection = true;
    private boolean v0CookieDateRFC1123compat = true;
    private boolean doNotAllowDuplicateSetCookies = false;
    private boolean waitForEndOfMessage = false;
    private boolean removeCLHeaderInTempStatusRespRFC7230compat = false;
    private boolean preventResponseSplit = true;
    private boolean attemptPurgeData = false;
    private boolean throwIOEForInboundConnections = false;
    private boolean skipCookiePathQuotes = false;

    public HttpChannelConfig(ChannelData cc) {
        this.parseConfig(cc);
    }

    public void updateConfig(ChannelData cc) {
        this.parseConfig(cc);
    }

    private void parseConfig(ChannelData cc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseConfig: " + cc.getName()), (Object[])new Object[0]);
        }
        Map propsIn = cc.getPropertyBag();
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        for (Map.Entry entry : propsIn.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equalsIgnoreCase("KeepAliveEnabled")) {
                props.put("KeepAliveEnabled", value);
                continue;
            }
            if (key.equalsIgnoreCase("MaxKeepAliveRequests")) {
                props.put("MaxKeepAliveRequests", value);
                continue;
            }
            if (key.equalsIgnoreCase("persistTimeout")) {
                props.put("persistTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("readTimeout")) {
                props.put("readTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("writeTimeout")) {
                props.put("writeTimeout", value);
                continue;
            }
            if (key.equalsIgnoreCase("JITOnlyReads")) {
                props.put("JITOnlyReads", value);
                continue;
            }
            if (key.equalsIgnoreCase("outgoingVersion")) {
                props.put("outgoingVersion", value);
                continue;
            }
            if (key.equalsIgnoreCase("useDirectBuffers")) {
                props.put("useDirectBuffers", value);
                continue;
            }
            if (key.equalsIgnoreCase("outgoingHdrBufferSize")) {
                props.put("outgoingHdrBufferSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("incomingHdrBufferSize")) {
                props.put("incomingHdrBufferSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("incomingBodyBufferSize")) {
                props.put("incomingBodyBufferSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("byteCacheSize")) {
                props.put("byteCacheSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("extractValue")) {
                props.put("extractValue", value);
                continue;
            }
            if (key.equalsIgnoreCase("enableBinaryTransport")) {
                props.put("enableBinaryTransport", value);
                continue;
            }
            if (key.equalsIgnoreCase("limitFieldSize")) {
                props.put("limitFieldSize", value);
                continue;
            }
            if (key.equalsIgnoreCase("limitNumHeaders")) {
                props.put("limitNumHeaders", value);
                continue;
            }
            if (key.equalsIgnoreCase("LimitNumberResponses")) {
                props.put("LimitNumberResponses", value);
                continue;
            }
            if (key.equalsIgnoreCase("MessageSizeLimit")) {
                props.put("MessageSizeLimit", value);
                continue;
            }
            if (key.equalsIgnoreCase("allowRetries")) {
                props.put("allowRetries", value);
                continue;
            }
            if (key.equalsIgnoreCase("splitResponseProtection")) {
                props.put("splitResponseProtection", value);
                continue;
            }
            if (key.equalsIgnoreCase("StrictURLFormat")) {
                props.put("StrictURLFormat", value);
                continue;
            }
            if (key.equalsIgnoreCase("ServerHeaderValue")) {
                props.put("ServerHeaderValue", value);
                continue;
            }
            if (key.equalsIgnoreCase("RemoveServerHeader")) {
                props.put("RemoveServerHeader", value);
                continue;
            }
            if (key.equalsIgnoreCase("DateHeaderRange")) {
                props.put("DateHeaderRange", value);
                continue;
            }
            if (key.equalsIgnoreCase("CookiesConfigureNoCache")) {
                props.put("CookiesConfigureNoCache", value);
                continue;
            }
            if (key.equalsIgnoreCase("HeaderChangeLimit")) {
                props.put("HeaderChangeLimit", value);
                continue;
            }
            if (key.equalsIgnoreCase("AutoDecompression")) {
                props.put("AutoDecompression", value);
                continue;
            }
            if (key.equalsIgnoreCase("EnableSmugglingProtection")) {
                props.put("EnableSmugglingProtection", value);
                continue;
            }
            if (key.equalsIgnoreCase("RunningOnZOS")) {
                props.put("RunningOnZOS", value);
                continue;
            }
            if (key.equalsIgnoreCase("ServantRegion")) {
                props.put("ServantRegion", value);
                continue;
            }
            if (key.equalsIgnoreCase("ControlRegion")) {
                props.put("ControlRegion", value);
                continue;
            }
            if (key.equalsIgnoreCase("v0CookieDateRFC1123compat")) {
                props.put("v0CookieDateRFC1123compat", value);
                continue;
            }
            if (key.equalsIgnoreCase("DoNotAllowDuplicateSetCookies")) {
                props.put("DoNotAllowDuplicateSetCookies", value);
                continue;
            }
            if (key.equalsIgnoreCase("WaitForEndOfMessage")) {
                props.put("WaitForEndOfMessage", value);
                continue;
            }
            if (key.equalsIgnoreCase("RemoveCLHeaderInTempStatusRespRFC7230compat")) {
                props.put("RemoveCLHeaderInTempStatusRespRFC7230compat", value);
                continue;
            }
            if (key.equalsIgnoreCase("PreventReponseSplit")) {
                props.put("PreventReponseSplit", value);
                continue;
            }
            if (key.equalsIgnoreCase("PurgeDataDuringClose")) {
                props.put("PurgeDataDuringClose", value);
                continue;
            }
            if (key.equalsIgnoreCase("ThrowIOEForInboundConnections")) {
                props.put("ThrowIOEForInboundConnections", value);
                continue;
            }
            if (key.equalsIgnoreCase("SkipCookiePathQuotes")) {
                props.put("SkipCookiePathQuotes", value);
                continue;
            }
            props.put(key, value);
        }
        this.parsePersistence(props);
        this.parseOutgoingVersion(props);
        this.parseBufferType(props);
        this.parseOutgoingBufferSize(props);
        this.parseIncomingHdrBufferSize(props);
        this.parseIncomingBodyBufferSize(props);
        this.parsePersistTimeout(props);
        this.parseReadTimeout(props);
        this.parseWriteTimeout(props);
        this.parseByteCacheSize(props);
        this.parseDelayedExtract(props);
        this.parseBinaryTransport(props);
        this.parseLimitFieldSize(props);
        this.parseLimitNumberHeaders(props);
        this.parseLimitNumberResponses(props);
        this.parseLimitMessageSize(props);
        this.parseAllowRetries(props);
        this.parseLoggingInfo(props);
        this.parseHeaderValidation(props);
        this.parseStrictURLFormat(props);
        this.parseServerHeader(props);
        this.parseDateHeaderRange(props);
        this.parseCookieUpdate(props);
        this.parseHeaderChangeLimit(props);
        this.parseAutoDecompression(props);
        this.parseRequestSmugglingProtection(props);
        this.parsev0CookieDateRFC1123compat(props);
        this.parseDoNotAllowDuplicateSetCookies(props);
        this.parseWaitForEndOfMessage(props);
        this.parseRemoveCLHeaderInTempStatusRespRFC7230compat(props);
        this.parsePreventResponseSplit(props);
        this.parseAttemptPurgeData(props);
        this.parseThrowIOEForInboundConnections(props);
        this.parseSkipCookiePathQuotes(props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseConfig");
        }
    }

    private String getProp(Map<Object, Object> props, String key) {
        String value = (String)props.get(key);
        if (null == value) {
            value = (String)props.get(key.toLowerCase());
        }
        return null != value ? value.trim() : null;
    }

    private void parsePersistence(Map<Object, Object> props) {
        this.parseKeepAliveEnabled(props);
        if (this.isKeepAliveEnabled()) {
            this.parseMaxPersist(props);
        }
    }

    private void parseKeepAliveEnabled(Map<Object, Object> props) {
        boolean flag = this.bKeepAliveEnabled;
        Object value = props.get("KeepAliveEnabled");
        if (null != value) {
            flag = this.convertBoolean(value);
        }
        this.bKeepAliveEnabled = flag;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Config: KeepAliveEnabled is " + this.isKeepAliveEnabled()), (Object[])new Object[0]);
        }
    }

    private void parseMaxPersist(Map<Object, Object> props) {
        block4: {
            Object value = props.get("MaxKeepAliveRequests");
            if (null != value) {
                try {
                    this.maxPersistRequest = this.minLimit(this.convertInteger(value), -1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Max persistent requests is " + this.getMaximumPersistentRequests()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseMaxPersist"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid max persistent requests; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseOutgoingVersion(Map<Object, Object> props) {
        String value = this.getProp(props, "outgoingVersion");
        if ("1.0".equals(value)) {
            this.outgoingHttpVersion = VersionValues.V10;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: Outgoing version is " + this.getOutgoingVersion().getName()), (Object[])new Object[0]);
            }
        }
    }

    private void parseBufferType(Map<Object, Object> props) {
        Object value = props.get("useDirectBuffers");
        if (null != value) {
            this.bDirectBuffers = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: use direct buffers is " + this.isDirectBufferType()), (Object[])new Object[0]);
            }
        }
    }

    private void parseOutgoingBufferSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("outgoingHdrBufferSize");
            if (null != value) {
                try {
                    this.outgoingHdrBuffSize = this.rangeLimit(this.convertInteger(value), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Outgoing hdr buffer size is " + this.getOutgoingHdrBufferSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseOutgoingBufferSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid outgoing header buffer size; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseIncomingHdrBufferSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("incomingHdrBufferSize");
            if (null != value) {
                try {
                    this.incomingHdrBuffSize = this.rangeLimit(this.convertInteger(value), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Incoming hdr buffer size is " + this.getIncomingHdrBufferSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseIncomingHdrBufferSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid incoming hdr buffer size of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseIncomingBodyBufferSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("incomingBodyBufferSize");
            if (null != value) {
                try {
                    this.incomingBodyBuffSize = this.rangeLimit(this.convertInteger(value), 1024, 0x100000);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Incoming body buffer size is " + this.getIncomingBodyBufferSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseIncomingBodyBufferSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid incoming body buffer size; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parsePersistTimeout(Map<Object, Object> props) {
        block4: {
            Object value = props.get("persistTimeout");
            if (null != value) {
                try {
                    this.persistTimeout = 1000 * this.minLimit(this.convertInteger(value), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Persist timeout is " + this.getPersistTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parsePersistTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid persist timeout; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseReadTimeout(Map<Object, Object> props) {
        block4: {
            Object value = props.get("readTimeout");
            if (null != value) {
                try {
                    this.readTimeout = 1000 * this.minLimit(this.convertInteger(value), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Read timeout is " + this.getReadTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseReadTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid read timeout; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseWriteTimeout(Map<Object, Object> props) {
        block4: {
            Object value = props.get("writeTimeout");
            if (null != value) {
                try {
                    this.writeTimeout = 1000 * this.minLimit(this.convertInteger(value), 0);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Write timeout is " + this.getWriteTimeout()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseWriteTimeout"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid write timeout; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseByteCacheSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("byteCacheSize");
            if (null != value) {
                try {
                    this.byteCacheSize = this.rangeLimit(this.convertInteger(value), 256, 2048);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: byte cache size is " + this.getByteCacheSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseByteCacheSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid bytecache setting of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseDelayedExtract(Map<Object, Object> props) {
        Object value = props.get("extractValue");
        if (null != value) {
            this.bExtractValue = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: header value extraction is " + this.shouldExtractValue()), (Object[])new Object[0]);
            }
        }
    }

    private void parseBinaryTransport(Map<Object, Object> props) {
        Object value = props.get("enableBinaryTransport");
        if (null != value) {
            this.bBinaryTransport = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: binary transport is " + this.isBinaryTransportEnabled()), (Object[])new Object[0]);
            }
        }
    }

    private void parseLimitFieldSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("limitFieldSize");
            if (null != value) {
                try {
                    this.limitFieldSize = this.rangeLimit(this.convertInteger(value), 50, 32768);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: field size limit is " + this.getLimitOfFieldSize()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitFieldSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invaild max field size setting of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseLimitNumberHeaders(Map<Object, Object> props) {
        block4: {
            Object value = props.get("limitNumHeaders");
            if (null != value) {
                try {
                    this.limitNumHeaders = this.rangeLimit(this.convertInteger(value), 50, 500);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Num hdrs limit is " + this.getLimitOnNumberOfHeaders()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitNumberHeaders"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid number of headers limit; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseLimitNumberResponses(Map<Object, Object> props) {
        block4: {
            Object value = props.get("LimitNumberResponses");
            if (null != value) {
                try {
                    int size = this.convertInteger(value);
                    this.limitNumResponses = -1 == size ? 50 : this.rangeLimit(size, 1, 50);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Num responses limit is " + this.getLimitOnNumberOfResponses()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitNumberResponses"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid max number of responses; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseLimitMessageSize(Map<Object, Object> props) {
        block4: {
            Object value = props.get("MessageSizeLimit");
            if (null != value) {
                try {
                    this.limitMessageSize = this.convertLong(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: Message size limit is " + this.getMessageSizeLimit()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseLimitMessageSize"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid message size limit; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    public long getMessageSizeLimit() {
        return this.limitMessageSize;
    }

    private void parseAccessLog(Map<Object, Object> props) {
        String id = (String)props.get("accessLogID");
        if (id != null) {
            AtomicReference<AccessLog> aLog = HttpEndpointImpl.getAccessLogger(id);
            if (aLog != null) {
                this.accessLogger = aLog;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config: using logging service", (Object[])new Object[]{this.accessLogger});
            }
        }
    }

    private void parseLoggingInfo(Map<Object, Object> props) {
        this.parseAccessLog(props);
    }

    private void parseAllowRetries(Map<Object, Object> props) {
        Object value = props.get("allowRetries");
        if (null != value) {
            this.bAllowRetries = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: allow retries is " + this.allowsRetries()), (Object[])new Object[0]);
            }
        }
    }

    private void parseHeaderValidation(Map<Object, Object> props) {
        Object value = props.get("splitResponseProtection");
        if (null != value) {
            this.bHeaderValidation = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: header validation is " + this.isHeaderValidationEnabled()), (Object[])new Object[0]);
            }
        }
    }

    private void parseJITOnlyReads(Map<Object, Object> props) {
        Object value = props.get("JITOnlyReads");
        if (null != value) {
            this.bJITOnlyReads = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: JIT only reads is " + this.isJITOnlyReads()), (Object[])new Object[0]);
            }
        }
    }

    private void parseStrictURLFormat(Map<Object, Object> props) {
        Object value = props.get("StrictURLFormat");
        if (null != value) {
            this.bStrictURLFormat = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: Strict URL formatting is " + this.isStrictURLFormat()), (Object[])new Object[0]);
            }
        }
    }

    private void parseServerHeader(Map<Object, Object> props) {
        Object ov;
        String value = this.getProp(props, "ServerHeaderValue");
        if (null != value && !"".equals(value)) {
            if ("DefaultServerVersion".equalsIgnoreCase(value)) {
                value = "WebSphere Application Server";
            }
            this.baServerHeaderValue = GenericUtils.getEnglishBytes(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: server header value [" + value + "]"), (Object[])new Object[0]);
            }
        }
        if (null != (ov = props.get("RemoveServerHeader"))) {
            this.bRemoveServerHeader = this.convertBoolean(ov);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: remove server header is " + this.removeServerHeader()), (Object[])new Object[0]);
            }
        }
    }

    private void parseDateHeaderRange(Map<Object, Object> props) {
        block4: {
            Object value = props.get("DateHeaderRange");
            if (null != value) {
                try {
                    this.lDateHeaderRange = this.minLimit(this.convertLong(value), 0L);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: date header range is " + value), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseDateHeaderRange"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid date header range; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseCookieUpdate(Map<Object, Object> props) {
        Object value = props.get("NoCacheCookiesControl");
        Object value2 = props.get("CookiesConfigureNoCache");
        boolean documentedProperty = true;
        boolean originalProperty = true;
        if (null != value) {
            documentedProperty = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: set no-cache cookie control is " + documentedProperty), (Object[])new Object[0]);
            }
        }
        if (null != value2) {
            originalProperty = this.convertBoolean(value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: set-cookie configures no-cache is " + originalProperty), (Object[])new Object[0]);
            }
        }
        this.bCookiesConfigureNoCache = originalProperty && documentedProperty;
    }

    private void parseHeaderChangeLimit(Map<Object, Object> props) {
        block4: {
            Object value = props.get("HeaderChangeLimit");
            if (null != value) {
                try {
                    this.headerChangeLimit = this.convertInteger(value);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Config: header change limit is " + this.getHeaderChangeLimit()), (Object[])new Object[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    FFDCFilter.processException((Throwable)nfe, (String)(this.getClass().getName() + ".parseHeaderChangeLimit"), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid header change count of " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    private void parseRequestSmugglingProtection(Map<Object, Object> props) {
        Object value = props.get("EnableSmugglingProtection");
        if (null != value) {
            this.bEnableSmugglingProtection = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: request smuggling protection is " + this.bEnableSmugglingProtection), (Object[])new Object[0]);
            }
        }
    }

    public boolean isRequestSmugglingProtectionEnabled() {
        return this.bEnableSmugglingProtection;
    }

    private void parseAutoDecompression(Map<Object, Object> props) {
        Object value = props.get("AutoDecompression");
        if (null != value) {
            this.bAutoDecompression = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: autodecompression is " + this.isAutoDecompressionEnabled()), (Object[])new Object[0]);
            }
        }
    }

    private void parsev0CookieDateRFC1123compat(Map<?, ?> props) {
        Object value = props.get("v0CookieDateRFC1123compat");
        if (null != value) {
            this.v0CookieDateRFC1123compat = this.convertBoolean(value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Config: v0CookieDateRFC1123compat is " + this.isv0CookieDateRFC1123compat() + " this = " + this), (Object[])new Object[0]);
        }
    }

    private void parseSkipCookiePathQuotes(Map<?, ?> props) {
        String value = (String)props.get("SkipCookiePathQuotes");
        if (null != value) {
            this.skipCookiePathQuotes = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: SkipCookiePathQuotes is " + this.shouldSkipCookiePathQuotes()), (Object[])new Object[0]);
            }
        }
    }

    private void parseDoNotAllowDuplicateSetCookies(Map<?, ?> props) {
        String value = (String)props.get("DoNotAllowDuplicateSetCookies");
        if (null != value) {
            this.doNotAllowDuplicateSetCookies = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: DoNotAllowDuplicateSetCookies is " + this.doNotAllowDuplicateSetCookies()), (Object[])new Object[0]);
            }
        }
    }

    private void parseWaitForEndOfMessage(Map props) {
        String value = (String)props.get("WaitForEndOfMessage");
        if (null != value) {
            this.waitForEndOfMessage = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: PI33453:WaitForEndOfMessage is " + this.shouldWaitForEndOfMessage()), (Object[])new Object[0]);
            }
        }
    }

    private void parseRemoveCLHeaderInTempStatusRespRFC7230compat(Map props) {
        String value = (String)props.get("RemoveCLHeaderInTempStatusRespRFC7230compat");
        if (null != value) {
            this.removeCLHeaderInTempStatusRespRFC7230compat = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: RemoveCLHeaderInTempStatusRespRFC7230compat " + this.shouldRemoveCLHeaderInTempStatusRespRFC7230compat()), (Object[])new Object[0]);
            }
        }
    }

    private void parsePreventResponseSplit(Map<?, ?> props) {
        String value = (String)props.get("PreventReponseSplit");
        if (null != value) {
            this.preventResponseSplit = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: PreventResponseSplit is " + this.shouldPreventResponseSplit()), (Object[])new Object[0]);
            }
        }
    }

    private void parseAttemptPurgeData(Map props) {
        String value = (String)props.get("PurgeDataDuringClose");
        if (null != value) {
            this.attemptPurgeData = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: PI11176:PurgeDataDuringClose is " + this.shouldAttemptPurgeData()), (Object[])new Object[0]);
            }
        }
    }

    private void parseThrowIOEForInboundConnections(Map<?, ?> props) {
        String value = (String)props.get("ThrowIOEForInboundConnections");
        if (null != value) {
            this.throwIOEForInboundConnections = this.convertBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Config: ThrowIOEForInboundConnections is " + this.throwIOEForInboundConnections()), (Object[])new Object[0]);
            }
        }
    }

    private boolean convertBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return "true".equalsIgnoreCase(o.toString().trim());
    }

    private int convertInteger(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return Integer.parseInt(o.toString().trim());
    }

    private long convertLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        return Long.parseLong(o.toString().trim());
    }

    private int rangeLimit(int size, int min, int max) {
        if (size < min) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + size + " too small"), (Object[])new Object[0]);
            }
            return min;
        }
        if (size > max) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + size + " too large"), (Object[])new Object[0]);
            }
            return max;
        }
        return size;
    }

    private int minLimit(int input, int min) {
        if (input < min) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + input + " too small."), (Object[])new Object[0]);
            }
            return min;
        }
        return input;
    }

    private long minLimit(long input, long min) {
        if (input < min) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + input + " too small."), (Object[])new Object[0]);
            }
            return min;
        }
        return input;
    }

    public int getMaximumPersistentRequests() {
        return this.maxPersistRequest;
    }

    public VersionValues getOutgoingVersion() {
        return this.outgoingHttpVersion;
    }

    public boolean isDirectBufferType() {
        return this.bDirectBuffers;
    }

    public boolean isKeepAliveEnabled() {
        return this.bKeepAliveEnabled;
    }

    public int getOutgoingHdrBufferSize() {
        return this.outgoingHdrBuffSize;
    }

    public int getIncomingHdrBufferSize() {
        return this.incomingHdrBuffSize;
    }

    public int getIncomingBodyBufferSize() {
        return this.incomingBodyBuffSize;
    }

    public int getPersistTimeout() {
        return this.persistTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getByteCacheSize() {
        return this.byteCacheSize;
    }

    public boolean shouldExtractValue() {
        return this.bExtractValue;
    }

    public boolean isBinaryTransportEnabled() {
        return this.bBinaryTransport;
    }

    public AccessLog getAccessLog() {
        return this.accessLogger.get();
    }

    public DebugLog getDebugLog() {
        return this.debugLogger;
    }

    public int getLimitOfFieldSize() {
        return this.limitFieldSize;
    }

    public int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    public int getLimitOnNumberOfResponses() {
        return this.limitNumResponses;
    }

    public boolean allowsRetries() {
        return this.bAllowRetries;
    }

    public boolean isServantRegion() {
        this.getClass();
        return false;
    }

    public boolean isControlRegion() {
        this.getClass();
        return false;
    }

    public boolean runningOnZOS() {
        this.getClass();
        return false;
    }

    public boolean isHeaderValidationEnabled() {
        return this.bHeaderValidation;
    }

    public boolean isJITOnlyReads() {
        return this.bJITOnlyReads;
    }

    public boolean isStrictURLFormat() {
        return this.bStrictURLFormat;
    }

    public byte[] getServerHeaderValue() {
        return this.baServerHeaderValue;
    }

    public boolean removeServerHeader() {
        return this.bRemoveServerHeader;
    }

    public long getDateHeaderRange() {
        return this.lDateHeaderRange;
    }

    public boolean shouldCookiesConfigureNoCache() {
        return this.bCookiesConfigureNoCache;
    }

    public int getHeaderChangeLimit() {
        return this.headerChangeLimit;
    }

    public boolean isAutoDecompressionEnabled() {
        return this.bAutoDecompression;
    }

    public boolean isAccessLoggingEnabled() {
        return this.accessLogger.get().isStarted();
    }

    public boolean isv0CookieDateRFC1123compat() {
        return this.v0CookieDateRFC1123compat;
    }

    public boolean shouldSkipCookiePathQuotes() {
        return this.skipCookiePathQuotes;
    }

    public boolean doNotAllowDuplicateSetCookies() {
        return this.doNotAllowDuplicateSetCookies;
    }

    public boolean shouldWaitForEndOfMessage() {
        return this.waitForEndOfMessage;
    }

    public boolean shouldRemoveCLHeaderInTempStatusRespRFC7230compat() {
        return this.removeCLHeaderInTempStatusRespRFC7230compat;
    }

    public boolean shouldPreventResponseSplit() {
        return this.preventResponseSplit;
    }

    public boolean shouldAttemptPurgeData() {
        return this.attemptPurgeData;
    }

    public boolean throwIOEForInboundConnections() {
        return this.throwIOEForInboundConnections;
    }
}

