/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.JAXWSAConstants;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SoapActionInInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapActionInInterceptor.class);
    static final long serialVersionUID = 624250191544463578L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SoapActionInInterceptor() {
        super("read");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "<init>", new Object[0]);
        }
        this.addAfter(ReadHeadersInterceptor.class.getName());
        this.addAfter(EndpointSelectionInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getSoapAction(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getSoapAction", new Object[]{m});
        }
        if (!(m instanceof SoapMessage)) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getSoapAction", string);
            }
            return string;
        }
        SoapMessage message = (SoapMessage)m;
        if (message.getVersion() instanceof Soap11) {
            List sa;
            Map headers = CastUtils.cast((Map)((Map)message.get(Message.PROTOCOL_HEADERS)));
            if (headers != null && (sa = (List)headers.get("SOAPAction")) != null && sa.size() > 0) {
                String action = (String)sa.get(0);
                if (action.startsWith("\"")) {
                    action = action.substring(1, action.length() - 1);
                }
                String string = action;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getSoapAction", string);
                }
                return string;
            }
        } else if (message.getVersion() instanceof Soap12) {
            String ct = (String)message.get("Content-Type");
            if (ct == null) {
                String string = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getSoapAction", string);
                }
                return string;
            }
            int start = ct.indexOf("action=");
            if (start != -1) {
                int end;
                if (ct.charAt(start + 7) == '\"') {
                    end = ct.indexOf(34, start += 8);
                } else {
                    end = ct.indexOf(59, start += 7);
                    if (end == -1) {
                        end = ct.length();
                    }
                }
                String string = ct.substring(start, end);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getSoapAction", string);
                }
                return string;
            }
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getSoapAction", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "handleMessage", new Object[]{message});
        }
        if (this.isRequestor((Message)message)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "handleMessage");
            }
            return;
        }
        String action = SoapActionInInterceptor.getSoapAction((Message)message);
        if (!StringUtils.isEmpty((String)action)) {
            SoapActionInInterceptor.getAndSetOperation(message, action);
            message.put("SOAPAction", action);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void getAndSetOperation(SoapMessage message, String action) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getAndSetOperation", new Object[]{message, action});
        }
        if (StringUtils.isEmpty((String)action)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getAndSetOperation");
            }
            return;
        }
        Exchange ex = message.getExchange();
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        if (ep == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getAndSetOperation");
            }
            return;
        }
        BindingOperationInfo bindingOp = null;
        Collection bops = ep.getEndpointInfo().getBinding().getOperations();
        if (bops != null) {
            for (BindingOperationInfo boi : bops) {
                Object o;
                SoapOperationInfo soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class);
                if (soi != null && action.equals(soi.getAction())) {
                    if (bindingOp != null) {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getAndSetOperation");
                        }
                        return;
                    }
                    bindingOp = boi;
                }
                if ((o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAM_ACTION_QNAME)) == null) {
                    o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME);
                }
                if (o == null || !action.equals(o.toString())) continue;
                if (bindingOp != null && bindingOp != boi) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getAndSetOperation");
                    }
                    return;
                }
                bindingOp = boi;
            }
        }
        if (bindingOp == null) {
            message.getInterceptorChain().add((Interceptor)new SoapActionInAttemptTwoInterceptor());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getAndSetOperation");
            }
            return;
        }
        ex.put(BindingOperationInfo.class, bindingOp);
        ex.put(OperationInfo.class, (Object)bindingOp.getOperationInfo());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor", "getAndSetOperation");
        }
    }

    public static class SoapActionInAttemptTwoInterceptor
    extends AbstractSoapInterceptor {
        public SoapActionInAttemptTwoInterceptor() {
            super("pre-logical");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            BindingOperationInfo boi = message.getExchange().getBindingOperationInfo();
            if (boi == null) {
                return;
            }
            String action = SoapActionInInterceptor.getSoapAction((Message)message);
            if (StringUtils.isEmpty((String)action)) {
                return;
            }
            SoapOperationInfo soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class);
            if (soi == null || action.equals(soi.getAction())) {
                return;
            }
            Object o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAM_ACTION_QNAME);
            if (o == null) {
                o = boi.getOperationInfo().getInput().getExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME);
            }
            if (o != null && action.equals(o.toString())) {
                return;
            }
            throw new Fault("SOAP_ACTION_MISMATCH", LOG, null, new Object[]{action});
        }
    }
}

