/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultOutInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class Soap12FaultOutInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(Soap12FaultOutInterceptor.class);
    static final long serialVersionUID = -572045379841227543L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Soap12FaultOutInterceptor() {
        super("prepare-send");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.Soap12FaultOutInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.Soap12FaultOutInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.Soap12FaultOutInterceptor", "handleMessage", new Object[]{message});
        }
        Fault f = (Fault)((Object)message.getContent(Exception.class));
        message.put(Message.RESPONSE_CODE, f.getStatusCode());
        if (message.getVersion() == Soap11.getInstance()) {
            message.getInterceptorChain().add((Interceptor)Soap11FaultOutInterceptor.Soap11FaultOutInterceptorInternal.INSTANCE);
        } else {
            message.getInterceptorChain().add((Interceptor)Soap12FaultOutInterceptorInternal.INSTANCE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.Soap12FaultOutInterceptor", "handleMessage");
        }
    }

    static class Soap12FaultOutInterceptorInternal
    extends AbstractSoapInterceptor {
        static final Soap12FaultOutInterceptorInternal INSTANCE = new Soap12FaultOutInterceptorInternal();

        public Soap12FaultOutInterceptorInternal() {
            super("marshal");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            LOG.info(this.getClass() + (String)message.get("Content-Type"));
            XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            Fault f = (Fault)((Object)message.getContent(Exception.class));
            message.put(Message.RESPONSE_CODE, f.getStatusCode());
            SoapFault fault = SoapFault.createFault(f, message.getVersion());
            try {
                Map<String, String> namespaces = fault.getNamespaces();
                for (Map.Entry<String, String> e : namespaces.entrySet()) {
                    writer.writeNamespace(e.getKey(), e.getValue());
                }
                String ns = message.getVersion().getNamespace();
                String defaultPrefix = writer.getPrefix(ns);
                if (defaultPrefix == null) {
                    defaultPrefix = StaxUtils.getUniquePrefix((XMLStreamWriter)writer, (String)ns, (boolean)false);
                    writer.writeStartElement(defaultPrefix, "Fault", ns);
                    writer.writeNamespace(defaultPrefix, ns);
                } else {
                    writer.writeStartElement(defaultPrefix, "Fault", ns);
                }
                writer.writeStartElement(defaultPrefix, "Code", ns);
                writer.writeStartElement(defaultPrefix, "Value", ns);
                writer.writeCharacters(fault.getCodeString(this.getFaultCodePrefix(writer, fault.getFaultCode()), defaultPrefix));
                writer.writeEndElement();
                if (fault.getSubCode() != null) {
                    writer.writeStartElement(defaultPrefix, "Subcode", ns);
                    writer.writeStartElement(defaultPrefix, "Value", ns);
                    writer.writeCharacters(fault.getSubCodeString(this.getFaultCodePrefix(writer, fault.getSubCode()), defaultPrefix));
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeStartElement(defaultPrefix, "Reason", ns);
                writer.writeStartElement(defaultPrefix, "Text", ns);
                String lang = f.getLang();
                if (lang == null || lang.equalsIgnoreCase("")) {
                    lang = this.getLangCode();
                }
                writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", lang);
                writer.writeCharacters(Soap12FaultOutInterceptorInternal.getFaultMessage(message, fault));
                writer.writeEndElement();
                writer.writeEndElement();
                if (fault.getRole() != null) {
                    writer.writeStartElement(defaultPrefix, "Role", ns);
                    writer.writeCharacters(fault.getRole());
                    writer.writeEndElement();
                }
                this.prepareStackTrace(message, fault);
                if (fault.hasDetails()) {
                    Element detail = fault.getDetail();
                    writer.writeStartElement(defaultPrefix, "Detail", ns);
                    for (Node node = detail.getFirstChild(); node != null; node = node.getNextSibling()) {
                        StaxUtils.writeNode((Node)node, (XMLStreamWriter)writer, (boolean)true);
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            catch (Exception xe) {
                LOG.log(Level.WARNING, "XML_WRITE_EXC", xe);
                throw f;
            }
        }

        private String getLangCode() {
            String code = LOG.getResourceBundle().getLocale().getLanguage();
            if (StringUtils.isEmpty((String)code)) {
                return "en";
            }
            return code;
        }
    }
}

