/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.SecurityHelper;
import com.ibm.ws.jca.adapter.WSManagedConnectionFactory;
import com.ibm.ws.kernel.security.thread.ThreadIdentityException;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.GenericCredential;
import javax.security.auth.Subject;

public class ThreadIdentitySecurityHelper
implements SecurityHelper {
    private static final long serialVersionUID = 71L;
    private WSManagedConnectionFactory mcf = null;
    private final boolean m_ThreadSecurity;
    private String m_ThreadIdentitySupport = null;
    private final boolean m_GlobalSecurityEnabled = true;
    private static TraceComponent tc = Tr.register(ThreadIdentitySecurityHelper.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");

    private void writeObject(ObjectOutputStream s) throws IOException {
        throw new NotSerializableException(ThreadIdentitySecurityHelper.class.getName());
    }

    private void readObject(ObjectInputStream s) throws IOException {
        throw new NotSerializableException(ThreadIdentitySecurityHelper.class.getName());
    }

    public ThreadIdentitySecurityHelper(WSManagedConnectionFactory mcf) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{this, mcf});
        }
        this.mcf = mcf;
        this.m_ThreadIdentitySupport = mcf.getThreadIdentitySupport();
        this.m_ThreadSecurity = mcf.getThreadSecurity();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void afterGettingConnection(Subject subject, ConnectionRequestInfo reqInfo, Object credentialToken) throws ResourceException {
        final Object credToken = credentialToken;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"afterGettingConnection", (Object)new Object[]{this, this.getSubjectString(subject), reqInfo, credentialToken});
        }
        if (credToken != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ThreadIdentityManager.resetChecked((Object)credToken);
                            return null;
                        }
                    });
                } else {
                    ThreadIdentityManager.resetChecked((Object)credToken);
                }
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.afterGettingConnection", (String)"37", (Object)this);
                Tr.error((TraceComponent)tc, (String)"FAILED_DOPRIVILEGED_J2CA0060", (Object)pae);
                Exception e = pae.getException();
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.afterGettingConnection() failed attempting to restore user identity to the OS Thread");
                re.initCause((Throwable)e);
                throw re;
            }
            catch (IllegalStateException ise) {
                FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.afterGettingConnection", (String)"38", (Object)this);
                Object[] parms = new Object[]{"ThreadIdentitySecurityHelper.afterGettingConnection()", ise};
                Tr.error((TraceComponent)tc, (String)"ILLEGAL_STATE_EXCEPTION_J2CA0079", (Object)parms);
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.afterGettingConnection() failed attempting to restore user identity to the OS Thread");
                re.initCause((Throwable)ise);
                throw re;
            }
            catch (ThreadIdentityException tie) {
                FFDCFilter.processException((Throwable)tie, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.afterGettingConnection", (String)"39", (Object)this);
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.afterGettingConnection() failed attempting to restore user identity to the OS Thread");
                re.initCause((Throwable)tie);
                throw re;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"afterGettingConnection() restored OS thread identity");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"afterGettingConnection");
        }
    }

    @Override
    public Object beforeGettingConnection(Subject subject, ConnectionRequestInfo reqInfo) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beforeGettingConnection", (Object)new Object[]{this, this.getSubjectString(subject), reqInfo});
        }
        Object retObject = null;
        Subject subj = subject;
        if (ThreadIdentityManager.isThreadIdentityEnabled()) {
            if (this.m_ThreadIdentitySupport.equals("ALLOWED") || this.m_ThreadIdentitySupport.equals("REQUIRED")) {
                if (subj != null) {
                    if (this.doesSubjectContainUTOKEN(subj)) {
                        if (this.m_ThreadSecurity) {
                            if (ThreadIdentityManager.isJ2CThreadIdentityEnabled()) {
                                retObject = this.setJ2CThreadIdentity(subj);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"beforeGettingConnection() pushed the user identity associated with the thread to the OS Thread:  ", (Object)new Object[]{this.getSubjectString(subj)});
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"beforeGettingConnection() could not push user identity associated with the thread to the OS Thread  because server was not enabled for SyncToThread.");
                                }
                                if (ThreadIdentityManager.isAppThreadIdentityEnabled()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"beforeGettingConnection() pushing server identity to the OS Thread because Application SyncToThread is enabled.");
                                    }
                                    retObject = ThreadIdentityManager.runAsServer();
                                }
                            }
                        }
                    } else {
                        this.checkForUTOKENNotFoundError(subj);
                    }
                } else if (this.m_ThreadSecurity && ThreadIdentityManager.isThreadIdentityEnabled()) {
                    retObject = ThreadIdentityManager.runAsServer();
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"beforeGettingConnection() processing skipped. Security not enabled.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beforeGettingConnection", (Object)new Object[]{retObject});
        }
        return retObject;
    }

    @Override
    public void finalizeCriForRRA(Subject subject, ConnectionRequestInfo reqInfo, ManagedConnectionFactory mcf) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finalizeCriForRRA");
        }
        if (subject != null) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finalizeCriForRRA");
        }
    }

    @Override
    public Subject finalizeSubject(Subject subject, ConnectionRequestInfo reqInfo, CMConfigData cmConfigData) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finalizeSubject", (Object)new Object[]{this, this.getSubjectString(subject), reqInfo});
        }
        Subject helperSubject = subject;
        if (cmConfigData.getAuth() == 0) {
            if (this.m_ThreadIdentitySupport.equals("ALLOWED")) {
                String containerAlias = this.getAliasToFinalize(cmConfigData);
                if (containerAlias == null || containerAlias.equals("")) {
                    helperSubject = this.getJ2CInvocationSubject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"finalizeSubject(): No user identity was specifed. User identity has been defaulted to current thread identity");
                    }
                }
            } else if (this.m_ThreadIdentitySupport.equals("REQUIRED")) {
                helperSubject = this.getJ2CInvocationSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"finalizeSubject(): Connector REQUIRED specified user identity to be overridden by the current thread identity");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finalizeSubject", (Object)new Object[]{this.getSubjectString(helperSubject)});
        }
        return helperSubject;
    }

    private String getSubjectString(Subject subject) {
        String returnVal = null;
        if (subject != null) {
            if (System.getSecurityManager() != null) {
                final Subject newSubject = subject;
                PrivilegedExceptionAction privExAction = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return newSubject.toString();
                    }
                };
                try {
                    returnVal = (String)AccessController.doPrivileged(privExAction);
                }
                catch (PrivilegedActionException pae) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception received in getSubjectString:", (Object)pae);
                    }
                    returnVal = "Subject cannot be traced due to a PrivilegedActionException";
                }
            } else {
                returnVal = subject.toString();
            }
        }
        return returnVal;
    }

    private String getAliasToFinalize(CMConfigData cmConfigData) {
        HashMap<String, String> loginConfigProps;
        String alias = null;
        if (cmConfigData == null) {
            return alias;
        }
        String DEFAULT_PRINCIPAL_MAPPING = "DefaultPrincipalMapping";
        String MAPPING_ALIAS = "com.ibm.mapping.authDataAlias";
        String loginConfigurationName = cmConfigData.getLoginConfigurationName();
        if (loginConfigurationName != null && !loginConfigurationName.equals("") && loginConfigurationName.equals("DefaultPrincipalMapping") && (loginConfigProps = cmConfigData.getLoginConfigProperties()) != null && !loginConfigProps.isEmpty()) {
            alias = loginConfigProps.get("com.ibm.mapping.authDataAlias");
        }
        if (alias == null) {
            alias = cmConfigData.getContainerAlias();
        }
        return alias;
    }

    private Subject getJ2CInvocationSubject() throws ResourceException {
        Subject j2cSubject = null;
        if (System.getSecurityManager() != null) {
            try {
                j2cSubject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ThreadIdentityManager.getJ2CInvocationSubject();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.finalizeSubject", (String)"826", (Object)this);
                Tr.error((TraceComponent)tc, (String)"FAILED_DOPRIVILEGED_J2CA0060", (Object)pae);
                Exception e = pae.getException();
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.finalizeSubject() failed attempting to get local OS invocation subject");
                re.initCause((Throwable)e);
                throw re;
            }
            catch (IllegalStateException ise) {
                FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.finalizeSubject", (String)"826", (Object)this);
                Object[] parms = new Object[]{"ThreadIdentitySecurityHelper.finalizeSubject()", ise};
                Tr.error((TraceComponent)tc, (String)"ILLEGAL_STATE_EXCEPTION_J2CA0079", (Object)parms);
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.finalizeSubject() failed attempting to get local OS invocation subject");
                re.initCause((Throwable)ise);
                throw re;
            }
        } else {
            j2cSubject = ThreadIdentityManager.getJ2CInvocationSubject();
        }
        return j2cSubject;
    }

    private boolean doesSubjectContainUTOKEN(Subject subj) throws ResourceException {
        Set privateGenericCredentials = this.getPrivateGenericCredentials(subj);
        final Iterator iter = privateGenericCredentials.iterator();
        boolean subjectHasUtokenCred = false;
        GenericCredential credential = null;
        while (iter.hasNext()) {
            if (System.getSecurityManager() != null) {
                try {
                    credential = (GenericCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return iter.next();
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", (String)"19", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"FAILED_DOPRIVILEGED_J2CA0060", (Object)pae);
                    Exception e = pae.getException();
                    ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to access Subject's credentials");
                    re.initCause((Throwable)e);
                    throw re;
                }
            } else {
                credential = (GenericCredential)iter.next();
            }
            if (!credential.getMechType().equals("oid:1.3.18.0.2.30.1")) continue;
            subjectHasUtokenCred = true;
            break;
        }
        return subjectHasUtokenCred;
    }

    private Set getPrivateGenericCredentials(final Subject subj) throws ResourceException {
        Set privateGenericCredentials = null;
        if (System.getSecurityManager() != null) {
            try {
                privateGenericCredentials = (Set)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return subj.getPrivateCredentials(GenericCredential.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", (String)"18", (Object)this);
                Tr.error((TraceComponent)tc, (String)"FAILED_DOPRIVILEGED_J2CA0060", (Object)pae);
                Exception e = pae.getException();
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper failed attempting to access Subject's credentials");
                re.initCause((Throwable)e);
                throw re;
            }
        } else {
            privateGenericCredentials = subj.getPrivateCredentials(GenericCredential.class);
        }
        return privateGenericCredentials;
    }

    private Object setJ2CThreadIdentity(final Subject subj) throws ResourceException {
        Object retObject = null;
        try {
            retObject = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ThreadIdentityManager.setJ2CThreadIdentity((Subject)subj);
                }
            }) : ThreadIdentityManager.setJ2CThreadIdentity((Subject)subj);
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", (String)"11", (Object)this);
            Tr.error((TraceComponent)tc, (String)"FAILED_DOPRIVILEGED_J2CA0060", (Object)pae);
            Exception e = pae.getException();
            ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the current user identity to the OS Thread");
            re.initCause((Throwable)e);
            throw re;
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", (String)"20", (Object)this);
            Object[] parms = new Object[]{"ThreadIdentitySecurityHelper.beforeGettingConnection()", ise};
            Tr.error((TraceComponent)tc, (String)"ILLEGAL_STATE_EXCEPTION_J2CA0079", (Object)parms);
            ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the current user identity to the OS Thread");
            re.initCause((Throwable)ise);
            throw re;
        }
        catch (ThreadIdentityException tie) {
            FFDCFilter.processException((Throwable)tie, (String)"com.ibm.ejs.j2c.ThreadIdentitySecurityHelper.beforeGettingConnection", (String)"21", (Object)this);
            ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() failed attempting to push the current user identity to the OS Thread");
            re.initCause((Throwable)tie);
            throw re;
        }
        return retObject;
    }

    private void checkForUTOKENNotFoundError(Subject subj) throws ResourceException {
        if (this.m_ThreadIdentitySupport.equals("REQUIRED")) {
            try {
                IllegalStateException e = new IllegalStateException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject not setup for using thread identity, but the connector requires thread identity be used.");
                Object[] parms = new Object[]{"ThreadIdentitySecurityHelper.beforeGettingConnection()", e};
                Tr.error((TraceComponent)tc, (String)"ILLEGAL_STATE_EXCEPTION_J2CA0079", (Object)parms);
                throw e;
            }
            catch (IllegalStateException ise) {
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject with illegal state");
                re.initCause((Throwable)ise);
                throw re;
            }
        }
        Set<Object> privateCredentials = subj.getPrivateCredentials();
        Iterator<Object> privateIterator = privateCredentials.iterator();
        if (!privateIterator.hasNext()) {
            try {
                IllegalStateException e = new IllegalStateException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject with no credentials.");
                Object[] parms = new Object[]{"ThreadIdentitySecurityHelper.beforeGettingConnection()", e};
                Tr.error((TraceComponent)tc, (String)"ILLEGAL_STATE_EXCEPTION_J2CA0079", (Object)parms);
                throw e;
            }
            catch (IllegalStateException ise) {
                ResourceException re = new ResourceException("ThreadIdentitySecurityHelper.beforeGettingConnection() detected Subject with illegal state");
                re.initCause((Throwable)ise);
                throw re;
            }
        }
    }
}

